/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;

public class ApproverInfosPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener {
    private static final String USERNAME = "username";
    private static final String ENTRYENTITY = "entryentity";
    private static final String SIGNTYPE = "signtype";
    private static final String BODERCOLOR = "1px_solid_#f1875d";
    private static final String ASSIGNEE = "assignee";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"closeflex"});
        AbstractGrid cloudGrid = (AbstractGrid)this.getControl(ENTRYENTITY);
        cloudGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("closeflex".equals(key)) {
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        Label signtypeLabel = (Label)this.getView().getControl(SIGNTYPE);
        String signType = (String)this.getView().getFormShowParameter().getCustomParam(SIGNTYPE);
        HashMap<String, Object> signTypeMap = new HashMap<String, Object>();
        Label rule = (Label)this.getView().getControl("rule");
        if ("huiqian".equals(signType)) {
            signtypeLabel.setText(ResManager.loadKDString((String)"\u4f1a\u7b7e", (String)"ApproverInfosPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            signTypeMap.put("fc", "#6096d8");
            String throughrule = (String)this.getView().getFormShowParameter().getCustomParam("throughrule");
            if (WfUtils.isEmpty((String)throughrule)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"rule"});
            } else {
                rule.setText(throughrule);
            }
        } else {
            signtypeLabel.setText(ResManager.loadKDString((String)"\u6216\u7b7e", (String)"ApproverInfosPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            signTypeMap.put("fc", "#f1875d");
            HashMap<String, String> bd = new HashMap<String, String>();
            bd.put("t", BODERCOLOR);
            bd.put("l", BODERCOLOR);
            bd.put("r", BODERCOLOR);
            bd.put("b", BODERCOLOR);
            HashMap<String, HashMap<String, String>> style = new HashMap<String, HashMap<String, String>>();
            style.put("b", bd);
            signTypeMap.put("s", style);
            this.getView().setVisible(Boolean.FALSE, new String[]{"rule"});
        }
        this.getView().updateControlMetadata(SIGNTYPE, signTypeMap);
        String groupDecisionType = (String)this.getView().getFormShowParameter().getCustomParam("groupdecisiontype");
        String resultInfo = ResManager.loadKDString((String)"\u5df2\u5ba1\u6279", (String)"ApproverInfosPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        HashMap<String, String> map = new HashMap<String, String>();
        if ("wait".equals(groupDecisionType)) {
            resultInfo = ResManager.loadKDString((String)"\u5f85\u5ba1\u6279", (String)"ApproverInfosPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            map.put("fc", "#F59C25");
        } else if ("approve".equals(groupDecisionType)) {
            resultInfo = ResManager.loadKDString((String)"\u5df2\u5ba1\u6279", (String)"ApproverInfosPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            map.put("fc", "#32AA70");
        } else if ("reject".equals(groupDecisionType)) {
            resultInfo = ResManager.loadKDString((String)"\u5df2\u9a73\u56de", (String)"ApproverInfosPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            map.put("fc", "#EA5E56");
        } else if ("terminate".equals(groupDecisionType)) {
            resultInfo = ResManager.loadKDString((String)"\u5ba1\u6279\u7ec8\u6b62", (String)"ApproverInfosPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            map.put("fc", "#EA5E56");
        } else if ("manualSuspended".equals(groupDecisionType)) {
            resultInfo = ResManager.loadKDString((String)"\u5df2\u624b\u52a8\u6302\u8d77", (String)"ApproverInfosPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            map.put("fc", "#F59C25");
        } else if ("forceReject".equals(groupDecisionType)) {
            resultInfo = ResManager.loadKDString((String)"\u5df2\u5f3a\u5236\u9a73\u56de", (String)"ApproverInfosPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            map.put("fc", "#EA5E56");
        }
        Label resultinfo = (Label)this.getView().getControl("resultinfo");
        resultinfo.setText(resultInfo);
        this.getView().updateControlMetadata("resultinfo", map);
        String contxtPath = UrlService.getDomainContextUrl();
        List approvers = (List)this.getView().getFormShowParameter().getCustomParam("approvers");
        if (approvers != null && !approvers.isEmpty()) {
            Label info = (Label)this.getView().getControl("labelap3");
            String approverInfosPlugin_7 = ResManager.loadKDString((String)"(%s \u4eba)", (String)"ApproverInfosPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            String format = String.format(approverInfosPlugin_7, approvers.size());
            info.setText(format);
            this.getModel().deleteEntryData(ENTRYENTITY);
            for (int i = 0; i < approvers.size(); ++i) {
                if (((Map)approvers.get(i)).get(ASSIGNEE) == null || StringUtils.isEmpty((CharSequence)((Map)approvers.get(i)).get(ASSIGNEE).toString())) continue;
                int index = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue("openid", ((Map)approvers.get(i)).get("openId"), index);
                String userStr = (String)((Map)approvers.get(i)).get("userStr");
                this.getModel().setValue("userid", (Object)userStr, index);
                String userimg = (String)((Map)approvers.get(i)).get("avatar");
                if ("-1".equals(userStr)) {
                    userimg = contxtPath + "/icons/pc/other/lcfwy_auto_38_38.png";
                }
                this.getModel().setValue("userimg", (Object)userimg, index);
                String assignee = ((Map)approvers.get(i)).get(ASSIGNEE).toString();
                if (((Boolean)((Map)approvers.get(i)).get("showUserNameFormat")).booleanValue()) {
                    this.getModel().setValue(USERNAME, (Object)assignee, index);
                } else {
                    String[] splits = assignee.split("\\\uff08|\\\uff09");
                    if (splits.length == 1) {
                        splits = assignee.split("\\(|\\)");
                    }
                    if (splits.length >= 2) {
                        this.getModel().setValue(USERNAME, (Object)splits[0], index);
                        this.getModel().setValue("gonghao", (Object)("(" + splits[1] + ")"), index);
                    } else {
                        this.getModel().setValue(USERNAME, (Object)assignee, index);
                    }
                }
                String valueGroupDecisionType = Optional.ofNullable(((Map)approvers.get(i)).get("groupDecisionType")).orElse("");
                String userState = "";
                if ("approve".equals(valueGroupDecisionType)) {
                    userState = contxtPath + "/icons/mobile/other/icon_sdfs.png";
                } else if ("reject".equals(valueGroupDecisionType) || "forceReject".equals(valueGroupDecisionType)) {
                    userState = contxtPath + "/icons/mobile/other/icon_erfd.png";
                } else if ("terminate".equals(valueGroupDecisionType)) {
                    userState = contxtPath + "/icons/mobile/other/icon_uhggr.png";
                } else if ("wait".equals(valueGroupDecisionType) || "manualSuspended".equals(valueGroupDecisionType)) {
                    userState = contxtPath + "/icons/mobile/other/icon_ufdss.png";
                }
                this.getModel().setValue("userstate", (Object)userState, index);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        if (!WfConfigurationUtil.isYunzhijiaEnable()) {
            return;
        }
        String openId = this.getModel().getValue("openid", evt.getRow()).toString();
        if (StringUtils.isEmpty((CharSequence)openId.trim())) {
            String userId = this.getModel().getValue("userid", evt.getRow()).toString();
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user", (String)"useropenid");
            openId = loadSingle.getString("useropenid");
        }
        if (StringUtils.isEmpty((CharSequence)openId.trim())) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("method", "personInfo");
        HashMap<String, String> person = new HashMap<String, String>();
        person.put("openId", openId);
        map.put("args", person);
        this.getView().executeClientCommand("callYZJApi", new Object[]{map});
    }
}

