/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.metadata.form.control.CustomControlAp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.utils.MobileFormUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.cardentry.CardEntryAp;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.container.AdvConBarItemAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.metadata.form.mcontrol.MBarItemAp;
import kd.bos.workflow.design.property.alias.AliasConverterFactory;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.WFErrorCode;

public class BillPageAttributeConfigPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String LIVISIBLE = "livisible";
    private static final String BTNHIDE = "btnhide";
    private static final String LINAME = "liname";
    private static final String LINUMBER = "linumber";
    private static final String BTNNAME = "btnname";
    private static final String BTNNUMBER = "btnnumber";
    private static final String CACHEKEY_MUSTINPUT_DISABLE = "_cachekey_mustinput_disable";
    private static final String FORM_KEY_TEXT = "formKeyText";
    private static final String FIELDNAME = "fieldname";
    private static final String MODIFY = "modify";
    private static final String DISPLAY = "display";
    private static final String HIDE = "hide";
    private static final String MUSTINPUT = "mustinput";
    private static final String FIELDNUMBER = "fieldnumber";
    private static final String MOBILE = "mobile";
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String splitChar = "_and_";
    private static final String FORMKEYTYPE_PC = "formKey";
    private static final String ITEMSTYPE_PC = "formKey.Editor.items";
    private static final String FORMKEYTYPE_MOBILE = "mobilFormKey";
    private static final String ITEMSTYPE_MOBILE = "mobilFormKey.Editor.items";
    private static final String OPENPAGETYPE = "openPageType";
    private static final String TABPAGE_FIELD = "tabpage_field";
    private static final String SETTINGENTITY = "settingentity";
    private static final String TABPAGE_BTN = "tabpage_btn";
    private static final String SETTINGENTITY_BTN = "settingentity_btn";
    private String LABEL_MOB_TIPS = "label_mob_tips";
    private static final String TABPAGE_LI = "tabpage_li";
    private static final String SETTINGENTITY_LI = "settingentity_li";
    private static final String TRUEFORMKEY = "trueFormKey";
    private static final String ENTITYNUMBER = "entityNumber";
    private static final String[] BLACKCONTROLCODES = new String[]{"imageap", "imageap1", "imageap2", "imageap3"};

    public void initialize() {
        Button btnsubmit = (Button)this.getView().getControl("btn_submit");
        btnsubmit.addClickListener((ClickListener)this);
        Button btncancel = (Button)this.getView().getControl("btn_cancel");
        btncancel.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        block3: {
            try {
                FormShowParameter params = this.getView().getFormShowParameter();
                Object openPageType = this.getPageTypeByParameter(params);
                Map<String, Object> returnData = this.setBillBaseInfo(params, openPageType);
                if (null != returnData) {
                    this.setBillEntryInfos(returnData.get(TRUEFORMKEY).toString(), returnData.get(ENTITYNUMBER).toString(), openPageType);
                }
                this.hideEditableColumn(params);
            }
            catch (Exception e) {
                if (!(e instanceof KDBizException)) break block3;
                this.getView().showErrorNotification(((KDBizException)((Object)e)).getMessage());
            }
        }
    }

    private void hideEditableColumn(FormShowParameter params) {
        String mobileFormKey;
        JSONObject nodeProperties;
        JSONObject customParam = (JSONObject)params.getCustomParam("context");
        if (customParam != null && (nodeProperties = customParam.getJSONObject("nodeProperties")) != null && MOBILE.equals(customParam.getString(OPENPAGETYPE)) && (mobileFormKey = nodeProperties.getString(FORMKEYTYPE_MOBILE)) != null && mobileFormKey.endsWith("$")) {
            EntryGrid entry = (EntryGrid)this.getControl(SETTINGENTITY);
            entry.setColumnProperty(MODIFY, "vi", (Object)Boolean.FALSE);
            entry.setColumnProperty(MUSTINPUT, "vi", (Object)Boolean.FALSE);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter parameter = (FormShowParameter)e.getSource();
        Object openPageType = this.getPageTypeByParameter(parameter);
        if (MOBILE.equals(openPageType)) {
            parameter.setCaption(ResManager.loadKDString((String)"\u79fb\u52a8\u5355\u636e\u754c\u9762\u5c5e\u6027\u8bbe\u7f6e", (String)"BillPageAttributeConfigPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else {
            parameter.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u754c\u9762\u5c5e\u6027\u8bbe\u7f6e", (String)"BillPageAttributeConfigPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private Object getPageTypeByParameter(FormShowParameter parameter) {
        Map extendData = (Map)parameter.getCustomParam("context");
        return extendData.get(OPENPAGETYPE);
    }

    private void setBillEntryInfos(String formKey, String entityNumber, Object openPageType) {
        HashMap<String, String> fieldInfoMap = new HashMap<String, String>();
        HashMap<String, String> btnInfoMap = new HashMap<String, String>();
        HashMap<String, String> liInfoMap = new HashMap<String, String>();
        this.getBillInfoMap(formKey, entityNumber, openPageType, fieldInfoMap, btnInfoMap, liInfoMap);
        this.setBillInfoSelected(fieldInfoMap, btnInfoMap, liInfoMap);
    }

    private void setBillInfoSelected(Map<String, String> fieldInfoMap, Map<String, String> btnInfoMap, Map<String, String> liInfoMap) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
        HashMap<String, Object> billInfoSelectedMapForField = null;
        HashMap<String, Object> billInfoSelectedMapForBtn = null;
        Map<String, Object> billInfoSelectedMapForLi = null;
        boolean optimize = true;
        if (value instanceof List) {
            List valueList = (List)value;
            HashMap<String, Object> billInfoSelectedMap = new HashMap<String, Object>(valueList.size());
            for (Map entity : valueList) {
                if (null == entity || null == entity.get(FIELDNUMBER)) continue;
                billInfoSelectedMap.put(entity.get(FIELDNUMBER).toString(), entity);
            }
            billInfoSelectedMapForField = billInfoSelectedMap;
            billInfoSelectedMapForBtn = billInfoSelectedMap;
            billInfoSelectedMapForLi = billInfoSelectedMap;
            optimize = false;
        } else if (value instanceof Map) {
            billInfoSelectedMapForField = (HashMap<String, Object>)((Map)value).get("field");
            billInfoSelectedMapForBtn = (HashMap<String, Object>)((Map)value).get("btn");
            billInfoSelectedMapForLi = (Map)((Map)value).get("img");
        }
        this.setBillInfo(fieldInfoMap, (Map<String, Object>)billInfoSelectedMapForField, SETTINGENTITY, optimize);
        this.setBillInfo(btnInfoMap, (Map<String, Object>)billInfoSelectedMapForBtn, SETTINGENTITY_BTN, optimize);
        this.setBillInfo(liInfoMap, billInfoSelectedMapForLi, SETTINGENTITY_LI, optimize);
    }

    private void setBillInfo(Map<String, String> billInfoMap, Map<String, Object> billInfoSelectedMap, String entityName, boolean optimize) {
        String tabPageName = null;
        if (SETTINGENTITY.equals(entityName)) {
            tabPageName = TABPAGE_FIELD;
        } else if (SETTINGENTITY_BTN.equals(entityName)) {
            tabPageName = TABPAGE_BTN;
        } else if (SETTINGENTITY_LI.equals(entityName)) {
            tabPageName = TABPAGE_LI;
        }
        if (null == billInfoMap || 0 == billInfoMap.size()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{tabPageName});
            return;
        }
        IDataModel model = this.getModel();
        String id = null;
        String fieldNumber = null;
        String fieldName = null;
        boolean isHide = false;
        boolean isModify = false;
        boolean isMustInput = false;
        int i = 0;
        JSONObject entityInfo = null;
        FieldEdit fieldEdit = null;
        for (Map.Entry<String, String> fieldInfoEntry : billInfoMap.entrySet()) {
            if (null == fieldInfoEntry) continue;
            fieldNumber = fieldInfoEntry.getKey();
            fieldName = fieldInfoEntry.getValue();
            if (null == fieldNumber && null == fieldName) continue;
            model.createNewEntryRow(entityName);
            if (SETTINGENTITY.equals(entityName)) {
                isHide = false;
                isModify = false;
                isMustInput = false;
            } else if (SETTINGENTITY_BTN.equals(entityName)) {
                isHide = true;
            } else if (SETTINGENTITY_LI.equals(entityName)) {
                isHide = true;
            }
            if (null != billInfoSelectedMap && !billInfoSelectedMap.isEmpty()) {
                if (optimize) {
                    isHide = this.getBooleanValueFromSelectedMap(billInfoSelectedMap, HIDE, fieldNumber);
                    if (SETTINGENTITY.equals(entityName)) {
                        isModify = isHide ? false : this.getBooleanValueFromSelectedMap(billInfoSelectedMap, MODIFY, fieldNumber);
                        isMustInput = this.getBooleanValueFromSelectedMap(billInfoSelectedMap, MUSTINPUT, fieldNumber);
                    }
                } else {
                    entityInfo = (JSONObject)billInfoSelectedMap.get(fieldNumber);
                    if (null != entityInfo) {
                        isHide = DesignerModelUtil.getBooleanValue(entityInfo.get((Object)HIDE));
                        isModify = DesignerModelUtil.getBooleanValue(entityInfo.get((Object)MODIFY));
                        id = entityInfo.getString("id");
                    }
                }
            }
            if (SETTINGENTITY.equals(entityName)) {
                String mustInputValue = this.getPageCache().get(fieldNumber + CACHEKEY_MUSTINPUT_DISABLE);
                if (WfUtils.isNotEmpty((String)mustInputValue) && !Boolean.parseBoolean(mustInputValue)) {
                    model.setValue(MUSTINPUT, (Object)Boolean.FALSE, i);
                    fieldEdit = (FieldEdit)this.getControl(MUSTINPUT);
                    fieldEdit.setEnable("", false, i);
                } else {
                    model.setValue(MUSTINPUT, (Object)isMustInput, i);
                }
                fieldEdit = (FieldEdit)this.getControl(FIELDNUMBER);
                fieldEdit.setEnable("", false, i);
                fieldEdit = (FieldEdit)this.getControl(FIELDNAME);
                fieldEdit.setEnable("", false, i);
                model.setValue("fieldid", (Object)id, i);
                model.setValue(FIELDNUMBER, (Object)fieldNumber, i);
                model.setValue(FIELDNAME, (Object)fieldName, i);
                model.setValue(HIDE, (Object)isHide, i);
                model.setValue(MODIFY, (Object)isModify, i);
            }
            if (SETTINGENTITY_BTN.equals(entityName)) {
                fieldEdit = (FieldEdit)this.getControl(BTNNUMBER);
                fieldEdit.setEnable("", false, i);
                fieldEdit = (FieldEdit)this.getControl(BTNNAME);
                fieldEdit.setEnable("", false, i);
                model.setValue("btnid", (Object)id, i);
                model.setValue(BTNNUMBER, (Object)fieldNumber, i);
                model.setValue(BTNNAME, (Object)fieldName, i);
                model.setValue(BTNHIDE, (Object)isHide, i);
            }
            if (SETTINGENTITY_LI.equals(entityName)) {
                fieldEdit = (FieldEdit)this.getControl(LINUMBER);
                fieldEdit.setEnable("", false, i);
                fieldEdit = (FieldEdit)this.getControl(LINAME);
                fieldEdit.setEnable("", false, i);
                model.setValue("liid", (Object)id, i);
                model.setValue(LINUMBER, (Object)fieldNumber, i);
                model.setValue(LINAME, (Object)fieldName, i);
                model.setValue(LIVISIBLE, (Object)(!isHide ? 1 : 0), i);
            }
            ++i;
            id = null;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{tabPageName});
    }

    private void getBillInfoMap(String formKey, String entityNumber, Object openPageType, Map<String, String> fieldInfoMap, Map<String, String> btnInfoMap, Map<String, String> liInfoMap) {
        if (null == fieldInfoMap || null == btnInfoMap || null == liInfoMap) {
            return;
        }
        String fieldNumber = null;
        String fieldName = null;
        if ("billSummary".equals(formKey)) {
            fieldInfoMap.putAll(MobileFormUtils.getItems((String)entityNumber));
        } else {
            String queryNumber = null;
            boolean isEntityMob = MOBILE.equals(openPageType) && null != formKey && formKey.endsWith("_mob");
            queryNumber = isEntityMob ? entityNumber : formKey;
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)queryNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            if (null != formMetadata) {
                if (isEntityMob) {
                    BillFormAp billFormAp = (BillFormAp)formMetadata.getRootAp();
                    formMetadata = billFormAp.getMobMeta();
                }
                if (null == formMetadata) {
                    this.dealExpectionForMetadataEmpty(openPageType);
                } else {
                    formMetadata.createIndex();
                }
                HashMap<String, String> entryIdNameMap = new HashMap<String, String>();
                StringBuilder entryIds = null;
                String entryIdName = null;
                String toolBarId = null;
                String controlApVisible = null;
                List li = formMetadata.getItems();
                if (WfUtils.isNotEmptyForCollection((Collection)li)) {
                    List<String> blackControls = Arrays.asList(BLACKCONTROLCODES);
                    for (ControlAp controlAp : li) {
                        if (this.isControlApHidden(controlAp)) continue;
                        fieldNumber = null;
                        fieldName = null;
                        toolBarId = null;
                        entryIds = new StringBuilder();
                        if (EntryFieldAp.class.isInstance(controlAp) || CardEntryFieldAp.class.isInstance(controlAp)) {
                            entryIdName = this.getEntryIdName(entryIdNameMap, controlAp.getParentId(), entryIds, formMetadata);
                            if (null == entryIdName) continue;
                            fieldNumber = entryIdName.split(this.splitChar)[0] + "." + controlAp.getKey();
                            fieldName = 1 < entryIdName.split(this.splitChar).length ? entryIdName.split(this.splitChar)[1] + "." + controlAp.getName().getLocaleValue() : controlAp.getName().getLocaleValue();
                        } else {
                            if (this.isHiddenForParentContainer(controlAp, formMetadata)) continue;
                            toolBarId = this.getToolBarIdForControl(controlAp, formMetadata);
                            if (null != toolBarId) {
                                fieldNumber = controlAp.getKey() + "." + toolBarId;
                                fieldName = controlAp.getName().getLocaleValue();
                            } else if (controlAp.getClass().equals(FieldAp.class) || controlAp.getClass().equals(AttachmentPanelAp.class) || controlAp.getClass().equals(CustomControlAp.class) || controlAp.getClass().equals(VectorAp.class)) {
                                fieldNumber = controlAp.getKey();
                                fieldName = controlAp.getName().getLocaleValue();
                                if (controlAp.getClass().equals(CustomControlAp.class) || controlAp.getClass().equals(AttachmentPanelAp.class)) {
                                    this.getPageCache().put(fieldNumber + CACHEKEY_MUSTINPUT_DISABLE, "false");
                                }
                            } else if (controlAp instanceof ButtonAp) {
                                if (!controlAp.getClass().equals(ButtonAp.class) && (controlAp instanceof LabelAp && !((LabelAp)controlAp).isClickable() || controlAp instanceof ImageAp && !((ImageAp)controlAp).isClickable())) continue;
                                entryIdName = this.getEntryIdName(entryIdNameMap, controlAp.getParentId(), entryIds, formMetadata);
                                if (null != entryIdName) {
                                    fieldNumber = entryIdName.split(this.splitChar)[0] + "." + controlAp.getKey();
                                    fieldName = 1 < entryIdName.split(this.splitChar).length ? entryIdName.split(this.splitChar)[1] + "." + controlAp.getName().getLocaleValue() : controlAp.getName().getLocaleValue();
                                } else {
                                    fieldNumber = controlAp.getKey();
                                    fieldName = controlAp.getName().getLocaleValue();
                                }
                            }
                        }
                        if (null == fieldNumber || blackControls.contains(fieldNumber)) continue;
                        if (null != toolBarId || controlAp.getClass().equals(ButtonAp.class) || controlAp instanceof VectorAp) {
                            btnInfoMap.put(fieldNumber, fieldName);
                            continue;
                        }
                        if (controlAp instanceof LabelAp || controlAp instanceof ImageAp) {
                            controlApVisible = controlAp.getVisible();
                            if (!WfUtils.isNotEmpty((String)controlApVisible) || !controlApVisible.contains("view")) continue;
                            liInfoMap.put(fieldNumber, fieldName);
                            continue;
                        }
                        fieldInfoMap.put(fieldNumber, fieldName);
                    }
                }
            }
        }
        if (null == fieldInfoMap || fieldInfoMap.isEmpty()) {
            this.dealExpectionForMetadataEmpty(openPageType);
        }
    }

    private boolean isControlApHidden(ControlAp<?> controlAp) {
        return null == controlAp ? true : controlAp.isHidden() || controlAp.isInvisible();
    }

    private String getToolBarIdForControl(ControlAp<?> controlAp, FormMetadata formMetadata) {
        Class<?> clazz = controlAp.getClass();
        if (BarItemAp.class.equals(clazz) || MBarItemAp.class.equals(clazz) || AdvConBarItemAp.class.equals(clazz)) {
            return formMetadata.getItem(controlAp.getParentId()).getKey();
        }
        return null;
    }

    private String getEntryIdName(Map<String, String> entryIdNameMap, String entryId, StringBuilder entryIds, FormMetadata formMetadata) {
        String entryIdName = null;
        Set<Map.Entry<String, String>> entrySet = entryIdNameMap.entrySet();
        Iterator<Map.Entry<String, String>> entrySetIterator = entrySet.iterator();
        Map.Entry<String, String> entry = null;
        while (entrySetIterator.hasNext()) {
            entry = entrySetIterator.next();
            if (!Arrays.asList(entry.getKey().split(",")).contains(entryId)) continue;
            entryIdName = entry.getValue();
            break;
        }
        if (null != entryIdName) {
            return entryIdName;
        }
        entryIds.append(entryId).append(',');
        ControlAp controlAp = formMetadata.getItem(entryId);
        if (this.isControlApHidden(controlAp)) {
            entryIdNameMap.put(entryIds.toString(), entryIdName);
        } else if (EntryAp.class.isInstance(controlAp) || CardEntryAp.class.isInstance(controlAp) || AdvConAp.class.isInstance(controlAp)) {
            entryIdName = controlAp.getKey() + this.splitChar + controlAp.getName().getLocaleValue();
            if (this.isHiddenForParentContainer(controlAp, formMetadata)) {
                entryIdName = null;
            }
            entryIdNameMap.put(entryIds.toString(), entryIdName);
        } else {
            entryIdName = this.getEntryIdName(entryIdNameMap, controlAp.getParentId(), entryIds, formMetadata);
        }
        return entryIdName;
    }

    private boolean isHiddenForParentContainer(ControlAp controlAp, FormMetadata formMetadata) {
        if (null == controlAp) {
            return false;
        }
        boolean isHidden = this.isControlApHidden(controlAp);
        if (isHidden) {
            return true;
        }
        try {
            isHidden = this.isHiddenForParentContainer(formMetadata.getItem(controlAp.getParentId()), formMetadata);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return isHidden;
    }

    private Map<String, Object> setBillBaseInfo(FormShowParameter params, Object openPageType) {
        String formKeyType = null;
        String itemsType = null;
        boolean isShowMobTips = false;
        HashMap<String, Object> returnData = null;
        if (MOBILE.equals(openPageType)) {
            formKeyType = FORMKEYTYPE_MOBILE;
            itemsType = ITEMSTYPE_MOBILE;
            isShowMobTips = true;
        } else {
            formKeyType = FORMKEYTYPE_PC;
            itemsType = ITEMSTYPE_PC;
        }
        this.getView().setVisible(Boolean.valueOf(isShowMobTips), new String[]{this.LABEL_MOB_TIPS});
        Map extendData = (Map)params.getCustomParam("context");
        Map nodeProperties = (Map)extendData.get("nodeProperties");
        Object formKey = nodeProperties.get(formKeyType);
        if (null == formKey) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u5173\u7684\u663e\u793a\u9875\u9762\u3002", (String)"BillPageAttributeConfigPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            this.getView().close();
        } else {
            returnData = new HashMap<String, Object>();
            String formKeyText = (String)nodeProperties.get(FORM_KEY_TEXT);
            this.getPageCache().put(FORM_KEY_TEXT, formKeyText);
            this.getPageCache().put(FORMKEYTYPE_PC, (String)formKey);
            String entityName = nodeProperties.get("entityName").toString();
            String entityNumber = nodeProperties.get(ENTITYNUMBER).toString();
            Boolean isFieldEnable = DesignerModelUtil.getBooleanValue(nodeProperties.get("billSetting.fieldModified")) != false && !"billSummary".equals(formKey);
            FieldEdit fe = (FieldEdit)this.getControl(MODIFY);
            fe.setEnable("", isFieldEnable.booleanValue(), -1);
            FieldEdit feForMustInput = (FieldEdit)this.getControl(MUSTINPUT);
            feForMustInput.setEnable("", isFieldEnable.booleanValue(), -1);
            returnData.put(TRUEFORMKEY, formKey);
            returnData.put(ENTITYNUMBER, entityNumber);
        }
        return returnData;
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase()) {
            case "btn_submit": {
                this.submitDataOptimize();
                break;
            }
            case "btn_cancel": {
                this.cancelData();
                break;
            }
        }
    }

    private void cancelData() {
        this.getPageCache().remove(FORM_KEY_TEXT);
        this.getPageCache().remove(FORMKEYTYPE_PC);
        this.getView().close();
    }

    public static String[] getBlackControlCodes() {
        return BLACKCONTROLCODES;
    }

    private void dealExpectionForMetadataEmpty(Object openPageType) {
        String tipsPageType = null;
        tipsPageType = MOBILE.equals(openPageType) ? ResManager.loadKDString((String)"\u5355\u636e\u79fb\u52a8\u8868\u5355", (String)"BillPageAttributeConfigPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5355\u636e\u8868\u5355", (String)"BillPageAttributeConfigPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        throw new KDBizException(WFErrorCode.billPageAttributeConfigErrorForMetadataNotExist(), new Object[]{tipsPageType});
    }

    private void submitDataOptimize() {
        HashMap<String, Object> submitDataOptimizeSumMap = new HashMap<String, Object>(3);
        this.setSubmitDataOptimizeMap(SETTINGENTITY, submitDataOptimizeSumMap);
        this.setSubmitDataOptimizeMap(SETTINGENTITY_BTN, submitDataOptimizeSumMap);
        this.setSubmitDataOptimizeMap(SETTINGENTITY_LI, submitDataOptimizeSumMap);
        this.getPageCache().remove(FORM_KEY_TEXT);
        this.getPageCache().remove(FORMKEYTYPE_PC);
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != submitDataOptimizeSumMap && !submitDataOptimizeSumMap.isEmpty()) {
            param.put("id", submitDataOptimizeSumMap);
            param.put("name", AliasConverterFactory.create("wf_billpageattrcfg").convert(submitDataOptimizeSumMap));
        }
        this.getView().returnDataToParent(param);
        this.getView().close();
    }

    private HashMap<String, Object> getSubmitDataOptimizeMap(String entityName) {
        Set keySet;
        IDataModel model = this.getModel();
        if (null == model) {
            return null;
        }
        int settingResultCount = model.getEntryRowCount(entityName);
        if (settingResultCount < 1) {
            return null;
        }
        HashMap<String, Object> submitDataOptimizeMap = null;
        boolean sceneForField = SETTINGENTITY.equals(entityName);
        boolean sceneForBtn = SETTINGENTITY_BTN.equals(entityName);
        boolean sceneForImg = SETTINGENTITY_LI.equals(entityName);
        StringBuilder fieldNameForModify = new StringBuilder();
        StringBuilder fieldNumberForModify = new StringBuilder();
        StringBuilder fieldNameForMustInput = new StringBuilder();
        StringBuilder fieldNumberForMustInput = new StringBuilder();
        int countForModify = 0;
        int countForMustInput = 0;
        StringBuilder fieldNameForHide = new StringBuilder();
        StringBuilder fieldNumberForHide = new StringBuilder();
        int countForHide = 0;
        StringBuilder fieldNameForDisplay = new StringBuilder();
        StringBuilder fieldNumberForDisplay = new StringBuilder();
        DynamicObject settledDataObj = null;
        int countForDisplay = 0;
        Object fieldName = null;
        Object fieldNumber = null;
        for (int i = 0; i < settingResultCount; ++i) {
            settledDataObj = model.getEntryRowEntity(entityName, i);
            if (null == settledDataObj) continue;
            if (sceneForField) {
                if (DesignerModelUtil.getBooleanValue(settledDataObj.get(MODIFY)).booleanValue()) {
                    fieldNameForModify.append(settledDataObj.get(FIELDNAME)).append(',');
                    fieldNumberForModify.append(settledDataObj.get(FIELDNUMBER)).append(',');
                    ++countForModify;
                }
                if (DesignerModelUtil.getBooleanValue(settledDataObj.get(MUSTINPUT)).booleanValue()) {
                    fieldNameForMustInput.append(settledDataObj.get(FIELDNAME)).append(',');
                    fieldNumberForMustInput.append(settledDataObj.get(FIELDNUMBER)).append(',');
                    ++countForMustInput;
                }
                if (DesignerModelUtil.getBooleanValue(settledDataObj.get(HIDE)).booleanValue()) {
                    fieldNameForHide.append(settledDataObj.get(FIELDNAME)).append(',');
                    fieldNumberForHide.append(settledDataObj.get(FIELDNUMBER)).append(',');
                    ++countForHide;
                }
            }
            if (sceneForBtn) {
                fieldName = settledDataObj.get(BTNNAME);
                fieldNumber = settledDataObj.get(BTNNUMBER);
                if (DesignerModelUtil.getBooleanValue(settledDataObj.get(BTNHIDE)).booleanValue()) {
                    fieldNameForHide.append(fieldName).append(',');
                    fieldNumberForHide.append(fieldNumber).append(',');
                    ++countForHide;
                } else {
                    fieldNameForDisplay.append(fieldName).append(',');
                    fieldNumberForDisplay.append(fieldNumber).append(',');
                    ++countForDisplay;
                }
            }
            if (!sceneForImg || !DesignerModelUtil.getBooleanValue(settledDataObj.get(LIVISIBLE)).booleanValue()) continue;
            fieldNameForDisplay.append(settledDataObj.get(LINAME)).append(',');
            fieldNumberForDisplay.append(settledDataObj.get(LINUMBER)).append(',');
            ++countForDisplay;
        }
        if (sceneForBtn && countForDisplay == 0) {
            return submitDataOptimizeMap;
        }
        submitDataOptimizeMap = new HashMap<String, Object>(4);
        if (countForHide > 0) {
            submitDataOptimizeMap.put(HIDE, this.getSettledDataMap(countForHide, fieldNameForHide, fieldNumberForHide));
        }
        if (countForModify > 0) {
            submitDataOptimizeMap.put(MODIFY, this.getSettledDataMap(countForModify, fieldNameForModify, fieldNumberForModify));
        }
        if (countForDisplay > 0) {
            submitDataOptimizeMap.put(DISPLAY, this.getSettledDataMap(countForDisplay, fieldNameForDisplay, fieldNumberForDisplay));
        }
        if (countForMustInput > 0) {
            submitDataOptimizeMap.put(MUSTINPUT, this.getSettledDataMap(countForMustInput, fieldNameForMustInput, fieldNumberForMustInput));
        }
        if ((keySet = submitDataOptimizeMap.keySet()).contains(HIDE) || keySet.contains(MODIFY) || keySet.contains(DISPLAY) || keySet.contains(MUSTINPUT)) {
            submitDataOptimizeMap.put("pagename", this.getPageCache().get(FORM_KEY_TEXT));
            submitDataOptimizeMap.put("pagenumber", this.getPageCache().get(FORMKEYTYPE_PC));
        }
        return submitDataOptimizeMap;
    }

    private HashMap<String, String> getSettledDataMap(int count, StringBuilder fieldName, StringBuilder fieldNumber) {
        HashMap<String, String> settledDataMapForHide = new HashMap<String, String>(count);
        if (null != fieldName && fieldName.length() > 1) {
            settledDataMapForHide.put(FIELDNAME, fieldName.substring(0, fieldName.length() - 1));
        }
        if (null != fieldNumber && fieldNumber.length() > 1) {
            settledDataMapForHide.put(FIELDNUMBER, fieldNumber.substring(0, fieldNumber.length() - 1));
        }
        return settledDataMapForHide;
    }

    private void setSubmitDataOptimizeMap(String entityName, HashMap<String, Object> submitDataOptimizeSumMap) {
        HashMap<String, Object> submitDataOptimizeMap = this.getSubmitDataOptimizeMap(entityName);
        if (null == submitDataOptimizeMap || submitDataOptimizeMap.isEmpty()) {
            return;
        }
        if (SETTINGENTITY.equals(entityName)) {
            submitDataOptimizeSumMap.put("field", submitDataOptimizeMap);
        } else if (SETTINGENTITY_BTN.equals(entityName)) {
            submitDataOptimizeSumMap.put("btn", submitDataOptimizeMap);
        } else if (SETTINGENTITY_LI.equals(entityName)) {
            submitDataOptimizeSumMap.put("img", submitDataOptimizeMap);
        }
    }

    private boolean getBooleanValueFromSelectedMap(Map<String, Object> billInfoSelectedMap, String billInfoSelectedKey, String fieldNumber) {
        if (null == billInfoSelectedMap || billInfoSelectedMap.isEmpty()) {
            return false;
        }
        Object billInfoSelectedObj = billInfoSelectedMap.get(billInfoSelectedKey);
        if (null == billInfoSelectedObj && HIDE.equals(billInfoSelectedKey)) {
            billInfoSelectedKey = DISPLAY;
            billInfoSelectedObj = billInfoSelectedMap.get(billInfoSelectedKey);
        }
        if (!(billInfoSelectedObj instanceof Map)) {
            return false;
        }
        Object fieldNumberObj = ((Map)billInfoSelectedObj).get(FIELDNUMBER);
        if (null == fieldNumberObj) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\b" + fieldNumber + "\\b");
        Matcher matcher = pattern.matcher(fieldNumberObj.toString());
        boolean exist = matcher.find();
        return DISPLAY.equals(billInfoSelectedKey) ? !exist : exist;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (!(newValue instanceof Boolean)) {
            return;
        }
        boolean booleanValue = Boolean.parseBoolean(newValue.toString());
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        int rowIndex = changeData[0].getRowIndex();
        switch (propName) {
            case "modify": {
                if (booleanValue && Boolean.parseBoolean(this.getModel().getValue(HIDE, rowIndex).toString())) {
                    this.getModel().setValue(HIDE, (Object)Boolean.FALSE, rowIndex);
                }
                if (booleanValue || !Boolean.parseBoolean(this.getModel().getValue(MUSTINPUT, rowIndex).toString())) break;
                this.getModel().setValue(MUSTINPUT, (Object)Boolean.FALSE, rowIndex);
                break;
            }
            case "mustinput": {
                if (!booleanValue) break;
                this.getModel().setValue(HIDE, (Object)Boolean.FALSE, rowIndex);
                this.getModel().setValue(MODIFY, (Object)Boolean.TRUE, rowIndex);
                break;
            }
            case "hide": {
                if (!booleanValue) break;
                this.getModel().setValue(MODIFY, (Object)Boolean.FALSE, rowIndex);
                this.getModel().setValue(MUSTINPUT, (Object)Boolean.FALSE, rowIndex);
                break;
            }
        }
    }
}

