/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabCloseEvent;
import kd.bos.form.control.events.TabCloseListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.ILicenseService;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.list.ListUserConfig;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.service.VersionService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.sysint.servicehelper.KnowledgeServiceHelper;
import kd.bos.sysint.servicehelper.constant.LocationConst;
import kd.bos.sysint.servicehelper.dto.KnowledgeSearchParams;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.util.RevProxyUtil;
import kd.bos.workflow.component.WFNavigationBar;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.center.util.NavigationTreeNode;
import kd.bos.workflow.engine.task.center.util.Navigationutils;
import kd.bos.workflow.message.service.MessageCenterService;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.task.utils.TaskModelUtils;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.MCNavigationItemCustomEvent;
import kd.bos.workflow.taskcenter.plugin.util.WorkflowTCDataPluginUtil;
import org.apache.commons.lang.time.DateFormatUtils;

public class MessageCenterPlugin
extends AbstractFormPlugin
implements ItemClickListener,
IConfirmCallBack,
TabSelectListener,
TabCloseListener {
    private static final String MSG_TYPE = "msgType";
    private static final String ENTITY_NUMBER = "entityNumber";
    private static final String FOLDER_ID = "folderId";
    private static final String INITMCENTER = "initMCenter";
    private static final String ISCLICKNAVGATION = "isClickNavgation";
    private static final String APPMIANTAB = "appmiantab";
    private static final String TRANSFER = "transfer";
    private static final String SET_AUTO_RULER = "setAutoRuler";
    private static final String ADD_CUSTOM_FOLDER = "addCustomFolder";
    private static final String MESSAGEID = "messageid";
    private static final String NUMBER = "number";
    private static final String UNREAD = "unread";
    private static final String PARENTID = "parentid";
    private static final String DEFAULT_MSG_TYPE_NAME = "defaultMsgTypeName";
    private static final String DEFAULT_MSG_TYPE_ID = "defaultMsgTypeId";
    public static final String MENUPAGEID = "menupageid";
    private static final String WFNAVIGATIONBARAP = "wfnavigationbarap";
    private static final String MESSAGE = "message";
    public static final String OPENTYPE = "openType";
    public static final String OPENPAGE = "openPage";
    public static final String HIDENAVIGATION = "hideNavigation";
    public static final String SHOW_TEAM_WORK = "showTeamWork";
    public static final String SUBMAINTAB = "_submaintab_";
    public static final String PICTUREFIELD = "picturefield";
    public static final String PAGE_ID = "pageId";
    public static final String BILL_FORM_ID = "billFormId";
    public static final String BILL_NAME = "billName";
    public static final String USERNAME = "username";
    public static final String TO_SHARE_FORM = "toShareForm";
    public static final String SHARE_FORM_ID = "shareFormId";
    public static final String SHARE_PK_ID = "sharePkId";
    public static final String SHARE_BILL_NAME = "shareBillName";
    public static final String CONTROL_KEY = "controlKey";
    public static final String TABTYPE = "tabType";
    public static final String MSGID = "messageId";
    public static final String TOHANDLE = "toHandle";
    public static final String HANDLED = "handled";
    public static final String TOAPPLY = "toApply";
    public static final String APPLYED = "applyed";
    public static final String ENTITY_MESSAGE = "wf_msg_message";
    public static final String TASK = "wf_task";
    public static final String HITASKINST = "wf_hitaskinst";
    public static final String HIPROCINST = "wf_hiprocinst";
    public static final String EXECUTION = "wf_execution";
    public static final String EXECUTIONTC = "wf_execution_tc";
    public static final String TASK_NAVIGATION = "wf_tasknavigation";
    public static final String DELEGATESETTING = "wf_delegatesetting_ext";
    private static final String DELEGATE = "delegate";
    public static final String PSONE = "psOne";
    public static final String PSMORE = "psMore";
    public static final String CARD = "card";
    public static final String API = "api";
    public static final String EVENTSOURCE = "eventSource";
    private static final String HASFLUSHNAVIGATIONDATA = "hasFlushNavigationData";
    private static final String READSTATE = "readState";
    private static final String ERRORINFO = "errorInfo";
    private static final String SHOW_HELP = "showHelp";
    private static final String TYPE_NAME = "typeName";
    private static final String TITLE = "title";
    private static final String CCS_ATLAS_URL = "https://club.kdcloud.com/knowledge/atlas?productLineId=2";
    private static final String COSMIC_ATLAS_URL = "https://developer.kingdee.com/knowledge/atlas?productLineId=29";
    private static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"messagecenter-pagehelper-pools");
    private Log logger = LogFactory.getLog(MessageCenterPlugin.class);
    private static final String ISTILEMENUMODEL = "isTileMenuModel";

    public void registerListener(EventObject e) {
        WFNavigationBar bar = (WFNavigationBar)this.getView().getControl(WFNAVIGATIONBARAP);
        bar.addCustomListListener(this);
        Tab apptabs = (Tab)this.getView().getControl(SUBMAINTAB);
        apptabs.addTabSelectListener((TabSelectListener)this);
        apptabs.addClickListener((ClickListener)this);
        apptabs.addTabCloseListener((TabCloseListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateNavAndList();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (this.getView().getMainView() != null && "home_page".equals(this.getView().getMainView().getEntityId())) {
            map.put("hideNav", true);
        }
        if (this.isShowTeamWork()) {
            map.put(SHOW_TEAM_WORK, true);
        } else {
            map.put(SHOW_TEAM_WORK, false);
        }
        map.put(SHOW_HELP, this.isShowHelp());
        this.getView().updateControlMetadata(SUBMAINTAB, map);
    }

    private boolean isShowHelp() {
        Object isSearch = BaseAppParameterServiceHelper.getParameterFromCache((String)"knowledge_search");
        if (isSearch == null || Boolean.parseBoolean(isSearch.toString())) {
            this.logger.debug("isShowHelp isSearch: " + isSearch);
            return true;
        }
        return false;
    }

    private boolean isShowTeamWork() {
        Account currentCenter = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        Map params = ParametersUtils.getCommonParameters((Account)currentCenter);
        return params != null && params.get("is_enable_team_work") instanceof Boolean && (Boolean)params.get("is_enable_team_work") != false;
    }

    public void click(EventObject evt) {
        if (!(evt instanceof ClickEvent)) {
            return;
        }
        ClickEvent clickEvent = (ClickEvent)evt;
        Map paramsMap = clickEvent.getParamsMap();
        Control c = (Control)evt.getSource();
        String clickKey = c.getKey();
        if (SUBMAINTAB.equals(clickKey) && null != paramsMap) {
            Object controlKey = paramsMap.get(CONTROL_KEY);
            String log = " ";
            if ("pageTeamWork".equals(controlKey)) {
                log = "MessageCenterPlugin_click: go to showteamwork";
                this.showTeamWork();
            } else if ("clickShare".equals(controlKey)) {
                this.showShareForm();
            } else if ("pageHelp".equals(controlKey)) {
                log = "MessageCenterPlugin_click: go to pageHelp";
                this.getHelpInfo("wftask");
            }
            this.logger.debug(log);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IPageCache mainPageCahce;
        String homepageTabapCount;
        IFormView mainPageView = this.getView().getMainView();
        if (mainPageView != null && (homepageTabapCount = (mainPageCahce = (IPageCache)mainPageView.getService(IPageCache.class)).get("homepage_tabap_count")) != null) {
            int count = Integer.parseInt(homepageTabapCount);
            mainPageCahce.put("homepage_tabap_count", Integer.toString(--count) + "");
        }
        this.getPageCache().remove(MENUPAGEID);
        this.getPageCache().remove(HASFLUSHNAVIGATIONDATA);
        this.getPageCache().remove(ISCLICKNAVGATION);
        this.getPageCache().remove(INITMCENTER);
    }

    public void tabClose(TabCloseEvent evt) {
        List tabKeys = evt.getTabKeys();
        ArrayList tabListClose = new ArrayList(tabKeys.size());
        for (String tabKey : tabKeys) {
            IFormView formView = SessionManager.getCurrent().getViewNoPlugin(tabKey);
            formView.close();
            HashMap<String, String> arg = new HashMap<String, String>(1);
            arg.put(PAGE_ID, tabKey);
            tabListClose.add(arg);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("closeWindow", tabListClose);
    }

    private void updateNavAndList() {
        try {
            String key;
            FormShowParameter fsp = this.getView().getFormShowParameter();
            Integer tabType = (Integer)fsp.getCustomParam(TABTYPE);
            String tabSelected = "";
            if (tabType != null) {
                if (TabTypeEnum.MSG.getKey() == tabType.intValue()) {
                    tabSelected = TabTypeEnum.MSG.getValue();
                    this.setNavigationData(tabSelected, "");
                } else if (TabTypeEnum.TASKTYPEENUM.getKey() == tabType.intValue()) {
                    tabSelected = TabTypeEnum.TASKTYPEENUM.getValue();
                    if (StringUtils.isBlank((CharSequence)((CharSequence)fsp.getCustomParam(BILL_FORM_ID)))) {
                        this.setNavigationData(tabSelected, TASK);
                    } else {
                        String billFormId = (String)fsp.getCustomParam(BILL_FORM_ID);
                        this.setNavigationData(tabSelected, EXECUTIONTC.equals(billFormId) ? EXECUTION : billFormId);
                    }
                }
                this.getPageCache().put(HASFLUSHNAVIGATIONDATA, "1");
            } else {
                tabSelected = TabTypeEnum.TASKTYPEENUM.getValue();
                this.setNavigationData(tabSelected, TASK);
                this.getPageCache().put(HASFLUSHNAVIGATIONDATA, "1");
            }
            String openType = (String)fsp.getCustomParam(OPENTYPE);
            if (StringUtils.isBlank((CharSequence)openType) || !HIDENAVIGATION.equalsIgnoreCase(openType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
            }
            if ((key = (String)fsp.getCustomParam(OPENPAGE)) != null && key.split("-").length > 1) {
                this.openViewByApi(fsp, tabType);
            } else if (StringUtils.isBlank((CharSequence)key)) {
                Object messageId = fsp.getCustomParam(MSGID);
                if (messageId != null) {
                    Long msgId = Long.parseLong(String.valueOf(messageId));
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("id", this.getPageCache().get(DEFAULT_MSG_TYPE_ID));
                    params.put("name", this.getPageCache().get(DEFAULT_MSG_TYPE_NAME));
                    if (TabTypeEnum.MSG.getKey() == tabType.intValue()) {
                        params.put(PARENTID, MESSAGE);
                        if (msgId != 0L) {
                            MessageCenterService messageService = (MessageCenterService)ServiceFactory.getService(MessageCenterService.class);
                            DynamicObject msgTypeObj = messageService.getMessageTypeById((Object)msgId);
                            if (msgTypeObj != null) {
                                params.put("id", msgTypeObj.getString("id"));
                                params.put("name", msgTypeObj.getLocaleString("name").getLocaleValue());
                            }
                            params.put(READSTATE, UNREAD);
                            params.put(EVENTSOURCE, PSONE);
                        } else {
                            params.put("id", "");
                            params.put(READSTATE, UNREAD);
                            params.put("name", ResManager.loadKDString((String)"\u6d88\u606f", (String)"MessageCenterPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                            params.put(EVENTSOURCE, PSMORE);
                        }
                    } else if (TabTypeEnum.TASKTYPEENUM.getKey() == tabType.intValue()) {
                        params.put(PARENTID, "task");
                        params.put(NUMBER, TASK);
                        if (msgId != 0L) {
                            params.put(EVENTSOURCE, PSONE);
                        } else {
                            params.put(EVENTSOURCE, PSMORE);
                        }
                    }
                    if (msgId != 0L) {
                        params.put(MESSAGEID, msgId);
                    }
                    this.generalNavClick(params);
                } else {
                    this.openRigthPage(TASK, "", "", "", "", null);
                }
            } else if (!(TOHANDLE.equals(key) || HANDLED.equals(key) || TOAPPLY.equals(key) || APPLYED.equals(key))) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", this.getPageCache().get(DEFAULT_MSG_TYPE_ID));
                params.put("name", this.getPageCache().get(DEFAULT_MSG_TYPE_NAME));
                params.put(PARENTID, MESSAGE);
                if (!UNREAD.equals(key)) {
                    DynamicObject typeObj = BusinessDataServiceHelper.loadSingle((Object)key, (String)"msg_type", (String)"name");
                    params.put("id", key);
                    params.put("name", typeObj.getLocaleString("name").getLocaleValue());
                    params.put(READSTATE, UNREAD);
                } else {
                    params.put("id", "");
                    params.put("name", ResManager.loadKDString((String)"\u6d88\u606f", (String)"MessageCenterPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    params.put(READSTATE, UNREAD);
                }
                params.put(EVENTSOURCE, CARD);
                this.generalNavClick(params);
            } else {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(EVENTSOURCE, CARD);
                switch (key) {
                    case "toHandle": {
                        this.openRigthPage(TASK, "", "", "", "", params);
                        break;
                    }
                    case "handled": {
                        this.openRigthPage(HITASKINST, "", "", "", "", params);
                        break;
                    }
                    case "toApply": {
                        this.openRigthPage(EXECUTIONTC, "", "", "", "", params);
                        break;
                    }
                    case "applyed": {
                        this.openRigthPage(HIPROCINST, "", "", "", "", params);
                        break;
                    }
                    default: {
                        this.openRigthPage(TASK, "", "", "", "", params);
                    }
                }
            }
        }
        catch (Exception err) {
            this.getView().showMessage(err.getMessage());
        }
    }

    private String getMessageListName(String msgNumber) {
        switch (msgNumber) {
            case "activity": {
                return ResManager.loadKDString((String)"\u6d3b\u52a8\u6d88\u606f", (String)"MessageCenterPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            case "warning": {
                return ResManager.loadKDString((String)"\u9884\u8b66", (String)"MessageCenterPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            case "message": {
                return ResManager.loadKDString((String)"\u901a\u77e5", (String)"MessageCenterPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            case "alarm": {
                return ResManager.loadKDString((String)"\u62a5\u8b66", (String)"MessageCenterPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            case "notice": {
                return ResManager.loadKDString((String)"\u516c\u544a", (String)"MessageCenterPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private void openViewByApi(FormShowParameter fsp, Integer tabType) {
        String openPage = (String)fsp.getCustomParam(OPENPAGE);
        if (openPage != null) {
            String[] openPages = openPage.split("-");
            String key = openPages[0];
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(OPENPAGE, openPage);
            if (openPages.length == 3 && !openPage.contains("viewBill")) {
                params.put("schemeId", openPages[2]);
            }
            if (fsp.getCustomParam(MSGID) != null) {
                params.put(MESSAGEID, fsp.getCustomParam(MSGID));
            }
            params.put(EVENTSOURCE, API);
            if (TabTypeEnum.MSG.getKey() == tabType.intValue()) {
                Long msgId;
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"msg_type", (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)key)});
                if (dynamicObject == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"showType\u4e0d\u5c5e\u4e8e\u4efb\u52a1\u548c\u6d88\u606f\u5206\u7c7b\uff0c\u8bf7\u68c0\u67e5", (String)"MessageCenterPlugin_19", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                params.put(PARENTID, MESSAGE);
                params.put("id", String.valueOf(dynamicObject.get("id")));
                params.put("name", this.getMessageListName(key));
                params.put(READSTATE, UNREAD);
                Object messageId = fsp.getCustomParam(MSGID);
                if (messageId != null && (msgId = Long.valueOf(Long.parseLong(String.valueOf(messageId)))) != 0L) {
                    params.put(EVENTSOURCE, PSONE);
                }
                this.openRigthPage(ENTITY_MESSAGE, "", "", "", "", params);
            } else if (TabTypeEnum.TASKTYPEENUM.getKey() == tabType.intValue()) {
                switch (key) {
                    case "toHandle": {
                        this.openRigthPage(TASK, "", "", "", "", params);
                        break;
                    }
                    case "handled": {
                        this.openRigthPage(HITASKINST, "", "", "", "", params);
                        break;
                    }
                    case "toApply": {
                        this.openRigthPage(EXECUTIONTC, "", "", "", "", params);
                        break;
                    }
                    case "applyed": {
                        this.openRigthPage(HIPROCINST, "", "", "", "", params);
                        break;
                    }
                    case "transferToHandle": {
                        this.openRigthPage(TASK, "", "", TRANSFER, "", params);
                        break;
                    }
                    case "transferHandled": {
                        this.openRigthPage(HITASKINST, "", "", TRANSFER, "", params);
                        break;
                    }
                    case "delegateToHandle": {
                        this.openRigthPage(TASK, "", "", "", DELEGATE, params);
                        break;
                    }
                    case "delegateHandled": {
                        this.openRigthPage(HITASKINST, "", "", "", DELEGATE, params);
                    }
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put(INITMCENTER, "true");
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKey;
        switch (operationKey = evt.getOperationKey()) {
            case "addCustomFolder": {
                this.addOrUpdateFolder("");
                break;
            }
            case "deleteCustomFolder": {
                String callBackId = String.format("deleteCustomFolder_%s", evt.getItemKey());
                String str = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u6587\u4ef6\u5939\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u6587\u4ef6\u5939\u5417?", (String)"MessageCenterPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(str, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(callBackId));
                break;
            }
            case "updateCustomFolder": {
                this.addOrUpdateFolder(evt.getItemKey());
                break;
            }
            case "customItemClick": {
                this.customNavClick(evt.getItemKey());
                break;
            }
            case "generalItemClick": {
                this.generalNavClick(evt.getItemKey());
                break;
            }
            case "tabClick": {
                this.tabClick(evt.getItemKey());
                break;
            }
            case "setAutoRuler": {
                this.setAutoRuler();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            return;
        }
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.contains("deleteCustomFolder")) {
            String[] strs = callBackId.split("_");
            String itemKey = String.valueOf(strs[1]);
            this.deleteCustomFolder(itemKey);
        }
    }

    private void addOrUpdateFolder(String value) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getCustomParams().put("folderValue", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_taskfolderedit");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_CUSTOM_FOLDER));
        this.getView().showForm(parameter);
    }

    private void deleteCustomFolder(String itemKey) {
        Map params = (Map)SerializationUtils.fromJsonString((String)itemKey, Map.class);
        long folderId = Long.parseLong((String)params.get("id"));
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        wfService.getRepositoryService().deleteEntity(Long.valueOf(folderId), TASK_NAVIGATION);
        this.setNavigationData();
    }

    private void customNavClick(String itemKey) {
        Map params = (Map)SerializationUtils.fromJsonString((String)itemKey, Map.class);
        String number = (String)params.get(NUMBER);
        String type = (String)params.get("type");
        if (TRANSFER.equalsIgnoreCase(number)) {
            this.openRigthPage(type, "", "", TRANSFER, "", null);
        } else if (DELEGATE.equals(number)) {
            this.openRigthPage(type, "", "", "", DELEGATE, null);
        } else {
            this.openRigthPage(type, "", params.get("id") + "", "", "", null);
        }
    }

    public void generalNavClick(String itemKey) {
        Map params = (Map)SerializationUtils.fromJsonString((String)itemKey, Map.class);
        this.generalNavClick(params);
    }

    private void generalNavClick(Map<String, Object> params) {
        String parentNumber = (String)params.get("parentNumber");
        parentNumber = EXECUTION.equals(parentNumber) ? EXECUTIONTC : parentNumber;
        String number = (String)params.get(NUMBER);
        String string = number = EXECUTION.equals(number) ? EXECUTIONTC : number;
        if (WfUtils.isEmpty((String)parentNumber)) {
            if (params.get(PARENTID).equals(MESSAGE)) {
                this.openRigthPage(ENTITY_MESSAGE, "", "", "", "", params);
            } else {
                this.openRigthPage(number, "", "", "", "", params);
            }
        } else {
            this.openRigthPage(parentNumber, number, "", "", "", null);
        }
    }

    public void tabClick(String itemKey) {
        Map params = (Map)SerializationUtils.fromJsonString((String)itemKey, Map.class);
        this.getPageCache().put(ISCLICKNAVGATION, "true");
        if (params.get("currentTab").equals(MESSAGE)) {
            params.put(PARENTID, MESSAGE);
            this.generalNavClick(params);
        } else {
            this.openRigthPage(TASK, "", "", "", "", null);
        }
    }

    private void setAutoRuler() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_taskrulelist");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SET_AUTO_RULER));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (StringUtils.isNotBlank((CharSequence)actionId)) {
            if (ADD_CUSTOM_FOLDER.equals(actionId) || SET_AUTO_RULER.equals(actionId)) {
                this.refreshMainTabPage(true);
            } else if (("openToDoPage".equals(actionId) || "approvalpagelistcallback".equals(actionId)) && WfUtils.isTileMenuModel()) {
                this.logger.debug("closedCallBack_isTileMenuModel[true]_putCache");
                IPageCache pageCache = this.getPageCache();
                pageCache.put(ISTILEMENUMODEL, "true");
                this.refreshMainTabPage(true);
            }
        }
    }

    public void tabSelected(TabSelectEvent arg0) {
        IPageCache pageCache = this.getPageCache();
        String isTitleMenuModel = pageCache.get(ISTILEMENUMODEL);
        if (WfUtils.isNotEmpty((String)isTitleMenuModel) && Boolean.parseBoolean(isTitleMenuModel)) {
            pageCache.remove(ISTILEMENUMODEL);
            this.logger.debug("closedCallBack_isTileMenuModel[true]_removeCache");
            return;
        }
        String naviTabKey = arg0.getTabKey();
        StringBuilder log = new StringBuilder();
        if (APPMIANTAB.equals(naviTabKey)) {
            log.append(String.format("tabSelected[%s]_appMainTab", RequestContext.get().getTraceId()));
            String isClickNavgation = pageCache.get(ISCLICKNAVGATION);
            if (isClickNavgation != null && Boolean.parseBoolean(isClickNavgation)) {
                log.append(", ").append(String.format("mcTabSelect[%s]_appMainTab_isClickNavgation", RequestContext.get().getTraceId()));
            } else {
                this.refreshMainTabPage(false);
            }
        } else {
            log.append(String.format("mcTabSelect[%s]_appMainTab_[%s]", RequestContext.get().getTraceId(), naviTabKey));
        }
        this.logger.debug(log.toString());
        pageCache.remove(ISCLICKNAVGATION);
    }

    private void refreshMainTabPage(boolean isCallBack) {
        String traceId = RequestContext.get().getTraceId();
        String pageId = this.getPageCache().get(MENUPAGEID);
        IFormView view = this.getView().getView(pageId);
        String log = "";
        if (view instanceof IListView) {
            WFNavigationBar bar = (WFNavigationBar)this.getControl(WFNAVIGATIONBARAP);
            bar.refreshData(this.getView());
            IListView childrenView = (IListView)view;
            String billFormId = childrenView.getBillFormId();
            if (WfUtils.isNotEmpty((String)billFormId) && !ENTITY_MESSAGE.equalsIgnoreCase(billFormId)) {
                childrenView.refresh();
            }
            childrenView.clearSelection();
            this.getView().sendFormAction((IFormView)childrenView);
            log = String.format("mcTabSelect[%s]_childrenViewRefreshOver_%s_isCallBack:%s", traceId, billFormId, isCallBack);
        } else {
            log = String.format("mcTabSelect[%s]_view is not list", traceId);
            this.openRigthPage(TASK, "", "", "", "", null);
        }
        this.logger.debug(log);
    }

    private String getType(String openSource) {
        switch (openSource) {
            case "wf_task": {
                return TOHANDLE;
            }
            case "wf_hitaskinst": {
                return HANDLED;
            }
            case "wf_execution_tc": {
                return TOAPPLY;
            }
            case "wf_hiprocinst": {
                return APPLYED;
            }
        }
        return null;
    }

    public void openRigthPage(String tableType, String entityNumber, String folderId, String transfer, String delegate, Map<String, Object> msgParams) {
        String openpage;
        if (StringUtils.isEmpty((CharSequence)tableType)) {
            return;
        }
        String msgType = msgParams == null ? "" : (String)msgParams.get("id");
        msgType = StringUtils.isBlank((CharSequence)msgType) || msgType.equalsIgnoreCase("null") ? "" : msgType;
        String string = openpage = msgParams == null || msgParams.get(OPENPAGE) == null ? "" : (String)msgParams.get(OPENPAGE);
        if (msgParams != null && (TASK.equals(tableType) || openpage != null && !ENTITY_MESSAGE.equals(tableType)) && msgParams.get(MESSAGEID) != null) {
            Long taskId = (Long)msgParams.get(MESSAGEID);
            if (WfUtils.isNotEmpty((String)openpage) && openpage.contains("viewBill")) {
                String type = this.getType(tableType);
                if (WfUtils.isNotEmpty((String)tableType)) {
                    WorkflowTCDataPluginUtil.openBillViewParameter(type, taskId, this.getView(), tableType);
                }
            } else {
                TaskInfo taskInfo = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getTaskService().findTaskByIdAndType(taskId, TOHANDLE);
                if (taskInfo == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\u3002", (String)"MessageCenterPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (TaskModelUtils.isBizTaskOpenByBrowserTab((TaskInfo)taskInfo)) {
                    WorkflowTCDataPluginUtil.showTaskHandlePageByOpenUrl(taskInfo, this.getView());
                    this.openNewPage(tableType, entityNumber, folderId, transfer, delegate, msgType, msgParams);
                } else {
                    IFormView tabView = WorkflowTCDataPluginUtil.getCurrentPageTab(taskId, TOHANDLE, this.getView());
                    if (tabView == null) {
                        CloseCallBack callback = new CloseCallBack((IFormPlugin)this, "openToDoPage");
                        FormShowParameter param = WorkflowTCDataPluginUtil.getApprovalParameter(taskId, taskInfo, callback, this.getView(), TOHANDLE);
                        if (WfUtils.isNotEmptyString((Object)param.getCustomParam(ERRORINFO))) {
                            this.getView().showMessage((String)param.getCustomParam(ERRORINFO));
                        } else {
                            if (WfUtils.isTileMenuModel()) {
                                this.openNewPage(tableType, entityNumber, folderId, transfer, delegate, msgType, msgParams);
                            }
                            this.getView().showForm(param);
                        }
                    } else {
                        tabView.activate();
                        this.getView().sendFormAction(tabView);
                    }
                }
            }
        } else {
            boolean isPsMore;
            Tab tab = (Tab)this.getControl(SUBMAINTAB);
            if (!APPMIANTAB.equalsIgnoreCase(tab.getCurrentTab())) {
                tab.activeTab(APPMIANTAB);
            }
            this.setNavigationData();
            boolean bl = isPsMore = msgParams != null && msgParams.get(EVENTSOURCE) != null && PSMORE.equals((String)msgParams.get(EVENTSOURCE));
            if (openpage != null || isPsMore || this.isNeedOpenNewPage(tableType, entityNumber, folderId, transfer, delegate, msgType, msgParams)) {
                String pageId = this.getPageCache().get(MENUPAGEID);
                IFormView formView = this.getView().getView(pageId);
                if (formView != null) {
                    this.closePage();
                }
                this.openNewPage(tableType, entityNumber, folderId, transfer, delegate, msgType, msgParams);
            } else {
                IListView childView = (IListView)this.getView().getView(this.getPageCache().get(MENUPAGEID));
                childView.refresh();
                this.getView().sendFormAction((IFormView)childView);
            }
        }
    }

    private void closePage() {
        String currentPageId = this.getPageCache().get(MENUPAGEID);
        if (StringUtils.isBlank((CharSequence)currentPageId)) {
            return;
        }
        IFormView formView = this.getView().getView(currentPageId);
        if (!"bos_list".equals(formView.getFormShowParameter().getFormId())) {
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)formView.getFormShowParameter();
        BillList billList = (BillList)formView.getControl("billlistap");
        Integer pageRows = billList.getEntryState().getPageRows();
        String billFormId = listShowParameter.getBillFormId();
        ListUserConfig listUserConfig = new ListUserConfig();
        listUserConfig.setPageRows(pageRows.intValue());
        listUserConfig.store(billFormId);
    }

    private void openNewPage(String tableType, String entityNumber, String folderId, String transfer, String delegate, String msgType, Map<String, Object> msgParams) {
        this.logger.debug(String.format("openNewPage-tableType[%s]-entityNumber[%s]-folderId[folderId]-transfer[%s]-msgType[%s]-msgParams[%s]", tableType, entityNumber, folderId, msgType, msgParams == null ? "" : msgParams.toString()));
        IPageCache pageCache = this.getPageCache();
        pageCache.put("tableType", tableType);
        pageCache.put(ENTITY_NUMBER, entityNumber);
        pageCache.put(FOLDER_ID, folderId);
        pageCache.put(TRANSFER, transfer);
        pageCache.put(DELEGATE, delegate);
        pageCache.put(MSG_TYPE, msgType);
        String menuPageid = UUID.randomUUID().toString();
        pageCache.put(MENUPAGEID, menuPageid);
        ListShowParameter parameter = new ListShowParameter();
        StyleCss sc = new StyleCss();
        parameter.getOpenStyle().setInlineStyleCss(sc);
        parameter.setBillFormId(tableType);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("flexpanelright");
        if (TASK.equals(tableType) && !TRANSFER.equals(transfer) && !DELEGATE.equals(delegate) || HITASKINST.equals(tableType) || EXECUTIONTC.equals(tableType) || HIPROCINST.equals(tableType) || msgParams != null && msgParams.get(MESSAGEID) != null || msgParams != null && MESSAGE.equals(msgParams.get(PARENTID)) || DELEGATESETTING.equals(tableType) && DELEGATE.equals(delegate)) {
            parameter.setMultiSelect(true);
        } else {
            parameter.setMultiSelect(false);
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(ENTITY_NUMBER, entityNumber);
        customParams.put(FOLDER_ID, folderId);
        customParams.put("scenes", "taskcenter");
        customParams.put("tabletype", tableType);
        if (msgParams != null && msgParams.get("schemeId") != null) {
            parameter.setFilterSchemeId((String)msgParams.get("schemeId"));
        }
        if (StringUtils.isNotEmpty((CharSequence)transfer) || StringUtils.isNotEmpty((CharSequence)delegate)) {
            if (!WfUtils.isEmpty((String)transfer)) {
                customParams.put(TRANSFER, TRANSFER);
            } else if (!WfUtils.isEmpty((String)delegate)) {
                customParams.put(DELEGATE, DELEGATE);
            }
            if (HITASKINST.equals(tableType)) {
                parameter.setCaption(ResManager.loadKDString((String)"\u5df2\u5904\u7406\u5217\u8868", (String)"MessageCenterPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else if (TASK.equals(tableType)) {
                parameter.setCaption(ResManager.loadKDString((String)"\u5f85\u5904\u7406\u5217\u8868", (String)"MessageCenterPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else if (DELEGATESETTING.equals(tableType)) {
                parameter.setHasRight(true);
                parameter.setCaption(ResManager.loadKDString((String)"\u59d4\u6258\u8bbe\u7f6e\u5217\u8868", (String)"MessageCenterPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                ListFilterParameter listFilterParameter = new ListFilterParameter();
                listFilterParameter.setFilter(new QFilter("assignorid", "=", (Object)WfUtils.getCurrentUser()));
                parameter.setListFilterParameter(listFilterParameter);
            }
        }
        if (msgParams != null) {
            if (WfUtils.isNotEmpty((String)msgType) && !"read".equalsIgnoreCase(msgType) && !UNREAD.equalsIgnoreCase(msgType)) {
                customParams.put(MSG_TYPE, Long.parseLong(msgType));
            }
            if (msgParams.get(READSTATE) != null) {
                customParams.put("readstate", (String)msgParams.get(READSTATE));
            }
            if (msgParams.get("name") != null) {
                String name = String.format(ResManager.loadKDString((String)"%s\u5217\u8868", (String)"MessageCenterPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), (String)msgParams.get("name"));
                parameter.setCaption(name);
            }
            if (msgParams.get(EVENTSOURCE) != null) {
                customParams.put(EVENTSOURCE, msgParams.get(EVENTSOURCE));
            }
        }
        if (msgParams != null && msgParams.get(MESSAGEID) != null) {
            customParams.put(MESSAGEID, msgParams.get(MESSAGEID));
            parameter.setSelectedRow(msgParams.get(MESSAGEID));
            parameter.addLinkQueryPkId(msgParams.get(MESSAGEID));
        }
        parameter.setCustomParams(customParams);
        parameter.setPageId(menuPageid);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public boolean isNeedOpenNewPage(String tableType, String entityNumber, String folderId, String transfer, String delegate, String msgType, Map<String, Object> msgParams) {
        IPageCache pageCache = this.getPageCache();
        String cacheTableType = pageCache.get("tableType");
        cacheTableType = StringUtils.isEmpty((CharSequence)cacheTableType) ? "" : cacheTableType;
        String cacheEntityNumber = pageCache.get(ENTITY_NUMBER);
        cacheEntityNumber = StringUtils.isEmpty((CharSequence)cacheEntityNumber) ? "" : cacheEntityNumber;
        String cacheFolderId = pageCache.get(FOLDER_ID);
        cacheFolderId = StringUtils.isEmpty((CharSequence)cacheFolderId) ? "" : cacheFolderId;
        String cacheTransfer = pageCache.get(TRANSFER);
        cacheTransfer = StringUtils.isEmpty((CharSequence)cacheTransfer) ? "" : cacheTransfer;
        String cacheDelegate = pageCache.get(DELEGATE);
        cacheDelegate = StringUtils.isEmpty((CharSequence)cacheDelegate) ? "" : cacheDelegate;
        String cacheMsgType = pageCache.get(MSG_TYPE);
        cacheMsgType = StringUtils.isEmpty((CharSequence)cacheMsgType) ? "" : cacheMsgType;
        String state = tableType + entityNumber + folderId + transfer + delegate + msgType;
        String preState = cacheTableType + cacheEntityNumber + cacheFolderId + cacheTransfer + cacheDelegate + cacheMsgType;
        boolean hasMessageId = false;
        if (msgParams != null && StringUtils.isNotBlank((Object)msgParams.get(MESSAGEID))) {
            hasMessageId = true;
        }
        boolean hasChildViewExist = false;
        String menuPageid = pageCache.get(MENUPAGEID);
        if (StringUtils.isNotBlank((CharSequence)menuPageid) && this.getView().getView(menuPageid) != null) {
            hasChildViewExist = true;
        }
        return !state.equalsIgnoreCase(preState) || !hasChildViewExist || hasMessageId;
    }

    private void setNavigationData() {
        String hasFlushNavigationData = this.getPageCache().get(HASFLUSHNAVIGATIONDATA);
        if (hasFlushNavigationData == null || !"1".equals(hasFlushNavigationData)) {
            this.setNavigationData("", "");
        }
        this.getPageCache().remove(HASFLUSHNAVIGATIONDATA);
    }

    private void setNavigationData(String selectedTab, String expandItem) {
        WFNavigationBar bar = (WFNavigationBar)this.getControl(WFNAVIGATIONBARAP);
        String initMCenter = this.getPageCache().get(INITMCENTER);
        if (WfUtils.isEmpty((String)initMCenter)) {
            HashMap<String, String> refreshNavigationData = new HashMap<String, String>();
            refreshNavigationData.put("selectedTab", selectedTab);
            refreshNavigationData.put("expandItem", expandItem);
            this.getView().getPageCache().put("refreshData", SerializationUtils.toJsonString(refreshNavigationData));
            bar.refreshData(this.getView());
        } else {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            HashMap<String, List> map = new HashMap<String, List>();
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            HashMap taskData = wfService.getTaskService().getMCNavigationData(userId);
            List taskNodes = Navigationutils.getNavigationNodes((List)((List)taskData.get("task")));
            List transfer = Navigationutils.getNavigationNodes((List)((List)taskData.get(TRANSFER)));
            taskNodes.addAll(transfer);
            List delegateNode = Navigationutils.getNavigationNodes((List)((List)taskData.get(DELEGATE)));
            taskNodes.addAll(delegateNode);
            List customs = Navigationutils.getNavigationNodes((List)((List)taskData.get("custom")));
            taskNodes.addAll(customs);
            map.put("task", taskNodes);
            List msgNodes = Navigationutils.getNavigationNodes((List)((List)taskData.get(MESSAGE)));
            map.put(MESSAGE, msgNodes);
            IPageCache pageCache = this.getPageCache();
            if (TabTypeEnum.TASKTYPEENUM.value.equals(selectedTab)) {
                pageCache.put(DEFAULT_MSG_TYPE_ID, ((NavigationTreeNode)taskNodes.get(0)).getId());
                pageCache.put(DEFAULT_MSG_TYPE_NAME, ((NavigationTreeNode)taskNodes.get(0)).getName());
            } else if (TabTypeEnum.MSG.value.equals(selectedTab)) {
                pageCache.put(DEFAULT_MSG_TYPE_ID, msgNodes.size() > 0 ? ((NavigationTreeNode)msgNodes.get(0)).getId() : null);
                pageCache.put(DEFAULT_MSG_TYPE_NAME, msgNodes.size() > 0 ? ((NavigationTreeNode)msgNodes.get(0)).getName() : null);
            }
            MCNavigationItemCustomEvent args = new MCNavigationItemCustomEvent(this.getView(), "MCNavigationItemInit", "MCNavigationItemInitEvent", null, userId, taskNodes);
            FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            proxy.fireCustomEvent((CustomEventArgs)args);
            bar.setData(map, selectedTab, expandItem);
            this.getPageCache().remove(INITMCENTER);
        }
    }

    private void showTeamWork() {
        Tab apptabs = (Tab)this.getView().getControl(SUBMAINTAB);
        HashMap<String, Object> parseResult = new HashMap<String, Object>(8);
        if (apptabs != null) {
            String billFormId = null;
            String currentTab = apptabs.getCurrentTab();
            String bizDataId = null;
            String appId = System.getProperty("YZJAppID");
            String domainUrl = UrlService.getDomainContextUrl();
            if (kd.bos.util.StringUtils.isNotEmpty((String)domainUrl) && domainUrl.endsWith("/")) {
                domainUrl = domainUrl.substring(0, domainUrl.length() - 1);
            }
            StringBuilder authCode = new StringBuilder();
            if (APPMIANTAB.equals(currentTab)) {
                billFormId = APPMIANTAB;
            } else {
                IFormView view = this.getView().getViewNoPlugin(currentTab);
                if (view == null) {
                    return;
                }
                if (view instanceof ListView) {
                    billFormId = ((ListView)view).getBillFormId();
                } else {
                    billFormId = this.getBillFormIdFromView(view);
                    Object pkId = view.getPageCache().get("businesskey");
                    if (StringUtils.isBlank((Object)pkId)) {
                        pkId = view.getFormShowParameter().getCustomParam("pkId");
                    }
                    MainEntityType mainEntityType = null;
                    try {
                        mainEntityType = MetadataServiceHelper.getDataEntityType((String)billFormId);
                        if (mainEntityType != null && mainEntityType.getDisplayName() != null && StringUtils.isNotEmpty((CharSequence)mainEntityType.getDisplayName().getLocaleValue())) {
                            parseResult.put(BILL_NAME, mainEntityType.getDisplayName().getLocaleValue());
                        }
                    }
                    catch (Exception e) {
                        this.logger.info("MessageCenterPlugin_showTeamWork : mainEntityType is null");
                    }
                    if (null != pkId && !"0".equals(pkId) && StringUtils.isNotBlank((CharSequence)billFormId)) {
                        bizDataId = String.valueOf(pkId);
                        authCode.append(bizDataId);
                        DynamicObject obj = null;
                        try {
                            obj = BusinessDataServiceHelper.loadSingle((Object)bizDataId, (String)billFormId);
                        }
                        catch (Exception e) {
                            this.logger.info("MessageCenterPlugin_showTeamWork : DynamicObject is null");
                        }
                        if (obj != null) {
                            String billno = null;
                            DynamicPropertyCollection property = (DynamicPropertyCollection)obj.getDataEntityType().getProperties();
                            Date createTime = null;
                            try {
                                createTime = obj.getDate("createtime");
                            }
                            catch (Exception e) {
                                this.logger.info("MessageCenterPlugin_showTeamWork : createtime is null");
                            }
                            DynamicObject creator = null;
                            try {
                                creator = obj.getDynamicObject("creator");
                            }
                            catch (Exception e) {
                                this.logger.info("MessageCenterPlugin_showTeamWork : creator is null");
                            }
                            if (property.containsKey((Object)"billno")) {
                                billno = obj.getString("billno");
                            }
                            if (createTime != null) {
                                authCode.append(createTime.getTime());
                                parseResult.put("createDate", DateFormatUtils.format((Date)createTime, (String)"yyyyMMdd"));
                                parseResult.put("createTime", DateFormatUtils.format((Date)createTime, (String)"HHmmss"));
                            }
                            if (creator != null) {
                                authCode.append(creator.get("id"));
                                parseResult.put("creatorId", creator.get("id"));
                                OrmLocaleValue nameLocalVal = (OrmLocaleValue)creator.get("name");
                                String name = nameLocalVal.get((Object)"zh_CN");
                                parseResult.put(USERNAME, name);
                                parseResult.put("creatorName", name);
                            }
                            if (kd.bos.util.StringUtils.isNotEmpty((String)billno)) {
                                parseResult.put(BILL_NAME, parseResult.get(BILL_NAME) + "-" + billno);
                            }
                            HashMap<String, String> data = new HashMap<String, String>(16);
                            data.put(SHARE_PK_ID, bizDataId);
                            data.put(SHARE_FORM_ID, billFormId);
                            data.put(SHARE_BILL_NAME, (String)parseResult.get(BILL_NAME));
                            this.getPageCache().put(TO_SHARE_FORM, SerializationUtils.toJsonString(data));
                        }
                        parseResult.put("billLink", domainUrl + "/index.html?pkId=" + bizDataId + "&formId=" + billFormId + "&appId=" + appId);
                    }
                }
                if (billFormId == null) {
                    billFormId = view.getFormShowParameter().getFormId();
                }
            }
            String dataCenterId = RequestContext.get().getAccountId();
            ArrayList<Long> userIds = new ArrayList<Long>(1);
            userIds.add(Long.parseLong(RequestContext.get().getUserId()));
            List userInfoList = UserServiceHelper.get(userIds, (String[])new String[]{"id", "eid", USERNAME, PICTUREFIELD, "name"}, null);
            if (StringUtils.isEmpty((CharSequence)bizDataId) || "0".equals(bizDataId)) {
                bizDataId = billFormId;
                StringBuilder temp = new StringBuilder(bizDataId).append(dataCenterId);
                authCode.append((CharSequence)temp);
            }
            parseResult.put("bizDataId", bizDataId);
            parseResult.put("dataCenterId", dataCenterId);
            parseResult.put("oid", RequestContext.get().getUserOpenId());
            parseResult.put("appId", appId);
            if (null != userInfoList && !userInfoList.isEmpty()) {
                parseResult.put("userId", ((Map)userInfoList.get(0)).get("id"));
                parseResult.put("eid", ((Map)userInfoList.get(0)).get("eid"));
                OrmLocaleValue nameLocalVal = (OrmLocaleValue)((Map)userInfoList.get(0)).get("name");
                String name = nameLocalVal.get((Object)"zh_CN");
                parseResult.put(USERNAME, name);
                Map photoUrlMap = UserServiceHelper.getUserAvatarPath(userIds, (boolean)true);
                if (photoUrlMap != null) {
                    parseResult.put(PICTUREFIELD, photoUrlMap.get(userIds.get(0)));
                } else {
                    parseResult.put(PICTUREFIELD, "");
                }
            }
            parseResult.put("authCode", authCode);
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PAGE_ID, this.getView().getPageId());
        params.put("data", parseResult);
        proxy.addAction(SHOW_TEAM_WORK, params);
    }

    private String getBillFormIdFromView(IFormView view) {
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)view.getFormShowParameter().getCustomParam(ENTITY_NUMBER)))) {
            return (String)view.getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        }
        if (StringUtils.isNotBlank((CharSequence)view.getPageCache().get(ENTITY_NUMBER))) {
            return view.getPageCache().get(ENTITY_NUMBER);
        }
        if (StringUtils.isNotBlank((CharSequence)view.getPageCache().get("entitynumber"))) {
            return view.getPageCache().get("entitynumber");
        }
        if (StringUtils.isNotBlank((CharSequence)view.getPageCache().get("formkey"))) {
            return view.getPageCache().get("formkey");
        }
        if (StringUtils.isNotBlank((CharSequence)view.getPageCache().get("formKey"))) {
            return view.getPageCache().get("formKey");
        }
        return (String)view.getFormShowParameter().getCustomParams().get("formId");
    }

    private void showShareForm() {
        String shareFormStr = this.getPageCache().get(TO_SHARE_FORM);
        if (StringUtils.isBlank((CharSequence)shareFormStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u5355\u636e", (String)"MessageCenterPlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Map shareForm = (Map)SerializationUtils.fromJsonString((String)shareFormStr, Map.class);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("bos_share_form");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParams(shareForm);
        this.getView().showForm(fsp);
    }

    private String getBillFormId() {
        String billFormId = null;
        Tab apptabs = (Tab)this.getView().getControl(SUBMAINTAB);
        if (apptabs != null) {
            String currentTab = apptabs.getCurrentTab();
            this.logger.info("MessageCenterPlugin.getBillFormId currentTab : " + currentTab);
            if (APPMIANTAB.equals(currentTab)) {
                billFormId = "";
            } else {
                IFormView view = this.getView().getViewNoPlugin(currentTab);
                if (view == null) {
                    return billFormId;
                }
                this.logger.debug("MessageCenterPlugin.getBillFormId view is not null");
                billFormId = view instanceof ListView ? ((ListView)view).getBillFormId() : (String)view.getFormShowParameter().getCustomParams().get(BILL_FORM_ID);
                if (billFormId == null) {
                    billFormId = view.getFormShowParameter().getFormId();
                }
            }
        }
        this.logger.info("MessageCenterPlugin.getBillFormId billFormId : " + billFormId);
        return billFormId;
    }

    private IFormView getCurrentView() {
        return this.getView();
    }

    private void showHotQuestion(Object result, String entityUrl) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> o = new HashMap<String, Object>();
        o.put(PAGE_ID, this.getView().getPageId());
        o.put("data", result);
        o.put("entityUrl", entityUrl);
        o.put("key", SUBMAINTAB);
        proxy.addAction("showHotQuestion", o);
    }

    private Map<String, Object> parse(List<String> sources) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList contentList = new ArrayList();
        for (String source : sources) {
            try {
                JSONObject jason = (JSONObject)JSON.parse((String)source);
                JSONArray contentJason = (JSONArray)jason.get((Object)"content");
                for (Object eachContent : contentJason.toArray()) {
                    JSONObject eachContentJason = (JSONObject)eachContent;
                    String title = (String)eachContentJason.get((Object)TITLE);
                    String url = (String)eachContentJason.get((Object)"entityUrl");
                    String entityType = eachContentJason.get((Object)"entity-type").toString();
                    HashMap<String, String> content = new HashMap<String, String>();
                    content.put("type", entityType);
                    switch (entityType) {
                        case "Question": {
                            content.put(TYPE_NAME, ResManager.loadKDString((String)"\u95ee\u7b54", (String)"MessageCenterPlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                            break;
                        }
                        case "Article": {
                            content.put(TYPE_NAME, ResManager.loadKDString((String)"\u77e5\u8bc6", (String)"MessageCenterPlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                            break;
                        }
                        case "Course": 
                        case "LearningCourse": {
                            content.put("type", "Course");
                            content.put(TYPE_NAME, ResManager.loadKDString((String)"\u8bfe\u7a0b", (String)"MessageCenterPlugin_18", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                            break;
                        }
                    }
                    content.put(TITLE, title);
                    content.put("url", url);
                    contentList.add(content);
                }
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
        }
        response.put("list", contentList);
        if (contentList.size() > 0) {
            response.put("errcode", "0");
        } else {
            response.put("errcode", "1");
        }
        response.put("description", "");
        return response;
    }

    private String getUrlParamsByMap(Map<String, Object> map) {
        if (map == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue());
            sb.append("&");
        }
        String s = sb.toString();
        if (s.endsWith("&")) {
            s = StringUtils.substringBeforeLast((String)s, (String)"&");
        }
        return s;
    }

    private String getEntityUrl() {
        String entityUrl = null;
        ILicenseService licenseService = (ILicenseService)kd.bos.service.ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        if (modelType == 3) {
            int count = VersionService.getVersionCount();
            entityUrl = count < 2 ? COSMIC_ATLAS_URL : CCS_ATLAS_URL;
        }
        return entityUrl;
    }

    private boolean isHomepage() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("home_page".equals(formId)) {
            Tab appTab = (Tab)this.getView().getControl("tabap");
            if (appTab != null) {
                String currentTab = appTab.getCurrentTab();
                return "tabpageap".equals(currentTab);
            }
            return false;
        }
        return false;
    }

    private String getKnowledgeSpecial(KnowledgeSearchParams searchParams) {
        String response = KnowledgeServiceHelper.getKnowledgeSpecial((KnowledgeSearchParams)searchParams);
        String entityUrl = null;
        try {
            JSONObject data;
            JSONArray content;
            int errorCode;
            JSONObject jason = (JSONObject)JSON.parse((String)response);
            if (jason != null && (errorCode = Integer.parseInt(jason.get((Object)"errorCode").toString())) == 0 && (content = (JSONArray)(data = (JSONObject)jason.get((Object)"data")).get((Object)"content")).size() > 0) {
                JSONObject result = (JSONObject)content.get(0);
                entityUrl = result.get((Object)"entityUrl").toString();
            }
        }
        catch (Exception e) {
            this.logger.error("MessageCenterPlugin.getKnowledgeSpecial error", (Throwable)e);
        }
        return entityUrl;
    }

    private void getHelpInfo(String title) {
        this.knowledgeSearch();
    }

    private void knowledgeSearch() {
        Map<String, Object> result;
        String billFormId = this.getBillFormId();
        String entityUrl = null;
        String module = "";
        String domain = "";
        String type = "";
        IFormView view = this.getCurrentView();
        if (view != null) {
            module = view.getFormShowParameter().getAppId();
            domain = AppMetadataCache.getAppInfo((String)module).getCloudNum();
        }
        this.logger.debug("MessageCenterPlugin.knowledgeSearch module : " + module);
        this.logger.debug("MessageCenterPlugin.knowledgeSearch domain : " + domain);
        String bizentity = billFormId == null ? "" : billFormId;
        String label = "";
        String restrictIn = "domain,module,bizentity";
        String authcode = "";
        String searchScope = "knowledge";
        int page = 1;
        int pageSize = 50;
        KnowledgeSearchParams searchParams = new KnowledgeSearchParams(type, domain, module, bizentity, label, restrictIn, "", authcode, page, pageSize, Boolean.valueOf(true), searchScope);
        searchParams.setLocation(LocationConst.PAGE_HELP.code());
        Future future = threadPool.submit(() -> this.getKnowledgeSpecial(searchParams));
        String knowledgeSource = KnowledgeServiceHelper.knowledgeSearch((KnowledgeSearchParams)searchParams);
        try {
            JSONObject jason = (JSONObject)JSON.parse((String)knowledgeSource);
            int totalPages = Integer.parseInt(jason.get((Object)"totalPages").toString());
            String moreUrl = jason.get((Object)"moreUrl").toString();
            ArrayList<String> sources = new ArrayList<String>(totalPages);
            sources.add(knowledgeSource);
            Map<String, Object> parseResult = this.parse(sources);
            if (WfUtils.isNotEmpty((String)moreUrl)) {
                int produceId = KnowledgeServiceHelper.getProductId();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("productId", produceId);
                params.put("domain", searchParams.getDomain());
                params.put("module", searchParams.getModule());
                String destUrl = this.getUrlParamsByMap(params);
                parseResult.put("moreUrl", moreUrl + RevProxyUtil.getHttpParamCollectFlag((String)moreUrl) + destUrl);
            }
            result = parseResult;
        }
        catch (Exception e) {
            this.logger.error("getHelpInfo error", (Throwable)e);
            result = JSON.parseObject((String)knowledgeSource, Map.class);
        }
        String log = "";
        if (this.isHomepage()) {
            log = "MessageCenterPlugin.knowledgeSearch isHomepage";
            entityUrl = this.getEntityUrl();
        } else {
            try {
                log = "MessageCenterPlugin.knowledgeSearch is not Homepage";
                entityUrl = (String)future.get();
            }
            catch (Exception e) {
                this.logger.error("MessageCenterPlugin.knowledgeSearch getKnowledgeSpecial error", (Throwable)e);
            }
        }
        this.logger.debug(log);
        this.showHotQuestion(result, entityUrl);
    }

    public static enum TabTypeEnum {
        TASKTYPEENUM(1, "task"),
        MSG(2, "message");

        private int key;
        private String value;

        private TabTypeEnum(int key, String value) {
            this.key = key;
            this.value = value;
        }

        public int getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

