/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.portal.pluginnew.HomePageSideBarPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.svc.control.events.HomePageSideBarEvent;
import org.apache.commons.lang.time.DateFormatUtils;

public class MsgCenterSideBarPlugin
extends HomePageSideBarPlugin {
    private static final String ENTITY_NUMBER = "entityNumber";
    public static final String SHOW_TEAM_WORK = "showTeamWork";
    public static final String PICTUREFIELD = "picturefield";
    public static final String PAGE_ID = "pageId";
    public static final String BILL_NAME = "billName";
    public static final String USERNAME = "username";
    public static final String TO_SHARE_FORM = "toShareForm";
    public static final String SHARE_FORM_ID = "shareFormId";
    public static final String SHARE_PK_ID = "sharePkId";
    public static final String SHARE_BILL_NAME = "shareBillName";
    public static final String APPMIANTAB = "appmiantab";
    public static final String SUBMAINTAB = "_submaintab_";
    private Log logger = LogFactory.getLog(MsgCenterSideBarPlugin.class);

    public void homePageSideBarclick(HomePageSideBarEvent evt) {
        this.logger.info("MsgCenterSideBarPlugin_2: into homePageSideBarclick");
        if (!(evt instanceof HomePageSideBarEvent)) {
            return;
        }
        IFormView currentAppView = this.getCurrentAppView();
        if (currentAppView == null) {
            return;
        }
        HomePageSideBarEvent event = evt;
        Map paramsMap = event.getArgs();
        if (null != paramsMap && "wf_msg_center".equals(currentAppView.getEntityId())) {
            this.logger.info("MsgCenterSideBarPlugin_4: into condition");
            Object controlKey = paramsMap.get("controlKey");
            if ("pageTeamWork".equals(controlKey)) {
                this.showTeamWork();
            }
        }
    }

    private void showTeamWork() {
        IFormView appView = this.getCurrentAppView();
        this.logger.info("MsgCenterSideBarPlugin_5: showTeamWork" + appView);
        if (appView == null) {
            return;
        }
        Tab apptabs = (Tab)appView.getControl(SUBMAINTAB);
        HashMap<String, Object> parseResult = new HashMap<String, Object>(8);
        IFormView currentView = null;
        if (apptabs != null) {
            String billFormId = null;
            String currentTab = apptabs.getCurrentTab();
            String bizDataId = null;
            String appId = System.getProperty("YZJAppID");
            String domainUrl = UrlService.getDomainContextUrl();
            if (kd.bos.util.StringUtils.isNotEmpty((String)domainUrl) && domainUrl.endsWith("/")) {
                domainUrl = domainUrl.substring(0, domainUrl.length() - 1);
            }
            StringBuilder authCode = new StringBuilder();
            if (APPMIANTAB.equals(currentTab)) {
                billFormId = APPMIANTAB;
            } else {
                currentView = this.getView().getViewNoPlugin(currentTab);
                if (currentView == null) {
                    return;
                }
                this.logger.info("showTeamWork1:" + currentView.getPageCache().toString());
                if (currentView instanceof ListView) {
                    billFormId = ((ListView)currentView).getBillFormId();
                } else {
                    billFormId = this.getBillFormIdFromView(currentView);
                    Object pkId = currentView.getPageCache().get("businesskey");
                    if (StringUtils.isBlank((Object)pkId)) {
                        pkId = currentView.getFormShowParameter().getCustomParam("pkId");
                    }
                    MainEntityType mainEntityType = null;
                    try {
                        mainEntityType = MetadataServiceHelper.getDataEntityType((String)billFormId);
                        if (mainEntityType != null && mainEntityType.getDisplayName() != null && StringUtils.isNotEmpty((CharSequence)mainEntityType.getDisplayName().getLocaleValue())) {
                            parseResult.put(BILL_NAME, mainEntityType.getDisplayName().getLocaleValue());
                        }
                    }
                    catch (Exception e) {
                        this.logger.info("MessageCenterPlugin_showTeamWork : mainEntityType is null");
                    }
                    if (null != pkId && !"0".equals(pkId) && StringUtils.isNotBlank((CharSequence)billFormId)) {
                        bizDataId = String.valueOf(pkId);
                        authCode.append(bizDataId);
                        DynamicObject obj = null;
                        try {
                            obj = BusinessDataServiceHelper.loadSingle((Object)bizDataId, (String)billFormId);
                        }
                        catch (Exception e) {
                            this.logger.info("MessageCenterPlugin_showTeamWork : DynamicObject is null");
                        }
                        if (obj != null) {
                            String billno = null;
                            DynamicPropertyCollection property = (DynamicPropertyCollection)obj.getDataEntityType().getProperties();
                            Date createTime = null;
                            try {
                                createTime = obj.getDate("createtime");
                            }
                            catch (Exception e) {
                                this.logger.info("MessageCenterPlugin_showTeamWork : createtime is null");
                            }
                            DynamicObject creator = null;
                            try {
                                creator = obj.getDynamicObject("creator");
                            }
                            catch (Exception e) {
                                this.logger.info("MessageCenterPlugin_showTeamWork : creator is null");
                            }
                            if (property.containsKey((Object)"billno")) {
                                billno = obj.getString("billno");
                            }
                            if (createTime != null) {
                                authCode.append(createTime.getTime());
                                parseResult.put("createDate", DateFormatUtils.format((Date)createTime, (String)"yyyyMMdd"));
                                parseResult.put("createTime", DateFormatUtils.format((Date)createTime, (String)"HHmmss"));
                            }
                            if (creator != null) {
                                authCode.append(creator.get("masterid"));
                                parseResult.put("creatorId", creator.get("masterid"));
                                OrmLocaleValue nameLocalVal = (OrmLocaleValue)creator.get("name");
                                String name = nameLocalVal.get((Object)"zh_CN");
                                parseResult.put(USERNAME, name);
                                parseResult.put("creatorName", name);
                            }
                            if (kd.bos.util.StringUtils.isNotEmpty((String)billno)) {
                                parseResult.put(BILL_NAME, parseResult.get(BILL_NAME) + "-" + billno);
                            }
                            HashMap<String, String> data = new HashMap<String, String>(16);
                            data.put(SHARE_PK_ID, bizDataId);
                            data.put(SHARE_FORM_ID, billFormId);
                            data.put(SHARE_BILL_NAME, (String)parseResult.get(BILL_NAME));
                            this.getPageCache().put(TO_SHARE_FORM, SerializationUtils.toJsonString(data));
                        }
                        parseResult.put("billLink", domainUrl + "/index.html?pkId=" + bizDataId + "&formId=" + billFormId + "&appId=" + appId);
                    }
                }
                if (billFormId == null) {
                    billFormId = currentView.getFormShowParameter().getFormId();
                }
            }
            String dataCenterId = RequestContext.get().getAccountId();
            ArrayList<Long> userIds = new ArrayList<Long>(1);
            userIds.add(Long.parseLong(RequestContext.get().getUserId()));
            List userInfoList = UserServiceHelper.get(userIds, (String[])new String[]{"id", "eid", USERNAME, PICTUREFIELD, "name"}, null);
            if (StringUtils.isEmpty(bizDataId) || "0".equals(bizDataId)) {
                bizDataId = billFormId;
                StringBuilder temp = new StringBuilder(bizDataId).append(dataCenterId);
                authCode.append((CharSequence)temp);
            }
            parseResult.put("bizDataId", bizDataId);
            parseResult.put("dataCenterId", dataCenterId);
            parseResult.put("oid", RequestContext.get().getUserOpenId());
            parseResult.put("appId", appId);
            if (null != userInfoList && !userInfoList.isEmpty()) {
                parseResult.put("userId", ((Map)userInfoList.get(0)).get("id"));
                parseResult.put("eid", ((Map)userInfoList.get(0)).get("eid"));
                OrmLocaleValue nameLocalVal = (OrmLocaleValue)((Map)userInfoList.get(0)).get("name");
                String name = nameLocalVal.get((Object)"zh_CN");
                parseResult.put(USERNAME, name);
                Map photoUrlMap = UserServiceHelper.getUserAvatarPath(userIds, (boolean)true);
                if (photoUrlMap != null) {
                    parseResult.put(PICTUREFIELD, photoUrlMap.get(userIds.get(0)));
                } else {
                    parseResult.put(PICTUREFIELD, "");
                }
            }
            parseResult.put("authCode", authCode);
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PAGE_ID, currentView == null ? this.getView().getPageId() : currentView.getPageId());
        params.put("data", parseResult);
        proxy.addAction(SHOW_TEAM_WORK, params);
    }

    private String getBillFormIdFromView(IFormView view) {
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)view.getFormShowParameter().getCustomParam(ENTITY_NUMBER)))) {
            return (String)view.getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        }
        if (StringUtils.isNotBlank((CharSequence)view.getPageCache().get(ENTITY_NUMBER))) {
            return view.getPageCache().get(ENTITY_NUMBER);
        }
        if (StringUtils.isNotBlank((CharSequence)view.getPageCache().get("entitynumber"))) {
            return view.getPageCache().get("entitynumber");
        }
        if (StringUtils.isNotBlank((CharSequence)view.getPageCache().get("formkey"))) {
            return view.getPageCache().get("formkey");
        }
        if (StringUtils.isNotBlank((CharSequence)view.getPageCache().get("formKey"))) {
            return view.getPageCache().get("formKey");
        }
        return (String)view.getFormShowParameter().getCustomParams().get("formId");
    }

    private IFormView getCurrentAppView() {
        Tab appTab = (Tab)this.getView().getControl("tabap");
        String currentTab = appTab.getCurrentTab();
        IFormView view = this.getView().getViewNoPlugin(currentTab);
        if (view != null) {
            this.logger.info("MsgCenterSideBarPlugin_view1:" + view.getEntityId());
        }
        return view;
    }
}

