/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class TaskCirculationPlugin
extends AbstractWorkflowPlugin {
    private static final String CIRCULATIONPERSON = "circulationperson";
    private static final String TASKCIRCULATION_MSG = "taskcirculation_msg";
    private static final String TASKID = "taskid";
    public static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
        BasedataEdit bosUserF7 = (BasedataEdit)this.getControl(CIRCULATIONPERSON);
        bosUserF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
        List<QFilter> qFilters = ApprovalPluginUtil.addPersonFiltersCustomEvent(this.getView(), null);
        if (null == qFilters || qFilters.isEmpty()) {
            return;
        }
        bosUserF7.setQFilters(qFilters);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(TASKCIRCULATION_MSG, (Object)ResManager.loadKDString((String)"\u8bf7\u53c2\u9605\u3002", (String)"TaskCirculationPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.showSubmitBtn();
                break;
            }
        }
    }

    private void showSubmitBtn() {
        DynamicObjectCollection userCollection = (DynamicObjectCollection)this.getModel().getValue(CIRCULATIONPERSON);
        HashSet<Long> selectUserList = new HashSet<Long>(userCollection.size());
        for (DynamicObject dynamicObject : userCollection) {
            DynamicObject userObject = dynamicObject.getDynamicObject("fbasedataid");
            Long UserId = (Long)userObject.getPkValue();
            selectUserList.add(UserId);
        }
        ILocaleString circulationMsg = (ILocaleString)this.getModel().getValue(TASKCIRCULATION_MSG);
        LocaleString circulationOption = new LocaleString();
        for (Map.Entry entry : circulationMsg.entrySet()) {
            circulationOption.put((String)entry.getKey(), entry.getValue());
        }
        boolean isValidateSuccess = this.showValidateSubmitResult(selectUserList, circulationMsg);
        if (isValidateSuccess) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long taskId = (Long)customParams.get(TASKID);
            Long senderUserId = Long.valueOf(RequestContext.get().getUserId());
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            TaskService taskService = wfService.getTaskService();
            try {
                Map result = taskService.taskCirculation(taskId, new ArrayList<Long>(selectUserList), (ILocaleString)circulationOption, senderUserId);
                Boolean isSuccess = (Boolean)result.get("issuccess");
                if (!isSuccess.booleanValue()) {
                    this.getView().showTipNotification(result.get("message").toString());
                } else {
                    this.getView().returnDataToParent((Object)selectUserList.size());
                    this.getView().close();
                }
            }
            catch (KDException e) {
                this.getView().showTipNotification(e.getErrorCode().getMessage());
                this.logger.warn("\u4e91\u4e4b\u5bb6\u5f85\u529e\u53d1\u9001\u5931\u8d25", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.warn("\u4e91\u4e4b\u5bb6\u5f85\u529e\u53d1\u9001\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public boolean showValidateSubmitResult(Set<Long> userIds, ILocaleString circulationMsg) {
        if (userIds == null || userIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4eba\u5458\u3002", (String)"TaskCirculationPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (WfUtils.isEmpty((ILocaleString)circulationMsg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u4f20\u9605\u610f\u89c1\u201d\u3002", (String)"TaskCirculationPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

