/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.monitor.plugin.WorkflowUserUtil;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class TaskCoordinatePlugin
extends AbstractWorkflowPlugin {
    private static final String TASKCOORDINATE_MSG = "taskcoordinate_msg";
    private static final String COORDINATER = "coordinater";
    private static final String BTNOK = "btnok";
    private static final String BTNCANCEL = "btncancel";
    private static final String TASKID = "taskid";
    private static final String ISTASKCOORDINATE = "is_taskcoordinate";
    private static final String ISPBULIC = "ispublic";

    public void registerListener(EventObject e) {
        BasedataEdit bosUserF7 = (BasedataEdit)this.getControl(COORDINATER);
        List<QFilter> qFilters = ApprovalPluginUtil.addPersonFiltersCustomEvent(this.getView(), null);
        if (null == qFilters || qFilters.isEmpty()) {
            return;
        }
        bosUserF7.setQFilters(qFilters);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTNOK, BTNCANCEL});
        WorkflowUserUtil.showUsersAddCustomParam(this.getView(), new String[]{COORDINATER});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(TASKCOORDINATE_MSG, (Object)WFMultiLangConstants.getCoordinateMsgDefaultTip());
        String isTaskCoodinate = (String)this.getView().getFormShowParameter().getCustomParams().get(ISTASKCOORDINATE);
        if (Boolean.parseBoolean(isTaskCoodinate)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ISPBULIC});
            MulBasedataEdit coordinater = (MulBasedataEdit)this.getView().getControl(COORDINATER);
            coordinater.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u81f3", (String)"TaskCoordinatePlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getTransferName())));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTNOK.equals(key)) {
            this.showSubmitBtn();
        } else if (BTNCANCEL.equals(key)) {
            this.showClosePage();
        }
    }

    private void showClosePage() {
        this.getView().close();
    }

    private void showSubmitBtn() {
        Boolean isValidateSuccess = this.showValidateSubmitResult();
        if (isValidateSuccess.booleanValue()) {
            ArrayList<Long> userIds = new ArrayList<Long>();
            DynamicObjectCollection userObjects = (DynamicObjectCollection)this.getModel().getValue(COORDINATER);
            for (DynamicObject userObject : userObjects) {
                userIds.add(userObject.getLong("fbasedataid_id"));
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long taskId = (Long)customParams.get(TASKID);
            Boolean isTaskCoodinate = Boolean.valueOf((String)customParams.get(ISTASKCOORDINATE));
            if (isTaskCoodinate.booleanValue()) {
                boolean exists = CoordinateRecordUtil.coordinateRecoredIsExist((Long)taskId);
                if (!exists) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5904\u7406\u3002", (String)"TaskCoordinatePlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                boolean isParticipant = CoordinateRecordUtil.isParticipant((Long)taskId, (String)RequestContext.get().getUserId(), (String)"participant");
                if (!isParticipant) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u53ef\u80fd\u5df2\u7ecf\u88ab\u5904\u7406\uff0c\u65e0\u9700\u91cd\u590d\u5904\u7406\u3002", (String)"TaskCoordinatePlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            try {
                ILocaleString coordinateMsg = (ILocaleString)this.getModel().getValue(TASKCOORDINATE_MSG);
                Boolean isPublic = (Boolean)this.getModel().getValue(ISPBULIC);
                String retMsg = this.getTaskService().taskCoordinateRequest(taskId, isTaskCoodinate, userIds, coordinateMsg, Long.valueOf(RequestContext.get().getUserId()), isPublic);
                JSONObject ret = new JSONObject();
                ret.put("retmsg", (Object)retMsg);
                ret.put(ISTASKCOORDINATE, (Object)isTaskCoodinate);
                this.getView().returnDataToParent((Object)ret);
                this.getView().close();
            }
            catch (Exception e) {
                if (e instanceof WFEngineException) {
                    this.getView().showErrorNotification(e.getMessage());
                }
                this.getView().showErrMessage(WfUtils.getExceptionStacktrace((Throwable)e), ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\u3002", (String)"TaskCoordinatePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public Boolean showValidateSubmitResult() {
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam(TASKID);
        boolean exists = QueryServiceHelper.exists((String)"wf_task", (Object)taskId);
        if (!exists) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5904\u7406\u3002", (String)"TaskCoordinatePlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        DynamicObjectCollection userObjects = (DynamicObjectCollection)this.getModel().getValue(COORDINATER);
        if (userObjects == null || userObjects.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4eba\u5458\u3002", (String)"TaskCoordinatePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        Boolean isTaskCoodinate = Boolean.valueOf((String)this.getView().getFormShowParameter().getCustomParams().get(ISTASKCOORDINATE));
        if (isTaskCoodinate.booleanValue() && userObjects.size() > 1) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u201c%2$s\u201d\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u4eba\u3002", (String)"TaskCoordinatePlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName(), WfConfigurationUtil.getTransferName()));
            return Boolean.FALSE;
        }
        Map userInfos = CoordinateRecordUtil.getParticipantsByTaskId((Long)taskId);
        ArrayList<String> existPartipanters = new ArrayList<String>();
        ArrayList<String> existCoordinaters = new ArrayList<String>();
        for (DynamicObject userObject : userObjects) {
            DynamicObject dynamicObject = userObject.getDynamicObject("fbasedataid");
            Long userId = (Long)dynamicObject.getPkValue();
            if (userInfos.get(userId) == null) continue;
            ILocaleString userName = WfUtils.findUserName((Long)userId);
            if ("participant".equals(userInfos.get(userId))) {
                existPartipanters.add(userName.getLocaleValue());
                continue;
            }
            if (!"coordinate".equals(userInfos.get(userId))) continue;
            existCoordinaters.add(userName.getLocaleValue());
        }
        if (!existPartipanters.isEmpty() || !existCoordinaters.isEmpty()) {
            String format;
            StringBuilder sb = new StringBuilder();
            if (!existPartipanters.isEmpty()) {
                String join = Joiner.on((String)",").join(existPartipanters);
                String tips = ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u4efb\u52a1\u53c2\u4e0e\u4eba\uff0c\u4e0d\u80fd\u9080\u8bf7\u201c\u534f\u529e\u201d\u3002", (String)"TaskCoordinatePlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                format = String.format(tips, join);
                sb.append(format);
            }
            if (!existCoordinaters.isEmpty()) {
                String tips = ResManager.loadKDString((String)"%1$s\u4e3a\u4efb\u52a1\u7684%2$s\u4eba\uff0c\u4e14\u8fd8\u672a\u5904\u7406%3$s\uff0c\u4e0d\u80fd\u518d\u6b21\u9080\u8bf7%4$s\u3002", (String)"TaskCoordinatePlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                String join = Joiner.on((String)",").join(existCoordinaters);
                format = String.format(tips, join, WfConfigurationUtil.getCoordinateName(), WfConfigurationUtil.getCoordinateName(), WfConfigurationUtil.getCoordinateName());
                sb.append(format);
            }
            this.getView().showErrorNotification(sb.toString());
            return Boolean.FALSE;
        }
        ILocaleString circulationMsg = (ILocaleString)this.getModel().getValue(TASKCOORDINATE_MSG);
        if (WfUtils.isEmpty((ILocaleString)circulationMsg)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5185\u5bb9\u3002", (String)"TaskCoordinatePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

