/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class TaskReminderPlugin
extends AbstractWorkflowPlugin {
    private static final String TASKDEALPERSON = "taskdealperson";
    private static final String REMINDER_MSG = "reminder_msg";
    private static final String BTNOK = "btnok";
    private static final String BTNCANCEL = "btncancel";
    public static final String EXECUTIONID = "executionId";
    public static final String ALLUSERNAME = "allUserName";

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTNOK, BTNCANCEL});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long executionId = (Long)customParams.get(EXECUTIONID);
        String allUserName = (String)customParams.get(ALLUSERNAME);
        this.getPageCache().put(EXECUTIONID, executionId.toString());
        this.getModel().setValue(TASKDEALPERSON, (Object)allUserName.substring(0, allUserName.length() - 1));
        this.getView().setEnable(Boolean.FALSE, new String[]{TASKDEALPERSON});
        this.getModel().setValue(REMINDER_MSG, (Object)ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u4e8b\u60c5\u7d27\u6025\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff0c\u8c22\u8c22\u3002", (String)"TaskReminderPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.showSubmitBtn();
                break;
            }
            case "btncancel": {
                this.getModel().setDataChanged(false);
                this.getView().close();
                break;
            }
        }
    }

    private void showSubmitBtn() {
        try {
            ILocaleString reminderMsg = (ILocaleString)this.getModel().getValue(REMINDER_MSG);
            if (WfUtils.isEmpty((ILocaleString)reminderMsg)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u610f\u89c1\u201d\u3002", (String)"TaskReminderPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getUrgeName()));
                return;
            }
            Map<String, Object> returnInfo = ApprovalPluginUtil.showTaskReminderResult(Long.valueOf(this.getPageCache().get(EXECUTIONID)), reminderMsg, "submit");
            this.getView().showMessage((String)returnInfo.get("showMsg"));
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }
}

