/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.model.AuditComment;
import kd.bos.workflow.bpmn.model.AuditCommentModel;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WfMobCommonAuditCommentPlugin
extends AbstractWorkflowPlugin
implements RowClickEventListener {
    WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
    private static final String BOS_WF_FORMPLUGIN = "bos-wf-formplugin";
    private static final String PROCESSDEFINITIONID = "processDefinitionId";
    private static final String PROCESSINSTANCEID = "processInstanceId";
    private static final String TASKDEFINITIONKEY = "taskdefinitionkey";
    private static final String ENTRYENTITY = "entryentity";
    private static final String AUDITCOMMENT = "auditcomment";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long processDefinitionId = Long.valueOf((String)parameter.getCustomParam(PROCESSDEFINITIONID));
        Long processInstanceId = Long.valueOf((String)parameter.getCustomParam(PROCESSINSTANCEID));
        if (WfUtils.isEmpty((Long)processDefinitionId) && WfUtils.isEmpty((Long)processInstanceId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5ba1\u6279\u573a\u666f\u65e0\u5e38\u7528\u5ba1\u6279\u610f\u89c1\u3002", (String)"WfMobCommonAuditCommentPlugin_0", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        BpmnModel bpmnModel = this.wfService.getRepositoryService().getBpmnModel(processDefinitionId, processInstanceId);
        String taskDefinitionKey = (String)parameter.getCustomParam(TASKDEFINITIONKEY);
        if (WfUtils.isEmpty((String)taskDefinitionKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5ba1\u6279\u573a\u666f\u65e0\u5e38\u7528\u5ba1\u6279\u610f\u89c1\u3002", (String)"WfMobCommonAuditCommentPlugin_0", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        AuditTask auditTask = (AuditTask)bpmnModel.getFlowElement(taskDefinitionKey);
        AuditCommentModel commentModel = auditTask.getAuditCommentModel();
        if (commentModel != null && commentModel.isAuditCommentWhenMatch()) {
            String auditNumber = (String)parameter.getCustomParam("auditNumber");
            if (WfUtils.isEmpty((String)auditNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5ba1\u6279\u573a\u666f\u65e0\u5e38\u7528\u5ba1\u6279\u610f\u89c1\u3002", (String)"WfMobCommonAuditCommentPlugin_0", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            List comments = commentModel.getAuditComments();
            if (!(comments = comments.stream().filter(comment -> WfUtils.isNotEmpty((String)comment.getDecision())).filter(comment -> comment.getDecision().contains(auditNumber) && WfUtils.isNotEmpty((String)comment.getContent())).collect(Collectors.toList())).isEmpty()) {
                int i = 0;
                for (AuditComment comment2 : comments) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)comment2.getBasedataid(), (String)"wf_commonauditcommenttree", (String)"name");
                    if (null == dynamicObject) continue;
                    this.getModel().createNewEntryRow(ENTRYENTITY);
                    this.getModel().setValue(AUDITCOMMENT, (Object)dynamicObject.getLocaleString("name"), i);
                    ++i;
                }
            } else if (WfConfigurationUtil.enableGetCommentFromBasedata()) {
                String auditType = (String)parameter.getCustomParam("auditType");
                if (WfUtils.isEmpty((String)auditType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5ba1\u6279\u573a\u666f\u65e0\u5e38\u7528\u5ba1\u6279\u610f\u89c1\u3002", (String)"WfMobCommonAuditCommentPlugin_0", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                QFilter qDecisionType = new QFilter("decisiontype", "=", (Object)auditType);
                QFilter qEnable = new QFilter("enable", "=", (Object)Boolean.TRUE);
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"wf_commonauditcommenttree", (String)"name", (QFilter[])new QFilter[]{qDecisionType, qEnable}, (String)"number");
                int i = 0;
                int length = dynamicObjects.length;
                if (length > 0) {
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        ILocaleString auditName = dynamicObject.getLocaleString("name");
                        String localeValue = WfMultiLangUtils.getValueFromLocalString((ILocaleString)auditName, (String)RequestContext.get().getLang().toString());
                        if (!WfUtils.isNotEmpty((String)localeValue)) continue;
                        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 1);
                        this.getModel().setValue(AUDITCOMMENT, (Object)localeValue, i);
                        ++i;
                    }
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5ba1\u6279\u573a\u666f\u65e0\u5e38\u7528\u5ba1\u6279\u610f\u89c1\u3002", (String)"WfMobCommonAuditCommentPlugin_0", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        this.getView().returnDataToParent(this.getModel().getValue(AUDITCOMMENT, row));
        this.getView().close();
    }
}

