/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.component.WfCondition;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterNavigationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterNavigationEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterOperationMetaEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterRuleEntityImpl;
import kd.bos.workflow.taskcenter.plugin.rule.util.ConditionConvertUtils;

public class WfTaskFolderEditPlugin
extends AbstractWorkflowPlugin {
    private static final String WF_TASK_FOLDER_EDIT_PLUGIN_7 = "WfTaskFolderEditPlugin_7";
    private static final String FOLDER_ID = "folderId";

    @Override
    public void initialize() {
        super.initialize();
        Button btn = (Button)this.getControl("cancel");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getControl("confirm");
        btn.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String value = (String)this.getView().getFormShowParameter().getCustomParam("folderValue");
        WfCondition conditionap = (WfCondition)this.getControl("condition");
        if (WfUtils.isNotEmpty((String)value)) {
            Map folderValue = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            long folderId = Long.parseLong((String)folderValue.get("id"));
            long taskcenterruleid = Long.parseLong((String)folderValue.get("taskcenterruleid"));
            this.getPageCache().put(FOLDER_ID, Long.toString(folderId));
            TaskCenterNavigationEntity navigationEntity = (TaskCenterNavigationEntity)this.getRepositoryService().findEntityById(Long.valueOf(folderId), "wf_tasknavigation");
            if (navigationEntity == null) {
                return;
            }
            ILocaleString folderName = navigationEntity.getName();
            folderName.setLocaleValue(folderName.toString());
            this.getModel().setValue("foldername", (Object)folderName);
            if (WfUtils.isNotEmpty((Long)taskcenterruleid)) {
                TaskCenterRuleEntity rulEntity = (TaskCenterRuleEntity)this.getRepositoryService().findEntityById(Long.valueOf(taskcenterruleid), "wf_taskattributerule");
                List conditionals = rulEntity.getConditionalRuleModel().getEntryentity();
                String taskEntityNumber = "";
                for (ConditionalEntity entity : conditionals) {
                    Map valMap;
                    Object obj;
                    if (!"task.entityNumber".equalsIgnoreCase(entity.getParamnumber())) continue;
                    String taskEntityNumberValue = entity.getValue();
                    if (WfUtils.isEmpty((String)taskEntityNumberValue) || !((obj = (valMap = (Map)SerializationUtils.fromJsonString((String)taskEntityNumberValue, Map.class)).get("task.entityNumber")) instanceof List) || ((List)obj).size() <= 0) break;
                    Map tmp = (Map)((List)obj).get(0);
                    taskEntityNumber = (String)tmp.get("number");
                    break;
                }
                conditionap.setEntityIdAndFilters(taskEntityNumber, true, null);
                List<Map<String, Object>> conditionItms = ConditionConvertUtils.getConditionItems(conditionals);
                conditionap.SetValue(conditionItms);
            }
        } else {
            conditionap.setEntityIdAndFilters(null, true, null);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "cancel": {
                this.closeWin();
                break;
            }
            case "confirm": {
                this.saveOrUpdateFolder();
                break;
            }
            case "delete": {
                this.delete();
                break;
            }
        }
    }

    private void closeWin() {
        this.getPageCache().remove(FOLDER_ID);
        this.getView().close();
    }

    private void saveOrUpdateFolder() {
        ILocaleString name = (ILocaleString)this.getModel().getValue("foldername");
        if (WfUtils.isEmpty((String)name.getLocaleValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6587\u4ef6\u5939\u540d\u79f0\u201d\u3002", (String)"WfTaskFolderEditPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        for (Lang lang : WfUtils.getSupportLangs()) {
            if (!WfUtils.isEmpty((String)((String)name.get((Object)lang.toString())))) continue;
            name.setItem(lang.toString(), (Object)name.toString());
        }
        String uid = RequestContext.get().getUserId();
        long userid = Long.parseLong(uid);
        String number = UUID.randomUUID().toString();
        WfCondition conditionap = (WfCondition)this.getControl("condition");
        List<Map<String, Object>> conditionItems = conditionap.getValue();
        if (conditionItems == null || conditionItems.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6761\u4ef6\u9879\u201d\u3002", (String)"WfTaskFolderEditPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        int i = 1;
        for (Map<String, Object> conditionItem : conditionItems) {
            Object value = conditionItem.get("value");
            if (value instanceof Map) {
                Map map = (Map)value;
                String compareType = conditionItem.get("compareType").toString();
                long count = map.values().stream().filter(o -> WfUtils.isNullObject((Object)o) || WfUtils.isEmptyString((Object)o)).count();
                if (count != 0L && !compareType.contains("empty")) {
                    String format = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u503c\u3002", (String)"WfTaskFolderEditPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), i);
                    this.getView().showTipNotification(format, Integer.valueOf(3000));
                    return;
                }
            }
            ++i;
        }
        String folderId = this.getPageCache().get(FOLDER_ID);
        String newExpression = ConditionConvertUtils.getExpressionFromMap(conditionItems);
        if (newExpression.length() > 2000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u6761\u4ef6\u89c4\u5219\u5185\u5bb9\u5b57\u7b26\u603b\u957f\u5ea6\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u7b80\u5316\u6761\u4ef6\u89c4\u5219\u5185\u5bb9\u3002", (String)"WfTaskCenterRulePlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter f1 = new QFilter("name", "=", (Object)name.getLocaleValue());
        QFilter f2 = new QFilter("userid", "=", (Object)userid);
        QFilter f3 = new QFilter("type", "=", (Object)"folder");
        QFilter f4 = new QFilter("expression", "=", (Object)newExpression);
        TaskCenterNavigationEntity entity = null;
        if (WfUtils.isEmpty((String)folderId)) {
            if (this.getTaskService().existTaskCenterRuleEntity(new QFilter[]{f1, f2, f3, f4}).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u5939\u5df2\u5b58\u5728\u3002", (String)"WfTaskFolderEditPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            entity = new TaskCenterNavigationEntityImpl();
        } else {
            entity = (TaskCenterNavigationEntity)this.getRepositoryService().findEntityById(Long.valueOf(folderId), "wf_tasknavigation");
            number = entity.getNumber();
            QFilter f5 = new QFilter("id", "!=", (Object)entity.getTaskcenterruleid());
            if (this.getTaskService().existTaskCenterRuleEntity(new QFilter[]{f1, f2, f3, f4, f5}).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u5939\u5df2\u5b58\u5728\u3002", (String)"WfTaskFolderEditPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
        }
        String operateparams = "{\"folderId\":\"" + folderId + "\"}";
        TaskCenterRuleEntity taskCenterRule = (TaskCenterRuleEntity)this.getRepositoryService().findEntityById(entity.getTaskcenterruleid(), "wf_taskattributerule");
        taskCenterRule = taskCenterRule == null ? new TaskCenterRuleEntityImpl() : taskCenterRule;
        taskCenterRule.setUserid(Long.valueOf(userid));
        taskCenterRule.setName(name);
        taskCenterRule.setNumber(number);
        taskCenterRule.setType("folder");
        taskCenterRule.setActivitstate("enable");
        ArrayList<TaskCenterOperationMetaEntityImpl> operationMetas = new ArrayList<TaskCenterOperationMetaEntityImpl>();
        TaskCenterOperationMetaEntityImpl operationMeta = new TaskCenterOperationMetaEntityImpl();
        operationMeta.setOperationkey("moveToFolder");
        operationMeta.setOperateparams(operateparams);
        operationMetas.add(operationMeta);
        ConditionalRuleEntity conditionRuleModel = ConditionConvertUtils.getConditionalRule(conditionItems, taskCenterRule.getConditionalRuleModel());
        taskCenterRule.setConditionalRuleModel(conditionRuleModel);
        String oldExpression = taskCenterRule.getExpression();
        if (WfUtils.isNotEmpty((String)oldExpression) && !oldExpression.equals(newExpression)) {
            this.getTaskService().clearFolderData(folderId);
        }
        taskCenterRule.setExpression(ConditionConvertUtils.getExpressionFromMap(conditionItems));
        taskCenterRule.setOperationMetas(operationMetas);
        entity.setUserid(Long.valueOf(userid));
        entity.setName(name);
        entity.setNumber(number);
        entity.setActivitstate("enable");
        entity.setTaskCenterRuleEntity(taskCenterRule);
        this.getRepositoryService().saveOrUpdateEntity((Entity)entity);
        if (WfUtils.isEmpty((String)folderId)) {
            WfUtils.addOpLog((String)"", (String)"addFolder", (MultiLangEnumBridge)new MultiLangEnumBridge("\u589e\u52a0\u6587\u4ef6\u5939", "WfTaskFolderEditPlugin_5", "bos-wf-formplugin"), null, (Object[])new Object[]{String.format("Id:[%s]%s", entity.getId(), entity.getName())});
        } else {
            WfUtils.addOpLog((String)"", (String)"modifyFolder", (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fee\u6539\u6587\u4ef6\u5939", "WfTaskFolderEditPlugin_6", "bos-wf-formplugin"), null, (Object[])new Object[]{String.format("Id:[%s]%s", entity.getId(), entity.getName())});
        }
        boolean isDisable = (Boolean)this.getModel().getValue("activitstate");
        if (isDisable) {
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            Long foldId = entity.getId();
            Long taskCount = this.getTaskService().getTaskCenterDataCount(RequestContext.get().getUserId(), "toHandle", "", "", new ArrayList());
            if (taskCount > 100L) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("userId", userId);
                params.put(FOLDER_ID, foldId);
                this.showForm("addexisttasktofolder", "wf_addtofoldconfirm", params);
            } else {
                this.getTaskService().executeFodler(userId, foldId, false);
                this.closeWin();
                this.getView().showSuccessNotification(this.getSuccessTips(), Integer.valueOf(3000));
            }
        } else {
            this.closeWin();
            this.getView().showSuccessNotification(this.getSuccessTips(), Integer.valueOf(3000));
        }
    }

    private void delete() {
        String folderId = this.getPageCache().get(FOLDER_ID);
        this.getRepositoryService().deleteEntity(Long.valueOf(folderId), "wf_tasknavigation");
        this.closeWin();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"WfTaskFolderEditPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.closeWin();
        this.getView().showSuccessNotification(this.getSuccessTips(), Integer.valueOf(3000));
    }

    private String getSuccessTips() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)WF_TASK_FOLDER_EDIT_PLUGIN_7, (String)"bos-wf-formplugin", (Object[])new Object[0]);
    }
}

