/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.BaseChangeLogsUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterOperationMetaEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskMarkEntity;
import kd.bos.workflow.engine.task.center.operation.OperationsRegister;

public class WfTaskRuleListPlugin
extends AbstractWorkflowPlugin {
    private static final String ISCALLBACK = "iscallback";
    private static final String BTNOK = "btnexit";
    private static final String RULE_LIST_ADD = "add";
    private static final String RULE_LIST_UPDATE = "update";
    private static final String RULE_LIST_DELETE = "delete";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String ENTITYNAME = "entryentity";
    private static final String RULEID = "ruleid";
    private static final String ISACTIVE = "isactive";
    private static final String RULENUMBER = "rulenumber";
    private static final String RULENAME = "rulename";
    private static final String saveOrUpdateRulePage = "wf_taskattributerule_cfg";

    @Override
    public void initialize() {
        this.addClickListeners(new String[]{BTNOK});
        this.addClickListeners(new String[]{RULE_LIST_ADD, RULE_LIST_UPDATE, RULE_LIST_DELETE});
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP});
    }

    public void afterCreateNewData(EventObject e) {
        this.refresh();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String ok;
        this.getModel().beginInit();
        this.getPageCache().put(ISCALLBACK, "true");
        this.refresh();
        this.getModel().endInit();
        this.getView().updateView();
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (("addRule".equals(actionId) || "updateRule".equals(actionId) && returnData instanceof String) && "ok".equals(ok = (String)returnData)) {
            String tips = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WfTaskCenterRulePlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(tips);
        }
    }

    public void refresh() {
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTITYNAME);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List ruleEntitys = this.getTaskService().getNoFolderTaskCenterRulesByUserId(userId);
        int i = 0;
        for (TaskCenterRuleEntity ruleEntity : ruleEntitys) {
            if ("autoExe".equals(ruleEntity.getType())) continue;
            model.batchCreateNewEntryRow(ENTITYNAME, 1);
            String activitState = ruleEntity.getActivitstate();
            boolean isActivit = "enable".equals(activitState);
            model.setValue(RULENAME, (Object)String.valueOf(ruleEntity.getName()), i);
            model.setValue(RULEID, (Object)ruleEntity.getId(), i);
            List operationMetas = ruleEntity.getOperationMetas();
            StringBuilder namesb = new StringBuilder();
            for (TaskCenterOperationMetaEntity operationMeta : operationMetas) {
                namesb.append(this.getOperationStr(operationMeta)).append(',');
            }
            if (namesb.length() > 1) {
                model.setValue(RULENUMBER, (Object)namesb.substring(0, namesb.length() - 1), i);
            } else {
                model.setValue(RULENUMBER, (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u6267\u884c\u4efb\u4f55\u64cd\u4f5c\u54e6", (String)"WfTaskRuleListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), i);
            }
            model.setValue(ISACTIVE, (Object)isActivit, i);
            ++i;
        }
        EntryGrid grid = (EntryGrid)this.getControl(ENTITYNAME);
        grid.selectRows(-1);
    }

    private String getOperationStr(TaskCenterOperationMetaEntity operationMeta) {
        String operationKey = operationMeta.getOperationkey();
        StringBuilder resultStr = new StringBuilder();
        resultStr.append(OperationsRegister.getInstance().getOperationNameByOperationKey(operationKey));
        String paramStr = operationMeta.getOperateparams();
        Map value = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
        switch (operationKey) {
            case "setTaskLevel": {
                Long levelId = Long.valueOf(value.get("levelId").toString());
                TaskMarkEntity taskMark = (TaskMarkEntity)this.getRepositoryService().findEntityById(levelId, "wf_taskmark");
                if (taskMark == null) break;
                resultStr = resultStr.append(taskMark.getName());
                break;
            }
            case "circulated": {
                Object obj = value.get("personIds");
                if (!(obj instanceof List)) break;
                List persons = (List)obj;
                resultStr.append(this.getUsersName(persons));
                break;
            }
            case "Transfer": {
                Object objs = value.get("Transfer");
                if (!(objs instanceof List)) break;
                List transfers = (List)objs;
                resultStr.append(this.getUsersName(transfers));
                break;
            }
        }
        return resultStr.toString();
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "add": {
                this.addRule(null, "addRule");
                break;
            }
            case "update": {
                this.updateRule();
                break;
            }
            case "delete": {
                int[] selectedRows = this.getFocusRows();
                if (selectedRows != null && selectedRows.length > 0) {
                    String tips = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"WfTaskCenterRulePlugin_18", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                    String format = String.format(tips, this.getFocusRows().length);
                    this.getView().showConfirm(format, MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener(RULE_LIST_DELETE, (IFormPlugin)this));
                    break;
                }
                StandardTips.view((IFormView)this.getView()).notSelectRow();
                break;
            }
            case "btnexit": {
                this.getView().close();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String resultValue;
        String callBackId = e.getCallBackId();
        if (RULE_LIST_DELETE.equals(callBackId) && "yes".equalsIgnoreCase(resultValue = e.getResultValue())) {
            this.deleteRule();
        }
    }

    private void addRule(Long ruleId, String closebackId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(saveOrUpdateRulePage);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closebackId));
        if (WfUtils.isNotEmpty((Long)ruleId)) {
            parameter.getCustomParams().put("ruleId", ruleId);
        }
        this.getView().showForm(parameter);
    }

    private void updateRule() {
        int[] selectedRows = this.getFocusRows();
        if (selectedRows.length == 1 && selectedRows[0] != -1) {
            Long ruleId = (Long)this.getModel().getValue(RULEID, selectedRows[0]);
            if (WfUtils.isEmpty((Long)ruleId)) {
                try {
                    throw new Exception(ResManager.loadKDString((String)"id\u4e3a\u7a7a", (String)"WfTaskRuleListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
                }
            }
            this.addRule(ruleId, "updateRule");
        } else {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        }
    }

    private void deleteRule() {
        int[] selectedRows = this.getFocusRows();
        if (selectedRows != null && selectedRows.length > 0) {
            for (int i = 0; i < selectedRows.length; ++i) {
                Long ruleId = (Long)this.getModel().getValue(RULEID, selectedRows[i]);
                TaskCenterRuleEntity entity = (TaskCenterRuleEntity)this.getRepositoryService().findEntityById(ruleId, "wf_taskattributerule");
                this.getRepositoryService().deleteEntity(ruleId, "wf_taskattributerule");
                WfUtils.addOpLog((String)"wf_taskattributerule", (String)RULE_LIST_DELETE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664", "WfTaskRuleListPlugin_8", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664name\u4e3a\uff1a%s", "WfTaskRuleListPlugin_4", "bos-wf-formplugin"), (Object[])new Object[]{entity.getName()});
                ILocaleString title = WfUtils.getPromptWordLocaleString((String)"\u5220\u9664\u81ea\u52a8\u89c4\u5219", (String)"WfTaskRuleListPlugin_5", (String)"bos-wf-formplugin");
                title = BaseChangeLogsUtil.mulitLangAppendString(title, String.format(":%s(%s)", entity.getName(), entity.getNumber()));
                BaseChangeLogsUtil.addLog(ruleId, "taskrule", RULE_LIST_DELETE, title, (ILocaleString)new LocaleString(), RequestContext.get().getUserId());
            }
            this.getModel().beginInit();
            this.getPageCache().put(ISCALLBACK, "true");
            this.refresh();
            this.getModel().endInit();
            this.getView().updateView();
        } else {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        }
    }

    private int[] getFocusRows() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTITYNAME);
        return grid.getSelectRows();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (ISACTIVE.equalsIgnoreCase(propertyName)) {
            EntryGrid grid = (EntryGrid)this.getControl(ENTITYNAME);
            int focusRow = grid.getEntryState().getFocusRow();
            Long ruleId = (Long)this.getModel().getValue(RULEID, focusRow);
            if (WfUtils.isEmpty((Long)ruleId)) {
                return;
            }
            TaskCenterRuleEntity centerEntity = (TaskCenterRuleEntity)this.getRepositoryService().findEntityById(ruleId, "wf_taskattributerule");
            boolean active = (Boolean)this.getModel().getValue(ISACTIVE, focusRow);
            String activitstate = active ? "enable" : "disable";
            centerEntity.setActivitstate(activitstate);
            this.getRepositoryService().saveOrUpdateTaskCenterRule(centerEntity);
            if (WfUtils.isEmpty((String)this.getPageCache().get(ISCALLBACK))) {
                ILocaleString title = active ? WfUtils.getPromptWordLocaleString((String)"\u542f\u7528\u81ea\u52a8\u89c4\u5219", (String)"WfTaskRuleListPlugin_6", (String)"bos-wf-formplugin") : WfUtils.getPromptWordLocaleString((String)"\u7981\u7528\u81ea\u52a8\u89c4\u5219", (String)"WfTaskRuleListPlugin_7", (String)"bos-wf-formplugin");
                title = BaseChangeLogsUtil.mulitLangAppendString(title, String.format(":%s(%s)", centerEntity.getName(), centerEntity.getNumber()));
                BaseChangeLogsUtil.addLog(ruleId, "taskrule", "modify", title, (ILocaleString)new LocaleString(), RequestContext.get().getUserId());
            }
            this.getPageCache().remove(ISCALLBACK);
            String tips = active ? ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"WfTaskCenterRulePlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"WfTaskCenterRulePlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(tips);
        }
    }

    private String getUsersName(List<Map<String, Object>> persons) {
        ArrayList<Long> userIds = new ArrayList<Long>(persons.size());
        for (int j = 0; j < persons.size(); ++j) {
            Map<String, Object> person = persons.get(j);
            userIds.add(Long.valueOf((String)person.get("value")));
        }
        return WfUtils.getUsersName(userIds);
    }
}

