/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.YzjContextMenuClickPlugin;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public class WfTeamWorkPlugin
extends AbstractWorkflowPlugin {
    private static final String ENTRYENTITY = "entryentity";
    public static final String TASKID = "taskId";
    public static final String USERID = "userId";
    public static final String USERIMG = "userimg";
    public static final String TWRESULT = "twresult";
    public static final String TWTIME = "twtime";
    public static final String TWMESSAGE = "twmessage";
    public static final String OPENID = "openid";
    public static final String HIDECHAT = "hideChat";
    public static final String TALKIMG = "talkimg";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{TALKIMG});
    }

    public void afterCreateNewData(EventObject e) {
        if (WfUtils.isNotEmptyString((Object)this.getView().getFormShowParameter().getCustomParam(TASKID)) && WfUtils.isNotEmptyString((Object)this.getView().getFormShowParameter().getCustomParam(USERID))) {
            Long taskId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam(TASKID));
            Long userId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam(USERID));
            List records = this.getTaskService().getCoordinatorRecordCmd(taskId);
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(ENTRYENTITY, records.size());
            boolean hideChat = "0".equals(this.getView().getFormShowParameter().getCustomParam(HIDECHAT));
            CardEntry grid = (CardEntry)this.getView().getControl(ENTRYENTITY);
            for (int i = 0; i < records.size(); ++i) {
                IApprovalRecordItem item = (IApprovalRecordItem)records.get(i);
                model.setValue(USERIMG, (Object)item.getAvatar(), i);
                model.setValue(TWRESULT, (Object)item.getAssignee(), i);
                if (WfUtils.isNotEmpty((String)item.getTime())) {
                    model.setValue(TWTIME, (Object)item.getTime(), i);
                } else {
                    grid.setChildVisible(false, i, new String[]{TWTIME});
                }
                if (WfUtils.isNotEmpty((String)item.getMessage())) {
                    model.setValue(TWMESSAGE, (Object)item.getMessage(), i);
                } else {
                    grid.setChildVisible(false, i, new String[]{TWMESSAGE});
                }
                if (WfUtils.isNotEmpty((String)item.getState())) {
                    String attachmentIds = item.getState();
                    if (attachmentIds.contains(",")) {
                        String[] attIds = attachmentIds.split(",");
                        Object[] a = new Object[attIds.length];
                        for (int j = 0; j < attIds.length; ++j) {
                            a[j] = Long.valueOf(attIds[j]);
                        }
                        model.setValue("attachmentfield", (Object)a, i);
                    } else {
                        Object[] a = new Object[]{Long.valueOf(attachmentIds)};
                        model.setValue("attachmentfield", (Object)a, i);
                    }
                }
                if (!hideChat && WfUtils.isNotEmpty((String)item.getOpenId()) && item.getUserId() != null && !RequestContext.get().getUserId().equals(item.getUserId().toString())) {
                    model.setValue(OPENID, (Object)item.getOpenId(), i);
                    continue;
                }
                model.setValue(OPENID, (Object)"0", i);
            }
        }
    }

    public void click(EventObject evt) {
        String openId;
        AbstractGrid grid;
        int rowIndex;
        String key = ((Control)evt.getSource()).getKey();
        if (TALKIMG.equals(key) && StringUtils.isNotBlank((Object)(rowIndex = (grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY)).getEntryState().getFocusRow())) && rowIndex > -1 && WfUtils.isNotEmpty((String)(openId = (String)this.getModel().getValue(OPENID, rowIndex)))) {
            YzjContextMenuClickPlugin yzj = new YzjContextMenuClickPlugin();
            yzj.setView(this.getView());
            HashMap<String, String> mData = new HashMap<String, String>();
            mData.put("chattype", "chat_pc");
            mData.put("openId", openId);
            yzj.yzjInterface("createAndChat", mData);
        }
    }
}

