/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;

public class WorkflowMobileViewTransferRecordsPlugin
extends AbstractWorkflowPlugin {
    private static final String EMPLOYEE_NUMBER = "employeeNumber";
    private static final String USERNAME = "username";
    private static final String ENTRY_ENTITY = "taskhandlelogentity";
    private static final String FIELD_TRANSFEROR = "transferor";
    private static final String FIELD_TRANSFERORNUMBER = "transferornumber";
    private static final String FIELD_TRANSFEREE = "transferee";
    private static final String FIELD_TRANSFEREENUMBER = "transfereenumber";
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_TIMEFIELD = "timefield";
    private static final String FIELD_PASSIMG = "passimg";
    private static final String FIELD_RERECEIVEIMG = "rereceiveimg";
    private static final String PICTUREFIELD = "picturefield";
    private final Map<Long, String> nameMap = new HashMap<Long, String>();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initEntryEntity();
    }

    private void initEntryEntity() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String childrenValueStr = (String)parameter.getCustomParam("value");
        Map childrenValue = null;
        boolean coordinate = Boolean.TRUE.equals(parameter.getCustomParam("coordinate"));
        if (WfUtils.isNotEmpty((String)childrenValueStr)) {
            childrenValue = (Map)SerializationUtils.fromJsonString((String)childrenValueStr, Map.class);
            LinkedList<Long> idList = new LinkedList<Long>();
            for (String key : childrenValue.keySet()) {
                idList.add(Long.valueOf(key));
            }
            QFilter filter1 = new QFilter("id", "in", idList);
            QFilter[] filters = new QFilter[]{filter1};
            DynamicObjectCollection tasks = QueryServiceHelper.query((String)"wf_task", (String)"id", (QFilter[])filters);
            if (tasks == null || tasks.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4efb\u52a1\u5df2\u88ab\u5904\u7406\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u9875\u9762\u540e\u91cd\u8bd5\u3002", (String)"WorkflowViewTransferRecordsPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getTransferName()));
                return;
            }
            for (DynamicObject task : tasks) {
                String taskId = task.getString("id");
                String userId = (String)childrenValue.get(task.getString("id"));
                List<TaskHandleLogEntity> taskHandleLogs = DesignerPluginUtil.getTransferRecordsData(taskId, userId, coordinate, this.getTaskService());
                this.setShowData(taskHandleLogs, true);
            }
        } else {
            String taskId = (String)parameter.getCustomParam("taskId");
            String userId = (String)parameter.getCustomParam("userId");
            List<TaskHandleLogEntity> taskHandleLogs = DesignerPluginUtil.getTransferRecordsData(taskId, userId, coordinate, this.getTaskService());
            this.setShowData(taskHandleLogs, false);
        }
    }

    private void setShowData(List<TaskHandleLogEntity> taskHandleLogs, boolean isYZJ) {
        if (taskHandleLogs == null || taskHandleLogs.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5%s\u4efb\u52a1\u53ef\u80fd\u5df2\u7ecf\u88ab\u64a4\u56de\uff0c\u8bf7\u5728\u5217\u8868\u9875\u9762\u5237\u65b0\u540e\u91cd\u8bd5", (String)"WorkflowViewTransferRecordsPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getTransferName()));
            return;
        }
        IDataModel model = this.getModel();
        int size = taskHandleLogs.size();
        TaskHandleLogEntity handleLog = null;
        for (int i = 0; i < size; ++i) {
            int rowIndex = model.createNewEntryRow(ENTRY_ENTITY);
            if (i == 0 && isYZJ) {
                String name = DesignerPluginUtil.getUserName(taskHandleLogs.get(taskHandleLogs.size() - 1).getOwnerId(), this.nameMap);
                model.setValue("textfield", (Object)String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4e3a%1$s\u4efb\u52a1\u7684%2$s\u5386\u53f2", (String)"WorkflowMobileViewTransferRecordsPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), name, WfConfigurationUtil.getTransferName()), rowIndex);
            }
            handleLog = taskHandleLogs.get(i);
            Map<String, String> transferorMap = this.nameResult(DesignerPluginUtil.getUserName(handleLog.getOwnerId(), this.nameMap));
            ILocaleString ownerFormat = handleLog.getOwnerFormat();
            model.setValue(FIELD_TRANSFEROR, (Object)ownerFormat.getLocaleValue(), rowIndex);
            model.setValue(FIELD_TRANSFERORNUMBER, (Object)transferorMap.get(EMPLOYEE_NUMBER), rowIndex);
            Map<String, String> transfeReeMap = this.nameResult(DesignerPluginUtil.getUserName(handleLog.getAssigneeid(), this.nameMap));
            ILocaleString transfeFormat = handleLog.getAssigneeFormat();
            model.setValue(FIELD_TRANSFEREE, (Object)transfeFormat.getLocaleValue(), rowIndex);
            model.setValue(FIELD_TRANSFEREENUMBER, (Object)transfeReeMap.get(EMPLOYEE_NUMBER), rowIndex);
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)handleLog.getOwnerId())};
            DynamicObject passer = QueryServiceHelper.queryOne((String)"bos_user", (String)PICTUREFIELD, (QFilter[])filters);
            String passImgUrl = WfUtils.getAbsAvatarPath((Object)passer.getString(PICTUREFIELD));
            model.setValue(FIELD_PASSIMG, (Object)passImgUrl, rowIndex);
            QFilter[] filters2 = new QFilter[]{new QFilter("id", "=", (Object)handleLog.getAssigneeid())};
            DynamicObject rereceiver = QueryServiceHelper.queryOne((String)"bos_user", (String)PICTUREFIELD, (QFilter[])filters2);
            String rereceiveImgUrl = WfUtils.getAbsAvatarPath((Object)rereceiver.getString(PICTUREFIELD));
            model.setValue(FIELD_RERECEIVEIMG, (Object)rereceiveImgUrl, rowIndex);
            model.setValue(FIELD_MESSAGE, (Object)(String.format(ResManager.loadKDString((String)"%s\u610f\u89c1\uff1a", (String)"WorkflowMobileViewTransferRecordsPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getTransferName()) + handleLog.getOpinion()), rowIndex);
            model.setValue(FIELD_TIMEFIELD, (Object)WfUtils.parseToUserZoneDateString((Date)handleLog.getCreateDate()), rowIndex);
        }
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRY_ENTITY);
        for (int i = 0; i < taskHandleLogs.size(); ++i) {
            if (!WfUtils.isEmpty((String)((String)this.getModel().getValue("textfield", i)))) continue;
            cardEntry.setChildVisible(false, i, new String[]{"textfield", "cardentryflexpanelap9"});
        }
    }

    private Map<String, String> nameResult(String assignee) {
        String[] splits = assignee.split("\\\uff08|\\\uff09");
        HashMap<String, String> assigneeMap = new HashMap<String, String>(2);
        if (splits.length == 1) {
            splits = assignee.split("\\(|\\)");
        }
        if (splits.length >= 2) {
            assigneeMap.put(USERNAME, splits[0]);
            assigneeMap.put(EMPLOYEE_NUMBER, "(" + splits[1] + ")");
        } else {
            assigneeMap.put(USERNAME, assignee);
        }
        return assigneeMap;
    }
}

