/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.workflow.component.WFNavigationBar;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.task.center.util.Navigationutils;

public class WorkflowTaskCenterPlugin
extends AbstractWorkflowPlugin
implements ItemClickListener,
IConfirmCallBack {
    public static final String OPENTYPE = "openType";
    public static final String OPENPAGE = "openPage";
    public static final String HIDENAVIGATION = "hideNavigation";

    @Override
    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        try {
            String key;
            Object o = this.getView().getFormShowParameter().getCustomParam(OPENTYPE);
            if (!WfUtils.isNotEmptyString((Object)o) || !HIDENAVIGATION.equalsIgnoreCase(o.toString())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
            }
            if (WfUtils.isNotEmpty((String)(key = (String)this.getView().getFormShowParameter().getCustomParam(OPENPAGE)))) {
                switch (key) {
                    case "toHandle": {
                        this.openRigthPage("wf_task", "", "", "");
                        break;
                    }
                    case "handled": {
                        this.openRigthPage("wf_hitaskinst", "", "", "");
                        break;
                    }
                    case "toApply": {
                        this.openRigthPage("wf_execution_tc", "", "", "");
                        break;
                    }
                    case "applyed": {
                        this.openRigthPage("wf_hiprocinst", "", "", "");
                        break;
                    }
                    default: {
                        this.openRigthPage("wf_task", "", "", "");
                        break;
                    }
                }
            } else {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                Object personCenterOpenType = customParams.get("personCenterOpenType");
                HashMap<String, Object> otherParamMap = null;
                if (StringUtils.isNotBlank(personCenterOpenType)) {
                    otherParamMap = new HashMap<String, Object>(2);
                    otherParamMap.put("personCenterOpenType", personCenterOpenType);
                    if (1 == Integer.parseInt(personCenterOpenType.toString())) {
                        otherParamMap.put("taskId", customParams.get("taskId"));
                    } else {
                        otherParamMap.put("messageId", customParams.get("messageId"));
                    }
                }
                this.openRigthPage("wf_task", "", "", "", otherParamMap);
            }
        }
        catch (Exception err) {
            this.getView().showMessage(err.getMessage());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String pageId = this.getPageCache().get("menupageid");
        IFormView view = this.getView().getView(pageId);
        if (view != null) {
            view.updateView();
            this.getView().sendFormAction(view);
        }
        this.setNavigationData();
    }

    public void openRigthPage(String tableType, String entityNumber, String folderId, String transfer) {
        this.openRigthPage(tableType, entityNumber, folderId, transfer, null);
    }

    public void openRigthPage(String tableType, String entityNumber, String folderId, String transfer, Map<String, Object> otherCustomParams) {
        Tab tab = (Tab)this.getControl("_submaintab_");
        if (!"mainpage".equalsIgnoreCase(tab.getCurrentTab())) {
            tab.activeTab("mainpage");
        }
        if (WfUtils.isEmpty((String)tableType)) {
            return;
        }
        if (!this.isSamePage(tableType, entityNumber, folderId, transfer)) {
            IPageCache pageCache = this.getPageCache();
            pageCache.put("tableType", tableType);
            pageCache.put("entityNumber", entityNumber);
            pageCache.put("folderId", folderId);
            pageCache.put("transfer", transfer);
            String menuPageid = this.getPageCache().get("menupageid");
            if (menuPageid != null) {
                HashMap<String, String> pageIds = new HashMap<String, String>();
                pageIds.put("pageId", menuPageid);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", pageIds);
            }
            menuPageid = UUID.randomUUID().toString();
            pageCache.put("menupageid", menuPageid);
            ListShowParameter parameter = new ListShowParameter();
            StyleCss sc = new StyleCss();
            parameter.getOpenStyle().setInlineStyleCss(sc);
            parameter.setBillFormId(tableType);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("flexpanelright");
            if ("wf_task".equals(tableType) && !"transfer".equals(transfer)) {
                parameter.setMultiSelect(true);
            } else {
                parameter.setMultiSelect(false);
            }
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("entityNumber", entityNumber);
            customParams.put("folderId", folderId);
            customParams.put("scenes", "taskcenter");
            if (otherCustomParams != null && !otherCustomParams.isEmpty()) {
                customParams.putAll(otherCustomParams);
            }
            if (WfUtils.isNotEmpty((String)transfer)) {
                customParams.put("transfer", "transfer");
                if ("wf_hitaskinst".equals(tableType)) {
                    parameter.setCaption(ResManager.loadKDString((String)"\u5df2\u5904\u7406\u5217\u8868", (String)"WorkflowTaskCenterPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                } else {
                    parameter.setCaption(ResManager.loadKDString((String)"\u5f85\u5904\u7406\u5217\u8868", (String)"WorkflowTaskCenterPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                }
            }
            parameter.setCustomParams(customParams);
            parameter.setPageId(menuPageid);
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            this.setNavigationData();
            String menuPageid = this.getPageCache().get("menupageid");
            IListView childView = (IListView)this.getView().getView(menuPageid);
            childView.refresh();
            this.getView().sendFormAction((IFormView)childView);
        }
    }

    public boolean isSamePage(String tableType, String entityNumber, String folderId, String transfer) {
        IPageCache pageCache = this.getPageCache();
        String cacheTableType = pageCache.get("tableType");
        cacheTableType = WfUtils.isEmpty((String)cacheTableType) ? "" : cacheTableType;
        String cacheEntityNumber = pageCache.get("entityNumber");
        cacheEntityNumber = WfUtils.isEmpty((String)cacheEntityNumber) ? "" : cacheEntityNumber;
        String cacheFolderId = pageCache.get("folderId");
        cacheFolderId = WfUtils.isEmpty((String)cacheFolderId) ? "" : cacheFolderId;
        String cacheTransfer = pageCache.get("transfer");
        cacheTransfer = WfUtils.isEmpty((String)cacheTransfer) ? "" : cacheTransfer;
        String state = tableType + entityNumber + folderId + transfer;
        String preState = cacheTableType + cacheEntityNumber + cacheFolderId + cacheTransfer;
        return state.equalsIgnoreCase(preState);
    }

    private void setNavigationData() {
        String uid = RequestContext.get().getUserId();
        WFNavigationBar bar = (WFNavigationBar)this.getControl("wfnavigationbarap");
        long userId = Long.parseLong(uid);
        List navigationData = this.getTaskService().getTCNavigationTreeData(userId);
        HashMap<String, List> data = new HashMap<String, List>();
        data.put("task", Navigationutils.getNavigationNodes((List)navigationData));
        ArrayList msgNodes = new ArrayList();
        data.put("message", msgNodes);
        bar.setData(data, "", "");
    }
}

