/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.quantitysum.LocalVariables;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.operation.TransferOperationParam;
import kd.bos.workflow.message.service.impl.MessageCenterServiceImpl;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class WorkflowTransferTohandleTaskPlugin
extends AbstractWorkflowPlugin {
    private static final String TRANSFERTO = "transferto";
    private static final String SUBSCRIBE = "subscribe";
    private static final String SUGGESTION = "suggestion";
    private static final String CONFIRMBTN = "confirmbtn";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRMBTN});
        this.showUsersAddCustomParam();
    }

    private void showUsersAddCustomParam() {
        BasedataEdit bosUserF7 = (BasedataEdit)this.getControl(TRANSFERTO);
        bosUserF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
        List<QFilter> qFilters = ApprovalPluginUtil.addPersonFiltersCustomEvent(this.getView(), null);
        if (null == qFilters || qFilters.isEmpty()) {
            return;
        }
        bosUserF7.setQFilters(qFilters);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        if (CONFIRMBTN.equals(ctl.getKey())) {
            this.transferTask();
        }
    }

    private void transferTask() {
        List bizTasks;
        DynamicObject transferTo = (DynamicObject)this.getModel().getValue(TRANSFERTO);
        if (transferTo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4eba\u5458\u3002", (String)"WorkflowTransferTohandleTaskPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        LocalVariables.putLocalVariables((boolean)true, (String[])new String[]{"tohandle", "transfer"});
        ILocaleString suggestion = (ILocaleString)this.getModel().getValue(SUGGESTION);
        Boolean subscribe = (Boolean)this.getModel().getValue(SUBSCRIBE);
        String ownerId = RequestContext.get().getUserId();
        Long transferId = (Long)transferTo.getPkValue();
        String name = transferTo.getString("name");
        List taskIds = (List)this.getView().getFormShowParameter().getCustomParam("taskIds");
        Long ownerIdLong = Long.valueOf(ownerId);
        this.logger.debug("WorkflowTransferTohandleTaskPlugin.transferTask_ownerIdStr:" + ownerId);
        this.logger.debug("WorkflowTransferTohandleTaskPlugin.transferTask_ownerIdLong:" + ownerIdLong);
        this.logger.debug("WorkflowTransferTohandleTaskPlugin.transferTask_transferId:" + transferId);
        HashMap<String, String> returnData = new HashMap<String, String>();
        List tasks = this.getTaskService().getTasksByIdsBatchCmd(taskIds, null);
        if (WfUtils.isEmptyForCollection((Collection)tasks)) {
            return;
        }
        List wfTasks = tasks.stream().filter(taskInfo -> !taskInfo.isBizTask()).collect(Collectors.toList());
        if (WfUtils.isNotEmptyForCollection(wfTasks)) {
            List wfTaskIds = wfTasks.stream().map(task -> task.getId()).collect(Collectors.toList());
            returnData.putAll(this.getTaskService().tasksTransfer(wfTaskIds, transferId, suggestion, subscribe, ownerIdLong));
        }
        if (tasks.size() > wfTasks.size() && WfUtils.isNotEmptyForCollection(bizTasks = tasks.stream().filter(taskInfo -> taskInfo.isBizTask()).collect(Collectors.toList()))) {
            List bizTaskIds = bizTasks.stream().map(bizTask -> bizTask.getId()).collect(Collectors.toList());
            TransferOperationParam transferOperationParam = new TransferOperationParam();
            transferOperationParam.setTaskIds(bizTaskIds);
            transferOperationParam.setOperaterId(ownerIdLong);
            transferOperationParam.setTransfererId(transferId);
            transferOperationParam.setTransferOpinion(suggestion);
            transferOperationParam.setTransferSubscribe(subscribe.booleanValue());
            MessageCenterServiceImpl impl = new MessageCenterServiceImpl();
            this.wrapResult(tasks, returnData, impl.transferBizTask(transferOperationParam));
        }
        this.getView().returnDataToParent(returnData);
        this.getView().close();
        StringBuilder addLogForDetailInfo = new StringBuilder(String.format(ResManager.loadKDString((String)"\u6279\u91cf%s\uff1a\u7531", (String)"WorkflowTransferTohandleTaskPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getTransferName()));
        addLogForDetailInfo.append(WfUtils.getUserText((Long)ownerIdLong)).append(String.format(ResManager.loadKDString((String)"%s\u7ed9", (String)"WorkflowTransferTohandleTaskPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getTransferName())).append(name);
        String desc = WfUtils.getFinalInfo((String)ResManager.loadKDString((String)"\u4efb\u52a1\u7f16\u7801", (String)"WorkflowTransferTohandleTaskPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), (List)taskIds, (String)addLogForDetailInfo.toString());
        WfUtils.addOpLog((String)"wf_transfertohandletask", (String)"taskTransfer", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5f85\u529e\u4efb\u52a1\u8f6c\u4ea4", "WorkflowTransferTohandleTaskPlugin_6", "bos-wf-formplugin"), null, (Object[])new Object[]{desc});
    }

    private void wrapResult(List<TaskInfo> tasks, Map<String, String> data, BatchOperateResult batchOperateResult) {
        int failedCount = batchOperateResult.getFailedCount();
        int sucessCount = batchOperateResult.getSucessCount();
        String validateMsg = batchOperateResult.getValidateMsg();
        ArrayList failList = new ArrayList();
        List operateResults = batchOperateResult.getOperateResults();
        operateResults.stream().forEach(ores -> {
            if ("failed".equals(ores.getOperateStatus())) {
                failList.add(ores.getOperateMsg());
            }
        });
        String details = Joiner.on((String)"\r\n").join(failList);
        String failInfo = Joiner.on((String)"#").join(failList);
        if (data.isEmpty()) {
            String failTag = ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0:\r\n", (String)"TasksTransferCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            data.put("successCount", sucessCount + "");
            data.put("failCount", failedCount + "");
            data.put("title", validateMsg);
            data.put("details", WfUtils.isNotEmpty((String)details) ? failTag + details : details);
            data.put("failList", failInfo);
        } else {
            data.put("successCount", Integer.parseInt(data.get("successCount")) + sucessCount + "");
            data.put("failCount", Integer.parseInt(data.get("failCount")) + failedCount + "");
            data.put("title", String.format(ResManager.loadKDString((String)"\u5171\u201c%1$s\u201d%2$s\u6761\u4efb\u52a1\uff0c\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761\u3002", (String)"TasksTransferCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getTransferName(), tasks.size(), data.get("successCount"), data.get("failCount")));
            String detailOriginal = data.get("details");
            String failListOriginal = data.get("failList");
            data.put("details", WfUtils.isEmpty((String)detailOriginal) ? details : detailOriginal + "\r\n" + details);
            data.put("failList", WfUtils.isEmpty((String)failListOriginal) ? failInfo : failListOriginal + "#" + failInfo);
        }
        data.put("handleName", WfConfigurationUtil.getTransferName());
    }
}

