/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.service.archive.ArchiveFormService;

public class WorkflowViewTransferRecordsPlugin
extends AbstractWorkflowPlugin {
    private static final String ENTRY_ENTITY = "taskhandlelogentity";
    private static final String FIELD_TRANSFEROR = "transferor";
    private static final String FIELD_TRANSFEREE = "transferee";
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_TIMEFIELD = "timefield";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ArchiveFormService.create().injectArchiveRouteInfo(this.getView());
        this.initEntryEntity();
    }

    private void initEntryEntity() {
        boolean coordinate;
        String userId;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String taskId = (String)parameter.getCustomParam("taskId");
        List taskHandleLogs = DesignerPluginUtil.getTransferRecordsData(taskId, userId = (String)parameter.getCustomParam("userId"), coordinate = Boolean.TRUE.equals(parameter.getCustomParam("coordinate")), this.getTaskService());
        if (null == taskHandleLogs || taskHandleLogs.isEmpty()) {
            taskHandleLogs = this.getTaskService().getDelegateTransferRecordsData(Long.valueOf(taskId), Long.valueOf(userId), coordinate);
        }
        IDataModel model = this.getModel();
        if (null == taskHandleLogs || taskHandleLogs.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5%s\u4efb\u52a1\u53ef\u80fd\u5df2\u7ecf\u88ab\u64a4\u56de\uff0c\u6216\u8be5\u6d41\u7a0b\u5df2\u572810\u5929\u524d\u7ed3\u675f\uff0c\u8f6c\u4ea4\u5386\u53f2\u88ab\u6e05\u7a7a\uff0c\u4e0d\u652f\u6301\u67e5\u770b\u3002", (String)"WorkflowViewTransferRecordsPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getTransferName()));
            return;
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, taskHandleLogs.size());
        int size = taskHandleLogs.size();
        TaskHandleLogEntity handleLog = null;
        for (int i = 0; i < size; ++i) {
            handleLog = (TaskHandleLogEntity)taskHandleLogs.get(i);
            String ownerName = String.valueOf(handleLog.getOwnerFormat());
            String assigneeName = String.valueOf(handleLog.getAssigneeFormat());
            model.setValue(FIELD_TRANSFEROR, (Object)ownerName, i);
            model.setValue(FIELD_TRANSFEREE, (Object)assigneeName, i);
            model.setValue(FIELD_MESSAGE, (Object)String.valueOf(handleLog.getOpinion()), i);
            model.setValue(FIELD_TIMEFIELD, (Object)handleLog.getCreateDate(), i);
        }
    }
}

