/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.custom;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.base.MobileBaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.cmd.task.AgentTaskHandleContext;
import kd.bos.workflow.engine.impl.cmd.task.TashHandleParam;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.exception.WFBizOperationException;
import kd.bos.workflow.exception.WFTaskException;
import kd.bos.workflow.management.plugin.ApprovalPageTpl;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForApprovalCustomEvent;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForHandledCustomEvent;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.BeforeSubmitCustomEvent;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class MCenterCustomApprovalPageTpl
extends ApprovalPageTpl {
    private Log logger = LogFactory.getLog(MCenterCustomApprovalPageTpl.class);
    public static final String TOOLBARPANEL = "toolbarpanel";
    public static final String TOOLBARAP = "toolbarap";
    public static final String BTNAPPROVAL = "btn_approval";
    public static final String BTNEXIT = "btn_exit";
    public static final String PAGEPANEL = "pagepanel";
    public static final String BILLPAGESHOWPANEL = "billpageshowpanel";
    public static final String NOSHOWBILLPAGE = "noshowbillpage";
    protected static final String TASKCATEGORY = "taskCategory";
    protected static final String ISBILLEXIST = "isBillExist";
    protected static final String ASSIGNEE = "assigneeid";
    protected static final String ISPCSHOW = "isPCShow";
    protected static final String FROMHISTORY = "fromHistory";
    protected static final String TASKTYPE = "tasktype";
    protected static final String NUMBER = "number";
    protected static final String TASKSUBMITOPERATION = "validateOperation";
    protected static final String AUDITTYPE = "auditType";
    protected static final String CALLBACK_WITHDRAW = "callBack_withdraw";
    protected AgentTaskHandleContext agentTaskHandleContext = null;

    public void preOpenForm(PreOpenFormEventArgs e) {
        this.setPreOpenForm(e, Boolean.TRUE);
    }

    public void setPreOpenForm(PreOpenFormEventArgs args, Boolean isPCShow) {
        FormShowParameter parameter = (FormShowParameter)args.getSource();
        ILocaleString captain = this.getCaptainForInitial(parameter.getCustomParams(), isPCShow);
        if (captain != null && !WfUtils.isEmpty((String)captain.getLocaleValue())) {
            parameter.setCaption(captain.getLocaleValue());
        }
        if (parameter.getAppId() == null) {
            parameter.setAppId("wf");
        }
    }

    public void initialize() {
        this.initalizePageControl();
    }

    private void initalizePageControl() {
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void afterCreateNewData(EventObject e) {
        try {
            if (this.getTaskDataInfo()) {
                return;
            }
            this.initApprovaPageControl();
            this.loadBizBillPage();
            this.initBizExtraPlugins();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (!customParams.isEmpty()) {
                Long taskId = 0L;
                if (!WfUtils.isNullObject(customParams.get("taskId"))) {
                    taskId = (Long)customParams.get("taskId");
                } else if (!WfUtils.isNullObject(customParams.get("tId"))) {
                    taskId = (Long)customParams.get("tId");
                }
                String apptype = ApprovalPluginUtil.getApptype(customParams.get("apptype"));
                ApprovalPluginUtil.callRecordReadTime(taskId, customParams.get("msgId"), apptype);
            }
        }
        catch (Exception e1) {
            this.logger.warn(WfUtils.getExceptionStacktrace((Throwable)e1));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"MCenterCustomApprovalPageTpl_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), e1.getMessage()));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (!BTNEXIT.equals(itemKey) && !this.canDoOperation("wf_participant", true)) {
            return;
        }
        switch (itemKey) {
            case "btn_exit": {
                super.showClosePageNormal(null);
                break;
            }
            case "btn_approval": {
                this.submitTask();
                break;
            }
        }
    }

    public void submitTask() {
        try {
            Map<String, Object> taskVariables = this.getVariables(new HashMap<String, Object>());
            boolean canSubmitTask = Boolean.TRUE;
            canSubmitTask = this.verifiedBasalCanSubmit(taskVariables);
            if (!canSubmitTask) {
                return;
            }
            Object extraVariablesResult = this.executeBeforeSubmitCustomEvent(taskVariables);
            canSubmitTask = this.verifiedBeforeSubmitCustomEventCanSubmit(extraVariablesResult);
            if (!canSubmitTask) {
                return;
            }
            canSubmitTask = this.verifiedTaskConfirm(taskVariables);
            if (!canSubmitTask) {
                return;
            }
            if (canSubmitTask && !taskVariables.isEmpty()) {
                canSubmitTask = this.executeBillValidateOperation(taskVariables);
                if (!canSubmitTask) {
                    return;
                }
                this.submitTask(taskVariables);
            }
            this.executeAfterSubmitCustomEvent(taskVariables);
            this.showClosePage(null);
        }
        catch (Exception e) {
            String errorMessage = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"MCenterCustomApprovalPageTpl_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage());
            this.logger.info(String.format("\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff1a%s", WfUtils.getExceptionStacktrace((Throwable)e)));
            this.getView().showTipNotification(errorMessage);
        }
    }

    private void submitTask(Map<String, Object> variables) {
        try {
            JSONObject jsonObject;
            boolean isSubmitSuccess;
            TaskService taskService = this.getTaskService();
            ArrayList<Long> taskIds = new ArrayList<Long>();
            Long taskId = Long.parseLong(this.getPageCache().get("taskId"));
            taskIds.add(taskId);
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            variables.put("userId", userId);
            variables.put("taskSource", this.getPageCache().get("taskSource"));
            variables.put(TASKCATEGORY, this.getPageCache().get(TASKCATEGORY));
            boolean isVerify = Boolean.FALSE;
            ILocaleString opinion = (ILocaleString)variables.get("auditMessage");
            String jsonString = taskService.batchCompleteCustomTask(taskIds, userId, opinion, isVerify, variables);
            if (WfUtils.isNotEmpty((String)jsonString) && !(isSubmitSuccess = (jsonObject = JSON.parseObject((String)jsonString)).getBoolean("success").booleanValue())) {
                this.getView().showTipNotification(jsonObject.getString("message"));
            }
        }
        catch (WFBizOperationException | WFTaskException e) {
            if (WfUtils.isNotEmpty((String)e.getLocalizedMessage())) {
                this.getView().showTipNotification(e.getLocalizedMessage());
            }
            String mCenterCustomApprovalPageTpl_2 = ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"MCenterCustomApprovalPageTpl_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            String format = String.format(mCenterCustomApprovalPageTpl_2, WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(format);
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            String mCenterCustomApprovalPageTpl_2 = ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"MCenterCustomApprovalPageTpl_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            String format = String.format(mCenterCustomApprovalPageTpl_2, WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(format);
        }
    }

    public boolean verifiedTaskConfirm(Map<String, Object> taskVariables) {
        return Boolean.TRUE;
    }

    public boolean executeBillValidateOperation(Map<String, Object> variables) {
        Boolean executeValidateSuccess = Boolean.TRUE;
        try {
            String validateOperation = this.getPageCache().get(TASKSUBMITOPERATION);
            String entityNumber = this.getPageCache().get("entityNumber");
            String businessKey = this.getPageCache().get("businesskey");
            if (WfUtils.isNotEmpty((String)validateOperation)) {
                executeValidateSuccess = this.invokeBillValidate(entityNumber, businessKey, validateOperation, new HashMap<String, String>());
            }
        }
        catch (Exception e) {
            executeValidateSuccess = Boolean.FALSE;
            String tips = ResManager.loadKDString((String)"\u6267\u884c\u4efb\u52a1\u4e2d\u5b9a\u4e49\u7684\u64cd\u4f5c\u63d2\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"MCenterCustomApprovalPageTpl_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            String format = String.format(tips, e.getMessage());
            this.logger.info(format);
            this.getView().showTipNotification(format);
        }
        return executeValidateSuccess;
    }

    private boolean invokeBillValidate(String entityNumber, String businessKey, String extItfValue, Map<String, String> variable) {
        if (ExternalInterfaceUtil.isValidValue((String)extItfValue)) {
            DynamicObject billInfo = BusinessDataServiceHelper.loadSingle((Object)businessKey, (String)entityNumber);
            return ExternalInterfaceUtil.invokeValidateExtItf((DynamicObject)billInfo, (String)extItfValue);
        }
        return this.doBillOperation(extItfValue, variable);
    }

    public Object executeBeforeSubmitCustomEvent(Map<String, Object> variables) {
        BeforeSubmitCustomEvent args = new BeforeSubmitCustomEvent(this.getView(), "keyForAppointBeforeSubmit", "beforeSubmitCustomEvent", null, variables, null, null);
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent((CustomEventArgs)args);
        return args;
    }

    public boolean verifiedBeforeSubmitCustomEventCanSubmit(Object extraVariablesResult) {
        return Boolean.TRUE;
    }

    public Object executeAfterSubmitCustomEvent(Map<String, Object> taskVariables) {
        return null;
    }

    protected Map<String, Object> getVariables(Map<String, Object> submitInfo) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        this.handleDecisionVariables(submitInfo, variablesMap);
        return variablesMap;
    }

    private void handleDecisionVariables(Map<String, Object> submitInfo, Map<String, Object> variablesMap) {
        DecisionOption decisionOption = this.getChooseDecisonoption();
        if (decisionOption == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u51b3\u7b56\u9879\u3002", (String)"MCenterCustomApprovalPageTpl_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        variablesMap.put("auditNumber", decisionOption.getNumber());
        variablesMap.put("auditName", this.getAuditNameByNumber(decisionOption));
        variablesMap.put(AUDITTYPE, decisionOption.getAuditType());
    }

    public ILocaleString getAuditNameByNumber(DecisionOption decisionOption) {
        LocaleString name = new LocaleString(decisionOption.getName());
        return name;
    }

    public DecisionOption getChooseDecisonoption() {
        DecisionOption decisionOption = new DecisionOption();
        decisionOption.setName(ResManager.loadKDString((String)"\u540c\u610f", (String)"MCenterCustomApprovalPageTpl_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        decisionOption.setNumber("Consent");
        decisionOption.setAuditType("approve");
        return decisionOption;
    }

    public Boolean verifiedBasalCanSubmit(Map<String, Object> variables) {
        String taskId = this.getPageCache().get("taskId");
        if (TaskUtils.isTaskSuspended((Long)Long.valueOf(taskId))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u4e3a\u6302\u8d77\u72b6\u6001\uff0c\u4e0d\u80fd\u63d0\u4ea4\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u51b3\u3002", (String)"MCenterCustomApprovalPageTpl_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void initBizExtraPlugins() {
        String taskType = this.agentTaskHandleContext.getType();
        if (WfUtils.isEmpty((String)taskType)) {
            taskType = (String)this.getView().getFormShowParameter().getCustomParam("type");
        }
        if ("handled".equals(taskType) || !this.canDoOperation("wf_participant", false)) {
            this.initBizExtraPluginsForHandled();
        } else {
            this.initBizExtraPluginsForToHandle();
        }
    }

    public void initBizExtraPluginsForToHandle() {
        AfterCreatNewDataForApprovalCustomEvent args = new AfterCreatNewDataForApprovalCustomEvent(this.getView(), "keyForAfterCreatNewData", "afterCreatNewDataForApprovalCustomEvent", null, this.agentTaskHandleContext, null, null);
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent((CustomEventArgs)args);
    }

    public void initBizExtraPluginsForHandled() {
        AfterCreatNewDataForHandledCustomEvent args = new AfterCreatNewDataForHandledCustomEvent(this.getView(), "keyForHandledAfterCreatNewData", "afterCreatNewDataForHandledCustomEvent", null, this.agentTaskHandleContext, null);
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent((CustomEventArgs)args);
    }

    public void loadBizBillPage() {
        String taskType = this.agentTaskHandleContext.getType();
        if (WfUtils.isEmpty((String)taskType)) {
            taskType = (String)this.getView().getFormShowParameter().getCustomParam("type");
        }
        if ("handled".equals(taskType) || !this.canDoOperation("wf_participant", false)) {
            this.loadHandledPage();
        } else {
            this.loadTohandlePage();
        }
    }

    public void loadHandledPage() {
        this.getView().setStatus(OperationStatus.VIEW);
        this.loadBillPage();
    }

    public void loadTohandlePage() {
        this.loadBillPage();
    }

    private void loadBillPage() {
        try {
            Boolean isBillExist = this.agentTaskHandleContext == null ? Boolean.FALSE : this.agentTaskHandleContext.getBillExist();
            String formkey = this.getPageCache().get("formKey");
            Boolean isPCShow = this.agentTaskHandleContext.getPcShow();
            if (isBillExist.booleanValue() && WfUtils.isNotEmpty((String)formkey) && ApprovalPluginUtil.isExistForFormId(formkey)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{NOSHOWBILLPAGE});
                TaskInfo taskInfo = this.agentTaskHandleContext.getTask();
                String entitynumber = taskInfo.getEntityNumber();
                String businesskey = taskInfo.getBusinessKey();
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entitynumber);
                if (entityType instanceof BillEntityType) {
                    BillShowParameter formShowParameter = this.getBillShowParameter(isPCShow, businesskey, formkey, entitynumber);
                    this.showForm((FormShowParameter)formShowParameter);
                }
            } else if (isPCShow.booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{NOSHOWBILLPAGE});
            }
        }
        catch (Exception e) {
            String tips = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4e1a\u52a1\u5355\u636e\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"MCenterCustomApprovalPageTpl_7", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            String format = String.format(tips, e.getMessage());
            this.logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showTipNotification(format);
        }
    }

    public BillShowParameter getBillShowParameter(Boolean isPCShow, String businesskey, String formkey, String entitynumber) {
        Object billShowParameter = null;
        QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "=", (Object)entitynumber)};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"modeltype", (QFilter[])filters);
        String modelType = dynamicObject.getString("modeltype");
        billShowParameter = isPCShow.booleanValue() ? ("BaseFormModel".equals(modelType) ? new BaseShowParameter() : new BillShowParameter()) : ("BaseFormModel".equals(modelType) ? new MobileBaseShowParameter() : new MobileBillShowParameter());
        billShowParameter.setBillStatus(BillOperationStatus.VIEW);
        billShowParameter.setStatus(OperationStatus.VIEW);
        if (WfUtils.isNotEmpty((String)businesskey)) {
            billShowParameter.setPkId(WfUtils.getBusinessKeyFromEntityType((String)businesskey, (String)entitynumber));
        }
        billShowParameter.setFormId(formkey);
        billShowParameter.getCustomParams().put("ServiceAppId", WfUtils.getAppIdForEntity((String)entitynumber));
        String billPageId = ApprovalPluginUtil.getBillPageId();
        billShowParameter.setPageId(billPageId);
        billShowParameter.getOpenStyle().setTargetKey(BILLPAGESHOWPANEL);
        billShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        billShowParameter.addCustPlugin("kd.bos.workflow.runtime.plugin.ApprovalBillControlPlugIn");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        billShowParameter.setCustomParams(customParams);
        billShowParameter.setCustomParam("formKey", (Object)formkey);
        billShowParameter.setCustomParam("businesskey", (Object)businesskey);
        billShowParameter.setCustomParam("onlyView", (Object)(this.agentTaskHandleContext.getBillView() != false || this.agentTaskHandleContext.isFromHistory() != false ? 1 : 0));
        billShowParameter.setCustomParam("pcShow", (Object)isPCShow);
        billShowParameter.setCustomParam("taskId", (Object)this.agentTaskHandleContext.getTaskId());
        this.getPageCache().put("billPageId", billPageId);
        return billShowParameter;
    }

    public void initApprovaPageControl() {
        String taskType = this.agentTaskHandleContext.getType();
        if ("handled".equals(taskType) || !this.canDoOperation("wf_participant", false)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTNAPPROVAL});
        }
    }

    @Override
    public String getApprovalPageId() {
        return this.getView().getPageId();
    }

    @Override
    public String getBillPageId() {
        return this.getPageCache().get("billPageId");
    }

    @Override
    public boolean isPCShow() {
        return true;
    }

    private boolean getTaskDataInfo() {
        boolean disContinue = Boolean.FALSE;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        TashHandleParam param = super.getTaskHandleParam(customParams);
        this.agentTaskHandleContext = super.getTaskInfo(param);
        boolean isTaskExist = this.agentTaskHandleContext.getTaskExist();
        TaskInfo taskInfo = this.agentTaskHandleContext.getTask();
        if (!isTaskExist || taskInfo == null) {
            this.getView().showConfirm(ApprovalPluginUtil.getTaskNotExistInfo(this.agentTaskHandleContext.getTaskNotExistReason()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_WITHDRAW));
            this.getView().setVisible(Boolean.FALSE, new String[]{TOOLBARAP});
            disContinue = Boolean.TRUE;
            return disContinue;
        }
        this.getFlowElement(taskInfo.getTaskDefinitionKey());
        this.setPageCacheForTaskData(customParams, taskInfo);
        return disContinue;
    }

    public void setPageCacheForTaskData(Map<String, Object> customParams, TaskInfo taskInfo) {
        Map<String, String> taskDataMap = this.putTaskDataIntoPageCache(taskInfo);
        this.getPageCache().put(taskDataMap);
    }

    private Map<String, String> putTaskDataIntoPageCache(TaskInfo taskInfo) {
        Long assigneeId;
        HashMap<String, String> taskDataMap = new HashMap<String, String>(25);
        taskDataMap.put("taskId", String.valueOf(taskInfo.getId()));
        taskDataMap.put(TASKCATEGORY, taskInfo.getCategory());
        taskDataMap.put("entityNumber", taskInfo.getEntityNumber());
        taskDataMap.put("businesskey", taskInfo.getBusinessKey());
        taskDataMap.put("BILLNO", taskInfo.getBillNo());
        taskDataMap.put("taskDefinitionKey", taskInfo.getTaskDefinitionKey());
        taskDataMap.put("formKey", taskInfo.getFormKey());
        taskDataMap.put("billView", this.agentTaskHandleContext.getBillView().toString());
        List<DecisionOption> decisionOptionList = this.getDecisionOptions(null);
        taskDataMap.put("decisionOptionList", SerializationUtils.toJsonString(decisionOptionList));
        taskDataMap.put("is_taskcoordinate", String.valueOf(this.agentTaskHandleContext.getTaskCoordinate()));
        taskDataMap.put(ISBILLEXIST, String.valueOf(this.agentTaskHandleContext.getBillExist()));
        taskDataMap.put("subject", WfUtils.isNotEmpty((String)taskInfo.getSubject().getLocaleValue()) ? taskInfo.getSubject().getLocaleValue() : "");
        taskDataMap.put(TASKSUBMITOPERATION, WfUtils.isNotEmpty((String)taskInfo.getValidateOperation()) ? taskInfo.getValidateOperation() : "");
        taskDataMap.put("SUSPENSIONSTATE", taskInfo.getSuspensionState());
        if (taskInfo instanceof HistoricTaskInstanceEntity && WfUtils.isNotEmpty((Long)(assigneeId = ((HistoricTaskInstanceEntity)taskInfo).getAssigneeId()))) {
            taskDataMap.put(ASSIGNEE, assigneeId.toString());
        }
        if (WfUtils.isNotEmpty((String)this.agentTaskHandleContext.getFormKey())) {
            taskDataMap.put("formKey", this.agentTaskHandleContext.getFormKey());
        }
        if (WfUtils.isNotEmpty((String)this.agentTaskHandleContext.getMobileFormKey())) {
            taskDataMap.put("mobileFormKey", this.agentTaskHandleContext.getMobileFormKey());
        }
        Boolean isPCShow = this.agentTaskHandleContext.getPcShow();
        taskDataMap.put(ISPCSHOW, isPCShow.toString());
        taskDataMap.put(FROMHISTORY, String.valueOf(this.agentTaskHandleContext.isFromHistory()));
        taskDataMap.put(TASKTYPE, this.agentTaskHandleContext.getType());
        taskDataMap.put("onlyView", String.valueOf(this.agentTaskHandleContext.getOnlyView()));
        String taskSource = "";
        if (taskInfo instanceof TaskEntityImpl) {
            taskSource = ((TaskEntity)taskInfo).getSource();
        } else if (taskInfo instanceof HistoricTaskInstanceEntityImpl) {
            taskSource = ((HistoricTaskInstanceEntity)taskInfo).getSource();
        }
        taskDataMap.put("taskSource", taskSource);
        return taskDataMap;
    }

    private FlowElement getFlowElement(String taskDefinitionKey) {
        return null;
    }

    @Override
    public List<DecisionOption> getDecisionOptions(FlowElement flowElement) {
        return null;
    }
}

