/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.separatestorage.SeparateStorageFormService;

public class TCCheckPermUtil {
    public static final String TCTYPE_TOHANDLER = "toHandler";
    public static final String TCTYPE_TOAPPLY = "toApply";
    public static final String TCTYPE_HANDLED = "handled";
    public static final String TCTYPE_APPLYED = "applyed";
    public static final String BATCHFLAG = "batchFlag";
    private static final String BTNBATCHAPPROVE = "btnbatchapprove";
    private static final String BTNBATCHREJECT = "btnbatchreject";
    private static final String BTNTRANSFER = "btntransfer";
    private static final String BTNCIRCULATED = "btncirculated";
    private static final String CIRCULATELOG = "circulatelog";
    private static final String BTNCONVERT = "btnconvert";
    private static final String BTNCANCEL = "btncancel";
    private static final String BATCHOP = "batchop";
    private static final String CONTROL = "control";
    private static final String PROCESSTYPE = "processtype";
    private static final String CIRCULATE = "circulate";
    private static final String WFTASK = "wftask";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkTaskRelationOrProcessStarter(ListSelectedRowCollection rows, IFormView formView, String type) {
        if (!TCCheckPermUtil.checkSelectedOne(rows, formView)) {
            return Boolean.FALSE;
        }
        boolean ret = true;
        List<Long> rowIds = TCCheckPermUtil.getSelectedRows(rows);
        try {
            SeparateStorageFormService.create().injectSeparateStorageKey(formView, TCCheckPermUtil.getEntityNumberByType(type), rowIds.get(0));
            if (WFTASK.equalsIgnoreCase(formView.getFormShowParameter().getAppId())) {
                if (TCTYPE_TOHANDLER.equalsIgnoreCase(type)) {
                    ret = WfPermUtils.isTaskRelationship(rowIds, (Long)RequestContext.get().getCurrUserId());
                } else if (TCTYPE_HANDLED.equalsIgnoreCase(type)) {
                    ret = WfPermUtils.isTaskRelationship(rowIds, (Long)RequestContext.get().getCurrUserId());
                } else if (TCTYPE_TOAPPLY.equalsIgnoreCase(type)) {
                    ret = WfPermUtils.isProcessStartUser((Long)rowIds.get(0), (Long)RequestContext.get().getCurrUserId());
                } else if (TCTYPE_APPLYED.equalsIgnoreCase(type)) {
                    ret = WfPermUtils.isProcessStartUser((Long)rowIds.get(0), (Long)RequestContext.get().getCurrUserId());
                }
                if (!ret) {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u4efb\u52a1\u5e72\u7cfb\u4eba\u6216\u6d41\u7a0b\u53d1\u8d77\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002", (String)"WorkflowTCDataPlugin_47", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                }
            }
        }
        finally {
            SeparateStorageFormService.create().removeSeparateStorageKey();
        }
        return ret;
    }

    private static String getEntityNumberByType(String type) {
        if (StringUtils.isNotBlank((CharSequence)type)) {
            switch (type) {
                case "toHandler": 
                case "handled": {
                    return "wf_hitaskinst";
                }
                case "toApply": 
                case "applyed": {
                    return "wf_hiprocinst";
                }
            }
        }
        return "";
    }

    private static List<Long> getSelectedRows(ListSelectedRowCollection rows) {
        ArrayList<Long> ids = new ArrayList<Long>(1);
        for (ListSelectedRow row : rows) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        return ids;
    }

    public static boolean checkTaskRelation(ListSelectedRowCollection rows, IFormView formView) {
        if (!TCCheckPermUtil.checkSelectedOne(rows, formView)) {
            return Boolean.FALSE;
        }
        List<Long> rowIds = TCCheckPermUtil.getSelectedRows(rows);
        if (!WfPermUtils.isTaskRelationship(rowIds, (Long)RequestContext.get().getCurrUserId())) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u4efb\u52a1\u5e72\u7cfb\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002", (String)"WorkflowTCDataPlugin_45", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean checkTaskTransfer(ListSelectedRowCollection rows, IFormView view) {
        if (!TCCheckPermUtil.checkSelectedOne(rows, view)) {
            return Boolean.FALSE;
        }
        List<Long> rowIds = TCCheckPermUtil.getSelectedRows(rows);
        if (!WfPermUtils.isTaskTransfer((Long)rowIds.get(0), (Long)RequestContext.get().getCurrUserId())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u65e0\u6743\u64cd\u4f5c\uff0c\u56e0\u4e3a\u60a8\u4e0d\u662f\u4efb\u52a1\u8f6c\u4ea4\u4eba\u3002", (String)"WorkflowTCDataPlugin_46", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean checkTaskParticipants(String type, ListSelectedRowCollection rows, IFormView formView) {
        if (BATCHFLAG.equalsIgnoreCase(type) ? !TCCheckPermUtil.checkSelected(rows, formView) : !TCCheckPermUtil.checkSelectedOne(rows, formView)) {
            return Boolean.FALSE;
        }
        List<Long> rowIds = TCCheckPermUtil.getSelectedRows(rows);
        if (!WfPermUtils.isTaskParticipant(rowIds, (Long)RequestContext.get().getCurrUserId())) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u4efb\u52a1\u53c2\u4e0e\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002", (String)"WorkflowTCDataPlugin_41", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean checkTaskAssignee(ListSelectedRowCollection rows, IFormView formView) {
        if (!TCCheckPermUtil.checkSelectedOne(rows, formView)) {
            return Boolean.FALSE;
        }
        List<Long> rowIds = TCCheckPermUtil.getSelectedRows(rows);
        if (!WfPermUtils.isTaskAssignee((Long)rowIds.get(0), (Long)RequestContext.get().getCurrUserId())) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u4efb\u52a1\u529e\u7406\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002", (String)"WorkflowTCDataPlugin_43", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean checkProcessStarter(ListSelectedRowCollection rows, IFormView formView) {
        if (!TCCheckPermUtil.checkSelectedOne(rows, formView)) {
            return Boolean.FALSE;
        }
        List<Long> rowIds = TCCheckPermUtil.getSelectedRows(rows);
        if (!WfPermUtils.isProcessStartUser((Long)rowIds.get(0), (Long)RequestContext.get().getCurrUserId())) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u6d41\u7a0b\u53d1\u8d77\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002", (String)"WorkflowTCDataPlugin_42", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean checkDelegateOwner(IFormView formView) {
        Long currentUserId = RequestContext.get().getCurrUserId();
        DynamicObject dynamicObject = formView.getModel().getDataEntity();
        if (null != dynamicObject) {
            Long delegateId = dynamicObject.get(0) == null ? null : (Long)dynamicObject.get(0);
            OperationStatus operationStatus = formView.getFormShowParameter().getStatus();
            if (OperationStatus.EDIT.equals((Object)operationStatus) && WfUtils.isNotEmpty((Long)delegateId) && !WfPermUtils.isMyDelegateUser((Long)delegateId, (Long)currentUserId)) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u4efb\u52a1\u59d4\u6258\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002", (String)"WorkflowDelegateSettingListPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public static boolean checkIsDelegateOwnerAndFromMsgCenter(ListSelectedRowCollection rows, IFormView formView) {
        if (!TCCheckPermUtil.checkSelectedOne(rows, formView)) {
            return Boolean.FALSE;
        }
        List<Long> rowIds = TCCheckPermUtil.getSelectedRows(rows);
        if (!WfPermUtils.isMyDelegateUser((Long)rowIds.get(0), (Long)RequestContext.get().getCurrUserId())) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u4efb\u52a1\u59d4\u6258\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002", (String)"WorkflowDelegateSettingListPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static boolean checkSelectedOne(ListSelectedRowCollection rows, IFormView formView) {
        StandardTips tips = StandardTips.view((IFormView)formView);
        if (rows == null || rows.isEmpty()) {
            tips.notSelectRow();
            return false;
        }
        if (rows.size() > 1) {
            tips.selectMultiRow(rows.size());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static boolean checkSelected(ListSelectedRowCollection rows, IFormView formView) {
        if (null == rows || rows.size() == 0) {
            formView.showTipNotification(WFMultiLangConstants.getNoDataSelectedTip());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean checkIsTaskParticipantsOrCoordinate(List<Long> taskIds) {
        if (WfPermUtils.isTaskParticipant(taskIds, (Long)RequestContext.get().getCurrUserId()) || WfPermUtils.isTaskCoordinates(taskIds, (Long)RequestContext.get().getCurrUserId())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean checkDisableButtonForSpecialScene(ListSelectedRowCollection rows, IFormView formView, String clickKey) {
        if (rows != null && rows.size() > 0) {
            boolean ret = true;
            List<Long> taskIds = TCCheckPermUtil.getSelectedRows(rows);
            List dataList = WfPermUtils.isCanClickButtonForSpecialScene(taskIds);
            if (dataList != null && dataList.size() > 0) {
                String processtype;
                if (BTNBATCHAPPROVE.equalsIgnoreCase(clickKey) && TCCheckPermUtil.checkBatchOperation(dataList, BTNBATCHAPPROVE)) {
                    ret = Boolean.FALSE;
                } else if (BTNBATCHREJECT.equalsIgnoreCase(clickKey) && TCCheckPermUtil.checkBatchOperation(dataList, BTNBATCHREJECT)) {
                    ret = Boolean.FALSE;
                } else if (BTNTRANSFER.equalsIgnoreCase(clickKey) && TCCheckPermUtil.checkTransfer(dataList)) {
                    ret = Boolean.FALSE;
                } else if (BTNCIRCULATED.equalsIgnoreCase(clickKey) || CIRCULATELOG.equalsIgnoreCase(clickKey)) {
                    String control = (String)((Map)dataList.get(0)).get(CONTROL);
                    if (WfUtils.isEmpty((String)control)) {
                        return Boolean.TRUE;
                    }
                    Map controlMap = (Map)SerializationUtils.fromJsonString((String)control, Map.class);
                    if (!"true".equalsIgnoreCase((String)controlMap.get(CIRCULATE))) {
                        ret = Boolean.FALSE;
                    }
                } else if ((BTNCONVERT.equalsIgnoreCase(clickKey) || BTNCANCEL.equalsIgnoreCase(clickKey)) && !"BizFlow".equalsIgnoreCase(processtype = (String)((Map)dataList.get(0)).get(PROCESSTYPE))) {
                    ret = Boolean.FALSE;
                }
            }
            if (!ret) {
                formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u64cd\u4f5c\u7684\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_48", (String)"bos-wf-formplugin", (Object[])new Object[0]), rows.size()));
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private static boolean checkBatchOperation(List<Map<String, Object>> dataList, String type) {
        boolean find = false;
        for (Map<String, Object> data : dataList) {
            String batchop = (String)data.get(BATCHOP);
            if (!WfUtils.isNotEmpty((String)batchop)) continue;
            String batchApprove = batchop.split("-")[0];
            String batchReject = batchop.split("-")[1];
            if (!"1".equals(batchReject) && BTNBATCHREJECT.equalsIgnoreCase(type)) {
                find = true;
                break;
            }
            if ("1".equals(batchApprove) || !BTNBATCHAPPROVE.equalsIgnoreCase(type)) continue;
            find = true;
            break;
        }
        return find;
    }

    private static boolean checkTransfer(List<Map<String, Object>> dataList) {
        boolean find = false;
        for (Map<String, Object> data : dataList) {
            String controlStr = (String)data.get(CONTROL);
            if (WfUtils.isEmpty((String)controlStr)) {
                return false;
            }
            Map controlMap = (Map)SerializationUtils.fromJsonString((String)controlStr, Map.class);
            if (((Boolean)controlMap.get("transfer")).booleanValue()) continue;
            find = true;
            break;
        }
        return find;
    }
}

