/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.data;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WfRejectInnerPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private String entryentity = "entryentity";

    public void initialize() {
        Button btnok = (Button)this.getView().getControl("btnok");
        btnok.addClickListener((ClickListener)this);
        Button btncancel = (Button)this.getView().getControl("btncancel");
        btncancel.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.entryentity);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.returnDataToParent();
        } else if (key.equalsIgnoreCase("btncancel")) {
            this.getView().close();
        }
    }

    public RepositoryService getRepositoryService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRepositoryService();
    }

    public TaskService getTaskService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getTaskService();
    }

    public void afterCreateNewData(EventObject eo) {
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        TaskEntity task = (TaskEntity)this.getRepositoryService().findEntityById(taskId, "wf_task");
        List preNodes = this.getTaskService().getRejectInnerNodes(task.getProcessInstanceId(), task.getTaskDefinitionKey());
        if (preNodes == null || preNodes.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow(this.entryentity, preNodes.size());
        int i = 0;
        for (Map map : preNodes) {
            this.setModelValue(model, i, map);
            ++i;
        }
    }

    protected void setModelValue(IDataModel model, int i, Map<String, Object> map) {
        model.setValue("nodeid", map.get("id"), i);
        model.setValue("nodename", map.get("name"), i);
        model.setValue("nodedec", map.get("documentation"), i);
    }

    private void returnDataToParent() {
        AbstractGrid grid = (AbstractGrid)this.getControl(this.entryentity);
        int[] rowIndexs = grid.getEntryState().getSelectedRows();
        ArrayList<String> innerNodeIds = new ArrayList<String>(rowIndexs.length);
        for (int i = 0; i < rowIndexs.length; ++i) {
            innerNodeIds.add((String)this.getModel().getValue("nodeid", rowIndexs[i]));
        }
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        String decOptionNumber = (String)this.getModel().getValue("decoptionnumber");
        String auditMessage = (String)this.getModel().getValue("auditmessage");
        DynamicObject user = (DynamicObject)this.getModel().getValue("user");
        boolean skip = (Boolean)this.getModel().getValue("skip");
        this.getTaskService().rejectToInnerNode(taskId, user == null ? null : (Long)user.getPkValue(), decOptionNumber, auditMessage, innerNodeIds, skip, null);
        this.getView().close();
    }
}

