/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.listop.ExportList;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.MulComboListColumn;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.separatestorage.FieldNameAliasMapper;
import kd.bos.workflow.form.operate.ViewFlowchart;
import kd.bos.workflow.message.service.DynamicFieldsService;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.service.separatestorage.SeparateStorageFormService;
import kd.bos.workflow.taskcenter.plugin.data.TCCheckPermUtil;
import kd.bos.workflow.taskcenter.plugin.data.WorkflowTCDataPlugin;
import kd.bos.workflow.taskcenter.plugin.util.WorkflowTCDataPluginUtil;

public class WorkflowTCApplyedPlugin
extends WorkflowTCDataPlugin {
    private static final String B_FENTRABILLNAME = "b.fentrabillname";
    private static final String B_FSUBJECT = "b.FSUBJECT";
    private static final String PROANDVERSION = "proandversion";
    private static final String CREATEDATE = "createdate";
    private static final String SUBJECTSHOW = "subjectshow";
    private static final String ENTRABILLNAMESHOW = "entrabillnameshow";
    private static final String ENDTIME = "endtime";
    private static final String BILLNO = "billno";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List arrays = DynamicFieldsService.create().getHistoricProcessInstanceListFislds();
        arrays.add(new String[]{" ", "priorityshow"});
        HashMap<String, String> fieldWidths = new HashMap<String, String>();
        List listColumns = args.getListColumns();
        String entityNumber = this.getPageCache().get("entityNumber");
        Container parent = (Container)args.getSource();
        for (Control control : parent.getItems()) {
            if (!(control instanceof ListGridView)) continue;
            parent = (Container)control;
            break;
        }
        if (!listColumns.isEmpty()) {
            return;
        }
        for (String[] arr : arrays) {
            ListColumn listColumn = this.createListColumn(arr, "wf_hiprocinst", fieldWidths, entityNumber);
            listColumn.setParentViewKey(parent.getKey());
            listColumn.setBlankFieldCanOrderAndFilter(true);
            if (SUBJECTSHOW.equals(arr[1])) {
                listColumn.setHyperlink(true);
            }
            if (ENTRABILLNAMESHOW.equals(arr[1]) || SUBJECTSHOW.equals(arr[1]) || CREATEDATE.equals(arr[1]) || ENDTIME.equals(arr[1]) || BILLNO.equals(arr[1])) {
                listColumn.setColumnOrderAndFilter(true);
            } else {
                listColumn.setColumnOrderAndFilter(false);
            }
            listColumns.add(listColumn);
        }
    }

    @Override
    public ListColumn createListColumn(String[] arr, String entity, Map<String, String> fieldWidths, String entityNumber) {
        MulComboListColumn listColumn;
        boolean flag = false;
        if (WfUtils.isNotEmpty((String)entityNumber) && ENTRABILLNAMESHOW.equals(arr[1])) {
            flag = true;
        }
        if ("id".equalsIgnoreCase(arr[1]) || "totalhandleduration".equals(arr[1])) {
            flag = true;
        }
        if ("priorityshow".equals(arr[1])) {
            listColumn = new MulComboListColumn();
            listColumn.setShowStyle(1);
            listColumn.setTextAlign("left");
        } else {
            listColumn = new ListColumn();
        }
        listColumn.setCaption(new LocaleString(arr[0]));
        listColumn.setClassName("className");
        listColumn.setEntityName(entity);
        listColumn.setFieldName(arr[1]);
        listColumn.setKey("key" + arr[1]);
        listColumn.setListFieldKey(arr[1]);
        listColumn.setSeq(2);
        String width = fieldWidths.get(arr[1]);
        if (StringUtils.isNotBlank((CharSequence)width)) {
            listColumn.setWidth(new LocaleString(width));
        }
        listColumn.setVisible(flag ? 0 : 13);
        return listColumn;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        String userId = RequestContext.get().getUserId();
        IFormView view = this.getView();
        args.setListDataProvider((IListDataProvider)new ApplyedListDataProvider(userId, this.getPageCache().get("entityNumber"), view));
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btnrefresh": {
                this.refreshData();
                break;
            }
            case "btnbill": {
                String appNum = this.getView().getFormShowParameter().getAppId();
                if (StringUtils.isNotBlank((CharSequence)appNum) && "wf".equals(appNum.toLowerCase(Locale.getDefault())) && !PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_historicalprocesses", (String)"47150e89000000ac")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67e5\u8be2\u7684\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showBill("applyed");
                break;
            }
            case "circulated": {
                this.circulated("applyed");
                break;
            }
            case "viewComments": {
                this.viewComments("applyed");
                break;
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        ArrayList<Long> procInstIds = new ArrayList<Long>();
        if (rows != null && !rows.isEmpty()) {
            for (ListSelectedRow row : rows) {
                procInstIds.add((Long)row.getPrimaryKeyValue());
            }
            if (this.isContainsNoCodeFlowTask("applyed", procInstIds)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"exportexcel", "baritemap"});
                return;
            }
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"exportexcel", "baritemap"});
    }

    public Map<String, List<Object>> buildFilter(List<QFilter> filters) {
        HashMap<String, String> formFieldMapSQLFiled = new HashMap<String, String>();
        formFieldMapSQLFiled.put("id", "a.fid");
        formFieldMapSQLFiled.put(CREATEDATE, "a.fcreatedate");
        formFieldMapSQLFiled.put(ENDTIME, "a.fendtime");
        formFieldMapSQLFiled.put("entitynumber", "a.FENTITYNUMBER");
        formFieldMapSQLFiled.put(SUBJECTSHOW, B_FSUBJECT);
        formFieldMapSQLFiled.put("subject", B_FSUBJECT);
        formFieldMapSQLFiled.put(ENTRABILLNAMESHOW, B_FENTRABILLNAME);
        formFieldMapSQLFiled.put("entrabillname", B_FENTRABILLNAME);
        formFieldMapSQLFiled.put(PROANDVERSION, "b.FNAME");
        formFieldMapSQLFiled.put(BILLNO, "a.fbillno");
        formFieldMapSQLFiled.put("priorityshow", "a.fpriorityshow");
        return this.getFilterSql(filters, formFieldMapSQLFiled);
    }

    public String getOrderByStr(String orderBy) {
        if (WfUtils.isEmpty((String)orderBy)) {
            return orderBy;
        }
        Map formFieldMapSQLFiled = FieldNameAliasMapper.getFieldNameAliasMap((String)"applyed");
        String[] sqlFiledArray = orderBy.split(",");
        String result = "";
        StringBuilder resultSB = new StringBuilder(" ");
        for (int i = 0; i < sqlFiledArray.length; ++i) {
            String[] os = sqlFiledArray[i].split(" ");
            if (os.length != 2) continue;
            String ob = (String)formFieldMapSQLFiled.get(os[0]) + " " + os[1];
            resultSB.append(ob).append(',');
        }
        result = resultSB.substring(0, resultSB.length() - 1);
        return result;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        ArchiveFormService.create().injectArchiveRouteInfo(this.getView());
        SeparateStorageFormService.create().injectSeparateStorageKey(this.getView(), "wf_hiprocinst");
        this.billListHyperLinkClick(args, this.getView(), "applyed");
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args, IFormView view, String type) {
        String businesskey;
        IListView lv = (IListView)this.getView();
        Long procInstId = (Long)lv.getFocusRowPkId();
        HistoricProcessInstanceEntity hiProcInstEntity = (HistoricProcessInstanceEntity)this.getRepositoryService().findEntityById(procInstId, EntityNumberConstant.getHiProcInstEntityNumber(), String.format("%s,%s", "businessKey", "entitynumber"));
        String entitynumber = hiProcInstEntity.getEntitynumber();
        boolean isBillExist = WfUtils.exist((String)entitynumber, (Object)(businesskey = hiProcInstEntity.getBusinessKey()));
        if (!isBillExist) {
            this.getView().showTipNotification(WFMultiLangConstants.getBillNotExistTip(), Integer.valueOf(3000));
        } else {
            Boolean isTaskExist = WorkflowTCDataPluginUtil.showMCenterTaskAndProcessPage((Long)lv.getFocusRowPkId(), view, this.getApprovalCallBack(), type);
            if (!isTaskExist.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8fd9\u6761\u6570\u636e\u53ef\u80fd\u5df2\u7ecf\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u67e5\u770b\u3002", (String)"WorkflowTCDataPlugin_19", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
        }
        args.setCancel(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof ExportList && this.getSelectedRows() == null) {
            args.setCancel(true);
        }
        if (args.getSource() instanceof ViewFlowchart) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            args.setCancel(!TCCheckPermUtil.checkTaskRelationOrProcessStarter(rows, this.getView(), "applyed"));
        }
    }

    class ApplyedListDataProvider
    extends ListDataProvider {
        private QueryResult queryResult = null;
        private String userId;
        private String entityNumber;
        private IFormView view;

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public ApplyedListDataProvider(String userId, String entityNumber, IFormView view) {
            this.userId = userId;
            this.entityNumber = entityNumber;
            this.view = view;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            ArchiveFormService.create().injectArchiveRouteInfo(this.view, this.getQueryBuilder());
            String orderBy = this.getOrderByExpr();
            TaskService taskService = WorkflowTCApplyedPlugin.this.getTaskService();
            DynamicObjectCollection data = null;
            if (!WfConfigurationUtil.isNotQueryByNewSql()) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.valueOf(Long.parseLong(this.userId)), start, limit, "applyed", orderBy).setqFilters(this.getQFilters()).setBillType(this.entityNumber);
                data = taskService.getTaskCenterDatas(processDataEntityQueryParams, "old");
            } else {
                orderBy = WorkflowTCApplyedPlugin.this.getOrderByStr(orderBy);
                Map<String, List<Object>> filterSqlAndParams = WorkflowTCApplyedPlugin.this.buildFilter(this.getQFilters());
                String filterSql = "";
                List<Object> params = new ArrayList();
                if (!filterSqlAndParams.isEmpty()) {
                    Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                    filterSql = entry.getKey();
                    params = entry.getValue();
                }
                data = taskService.getTaskCenterData(start, limit, this.userId, null, this.entityNumber, "applyed", filterSql, params, orderBy);
            }
            this.queryResult = new QueryResult();
            WorkflowTCApplyedPlugin.this.putNoCodeFlowPksMapInPageCache(this.view, data, "applyed");
            this.queryResult.setCollection(data);
            return data;
        }

        public int getRealCount() {
            ArchiveFormService.create().injectArchiveRouteInfo(this.view, this.getQueryBuilder());
            TaskService taskService = WorkflowTCApplyedPlugin.this.getTaskService();
            if (!WfConfigurationUtil.isNotQueryByNewSql()) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams("applyed", Long.valueOf(Long.parseLong(this.userId))).setqFilters(this.getQFilters()).setqFilters(this.getQFilters()).setBillType(this.entityNumber);
                return (int)taskService.getTaskCenterDataCount(processDataEntityQueryParams, "old");
            }
            Map<String, List<Object>> filterSqlAndParams = WorkflowTCApplyedPlugin.this.buildFilter(this.getQFilters());
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            return (int)taskService.getTaskCenterUnionDataCount(this.userId, "applyed", this.entityNumber, filterSql, params);
        }
    }
}

