/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.data;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.listop.ExportList;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.WorkflowFormService;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.form.operate.ViewFlowchart;
import kd.bos.workflow.message.service.DynamicFieldsService;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.service.separatestorage.SeparateStorageFormService;
import kd.bos.workflow.task.service.TaskModelService;
import kd.bos.workflow.taskcenter.plugin.data.TCCheckPermUtil;
import kd.bos.workflow.taskcenter.plugin.data.WorkflowTCDataPlugin;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class WorkflowTCHandledPlugin
extends WorkflowTCDataPlugin {
    private static final String ENDTIME = "endtime";
    private static final String CREATEDATE = "createdate";
    private static final String SENDERNAME = "sendername";
    private static final String HANDLESTATE = "handlestate";
    private static final String SUBJECT = "subject";
    private static final String STARTNAME = "startname";
    private static final String ENTITYNAME = "entityname";
    private static final String BILLNO = "billno";
    private static final String PRESENTASSIGNEE = "presentassignee";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String entityNumber = this.getPageCache().get("entityNumber");
        String delegate = this.getPageCache().get("delegate");
        String transfer = this.getPageCache().get("transfer");
        String folderId = this.getPageCache().get("folderId");
        String type = null;
        if (StringUtils.isNotEmpty((CharSequence)transfer)) {
            type = "transfer";
        } else if (!WfUtils.isEmpty((String)delegate)) {
            type = "delegate";
        }
        List arrays = DynamicFieldsService.create().getHandleTaskListFislds(type);
        if (TaskModelService.create().isExistOuterTaskModelDefinition()) {
            if (entityNumber != null && !entityNumber.startsWith("3&") && !entityNumber.startsWith("4&")) {
                arrays.removeIf(item -> "sourcename".equalsIgnoreCase(item[1]));
            }
        } else {
            arrays.removeIf(item -> "sourcename".equalsIgnoreCase(item[1]));
        }
        if (StringUtils.isBlank((CharSequence)transfer) && StringUtils.isBlank((CharSequence)delegate) && StringUtils.isBlank((CharSequence)folderId)) {
            List<String[]> dynamicArrays = this.getDynamicListColumnsArray(entityNumber, this.getEntityName());
            arrays.addAll(5, dynamicArrays);
        }
        HashMap<String, String> fieldWidths = new HashMap<String, String>();
        List listColumns = args.getListColumns();
        Container parent = (Container)args.getSource();
        for (Control control : parent.getItems()) {
            if (!(control instanceof ListGridView)) continue;
            parent = (Container)control;
            break;
        }
        if (!listColumns.isEmpty()) {
            return;
        }
        for (String[] arr : arrays) {
            ListColumn listColumn = this.createListColumn(arr, "wf_hitaskinst", fieldWidths, entityNumber);
            listColumn.setBlankFieldCanOrderAndFilter(true);
            listColumn.setParent(parent);
            listColumn.setParentViewKey(parent.getKey());
            if (SUBJECT.equals(arr[1])) {
                listColumn.setHyperlink(true);
            }
            if (STARTNAME.equals(arr[1]) || ENTITYNAME.equals(arr[1]) || SUBJECT.equals(arr[1]) || "name".equals(arr[1]) || BILLNO.equals(arr[1]) || CREATEDATE.equals(arr[1]) || ENDTIME.equals(arr[1]) || HANDLESTATE.equals(arr[1]) || SENDERNAME.equals(arr[1]) || PRESENTASSIGNEE.equals(arr[1]) || arr[1].contains("biz_") || "sourcename".equals(arr[1])) {
                listColumn.setColumnOrderAndFilter(true);
            } else {
                listColumn.setColumnOrderAndFilter(false);
            }
            listColumns.add(listColumn);
        }
    }

    public void packageData(PackageDataEvent e) {
        if (StringUtils.isBlank((CharSequence)this.getPageCache().get("delegate")) && StringUtils.isBlank((CharSequence)this.getPageCache().get("transfer")) && StringUtils.isBlank((CharSequence)this.getPageCache().get("folderId"))) {
            DynamicObject rowData = e.getRowData();
            ColumnDesc source = (ColumnDesc)e.getSource();
            IDataEntityProperty srcFieldProp = source.getSrcFieldProp();
            String key = source.getKey();
            if (source.getKey().contains("biz_") && (srcFieldProp instanceof DecimalProp || srcFieldProp instanceof DateTimeProp)) {
                Object[] arr = (Object[])e.getFormatValue();
                arr[0] = rowData.get(key + "_format");
                e.setFormatValue((Object)arr);
            }
            super.packageData(e);
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        String delegate;
        super.filterContainerInit(args);
        String transfer = this.getPageCache().get("transfer");
        if (StringUtils.isNotEmpty((CharSequence)transfer)) {
            FilterColumn schemeFilter = args.getSchemeFilterColumns().stream().filter(item -> CREATEDATE.equals(item.getFieldName())).findFirst().orElseGet(() -> new FilterColumn());
            LocaleString localeString = ResManager.getLocaleString((String)"\u8f6c\u4ea4\u65f6\u95f4", (String)"WorkflowTCToHandlePlugin_26", (String)"bos-wf-formplugin");
            schemeFilter.setCaption(localeString);
            FilterColumn commonFilter = args.getCommonFilterColumns().stream().filter(item -> CREATEDATE.equals(item.getFieldName())).findFirst().orElseGet(() -> new FilterColumn());
            commonFilter.setCaption(localeString);
        }
        if (StringUtils.isNotEmpty((CharSequence)(delegate = this.getPageCache().get("delegate")))) {
            FilterColumn schemeFilter = args.getSchemeFilterColumns().stream().filter(item -> CREATEDATE.equals(item.getFieldName())).findFirst().orElseGet(() -> new FilterColumn());
            LocaleString localeString = ResManager.getLocaleString((String)"\u59d4\u6258\u65f6\u95f4", (String)"WorkflowTCToHandlePlugin_16", (String)"bos-wf-formplugin");
            schemeFilter.setCaption(localeString);
            FilterColumn commonFilter = args.getCommonFilterColumns().stream().filter(item -> CREATEDATE.equals(item.getFieldName())).findFirst().orElseGet(() -> new FilterColumn());
            commonFilter.setCaption(localeString);
            FilterColumn stateSchemeFilter = args.getSchemeFilterColumns().stream().filter(item -> HANDLESTATE.equals(item.getFieldName())).findFirst().orElseGet(() -> new FilterColumn());
            LocaleString stateLocaleString = ResManager.getLocaleString((String)"\u72b6\u6001", (String)"WorkflowTaskInTransitsListPlugin_4", (String)"bos-wf-formplugin");
            stateSchemeFilter.setCaption(stateLocaleString);
            FilterColumn stateFilter = args.getCommonFilterColumns().stream().filter(item -> HANDLESTATE.equals(item.getFieldName())).findFirst().orElseGet(() -> new FilterColumn());
            stateFilter.setCaption(stateLocaleString);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        String userId = RequestContext.get().getUserId();
        String folderIdstr = this.getPageCache().get("folderId");
        String transfer = this.getPageCache().get("transfer");
        String delegate = this.getPageCache().get("delegate");
        IFormView view = this.getView();
        if (WfUtils.isNotEmpty((String)folderIdstr)) {
            long folderId = Long.parseLong(folderIdstr);
            args.setListDataProvider((IListDataProvider)new CustomListDataProviderImpl(folderId, view));
        } else if (WfUtils.isNotEmpty((String)transfer)) {
            args.setListDataProvider((IListDataProvider)new TransferListDataProviderImpl(userId, view));
        } else if (WfUtils.isNotEmpty((String)delegate)) {
            args.setListDataProvider((IListDataProvider)new DelegateListDataProviderImpl(userId, view));
        } else {
            args.setListDataProvider((IListDataProvider)new HandledListDataProvider(userId, this.getPageCache().get("entityNumber"), view));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof ExportList && this.getSelectedRows() == null) {
            args.setCancel(true);
        }
        if (args.getSource() instanceof ViewFlowchart) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            args.setCancel(!TCCheckPermUtil.checkTaskRelationOrProcessStarter(rows, this.getView(), "handled"));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        switch (key) {
            case "btnrefresh": {
                this.refreshData();
                break;
            }
            case "btnbill": {
                this.showBill("handled");
                break;
            }
            case "circulated": {
                this.circulated("handled");
                break;
            }
            case "circulatelog": {
                if (!TCCheckPermUtil.checkTaskRelation(rows, this.getView())) {
                    return;
                }
                this.showCirculateLog();
                break;
            }
            case "btncirculated": {
                if (!TCCheckPermUtil.checkTaskRelation(rows, this.getView())) {
                    return;
                }
                this.showCirculationPage();
                break;
            }
            case "viewComments": {
                this.viewComments("handled");
                break;
            }
            case "btnwithdraw": {
                if (!TCCheckPermUtil.checkTaskAssignee(rows, this.getView())) {
                    return;
                }
                this.withdraw();
                break;
            }
            case "batchprint": {
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                if (selectedRows == null || selectedRows.size() <= 0) {
                    return;
                }
                this.batchPrint();
                break;
            }
        }
    }

    public void withdraw() {
        ListSelectedRowCollection rows = this.getSelectedRow();
        if (rows != null) {
            String successMsg;
            Long historicTaskId = (Long)rows.get(0).getPrimaryKeyValue();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)historicTaskId, (String)"wf_hitaskinst");
            if (dynamicObject != null && "BillTask".equals(dynamicObject.get("category"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\uff0c\u5355\u636eBOTP\u4efb\u52a1\u4e0d\u652f\u6301\u64a4\u56de\u3002", (String)"WorkflowTCHandledPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isCoordianteRecored = CoordinateRecordUtil.isCoordinateRecord((Long)historicTaskId, (String)RequestContext.get().getUserId());
            if (isCoordianteRecored) {
                boolean exist = QueryServiceHelper.exists((String)"wf_task", (Object)historicTaskId);
                if (!exist) {
                    if (CoordinateRecordUtil.isHiparticipant((Long)historicTaskId, (String)RequestContext.get().getUserId(), (String)"participant")) {
                        String successMsg2 = ApprovalPluginUtil.showWithdrawFunc("handled", historicTaskId, null, this.getView());
                        if (WfUtils.isNotEmpty((String)successMsg2)) {
                            this.getView().showSuccessNotification(successMsg2, Integer.valueOf(3000));
                            this.refreshData();
                        }
                        return;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u88ab\u5904\u7406\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"WorkflowTCHandledPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                exist = CoordinateRecordUtil.coordinateRecoredIsExist((Long)historicTaskId);
                if (exist) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8fd8\u6709\u672a\u5b8c\u6210\u7684%1$s\u4efb\u52a1\uff0c\u65e0\u9700\u64a4\u56de\uff0c%2$s\u5b8c\u6210\u540e\u76f4\u63a5\u8986\u76d6\u3002", (String)"WorkflowTCHandledPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName(), WfConfigurationUtil.getCoordinateName()));
                    return;
                }
                boolean isParticipant = CoordinateRecordUtil.isParticipant((Long)historicTaskId, (String)RequestContext.get().getUserId(), (String)"participant");
                if (isParticipant) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u5df2\u7ecf\u662f\u4efb\u52a1\u7684\u5ba1\u6279\u4eba\uff0c%s\u4efb\u52a1\u4e0d\u80fd\u64a4\u56de\u3002", (String)"WorkflowTCHandledPlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName()));
                    return;
                }
                Boolean isTransfered = CoordinateRecordUtil.isTransfered((Long)historicTaskId, (String)RequestContext.get().getUserId());
                if (isTransfered.booleanValue()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%2$s\u201d\u4efb\u52a1\u4e0d\u80fd\u64a4\u56de\uff0c\u60a8\u5df2\u7ecf\u5c06\u4efb\u52a1\u201c%1$s\u201d\u7ed9\u5176\u4ed6\u4eba\u3002", (String)"WorkflowTCHandledPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName(), WfConfigurationUtil.getCoordinateName()));
                    return;
                }
                boolean isHiparticipant = CoordinateRecordUtil.isHiparticipant((Long)historicTaskId, (String)RequestContext.get().getUserId(), (String)"coordinate");
                if (!isHiparticipant) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5728%2$s\u540e\u53d1\u751f\u8fc7%1$s\u5e76\u4e14\u88ab\u64a4\u56de\u8f6c\u4ea4\uff0c\u56e0\u6b64\u60a8\u4e0d\u80fd\u518d\u64a4\u56de%2$s\u4efb\u52a1\u3002", (String)"WorkflowTCHandledPlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getTransferName(), WfConfigurationUtil.getCoordinateName()));
                    return;
                }
                WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                successMsg = wfService.getTaskService().taskCoordinateWithdraw(historicTaskId);
            } else {
                successMsg = ApprovalPluginUtil.showWithdrawFunc("handled", historicTaskId, null, this.getView());
            }
            if (WfUtils.isNotEmpty((String)successMsg)) {
                this.getView().showSuccessNotification(successMsg, Integer.valueOf(3000));
                this.refreshData();
            }
        }
    }

    public Map<String, List<Object>> buildFilter(List<QFilter> filters) {
        return this.buildFilter(filters, false);
    }

    public Map<String, List<Object>> buildFilter(List<QFilter> filters, boolean isFromCount) {
        String transfer = this.getPageCache().get("transfer");
        String folderIdstr = this.getPageCache().get("folderId");
        String delegate = this.getPageCache().get("delegate");
        String queryType = "handled";
        if (WfUtils.isNotEmpty((String)transfer)) {
            queryType = "transferHandled";
        } else if (WfUtils.isNotEmpty((String)delegate)) {
            queryType = "delegateHandled";
        } else if (WfUtils.isNotEmpty((String)folderIdstr)) {
            queryType = "foldHandled";
        }
        return WorkflowFormService.create().buildHandledTaskFilter(queryType, filters, isFromCount);
    }

    public String getOrderByStr(String orderBy) {
        return WorkflowFormService.create().buildOrderByToSql("handled", orderBy);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        ArchiveFormService.create().injectArchiveRouteInfo(this.getView());
        SeparateStorageFormService.create().injectSeparateStorageKey(this.getView(), "wf_hitaskinst");
        super.billListHyperLinkClick(args, this.getView(), "handled");
    }

    public void listRowClick(ListRowClickEvent evt) {
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        ArrayList<Long> taskIds = new ArrayList<Long>(rows.size());
        if (rows != null && !rows.isEmpty()) {
            for (ListSelectedRow row : rows) {
                taskIds.add((Long)row.getPrimaryKeyValue());
            }
            if (this.isContainsNoCodeFlowTask("handled", taskIds)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"btnwithdraw", "btncirculated", "batchprint", "exportexcel", "baritemap3", "circulatelog"});
                return;
            }
            List tasks = this.getTaskService().getTasksByIdsBatchCmd(taskIds, "hitask");
            this.circulateEnableOrDisable(taskIds, tasks);
            this.withdrawTaskEnable(tasks);
            this.viewBillEnableOrDisable(taskIds, tasks);
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btnwithdraw", "btncirculated", "batchprint", "exportexcel", "baritemap3", "circulatelog", "btnbill"});
        }
    }

    private void withdrawTaskEnable(List<TaskInfo> tasks) {
        boolean isCustomTask = this.isCustomTask(tasks);
        boolean isArchiveDB = ArchiveFormService.create().isArchiveDBInView(this.getView());
        boolean containYunzhijiaTask = this.containYunzhijiaTask(tasks);
        if (isCustomTask || isArchiveDB || containYunzhijiaTask) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnwithdraw"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btnwithdraw"});
        }
        if (isCustomTask) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnflowgraph"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btnflowgraph"});
        }
    }

    private boolean containYunzhijiaTask(List<TaskInfo> tasks) {
        return tasks.stream().anyMatch(item -> "YunzhijiaTask".equalsIgnoreCase(item.getCategory()));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("entityNumber")) {
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
            if (WfUtils.isNotEmpty((String)entityNumber)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"batchprint"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"batchprint"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"batchprint"});
        }
    }

    public void setEnableCustomSum(EnableCustomSumEvent args) {
        super.setEnableCustomSum(args);
    }

    private String getEntityName() {
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            return "wf_hicomment";
        }
        return "wf_hitaskinst";
    }

    class DelegateListDataProviderImpl
    extends ListDataProvider {
        private QueryResult queryResult = null;
        private String userId;
        private IFormView view;

        public DelegateListDataProviderImpl(String userId, IFormView view) {
            this.userId = userId;
            this.view = view;
        }

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            ArchiveFormService.create().injectArchiveRouteInfo(this.view, this.getQueryBuilder());
            String orderBy = this.getOrderByExpr();
            DynamicObjectCollection data = null;
            if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.valueOf(Long.parseLong(this.userId)), start, limit, "delegateHandled", orderBy).setqFilters(this.getQFilters());
                data = WorkflowTCHandledPlugin.this.getTaskService().getTaskCenterDatas(processDataEntityQueryParams, "old");
            } else {
                orderBy = WorkflowTCHandledPlugin.this.getOrderByStr(orderBy);
                Map<String, List<Object>> filterSqlAndParams = WorkflowTCHandledPlugin.this.buildFilter(this.getQFilters(), Boolean.TRUE);
                String filterSql = "";
                List<Object> params = new ArrayList();
                if (!filterSqlAndParams.isEmpty()) {
                    Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                    filterSql = entry.getKey();
                    params = entry.getValue();
                }
                data = WorkflowTCHandledPlugin.this.getTaskService().getTaskCenterDelegateData(start, limit, this.userId, "handled", filterSql, params, orderBy);
            }
            this.queryResult = new QueryResult();
            this.queryResult.setCollection(data);
            return data;
        }

        public int getRealCount() {
            ArchiveFormService.create().injectArchiveRouteInfo(this.view, this.getQueryBuilder());
            if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams("delegateHandled", Long.valueOf(Long.parseLong(this.userId))).setqFilters(this.getQFilters());
                return (int)WorkflowTCHandledPlugin.this.getTaskService().getTaskCenterDataCount(processDataEntityQueryParams, "old");
            }
            Map<String, List<Object>> filterSqlAndParams = WorkflowTCHandledPlugin.this.buildFilter(this.getQFilters(), Boolean.TRUE);
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            return WorkflowTCHandledPlugin.this.getTaskService().getTaskCenterDelegateCount(this.userId, "handled", filterSql, params);
        }
    }

    class TransferListDataProviderImpl
    extends ListDataProvider {
        private QueryResult queryResult = null;
        private String uid;
        private IFormView view;

        public TransferListDataProviderImpl(String uid, IFormView view) {
            this.uid = uid;
            this.view = view;
        }

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            ArchiveFormService.create().injectArchiveRouteInfo(this.view, this.getQueryBuilder());
            String orderBy = this.getOrderByExpr();
            this.queryResult = new QueryResult();
            TaskService service = WorkflowTCHandledPlugin.this.getTaskService();
            DynamicObjectCollection data = null;
            if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateTaskHandleLogComplete().booleanValue()) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.valueOf(Long.parseLong(this.uid)), start, limit, "transferHandled", orderBy).setEndType("pc").setqFilters(this.getQFilters());
                data = service.getTaskCenterDatas(processDataEntityQueryParams, "old");
            } else {
                orderBy = WorkflowTCHandledPlugin.this.getOrderByStr(orderBy);
                Map<String, List<Object>> filterSqlAndParams = WorkflowTCHandledPlugin.this.buildFilter(this.getQFilters());
                String filterSql = "";
                List<Object> params = new ArrayList();
                if (!filterSqlAndParams.isEmpty()) {
                    Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                    filterSql = entry.getKey();
                    params = entry.getValue();
                }
                data = service.getTaskCenterTransferData(start, limit, this.uid, "handled", filterSql, params, orderBy);
            }
            this.queryResult.setCollection(data);
            return data;
        }

        public int getRealCount() {
            TaskService service = WorkflowTCHandledPlugin.this.getTaskService();
            ArchiveFormService.create().injectArchiveRouteInfo(this.view, this.getQueryBuilder());
            if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateTaskHandleLogComplete().booleanValue()) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams("transferHandled", Long.valueOf(Long.parseLong(this.uid))).setqFilters(this.getQFilters()).setEndType("pc");
                return (int)service.getTaskCenterDataCount(processDataEntityQueryParams, "old");
            }
            Map<String, List<Object>> filterSqlAndParams = WorkflowTCHandledPlugin.this.buildFilter(this.getQFilters(), true);
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            return service.getTaskCenterTransferCount(this.uid, "handled", filterSql, params);
        }
    }

    class HandledListDataProvider
    extends ListDataProvider {
        private QueryResult queryResult = null;
        private String userId;
        private String entityNumber;
        private IFormView view;

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public HandledListDataProvider(String userId, String entityNumber, IFormView view) {
            this.userId = userId;
            this.entityNumber = entityNumber;
            this.view = view;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            ArchiveFormService.create().injectArchiveRouteInfo(this.view, this.getQueryBuilder());
            String orderBy = this.getOrderByExpr();
            TaskService taskService = WorkflowTCHandledPlugin.this.getTaskService();
            DynamicObjectCollection data = null;
            if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.valueOf(Long.parseLong(this.userId)), start, limit, "handled", orderBy).setEndType("pc").setqFilters(this.getQFilters()).setBillType(this.entityNumber);
                data = taskService.getTaskCenterDatas(processDataEntityQueryParams, "old");
            } else {
                orderBy = WorkflowTCHandledPlugin.this.getOrderByStr(orderBy);
                Map<String, List<Object>> filterSqlAndParams = WorkflowTCHandledPlugin.this.buildFilter(this.getQFilters());
                String filterSql = "";
                List<Object> params = new ArrayList();
                if (!filterSqlAndParams.isEmpty()) {
                    Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                    filterSql = entry.getKey();
                    params = entry.getValue();
                }
                data = taskService.getTaskCenterData(start, limit, this.userId, null, this.entityNumber, "handled", filterSql, params, orderBy);
            }
            WorkflowTCHandledPlugin.this.putNoCodeFlowPksMapInPageCache(this.view, data, "handled");
            this.queryResult = new QueryResult();
            this.queryResult.setCollection(data);
            this.queryResult.setSummaryResults(WorkflowTCHandledPlugin.this.getListSummaryResults((IListDataProvider)this, data));
            return data;
        }

        public List<SummaryResult> getSummaryResults() {
            return super.getSummaryResults();
        }

        public int getRealCount() {
            ArchiveFormService.create().injectArchiveRouteInfo(this.view, this.getQueryBuilder());
            TaskService taskService = WorkflowTCHandledPlugin.this.getTaskService();
            if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams("handled", Long.valueOf(Long.parseLong(this.userId))).setqFilters(this.getQFilters()).setEndType("pc").setBillType(this.entityNumber);
                return (int)taskService.getTaskCenterDataCount(processDataEntityQueryParams, "old");
            }
            Map<String, List<Object>> filterSqlAndParams = WorkflowTCHandledPlugin.this.buildFilter(this.getQFilters(), true);
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            return (int)taskService.getTaskCenterUnionDataCount(this.userId, "handled", this.entityNumber, filterSql, params);
        }
    }

    class CustomListDataProviderImpl
    extends ListDataProvider {
        private QueryResult queryResult = null;
        private long folderId;
        private IFormView view;

        public CustomListDataProviderImpl(long folderId, IFormView view) {
            this.folderId = folderId;
            this.view = view;
        }

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            ArchiveFormService.create().injectArchiveRouteInfo(this.view, this.getQueryBuilder());
            String orderBy = this.getOrderByExpr();
            orderBy = WorkflowTCHandledPlugin.this.getOrderByStr(orderBy);
            this.queryResult = new QueryResult();
            TaskService service = WorkflowTCHandledPlugin.this.getTaskService();
            Map<String, List<Object>> filterSqlAndParams = WorkflowTCHandledPlugin.this.buildFilter(this.getQFilters());
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            DynamicObjectCollection c = service.getTaskCenterCustomData(start, limit, this.folderId, "handled", filterSql, params, orderBy);
            WorkflowTCHandledPlugin.this.putNoCodeFlowPksMapInPageCache(this.view, c, "handled");
            this.queryResult.setCollection(c);
            return c;
        }

        public int getRealCount() {
            ArchiveFormService.create().injectArchiveRouteInfo(this.view, this.getQueryBuilder());
            Map<String, List<Object>> filterSqlAndParams = WorkflowTCHandledPlugin.this.buildFilter(this.getQFilters(), true);
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            TaskService service = WorkflowTCHandledPlugin.this.getTaskService();
            return (int)service.getTaskCenterCustomCount(this.folderId, "handled", filterSql, params);
        }
    }
}

