/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.listop.ExportList;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.MulComboListColumn;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.form.operate.ViewFlowchart;
import kd.bos.workflow.message.service.DynamicFieldsService;
import kd.bos.workflow.service.separatestorage.SeparateStorageFormService;
import kd.bos.workflow.taskcenter.plugin.data.TCCheckPermUtil;
import kd.bos.workflow.taskcenter.plugin.data.WorkflowTCDataPlugin;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class WorkflowTCToApplyPlugin
extends WorkflowTCDataPlugin {
    private static final String B_FSUBJECT = "b.FSUBJECT";
    private static final String B_FACTIVITYNAME = "b.factivityname";
    private static final String B_FENTRABILLNAME = "b.fentrabillname";
    private static final String A_FCREATEDATE = "a.fcreatedate";
    private static final String BILLNO = "billno";
    private static final String CREATEDATE = "createdate";
    private static final String ACTIVITYNAMESHOW = "activitynameshow";
    private static final String SUSPENSIONSTATE = "suspensionstate";
    private static final String SUBJECTSHOW = "subjectshow";
    private static final String ENTRABILLNAMESHOW = "entrabillnameshow";
    private static final String PRESENTASSIGNEE = "presentassignee";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List arrays = DynamicFieldsService.create().getExecutionListFislds();
        arrays.add(new String[]{" ", "priorityshow"});
        HashMap<String, String> fieldWidths = new HashMap<String, String>();
        List listColumns = args.getListColumns();
        String entityNumber = this.getPageCache().get("entityNumber");
        Container parent = (Container)args.getSource();
        for (Control control : parent.getItems()) {
            if (!(control instanceof ListGridView)) continue;
            parent = (Container)control;
            break;
        }
        if (!listColumns.isEmpty()) {
            return;
        }
        boolean isTransfer = Boolean.FALSE;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (WfUtils.isNotEmptyForMap((Map)customParams) && WfUtils.isNotEmptyString(customParams.get("executionTransfer"))) {
            isTransfer = Boolean.parseBoolean(customParams.get("executionTransfer").toString());
        }
        for (String[] arr : arrays) {
            ListColumn listColumn = this.createListColumn(arr, "wf_execution_tc", fieldWidths, entityNumber);
            listColumn.setBlankFieldCanOrderAndFilter(true);
            listColumn.setParentViewKey(parent.getKey());
            if (SUBJECTSHOW.equals(arr[1]) && !isTransfer) {
                listColumn.setHyperlink(true);
            }
            if (SUBJECTSHOW.equals(arr[1]) || ENTRABILLNAMESHOW.equals(arr[1]) || ACTIVITYNAMESHOW.equals(arr[1]) || BILLNO.equals(arr[1]) || CREATEDATE.equals(arr[1]) || PRESENTASSIGNEE.equals(arr[1])) {
                listColumn.setColumnOrderAndFilter(true);
            } else {
                listColumn.setColumnOrderAndFilter(false);
            }
            listColumns.add(listColumn);
        }
    }

    @Override
    public ListColumn createListColumn(String[] arr, String entity, Map<String, String> fieldWidths, String entityNumber) {
        MulComboListColumn listColumn;
        if ("priorityshow".equals(arr[1])) {
            listColumn = new MulComboListColumn();
            listColumn.setShowStyle(1);
            listColumn.setTextAlign("left");
        } else {
            listColumn = new ListColumn();
        }
        listColumn.setCaption(new LocaleString(arr[0]));
        listColumn.setClassName("className");
        listColumn.setEntityName(entity);
        listColumn.setFieldName(arr[1]);
        listColumn.setKey("key" + arr[1]);
        listColumn.setListFieldKey(arr[1]);
        listColumn.setTextAlign("left");
        listColumn.setSeq(2);
        String width = fieldWidths.get(arr[1]);
        if (WfUtils.isNotEmpty((String)width)) {
            listColumn.setWidth(new LocaleString(width));
        }
        if ("id".equals(arr[1]) || ENTRABILLNAMESHOW.equals(arr[1]) && WfUtils.isNotEmpty((String)entityNumber)) {
            listColumn.setVisible(0);
        }
        return listColumn;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        String userId = RequestContext.get().getUserId();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (WfUtils.isNotEmptyForMap((Map)customParams) && WfUtils.isNotEmptyString(customParams.get("workTransferCreatorId"))) {
            userId = String.valueOf(customParams.get("workTransferCreatorId"));
        }
        args.setListDataProvider((IListDataProvider)new ToApplyListDataProvider(userId, this.getPageCache().get("entityNumber"), this.getView()));
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List schemeFilterColumns = args.getSchemeFilterColumns();
        List needDeleteFilters = schemeFilterColumns.stream().filter(item -> "modifydate".equals(item.getFieldName()) || "scope".equals(item.getFieldName()) || "processtype".equals(item.getFieldName())).collect(Collectors.toList());
        schemeFilterColumns.removeAll(needDeleteFilters);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        switch (key) {
            case "btnrefresh": {
                this.refreshData();
                break;
            }
            case "btnbill": {
                this.showBill("toApply");
                break;
            }
            case "reminders": {
                if (!TCCheckPermUtil.checkProcessStarter(rows, this.getView())) {
                    return;
                }
                this.msgReminders("toApply");
                break;
            }
            case "reminderlog": {
                if (!TCCheckPermUtil.checkProcessStarter(rows, this.getView())) {
                    return;
                }
                this.viewReminderLog();
                break;
            }
            case "circulated": {
                this.circulated("toApply");
                break;
            }
            case "viewComments": {
                this.viewComments("toApply");
                break;
            }
            case "btnwithdraw": {
                if (!TCCheckPermUtil.checkProcessStarter(rows, this.getView())) {
                    return;
                }
                this.withdraw();
                break;
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        ArrayList<Long> executionIs = new ArrayList<Long>();
        if (rows != null && !rows.isEmpty()) {
            for (ListSelectedRow row : rows) {
                executionIs.add((Long)row.getPrimaryKeyValue());
            }
            if (this.isContainsNoCodeFlowTask("toApply", executionIs)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"btnwithdraw", "reminders", "exportexcel", "reminderlog"});
                return;
            }
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"btnwithdraw", "reminders", "exportexcel", "reminderlog"});
    }

    public void withdraw() {
        Long executionId;
        String successMsg;
        ListSelectedRowCollection rows = this.getSelectedRow();
        if (rows != null && WfUtils.isNotEmpty((String)(successMsg = ApprovalPluginUtil.showWithdrawFunc("toApply", null, executionId = (Long)rows.get(0).getPrimaryKeyValue(), this.getView())))) {
            this.getView().showSuccessNotification(successMsg, Integer.valueOf(3000));
            this.refreshData();
        }
    }

    public Map<String, List<Object>> buildFilter(List<QFilter> filters) {
        HashMap<String, String> formFieldMapSQLFiled = new HashMap<String, String>();
        formFieldMapSQLFiled.put("id", "a.fid");
        formFieldMapSQLFiled.put(CREATEDATE, A_FCREATEDATE);
        formFieldMapSQLFiled.put(BILLNO, "a.fbillno");
        formFieldMapSQLFiled.put("entitynumber", "a.FENTITYNUMBER");
        formFieldMapSQLFiled.put(ENTRABILLNAMESHOW, B_FENTRABILLNAME);
        formFieldMapSQLFiled.put("entrabillname", B_FENTRABILLNAME);
        formFieldMapSQLFiled.put(ACTIVITYNAMESHOW, B_FACTIVITYNAME);
        formFieldMapSQLFiled.put("activityname", B_FACTIVITYNAME);
        formFieldMapSQLFiled.put(SUSPENSIONSTATE, "a.FSUSPENSIONSTATE");
        formFieldMapSQLFiled.put(SUBJECTSHOW, B_FSUBJECT);
        formFieldMapSQLFiled.put("subject", B_FSUBJECT);
        formFieldMapSQLFiled.put("modifydate", "a.fmodifydate");
        formFieldMapSQLFiled.put(PRESENTASSIGNEE, "b.fpresentassignee");
        formFieldMapSQLFiled.put("priorityshow", "a.fpriorityshow");
        formFieldMapSQLFiled.put("processtype", "a.fprocesstype");
        return this.getFilterSql(filters, formFieldMapSQLFiled);
    }

    public String getOrderByStr(String orderBy) {
        if (WfUtils.isEmpty((String)orderBy)) {
            return orderBy;
        }
        HashMap<String, String> formFieldMapSQLFiled = new HashMap<String, String>();
        formFieldMapSQLFiled.put("id", "a.fid");
        formFieldMapSQLFiled.put(CREATEDATE, A_FCREATEDATE);
        formFieldMapSQLFiled.put("entitynumber", "a.FENTITYNUMBER");
        formFieldMapSQLFiled.put(SUBJECTSHOW, B_FSUBJECT);
        formFieldMapSQLFiled.put("subject", B_FSUBJECT);
        formFieldMapSQLFiled.put(ENTRABILLNAMESHOW, B_FENTRABILLNAME);
        formFieldMapSQLFiled.put(ACTIVITYNAMESHOW, B_FACTIVITYNAME);
        formFieldMapSQLFiled.put(SUSPENSIONSTATE, "a.FSUSPENSIONSTATE");
        formFieldMapSQLFiled.put("handletime", A_FCREATEDATE);
        formFieldMapSQLFiled.put(BILLNO, "a.fbillno");
        formFieldMapSQLFiled.put(PRESENTASSIGNEE, "b.fpresentassignee");
        String[] sqlFiledArray = orderBy.split(",");
        String result = "";
        StringBuilder resultSB = new StringBuilder(" ");
        for (int i = 0; i < sqlFiledArray.length; ++i) {
            String[] os = sqlFiledArray[i].split(" ");
            if (os.length != 2) continue;
            String ob = (String)formFieldMapSQLFiled.get(os[0]) + " " + os[1];
            resultSB.append(ob).append(',');
        }
        result = resultSB.substring(0, resultSB.length() - 1);
        return result;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        SeparateStorageFormService.create().injectSeparateStorageKey(this.getView(), "wf_hiprocinst");
        super.billListHyperLinkClick(args, this.getView(), "toApply");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof ExportList && this.getSelectedRows() == null) {
            args.setCancel(true);
        }
        if (args.getSource() instanceof ViewFlowchart) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            args.setCancel(!TCCheckPermUtil.checkTaskRelationOrProcessStarter(rows, this.getView(), "toApply"));
        }
    }

    class ToApplyListDataProvider
    extends ListDataProvider {
        private QueryResult queryResult = null;
        private String userId;
        private String entityNumber;
        private IFormView view;

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public ToApplyListDataProvider(String userId, String entityNumber) {
            this.userId = userId;
            this.entityNumber = entityNumber;
        }

        public ToApplyListDataProvider(String userId, String entityNumber, IFormView view) {
            this.userId = userId;
            this.entityNumber = entityNumber;
            this.view = view;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String orderBy = this.getOrderByExpr();
            DynamicObjectCollection data = null;
            TaskService taskService = WorkflowTCToApplyPlugin.this.getTaskService();
            if (!WfConfigurationUtil.isNotQueryByNewSql()) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.valueOf(Long.parseLong(this.userId)), start, limit, "toApply", orderBy).setqFilters(this.getQFilters()).setBillType(this.entityNumber);
                data = taskService.getTaskCenterDatas(processDataEntityQueryParams, "old");
            } else {
                orderBy = WorkflowTCToApplyPlugin.this.getOrderByStr(orderBy);
                Map<String, List<Object>> filterSqlAndParams = WorkflowTCToApplyPlugin.this.buildFilter(this.getQFilters());
                String filterSql = "";
                List<Object> params = new ArrayList();
                if (!filterSqlAndParams.isEmpty()) {
                    Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                    filterSql = entry.getKey();
                    params = entry.getValue();
                }
                data = taskService.getTaskCenterData(start, limit, this.userId, null, this.entityNumber, "toApply", filterSql, params, orderBy);
            }
            this.queryResult = new QueryResult();
            WorkflowTCToApplyPlugin.this.putNoCodeFlowPksMapInPageCache(this.view, data, "toApply");
            this.queryResult.setCollection(data);
            return data;
        }

        public int getRealCount() {
            Map<String, List<Object>> filterSqlAndParams = WorkflowTCToApplyPlugin.this.buildFilter(this.getQFilters());
            TaskService taskService = WorkflowTCToApplyPlugin.this.getTaskService();
            if (!WfConfigurationUtil.isNotQueryByNewSql()) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams("toApply", Long.valueOf(Long.parseLong(this.userId))).setqFilters(this.getQFilters()).setBillType(this.entityNumber);
                return (int)taskService.getTaskCenterDataCount(processDataEntityQueryParams, "old");
            }
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            return (int)taskService.getTaskCenterDataCount(this.userId, "toApply", this.entityNumber, filterSql, params);
        }
    }
}

