/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.data;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.filter.SchemeFilterView;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.listop.ExportList;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.message.utils.MessageSystemParamterUtils;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.TohandleGroupUtil;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.WorkflowFormService;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SuspendType;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.msg.quantitysum.LocalVariables;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.exception.WFBizException;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;
import kd.bos.workflow.form.operate.ViewFlowchart;
import kd.bos.workflow.message.service.DynamicFieldsService;
import kd.bos.workflow.service.separatestorage.SeparateStorageFormService;
import kd.bos.workflow.task.plugin.frontend.ClientCommandUtils;
import kd.bos.workflow.task.service.TaskModelService;
import kd.bos.workflow.task.service.TaskRuntimeService;
import kd.bos.workflow.taskcenter.plugin.data.TCCheckPermUtil;
import kd.bos.workflow.taskcenter.plugin.data.WorkflowTCDataPlugin;

public class WorkflowTCToHandlePlugin
extends WorkflowTCDataPlugin {
    private static final String BTNWITHDRAW_TRANSFER = "btnwithdraw_transfer";
    private static final String BTNCIRCULATED = "btncirculated";
    private static final String BTNCIRCULATELOG = "circulatelog";
    private static final String CREATEDATE = "createdate";
    private static final String HANDLESTATE = "handlestate";
    private static final String SUBJECT = "subject";
    private static final String STARTNAME = "startname";
    private static final String ENTITYNAME = "entityname";
    private static final String BILLNO = "billno";
    private static final String BTNTRANSFER = "btntransfer";
    private static final String SENDERNAME = "sendername";
    private static final String BIZTRACENO = "biztraceno";
    private static final Map<String, String> mapping = new HashMap<String, String>();

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String entityNumber = this.getPageCache().get("entityNumber");
        String transfer = this.getPageCache().get("transfer");
        String delegate = this.getPageCache().get("delegate");
        String folderId = this.getPageCache().get("folderId");
        String type = null;
        if (StringUtils.isNotEmpty((CharSequence)transfer)) {
            type = "transfer";
        } else if (!WfUtils.isEmpty((String)delegate)) {
            type = "delegate";
        }
        List arrays = DynamicFieldsService.create().getToHandleTaskListFislds(type);
        arrays.add(new String[]{" ", "priorityshow"});
        arrays.add(new String[]{"", ""});
        if (TaskModelService.create().isExistOuterTaskModelDefinition()) {
            if (entityNumber != null && !entityNumber.startsWith("3&") && !entityNumber.startsWith("4&")) {
                arrays.removeIf(item -> "sourcename".equalsIgnoreCase(item[1]));
            }
        } else {
            arrays.removeIf(item -> "sourcename".equalsIgnoreCase(item[1]));
        }
        if (StringUtils.isEmpty((CharSequence)transfer) && StringUtils.isEmpty((CharSequence)delegate) && StringUtils.isEmpty((CharSequence)folderId)) {
            arrays.add(new String[]{ResManager.loadKDString((String)"\u4e1a\u52a1\u8ddf\u8e2a\u53f7", (String)"WorkflowTCToHandlePlugin_25", (String)"bos-wf-formplugin", (Object[])new Object[0]), BIZTRACENO});
        }
        if (StringUtils.isBlank((CharSequence)transfer) && StringUtils.isBlank((CharSequence)delegate) && StringUtils.isBlank((CharSequence)folderId)) {
            List<String[]> dynamicArrays = this.getDynamicListColumnsArray(entityNumber, "wf_task");
            arrays.addAll(5, dynamicArrays);
        }
        HashMap<String, String> fieldWidths = new HashMap<String, String>();
        List listColumns = args.getListColumns();
        Container parent = (Container)args.getSource();
        for (Control control : parent.getItems()) {
            if (!(control instanceof ListGridView)) continue;
            parent = (Container)control;
            break;
        }
        if (!listColumns.isEmpty()) {
            return;
        }
        for (String[] arr : arrays) {
            ListColumn listColumn = this.createListColumn(arr, "wf_task", fieldWidths, entityNumber);
            listColumn.setParent(parent);
            listColumn.setParentViewKey(parent.getKey());
            listColumn.setBlankFieldCanOrderAndFilter(true);
            if (SUBJECT.equals(arr[1])) {
                listColumn.setHyperlink(true);
            }
            if ("active".equals(arr[1]) || BIZTRACENO.equals(arr[1])) {
                listColumn.setVisible(0);
            }
            if (BILLNO.equals(arr[1]) || STARTNAME.equals(arr[1]) || ENTITYNAME.equals(arr[1]) || SUBJECT.equals(arr[1]) || "name".equals(arr[1]) || "delegatetime".equals(arr[1]) || CREATEDATE.equals(arr[1]) || HANDLESTATE.equals(arr[1]) || SENDERNAME.equals(arr[1]) || arr[1].contains("biz_") || "sourcename".equals(arr[1])) {
                listColumn.setColumnOrderAndFilter(true);
            } else {
                listColumn.setColumnOrderAndFilter(false);
            }
            listColumns.add(listColumn);
        }
    }

    public void packageData(PackageDataEvent e) {
        if (StringUtils.isBlank((CharSequence)this.getPageCache().get("transfer")) && StringUtils.isBlank((CharSequence)this.getPageCache().get("delegate")) && StringUtils.isBlank((CharSequence)this.getPageCache().get("folderId"))) {
            DynamicObject rowData = e.getRowData();
            ColumnDesc source = (ColumnDesc)e.getSource();
            IDataEntityProperty srcFieldProp = source.getSrcFieldProp();
            String key = source.getKey();
            if (source.getKey().contains("biz_") && (srcFieldProp instanceof DecimalProp || srcFieldProp instanceof DateTimeProp)) {
                Object[] arr = (Object[])e.getFormatValue();
                arr[0] = rowData.get(key + "_format");
                e.setFormatValue((Object)arr);
            }
            super.packageData(e);
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        List columns;
        String delegate;
        String userId = RequestContext.get().getUserId();
        DynamicObjectCollection dyObjs = TohandleGroupUtil.getTohandleGroupByUserId(0, -1, userId, null, null);
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (CommonFilterColumn filterColumn : commonFilterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (!"groupnumber.name".equals(fieldName)) continue;
            if (dyObjs.size() <= 1) {
                commonFilterColumns.remove(filterColumn);
                break;
            }
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(dyObjs.size());
            items.add(this.createComboItem("945713897455805440", ResManager.getLocaleString((String)"\u672a\u5206\u7ec4", (String)"WorkflowTCToHandlePlugin_24", (String)"bos-wf-formplugin")));
            for (int i = 0; i < dyObjs.size(); ++i) {
                if (((DynamicObject)dyObjs.get(i)).getLong("id") == 945713897455805440L) continue;
                LocaleString ls = new LocaleString(RequestContext.get().getLang().toString(), ((DynamicObject)dyObjs.get(i)).getString("name"));
                items.add(this.createComboItem(String.valueOf(((DynamicObject)dyObjs.get(i)).get("id")), ls));
            }
            filterColumn.setComboItems(items);
        }
        this.removeCobPassDate(args.getFilterContainerInitEvent());
        String transfer = this.getPageCache().get("transfer");
        if (StringUtils.isNotEmpty((CharSequence)transfer)) {
            FilterColumn schemeFilter = args.getSchemeFilterColumns().stream().filter(item -> CREATEDATE.equals(item.getFieldName())).findFirst().orElseGet(() -> new FilterColumn());
            LocaleString localeString = ResManager.getLocaleString((String)"\u8f6c\u4ea4\u65f6\u95f4", (String)"WorkflowTCToHandlePlugin_26", (String)"bos-wf-formplugin");
            schemeFilter.setCaption(localeString);
            FilterColumn commonFilter = args.getCommonFilterColumns().stream().filter(item -> CREATEDATE.equals(item.getFieldName())).findFirst().orElseGet(() -> new FilterColumn());
            commonFilter.setCaption(localeString);
        }
        if (StringUtils.isNotEmpty((CharSequence)(delegate = this.getPageCache().get("delegate")))) {
            FilterColumn schemeFilter = args.getSchemeFilterColumns().stream().filter(item -> CREATEDATE.equals(item.getFieldName())).findFirst().orElseGet(() -> new FilterColumn());
            LocaleString localeString = ResManager.getLocaleString((String)"\u59d4\u6258\u65f6\u95f4", (String)"WorkflowTCToHandlePlugin_16", (String)"bos-wf-formplugin");
            schemeFilter.setCaption(localeString);
            FilterColumn commonFilter = args.getCommonFilterColumns().stream().filter(item -> CREATEDATE.equals(item.getFieldName())).findFirst().orElseGet(() -> new FilterColumn());
            commonFilter.setCaption(localeString);
        }
        String folderId = this.getPageCache().get("folderId");
        if ((StringUtils.isNotEmpty((CharSequence)transfer) || StringUtils.isNotEmpty((CharSequence)delegate) || StringUtils.isNotEmpty((CharSequence)folderId)) && (columns = args.getFastFilterColumns()) != null && !columns.isEmpty()) {
            Iterator iterator = columns.iterator();
            while (iterator.hasNext()) {
                FilterColumn column = (FilterColumn)iterator.next();
                if (!BIZTRACENO.equals(column.getFieldName())) continue;
                iterator.remove();
                break;
            }
        }
        super.filterContainerInit(args);
    }

    private void removeCobPassDate(FilterContainerInitEvent event) {
        try {
            String transfer = this.getPageCache().get("transfer");
            String delegate = this.getPageCache().get("delegate");
            Set<String> ids = mapping.keySet();
            Field field = event.getClass().getDeclaredField("schemeFilterView");
            ReflectionUtils.makeAccessible((Field)field);
            SchemeFilterView schemeFilterView = (SchemeFilterView)field.get(event);
            List filterColumns = schemeFilterView.getFilterColumns();
            Iterator columnsIterator = filterColumns.iterator();
            while (columnsIterator.hasNext()) {
                FilterColumn column = (FilterColumn)columnsIterator.next();
                SchemeFilterColumn schemeFilterColumn = (SchemeFilterColumn)column;
                Field field1 = schemeFilterColumn.getClass().getDeclaredField("compareTypes");
                ReflectionUtils.makeAccessible((Field)field1);
                List compareTypes = (List)field1.get(schemeFilterColumn);
                if ("prioritynumber".equals(column.getFieldName())) {
                    if (WfUtils.isNotEmpty((String)transfer) || WfUtils.isNotEmpty((String)delegate)) {
                        columnsIterator.remove();
                        continue;
                    }
                    compareTypes.removeIf(temp -> !ids.contains(temp.getId()));
                    continue;
                }
                if (!HANDLESTATE.equals(column.getFieldName())) continue;
                compareTypes.removeIf(item -> item.getId().equals("106") || item.getId().equals("34"));
            }
        }
        catch (Exception e) {
            this.logger.warn("WorkflowTCToHandlePlugin_removeCobPassDate:\u79fb\u9664\u4f18\u5148\u7ea7\u7b5b\u9009\u6761\u4ef6\u5f02\u5e38");
        }
    }

    private ComboItem createComboItem(String value, LocaleString caption) {
        ComboItem item = new ComboItem();
        item.setValue(value);
        item.setCaption(caption);
        return item;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        SeparateStorageFormService.create().injectSeparateStorageKey(this.getView(), "wf_hitaskinst");
        super.billListHyperLinkClick(args, this.getView(), "toHandle");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        String userId = RequestContext.get().getUserId();
        String folderIdstr = this.getPageCache().get("folderId");
        String transfer = this.getPageCache().get("transfer");
        String delegate = this.getPageCache().get("delegate");
        if (WfUtils.isNotEmpty((String)folderIdstr)) {
            long folderId = Long.parseLong(folderIdstr);
            args.setListDataProvider((IListDataProvider)new CustomListDataProviderImpl(folderId, this.getView()));
        } else if (WfUtils.isNotEmpty((String)transfer)) {
            args.setListDataProvider((IListDataProvider)new TransferListDataProviderImpl(userId));
        } else if (WfUtils.isNotEmpty((String)delegate)) {
            args.setListDataProvider((IListDataProvider)new DelegateListDataProviderImpl(userId));
        } else {
            args.setListDataProvider((IListDataProvider)new ToHandleListDataProvider(userId, this.getPageCache().get("entityNumber"), this.getView()));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String parentFormId;
        if (args.getSource() instanceof ExportList && this.getSelectedRows() == null) {
            args.setCancel(true);
        }
        super.beforeDoOperation(args);
        if (args.getSource() instanceof ViewFlowchart && "wf_msg_center".equals(parentFormId = this.getView().getFormShowParameter().getParentFormId())) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            args.setCancel(!TCCheckPermUtil.checkTaskRelationOrProcessStarter(rows, this.getView(), "toHandler"));
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        this.controlButtonState(rows);
    }

    private void controlButtonState(ListSelectedRowCollection rows) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        if (rows != null && !rows.isEmpty()) {
            for (ListSelectedRow row : rows) {
                taskIds.add((Long)row.getPrimaryKeyValue());
            }
            if (this.isContainsNoCodeFlowTask("toHandle", taskIds)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"btndelegatehandle", "btnbatchapprove", "btnbatchreject", BTNTRANSFER, BTNCIRCULATED, "btnconvert", "btncancel", BTNWITHDRAW_TRANSFER, "batchprint", "exportexcel", BTNCIRCULATELOG});
                return;
            }
            List tasks = this.getTaskService().getTasksByIdsBatchCmd(taskIds, null);
            boolean isContainCoordinateRecored = CoordinateRecordUtil.getIsContainCoordinateRecored(taskIds);
            this.transferEnableOrDisable(taskIds, isContainCoordinateRecored, tasks);
            this.circulateEnableOrDisable(taskIds, tasks);
            this.batchOpEnableOrDisable(taskIds, tasks);
            this.viewBillEnableOrDisable(taskIds, tasks);
            this.withdrawTansferEnableOrDisable(tasks);
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btndelegatehandle", "btnbatchapprove", "btnbatchreject", BTNTRANSFER, BTNCIRCULATED, "btnconvert", "btncancel", BTNWITHDRAW_TRANSFER, "batchprint", "exportexcel", BTNCIRCULATELOG, "btnbill"});
        }
    }

    private void withdrawTansferEnableOrDisable(List<TaskInfo> tasks) {
        boolean btnWithdrawTransferEnable = false;
        TaskInfo bizTaskInfo = tasks.stream().filter(task -> task.isBizTask()).findFirst().orElse(null);
        if (bizTaskInfo != null) {
            this.getView().setEnable(Boolean.valueOf(btnWithdrawTransferEnable), new String[]{BTNWITHDRAW_TRANSFER});
            return;
        }
    }

    public void registerListener(EventObject e) {
        BillList gridView = (BillList)this.getControl("billlistap");
        gridView.addListRowSelectAllListeners(selectAllEvent -> {
            BillList billList = (BillList)selectAllEvent.getSource();
            ListSelectedRowCollection rows = billList.getSelectedRows();
            this.controlButtonState(rows);
        });
        gridView.addClearSelectionListener(clearSelection -> this.getView().setEnable(Boolean.TRUE, new String[]{BTNTRANSFER, BTNCIRCULATED}));
    }

    private void transferEnableOrDisable(List<Long> taskIds, boolean isContainCoordinateRecored, List<TaskInfo> tasks) {
        boolean btnTransferEnable = false;
        TaskInfo bizTaskInfo = tasks.stream().filter(task -> task.isBizTask()).findFirst().orElse(null);
        if (bizTaskInfo != null) {
            this.getView().setEnable(Boolean.valueOf(btnTransferEnable), new String[]{BTNTRANSFER});
            return;
        }
        boolean isAllowTransfer = this.getTaskService().isAllTasksAllowTransfer(taskIds, tasks);
        QFilter filter1 = new QFilter("taskid", "in", (Object)taskIds.toArray());
        QFilter qFilter2 = new QFilter("type", "=", (Object)SuspendType.MANUALSUSPEND.getCode());
        QFilter qFilter3 = new QFilter("undosuspendtime", "is null", null);
        QFilter[] filters = new QFilter[]{filter1, qFilter2, qFilter3};
        Long durations = this.getRepositoryService().getEntityCountByFilter("wf_durationdetail", filters);
        if (!isContainCoordinateRecored && isAllowTransfer && durations == 0L || taskIds.size() == 1 && isContainCoordinateRecored && isAllowTransfer && durations == 0L) {
            btnTransferEnable = true;
        }
        if (TaskDelegateUtil.isContainDelegateTask(taskIds, (Long)RequestContext.get().getCurrUserId()) && WfConfigurationUtil.isTrustHandle()) {
            btnTransferEnable = false;
        }
        this.getView().setEnable(Boolean.valueOf(btnTransferEnable), new String[]{BTNTRANSFER});
    }

    public void customEvent(CustomEventArgs e) {
        String data = e.getEventArgs();
        if (!"callAppMethod".equalsIgnoreCase(e.getKey()) || WfUtils.isEmpty((String)data)) {
            return;
        }
        this.hideTask(e.getEventName(), data);
    }

    private void hideTask(String methodName, String data) {
        try {
            List taskIds = ClientCommandUtils.getTargetTaskIdsbyClient((IFormView)this.getView(), (String)methodName, (String)data);
            if (taskIds.isEmpty()) {
                return;
            }
            TaskRuntimeService.create().hideTaskCmd(taskIds);
            this.refreshData();
        }
        catch (Exception e) {
            this.logger.info(String.format("\u9690\u85cf\u7b2c\u4e09\u65b9\u4efb\u52a1&\u5237\u65b0\u5217\u8868\u62a5\u9519:[%s]", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        switch (key) {
            case "btnrefresh": {
                this.refreshData();
                break;
            }
            case "btnhandle": 
            case "btndelegatehandle": 
            case "btnconvert": {
                if (WfUtils.isEmptyForCollection((Collection)rows)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"WorkflowTCDataPlugin_61", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                List ids = rows.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
                if (!WfPermUtils.isTaskParticipant(ids, (Long)RequestContext.get().getCurrUserId())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u4efb\u52a1\u53c2\u4e0e\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002", (String)"WorkflowTCDataPlugin_41", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!TCCheckPermUtil.checkDisableButtonForSpecialScene(rows, this.getView(), key)) {
                    return;
                }
                this.handleData();
                break;
            }
            case "btnbatchapprove": {
                if (!TCCheckPermUtil.checkTaskParticipants("batchFlag", rows, this.getView())) {
                    return;
                }
                if (!TCCheckPermUtil.checkDisableButtonForSpecialScene(rows, this.getView(), key)) {
                    return;
                }
                this.handleTask("approve");
                break;
            }
            case "btnbatchreject": {
                if (!TCCheckPermUtil.checkTaskParticipants("batchFlag", rows, this.getView())) {
                    return;
                }
                if (!TCCheckPermUtil.checkDisableButtonForSpecialScene(rows, this.getView(), key)) {
                    return;
                }
                this.handleTask("reject");
                break;
            }
            case "btnbill": {
                this.showBill("toHandle");
                break;
            }
            case "btncirculated": {
                if (!TCCheckPermUtil.checkTaskRelation(rows, this.getView())) {
                    return;
                }
                if (!TCCheckPermUtil.checkDisableButtonForSpecialScene(rows, this.getView(), key)) {
                    return;
                }
                this.showCirculationPage();
                break;
            }
            case "circulatelog": {
                if (!TCCheckPermUtil.checkTaskRelation(rows, this.getView())) break;
                this.showCirculateLog();
                break;
            }
            case "btntransfer": {
                if (!TCCheckPermUtil.checkTaskParticipants("batchFlag", rows, this.getView())) {
                    return;
                }
                if (!TCCheckPermUtil.checkDisableButtonForSpecialScene(rows, this.getView(), key)) {
                    return;
                }
                this.showTaskTransfer();
                break;
            }
            case "btnwithdraw_transfer": {
                if (!TCCheckPermUtil.checkTaskTransfer(rows, this.getView())) {
                    return;
                }
                this.showWithdrawTansfer();
                break;
            }
            case "batchprint": {
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                if (selectedRows == null || selectedRows.size() <= 0) {
                    return;
                }
                this.batchPrint();
                break;
            }
            case "btncancel": {
                if (WfUtils.isEmptyForCollection((Collection)rows)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"WorkflowTCDataPlugin_61", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                List ids = rows.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
                if (!WfPermUtils.isTaskParticipant(ids, (Long)RequestContext.get().getCurrUserId())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u4efb\u52a1\u53c2\u4e0e\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002", (String)"WorkflowTCDataPlugin_41", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!TCCheckPermUtil.checkDisableButtonForSpecialScene(rows, this.getView(), key)) {
                    return;
                }
                this.beforeCloseTasks();
                break;
            }
            case "rejectinner": {
                this.rejectInner();
                break;
            }
        }
    }

    private void rejectInner() {
        ListSelectedRowCollection rows = this.getSelectedRow();
        if (rows != null) {
            Long taskId = (Long)rows.get(0).getPrimaryKeyValue();
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("wf_rejectinnernode");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, Long> customParams = new HashMap<String, Long>();
            customParams.put("taskId", taskId);
            parameter.setCustomParams(customParams);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rejectInner"));
            this.getView().showForm(parameter);
        }
    }

    private void beforeCloseTasks() {
        ListSelectedRowCollection rows = this.getSelectedRow();
        if (rows != null && !rows.isEmpty()) {
            String info = String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u53d6\u6d88\u9009\u4e2d\u7684\u201c%s\u201d\u6761\u4efb\u52a1\u5417\uff1f", (String)"WorkflowTCToHandlePlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]), rows.size());
            this.getView().showConfirm(info, MessageBoxOptions.YesNo, new ConfirmCallBackListener("btncancel"));
        }
    }

    private void closeTasks() {
        ListSelectedRowCollection rows = this.getSelectedRow();
        if (rows != null && !rows.isEmpty()) {
            ArrayList<Long> taskIds = new ArrayList<Long>(rows.size());
            for (ListSelectedRow row : rows) {
                taskIds.add((Long)row.getPrimaryKeyValue());
            }
            try {
                LocalVariables.putLocalVariables((boolean)true, (String[])new String[]{"tohandle"});
                this.getTaskService().closeTasks(taskIds);
                this.refreshData();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f\u3002", (String)"WorkflowTCToHandlePlugin_28", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
            catch (WFBizException e) {
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    private void handleTask(String opType) {
        this.getPageCache().put("btnBatchOpType", opType);
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows != null && !rows.isEmpty()) {
            this.batchHandleData(rows);
        }
    }

    private void showWithdrawTansfer() {
        ListSelectedRowCollection rows = this.getSelectedRow();
        if (rows != null) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u64a4\u56de%s\u7684\u4efb\u52a1\u5417\uff1f", (String)"WorkflowTCToHandlePlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getTransferName()), MessageBoxOptions.YesNo, new ConfirmCallBackListener(BTNWITHDRAW_TRANSFER));
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (BTNWITHDRAW_TRANSFER.equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            ListSelectedRowCollection rows = this.getSelectedRow();
            if (rows != null) {
                Long taskId = (Long)rows.get(0).getPrimaryKeyValue();
                Long userId = Long.valueOf(RequestContext.get().getUserId());
                try {
                    String taskType = this.getTaskType(taskId);
                    Map result = null;
                    if (taskType == null) {
                        return;
                    }
                    if ("participant".equals(taskType)) {
                        LocalVariables.putLocalVariables((boolean)true, (String[])new String[]{"tohandle", "transfer"});
                        result = this.getTaskService().withdrawTansferTask(taskId, userId);
                    } else if ("coordinate".equals(taskType)) {
                        LocalVariables.putLocalVariables((boolean)true, (String[])new String[]{"tohandle", "transfer"});
                        this.getTaskService().withdrawTransferCoordinateTask(taskId, userId);
                    } else {
                        String workflowTCToHandlePlugin_15 = ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\u4e3a\u201c%s\u201d\uff0c\u4e0d\u652f\u6301\u64a4\u56de\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WorkflowTCToHandlePlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                        String format = String.format(workflowTCToHandlePlugin_15, taskType);
                        this.getView().showErrorNotification(format);
                        return;
                    }
                    if (result == null || result.isEmpty()) {
                        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u64a4\u56de\u6210\u529f\u3002", (String)"WorkflowTCToHandlePlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getTransferName()), Integer.valueOf(3000));
                    } else {
                        Map message = result;
                        String title = (String)message.get("title");
                        String details = (String)message.get("details");
                        this.getView().showMessage(title, details, null);
                    }
                    this.refreshData();
                    WfUtils.addOpLog((String)"wf_task", (String)"withdrawTransfer", (MultiLangEnumBridge)new MultiLangEnumBridge("\u64a4\u56de\u8f6c\u4ea4", "WorkflowTCToHandlePlugin_29", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u4efb\u52a1\u7f16\u7801\uff1a%s", "WorkflowTCToHandlePlugin_13", "bos-wf-formplugin"), (Object[])new Object[]{taskId});
                }
                catch (NumberFormatException e1) {
                    this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e1));
                }
            }
        } else if ("btncancel".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.closeTasks();
        }
    }

    private String getTaskType(Long taskId) {
        QFilter q1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter q3 = new QFilter("type", "=", (Object)"transfer");
        QFilter q5 = new QFilter("isadminforward", "=", (Object)Character.valueOf('0'));
        DynamicObject[] taskhandlelogs = BusinessDataServiceHelper.load((String)"wf_taskhandlelog", (String)"id,assigneeid", (QFilter[])new QFilter[]{q1, q3, q5});
        if (taskhandlelogs.length == 0) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u201c%s\u201d\u65e5\u5fd7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WorkflowTCToHandlePlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getTransferName()));
            return null;
        }
        if (taskhandlelogs.length >= 2) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u4e24\u6b21\u53ca\u4ee5\u4e0a\u7684%s\u8bb0\u5f55\uff0c\u6682\u4e0d\u652f\u6301\u64a4\u9500\u3002", (String)"WorkflowTCToHandlePlugin_18", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getTransferName()));
            return null;
        }
        Long transferId = taskhandlelogs[0].getLong("assigneeid");
        QFilter q4 = new QFilter("userid", "=", (Object)transferId);
        DynamicObject[] participants = BusinessDataServiceHelper.load((String)"wf_participant", (String)"id,type", (QFilter[])new QFilter[]{q1, q4});
        if (participants.length == 0) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u53ef\u80fd\u5df2\u88ab\u5904\u7406\u6216%s\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"WorkflowTCToHandlePlugin_19", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getTransferName()));
            return null;
        }
        if (participants.length > 2) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6761\u4efb\u52a1\u4e2d\u540c\u4e00\u53c2\u4e0e\u4eba\u53ea\u80fd\u51fa\u73b0\u4e00\u6b21\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WorkflowTCToHandlePlugin_20", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return null;
        }
        return participants[0].getString("type");
    }

    protected void analyzeHandlestateFilter(IListDataProvider dataProvider) {
        for (QFilter f : dataProvider.getQFilters()) {
            WorkflowFormService.create().analyzeHandlestateFilter(f);
        }
    }

    public Map<String, List<Object>> buildFilter(List<QFilter> filters) {
        return this.buildFilter(filters, true, false);
    }

    public Map<String, List<Object>> buildFilter(List<QFilter> filters, boolean isNeedsendername, boolean isFromCount) {
        String transfer = this.getPageCache().get("transfer");
        String folderIdstr = this.getPageCache().get("folderId");
        String delegate = this.getPageCache().get("delegate");
        String queryType = "toHandle";
        if (WfUtils.isNotEmpty((String)transfer)) {
            queryType = "transferToHandle";
        } else if (WfUtils.isNotEmpty((String)delegate)) {
            queryType = "delegateToHandle";
        } else if (WfUtils.isNotEmpty((String)folderIdstr)) {
            queryType = "foldToHandle";
        }
        return WorkflowFormService.create().buildToHandleFilter(queryType, this.getView().getFormShowParameter().getParentFormId(), filters, isNeedsendername, isFromCount);
    }

    public String getOrderByStr(String orderBy) {
        String transfer = this.getPageCache().get("transfer");
        String folderIdstr = this.getPageCache().get("folderId");
        String delegate = this.getPageCache().get("delegate");
        String queryType = "toHandle";
        if (WfUtils.isNotEmpty((String)transfer)) {
            queryType = "transferToHandle";
        } else if (WfUtils.isNotEmpty((String)delegate)) {
            queryType = "delegateToHandle";
        } else if (WfUtils.isNotEmpty((String)folderIdstr)) {
            queryType = "foldToHandle";
        }
        return WorkflowFormService.create().buildOrderByToSql(queryType, orderBy);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ClientCommandUtils.initClientListener((IFormView)this.getView());
        if (!MessageSystemParamterUtils.startBizFlow()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btncancel", "btnconvert"});
        }
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("entityNumber")) {
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
            if (WfUtils.isNotEmpty((String)entityNumber)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"batchprint"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"batchprint"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"batchprint"});
        }
    }

    public void setEnableCustomSum(EnableCustomSumEvent args) {
        super.setEnableCustomSum(args);
    }

    static {
        mapping.put("105", "stringEquals");
        mapping.put("106", "stringNotEquals");
    }

    class DelegateListDataProviderImpl
    extends ListDataProvider {
        private QueryResult queryResult = null;
        private String userId;

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public DelegateListDataProviderImpl(String userId) {
            this.userId = userId;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String orderBy = this.getOrderByExpr();
            DynamicObjectCollection collection = null;
            if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateTaskToParticipantComplete().booleanValue()) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.valueOf(Long.parseLong(this.userId)), start, limit, "delegateToHandle", orderBy).setEndType("pc").setqFilters(this.getQFilters());
                collection = WorkflowTCToHandlePlugin.this.getTaskService().getTaskCenterDatas(processDataEntityQueryParams, "old");
            } else {
                WorkflowTCToHandlePlugin.this.analyzeHandlestateFilter((IListDataProvider)this);
                orderBy = WorkflowTCToHandlePlugin.this.getOrderByStr(orderBy);
                WorkflowTCToHandlePlugin.this.logger.debug("tohandle1:" + this.getQFilters().toString());
                Map<String, List<Object>> filterSqlAndParams = WorkflowTCToHandlePlugin.this.buildFilter(this.getQFilters(), true, true);
                String filterSql = "";
                List<Object> params = new ArrayList();
                if (!filterSqlAndParams.isEmpty()) {
                    Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                    filterSql = entry.getKey();
                    params = entry.getValue();
                }
                collection = WorkflowTCToHandlePlugin.this.getTaskService().getTaskCenterDelegateData(start, limit, this.userId, "toHandle", filterSql, params, orderBy);
            }
            this.queryResult = new QueryResult();
            this.queryResult.setCollection(collection);
            return collection;
        }

        public int getRealCount() {
            if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateTaskToParticipantComplete().booleanValue()) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams("delegateToHandle", Long.valueOf(Long.parseLong(this.userId))).setEndType("pc").setqFilters(this.getQFilters());
                return (int)WorkflowTCToHandlePlugin.this.getTaskService().getTaskCenterDataCount(processDataEntityQueryParams, "old");
            }
            WorkflowTCToHandlePlugin.this.analyzeHandlestateFilter((IListDataProvider)this);
            Map<String, List<Object>> filterSqlAndParams = WorkflowTCToHandlePlugin.this.buildFilter(this.getQFilters(), true, true);
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            return WorkflowTCToHandlePlugin.this.getTaskService().getTaskCenterDelegateCount(this.userId, "toHandle", filterSql, params);
        }
    }

    class TransferListDataProviderImpl
    extends ListDataProvider {
        private QueryResult queryResult = null;
        private String uid;

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public TransferListDataProviderImpl(String uid) {
            this.uid = uid;
        }

        public List<IDataEntityType> getDataEntityTypes() {
            return super.getDataEntityTypes();
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String orderBy = this.getOrderByExpr();
            TaskService service = WorkflowTCToHandlePlugin.this.getTaskService();
            DynamicObjectCollection c = null;
            if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateTaskHandleLogComplete().booleanValue()) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.valueOf(Long.parseLong(this.uid)), start, limit, "transferToHandle", orderBy).setEndType("pc").setqFilters(this.getQFilters());
                c = service.getTaskCenterDatas(processDataEntityQueryParams, "old");
            } else {
                orderBy = WorkflowTCToHandlePlugin.this.getOrderByStr(orderBy);
                Map<String, List<Object>> filterSqlAndParams = WorkflowTCToHandlePlugin.this.buildFilter(this.getQFilters());
                String filterSql = "";
                List<Object> params = new ArrayList();
                if (!filterSqlAndParams.isEmpty()) {
                    Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                    filterSql = entry.getKey();
                    params = entry.getValue();
                }
                c = service.getTaskCenterTransferData(start, limit, this.uid, "toHandle", filterSql, params, orderBy);
            }
            this.queryResult = new QueryResult();
            this.queryResult.setCollection(c);
            return c;
        }

        public int getRealCount() {
            TaskService service = WorkflowTCToHandlePlugin.this.getTaskService();
            if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateTaskHandleLogComplete().booleanValue()) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams("transferToHandle", Long.valueOf(Long.parseLong(this.uid))).setqFilters(this.getQFilters()).setEndType("pc");
                return (int)service.getTaskCenterDataCount(processDataEntityQueryParams, "old");
            }
            Map<String, List<Object>> filterSqlAndParams = WorkflowTCToHandlePlugin.this.buildFilter(this.getQFilters(), true, true);
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            return service.getTaskCenterTransferCount(this.uid, "toHandle", filterSql, params);
        }
    }

    class ToHandleListDataProvider
    extends ListDataProvider {
        private QueryResult queryResult = null;
        private String userId;
        private String entityNumber;
        private IFormView view;

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public ToHandleListDataProvider(String userId, String entityNumber) {
            this.userId = userId;
            this.entityNumber = entityNumber;
        }

        public ToHandleListDataProvider(String userId, String entityNumber, IFormView view) {
            this.userId = userId;
            this.entityNumber = entityNumber;
            this.view = view;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String orderBy = this.getOrderByExpr();
            if (null != orderBy) {
                WorkflowTCToHandlePlugin.this.getPageCache().put("pc_filterSqlOrderBy", orderBy.subSequence(0, orderBy.indexOf(",")).toString());
            }
            TaskService taskService = WorkflowTCToHandlePlugin.this.getTaskService();
            DynamicObjectCollection data = null;
            if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateTaskToParticipantComplete().booleanValue() && TaskExtendFieldUtil.isRepaireParticipantFinish((String)this.entityNumber)) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.valueOf(Long.parseLong(this.userId)), start, limit, "toHandle", orderBy).setEndType("pc").setqFilters(this.getQFilters()).setBillType(this.entityNumber);
                data = taskService.getTaskCenterDatas(processDataEntityQueryParams, "old");
            } else {
                WorkflowTCToHandlePlugin.this.analyzeHandlestateFilter((IListDataProvider)this);
                orderBy = WorkflowTCToHandlePlugin.this.getOrderByStr(orderBy);
                Map<String, List<Object>> filterSqlAndParams = WorkflowTCToHandlePlugin.this.buildFilter(this.getQFilters());
                String filterSql = "";
                List<Object> params = new ArrayList();
                if (!filterSqlAndParams.isEmpty()) {
                    Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                    filterSql = entry.getKey();
                    params = entry.getValue();
                }
                data = taskService.getTaskCenterData(start, limit, this.userId, null, this.entityNumber, "toHandle", filterSql, params, orderBy);
            }
            this.queryResult = new QueryResult();
            WorkflowTCToHandlePlugin.this.putNoCodeFlowPksMapInPageCache(this.view, data, "toHandle");
            this.queryResult.setCollection(data);
            this.queryResult.setSummaryResults(WorkflowTCToHandlePlugin.this.getListSummaryResults((IListDataProvider)this, data));
            return data;
        }

        public List<SummaryResult> getSummaryResults() {
            return super.getSummaryResults();
        }

        public int getRealCount() {
            TaskService taskService = WorkflowTCToHandlePlugin.this.getTaskService();
            if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateTaskToParticipantComplete().booleanValue() && TaskExtendFieldUtil.isRepaireParticipantFinish((String)this.entityNumber)) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams("toHandle", Long.valueOf(Long.parseLong(this.userId))).setEndType("pc").setqFilters(this.getQFilters()).setBillType(this.entityNumber);
                return (int)taskService.getTaskCenterDataCount(processDataEntityQueryParams, "old");
            }
            WorkflowTCToHandlePlugin.this.analyzeHandlestateFilter((IListDataProvider)this);
            Map<String, List<Object>> filterSqlAndParams = WorkflowTCToHandlePlugin.this.buildFilter(this.getQFilters(), true, true);
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            return (int)taskService.getTaskCenterDataCount(this.userId, "toHandle", this.entityNumber, filterSql, params);
        }
    }

    class CustomListDataProviderImpl
    extends ListDataProvider {
        private QueryResult queryResult = null;
        private long folderId;
        private IFormView view;

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public CustomListDataProviderImpl(long folderId) {
            this.folderId = folderId;
        }

        public CustomListDataProviderImpl(long folderId, IFormView view) {
            this.folderId = folderId;
            this.view = view;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String orderBy = this.getOrderByExpr();
            orderBy = WorkflowTCToHandlePlugin.this.getOrderByStr(orderBy);
            Map<String, List<Object>> filterSqlAndParams = WorkflowTCToHandlePlugin.this.buildFilter(this.getQFilters());
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            this.queryResult = new QueryResult();
            TaskService service = WorkflowTCToHandlePlugin.this.getTaskService();
            DynamicObjectCollection c = service.getTaskCenterCustomData(start, limit, this.folderId, "toHandle", filterSql, params, orderBy);
            WorkflowTCToHandlePlugin.this.putNoCodeFlowPksMapInPageCache(this.view, c, "toHandle");
            this.queryResult.setCollection(c);
            return c;
        }

        public int getRealCount() {
            TaskService service = WorkflowTCToHandlePlugin.this.getTaskService();
            Map<String, List<Object>> filterSqlAndParams = WorkflowTCToHandlePlugin.this.buildFilter(this.getQFilters(), true, true);
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            return (int)service.getTaskCenterCustomCount(this.folderId, "toHandle", filterSql, params);
        }
    }
}

