/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.entity;

import java.beans.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SignInfoForBatch
implements Serializable {
    private List<Long> noSignTaskIds = new ArrayList<Long>();
    private Map<String, List<Long>> verifySignTask = new HashMap<String, List<Long>>();
    private Map<String, List<Long>> signTask = new HashMap<String, List<Long>>();
    private Map<String, String> businessAndBillnoMapping = new HashMap<String, String>();
    private String entityNumber;
    private boolean signForSameEntity = true;
    private static Log logger = LogFactory.getLog(SignInfoForBatch.class);

    public void addNoSignTaskIds(Long taskId) {
        this.noSignTaskIds.add(taskId);
    }

    public void putBusinessAndBillnoMapping(String businessKey, String billNo) {
        this.businessAndBillnoMapping.put(businessKey, billNo);
    }

    public void putVerifySignTask(String businessKey, Long taskId) {
        this.verifySignTask.putIfAbsent(businessKey, new ArrayList());
        this.verifySignTask.get(businessKey).add(taskId);
    }

    public void putSignTask(String businessKey, Long taskId) {
        this.signTask.putIfAbsent(businessKey, new ArrayList());
        this.signTask.get(businessKey).add(taskId);
    }

    @Transient
    public boolean isNoSignTask() {
        return !this.isNeedVerifySignTask() && !this.isNeedSignTask();
    }

    @Transient
    public boolean isNeedVerifySignTask() {
        return null != this.verifySignTask && !this.verifySignTask.isEmpty();
    }

    @Transient
    public boolean isNeedSignTask() {
        return null != this.signTask && !this.signTask.isEmpty();
    }

    public void removeTask(Object pkId) {
        this.signTask.remove(pkId);
        logger.debug("SignInfoForBatch.removeTask() signTask: " + this.signTask);
        this.verifySignTask.remove(pkId);
        logger.debug("SignInfoForBatch.removeTask() verifySignTask: " + this.verifySignTask);
    }

    @Transient
    public List<Long> getTaskIds() {
        ArrayList<List<Long>> collection = new ArrayList<List<Long>>();
        if (this.isNeedVerifySignTask()) {
            collection.addAll(this.verifySignTask.values());
            logger.debug("SignInfoForBatch.getTaskIds() verifyCollection: " + collection);
        }
        if (this.isNeedSignTask()) {
            collection.addAll(this.signTask.values());
            logger.debug("SignInfoForBatch.getTaskIds() signCollection: " + collection);
        }
        logger.debug("SignInfoForBatch.getTaskIds() noSignTaskIds: " + this.noSignTaskIds);
        if (collection.isEmpty()) {
            return this.noSignTaskIds;
        }
        for (List list : collection) {
            this.noSignTaskIds.addAll(list);
        }
        logger.info("SignInfoForBatch.getTaskIds() noSignTaskIds final: " + this.noSignTaskIds);
        return this.noSignTaskIds;
    }

    public List<Long> getNoSignTaskIds() {
        return this.noSignTaskIds;
    }

    public void setNoSignTaskIds(List<Long> noSignTaskIds) {
        this.noSignTaskIds = noSignTaskIds;
    }

    public Map<String, List<Long>> getVerifySignTask() {
        return this.verifySignTask;
    }

    public void setVerifySignTask(Map<String, List<Long>> verifySignTask) {
        this.verifySignTask = verifySignTask;
    }

    public Map<String, List<Long>> getSignTask() {
        return this.signTask;
    }

    public void setSignTask(Map<String, List<Long>> signTask) {
        this.signTask = signTask;
    }

    public Map<String, String> getBusinessAndBillnoMapping() {
        return this.businessAndBillnoMapping;
    }

    public void setBusinessAndBillnoMapping(Map<String, String> businessAndBillnoMapping) {
        this.businessAndBillnoMapping = businessAndBillnoMapping;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public boolean isSignForSameEntity() {
        return this.signForSameEntity;
    }

    public void setSignForSameEntity(boolean signForSameEntity) {
        this.signForSameEntity = signForSameEntity;
    }

    public void removeTaskForSignFailed(List<String> failList) {
        String formatErrMsg = ResManager.loadKDString((String)"[%1$s]\u6dfb\u52a0\u6570\u5b57\u7b7e\u540d\u5931\u8d25\u3002", (String)"SignInfoForBatch_01", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        Set<String> signSet = this.signTask.keySet();
        logger.debug("SignInfoForBatch.removeTaskForSignFailed() signSet: " + signSet);
        for (String key : signSet) {
            logger.debug("SignInfoForBatch.removeTaskForSignFailed() signSet for businesskey: " + key);
            this.verifySignTask.remove(key);
            failList.add(String.format(formatErrMsg, this.businessAndBillnoMapping.get(key)));
        }
        logger.debug("SignInfoForBatch.removeTaskForSignFailed() verifySignTask: " + this.verifySignTask + ";failList: " + failList);
        this.signTask.clear();
        logger.info("SignInfoForBatch.removeTaskForSignFailed(List<String>) signSet: " + this.signTask);
    }
}

