/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.design.util.ConditionalRuleUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.taskcenter.plugin.rule.util.CompareTypesForTCUtils;

public class ConditionRegister {
    private static final String ITEMS = "items";
    private static final String FIELD_CAPTION = "fieldCaption";
    private static final String FIELD_NAME = "fieldName";
    private static final String MODEL = "model.";
    private static final String ENTRY_ENTITY = "entryEntity";
    private static final String VALUE = "value";
    private static final String ENTITY_ID = "entityId";
    private static final String NUMBER = "number";
    private static final String FIELD_TYPE = "fieldType";
    private static final String COMPARE_GROUP_ID = "compareGroupID";
    private static final String COMPARE_TYPES = "compareTypes";
    private static final String PROCESSDEFINITIONINFO = "wf_processdefinitioninfo";
    private static final String ENTITYMETA = "bos_entitymeta";
    private static final Log log = LogFactory.getLog(ConditionRegister.class);

    public static List<Map<String, Object>> getGeneralConditions(boolean isItemBill) {
        ArrayList<Map<String, Object>> generalConditions = new ArrayList<Map<String, Object>>();
        generalConditions.addAll(ConditionRegister.getMacroConditions());
        if (isItemBill) {
            generalConditions.addAll(ConditionRegister.getTaskConditions(PROCESSDEFINITIONINFO));
        } else {
            generalConditions.addAll(ConditionRegister.getTaskConditions(ENTITYMETA));
        }
        return generalConditions;
    }

    public static List<Map<String, Object>> getGeneralConditions(String entityNumber, boolean isItemBill, Integer size) {
        ArrayList<Map<String, Object>> generalConditions = new ArrayList<Map<String, Object>>();
        generalConditions.addAll(ConditionRegister.getGeneralConditions(isItemBill));
        if (WfUtils.isNotEmpty((String)entityNumber) && (size == null || size == 1)) {
            generalConditions.addAll(ConditionRegister.getBillConditions(entityNumber));
        }
        return generalConditions;
    }

    private static List<Map<String, Object>> getMacroConditions() {
        ArrayList<Map<String, Object>> macroConditions = new ArrayList<Map<String, Object>>();
        Map<String, Object> sponsorCondition = ConditionRegister.getConditionByParams("proc.initiator", ResManager.loadKDString((String)"\u53d1\u8d77\u4eba", (String)"ConditionRegister_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        sponsorCondition.put(COMPARE_TYPES, ConditionRegister.getCompareTypesByTypeId("15"));
        sponsorCondition.put(COMPARE_GROUP_ID, "15");
        sponsorCondition.put(FIELD_TYPE, "");
        ArrayList sponsorConditionValue = new ArrayList();
        HashMap<String, String> sponsorValue = new HashMap<String, String>();
        sponsorValue.put("type", "user");
        sponsorValue.put(NUMBER, "proc.initiator");
        sponsorValue.put(ENTITY_ID, "bos_user");
        sponsorConditionValue.add(sponsorValue);
        sponsorCondition.put(VALUE, sponsorConditionValue);
        macroConditions.add(sponsorCondition);
        Map<String, Object> preHandlerCondition = ConditionRegister.getConditionByParams("proc.lastAssignee", ResManager.loadKDString((String)"\u4e0a\u4e00\u6b65\u5904\u7406\u4eba", (String)"ConditionRegister_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        preHandlerCondition.put(COMPARE_TYPES, ConditionRegister.getCompareTypesByTypeId("15"));
        preHandlerCondition.put(COMPARE_GROUP_ID, "15");
        preHandlerCondition.put(FIELD_TYPE, "");
        ArrayList preHandlerConditionValue = new ArrayList();
        HashMap<String, String> preHandlerValue = new HashMap<String, String>();
        preHandlerValue.put("type", "user");
        preHandlerValue.put(NUMBER, "proc.lastAssignee");
        preHandlerValue.put(ENTITY_ID, "bos_user");
        preHandlerConditionValue.add(preHandlerValue);
        preHandlerCondition.put(VALUE, preHandlerConditionValue);
        macroConditions.add(preHandlerCondition);
        return macroConditions;
    }

    private static List<Map<String, Object>> getTaskConditions(String formId) {
        ArrayList<Map<String, Object>> taskConditions = new ArrayList<Map<String, Object>>();
        ConditionRegister.addEntityNumberCondition(taskConditions, formId);
        ConditionRegister.addCreateTimeCondition(taskConditions);
        ConditionRegister.addNodeCondition(taskConditions);
        return taskConditions;
    }

    private static void addEntityNumberCondition(List<Map<String, Object>> taskConditions, String formId) {
        Map<String, Object> entityNumberCondition = ConditionRegister.getConditionByParams("task.entityNumber", ResManager.loadKDString((String)"\u5355\u636e", (String)"ConditionRegister_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        entityNumberCondition.put(COMPARE_TYPES, ConditionRegister.getCompareTypesByTypeId("14"));
        entityNumberCondition.put(COMPARE_GROUP_ID, "14");
        entityNumberCondition.put(FIELD_TYPE, "");
        ArrayList entityNumberConditionValue = new ArrayList();
        HashMap<String, String> entityNumberValue = new HashMap<String, String>();
        entityNumberValue.put("type", "basedata");
        entityNumberValue.put(NUMBER, "task.entityNumber");
        entityNumberValue.put(ENTITY_ID, formId);
        entityNumberConditionValue.add(entityNumberValue);
        entityNumberCondition.put(VALUE, entityNumberConditionValue);
        taskConditions.add(entityNumberCondition);
    }

    private static void addCreateTimeCondition(List<Map<String, Object>> taskConditions) {
        Map<String, Object> createTimeCondition = ConditionRegister.getConditionByParams("task.createDate", ResManager.loadKDString((String)"\u63a5\u6536\u65f6\u95f4", (String)"ConditionRegister_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        createTimeCondition.put(COMPARE_TYPES, ConditionRegister.getCompareTypesByTypeId("2"));
        createTimeCondition.put(COMPARE_GROUP_ID, "2");
        createTimeCondition.put(FIELD_TYPE, "");
        ArrayList creatTimeConditionValue = new ArrayList();
        HashMap<String, String> createTimeValue = new HashMap<String, String>();
        createTimeValue.put("type", "date");
        createTimeValue.put(NUMBER, "task.createDate");
        creatTimeConditionValue.add(createTimeValue);
        createTimeCondition.put(VALUE, creatTimeConditionValue);
        taskConditions.add(createTimeCondition);
    }

    private static void addNodeCondition(List<Map<String, Object>> taskConditions) {
        Map<String, Object> nodeCondition = ConditionRegister.getConditionByParams("task.name", ResManager.loadKDString((String)"\u8282\u70b9\u540d\u79f0", (String)"ConditionRegister_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        nodeCondition.put(COMPARE_TYPES, ConditionRegister.getCompareTypesByTypeId("0"));
        nodeCondition.put(COMPARE_GROUP_ID, "0");
        nodeCondition.put(FIELD_TYPE, "");
        ArrayList nodeConditionValue = new ArrayList();
        HashMap<String, String> nodeValue = new HashMap<String, String>();
        nodeValue.put("type", "text");
        nodeValue.put(NUMBER, "task.name");
        nodeConditionValue.add(nodeValue);
        nodeCondition.put(VALUE, nodeConditionValue);
        taskConditions.add(nodeCondition);
    }

    public static List<FilterField> createFilterFields(MainEntityType mainType, IDataEntityProperty srcFieldProp, IDataEntityProperty prop) {
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>();
        String refEntityId = null;
        if (srcFieldProp instanceof BasedataProp) {
            refEntityId = ((BasedataProp)srcFieldProp).getBaseEntityId();
        } else if (srcFieldProp instanceof MulBasedataProp) {
            refEntityId = ((MulBasedataProp)srcFieldProp).getBaseEntityId();
        }
        FilterField filterField = new FilterField(mainType, srcFieldProp, prop, (IDataEntityProperty)null, refEntityId);
        filterFields.add(filterField);
        return filterFields;
    }

    public static List<FilterField> getFilterFields(MainEntityType mainType) {
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>();
        for (IDataEntityProperty fieldProp : mainType.getAllFields().values()) {
            if (!(fieldProp instanceof IFieldHandle)) continue;
            List<FilterField> list = null;
            list = fieldProp instanceof BasedataProp ? ConditionRegister.createFilterFields(mainType, fieldProp, (IDataEntityProperty)((BasedataProp)fieldProp).getComplexType().getPrimaryKey()) : (fieldProp instanceof MulBasedataProp ? ConditionRegister.createFilterFields(mainType, fieldProp, (IDataEntityProperty)((MulBasedataProp)fieldProp).getComplexType().getPrimaryKey()) : ConditionRegister.createFilterFields(mainType, fieldProp, null));
            filterFields.addAll(list);
        }
        return filterFields;
    }

    public static List<Map<String, Object>> getFilterColumns(MainEntityType mainType) {
        List<FilterField> filterFields = ConditionRegister.getFilterFields(mainType);
        ArrayList<Map<String, Object>> filterColumns = new ArrayList<Map<String, Object>>(filterFields.size());
        for (FilterField filterField : filterFields) {
            String fieldName;
            Map item = filterField.createFilterColumn();
            HashMap<String, Object> filterColumn = new HashMap<String, Object>();
            String entryEntityName = item.get(ENTRY_ENTITY).toString();
            if (WfUtils.isNotEmptyString((Object)entryEntityName) && !mainType.getName().equals(entryEntityName)) {
                String entryEntity = item.get(ENTRY_ENTITY).toString() + ".";
                fieldName = MODEL + entryEntity + item.get(FIELD_NAME);
            } else {
                fieldName = MODEL + item.get(FIELD_NAME);
            }
            filterColumn.put(FIELD_NAME, fieldName);
            String fieldCaption = (String)item.get(FIELD_CAPTION);
            fieldCaption = fieldCaption.contains(".id") ? fieldCaption.replace(".id", "") : fieldCaption;
            filterColumn.put(FIELD_CAPTION, fieldCaption);
            Object type = item.get("type");
            IDataEntityProperty fieldProp = filterField.getFieldProp();
            if (fieldProp instanceof DecimalProp) {
                type = NUMBER;
            }
            if (WfUtils.isEmptyString(type)) continue;
            String compareGroupID = ConditionalRuleUtil.getCompareGroupIdByType(fieldProp instanceof BooleanProp ? "boolean" : type.toString());
            filterColumn.put(COMPARE_TYPES, ConditionRegister.getCompareTypesByTypeId(compareGroupID));
            filterColumn.put(COMPARE_GROUP_ID, compareGroupID);
            filterColumn.put(FIELD_TYPE, item.get(FIELD_TYPE));
            ArrayList values = new ArrayList();
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put("type", type);
            value.put(NUMBER, fieldName);
            if (item.get(ITEMS) != null) {
                value.put(ITEMS, item.get(ITEMS));
            }
            if (item.get(ENTITY_ID) != null) {
                value.put(ENTITY_ID, item.get(ENTITY_ID));
            }
            values.add(value);
            filterColumn.put(VALUE, values);
            filterColumns.add(filterColumn);
        }
        return filterColumns;
    }

    public static List<Map<String, Object>> getBillConditions(String entityNumber) {
        if (WfUtils.isEmpty((String)entityNumber)) {
            return new ArrayList<Map<String, Object>>();
        }
        try {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            List<Map<String, Object>> filterConditons = ConditionRegister.getFilterColumns(entityType);
            return filterConditons;
        }
        catch (Exception e) {
            log.error(WfUtils.getExceptionStacktrace((Throwable)e));
            return new ArrayList<Map<String, Object>>();
        }
    }

    private static Map<String, Object> getConditionByParams(String fieldName, String fieldCaption) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put(FIELD_NAME, fieldName);
        condition.put(FIELD_CAPTION, fieldCaption);
        return condition;
    }

    public static List<CompareTypeDto> getCompareTypesByTypeId(String compareGroupID) {
        return CompareTypesForTCUtils.get().getCompareTypesById(compareGroupID);
    }

    public static List<ValueMapItem> getBillFields(String entityId) {
        if (WfUtils.isEmpty((String)entityId)) {
            return new ArrayList<ValueMapItem>();
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityTypeById((String)entityId);
        List<FilterField> filterFields = ConditionRegister.getFilterFields(entityType);
        ArrayList<ValueMapItem> billFields = new ArrayList<ValueMapItem>(filterFields.size());
        for (FilterField filterField : filterFields) {
            String fieldName;
            Map item = filterField.createFilterColumn();
            ValueMapItem billField = new ValueMapItem();
            String entryEntityName = item.get(ENTRY_ENTITY).toString();
            if (WfUtils.isNotEmptyString((Object)entryEntityName) && !entityType.getName().equals(entryEntityName)) {
                String entryEntity = item.get(ENTRY_ENTITY).toString() + ".";
                fieldName = MODEL + entryEntity + item.get(FIELD_NAME);
            } else {
                fieldName = MODEL + item.get(FIELD_NAME);
            }
            billField.setValue(fieldName);
            String fieldCaption = (String)item.get(FIELD_CAPTION);
            fieldCaption = fieldCaption.contains(".id") ? fieldCaption.replace(".id", "") : fieldCaption;
            billField.setName(new LocaleString(fieldCaption));
            billFields.add(billField);
        }
        return billFields;
    }
}

