/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.rule.expression.property.ExpressionProperty;
import kd.bos.workflow.engine.rule.util.WfFunctionConfigUtils;

public class WfFunctionConfigPlugin
extends AbstractWorkflowPlugin
implements TreeNodeClickListener {
    private static final String TREE_FUNCTION = "functiontree";
    private static final String BTN_OK = "btnok";
    private static final String LABEL_FUNCNAME = "funcname";
    private static final String LABEL_RETURNTYPE = "returntype";
    private static final String MULTITEXT_FUNCDESC = "funcdesc";
    private static final String PANEL_FUNCTIONTREE = "functiontreepanel";
    private static final String PANEL_NOFUNCHINT = "nofunchintpanel";
    private static final String CURRENTPROP = "currentProp";
    private static final String ROOTID = "root";
    private static final String PREFIX_FUNCGROUP = "grup.";
    private static final String PREFIX_FUNCPROP = "func.";
    private static final String CACHE_ALL_FUNCPROPS = "allFuncProps";
    private static final String CACHE_STACK_FUNCNUMBERS = "cache_funcNumsStack";
    private static final String DESC_FUNCNAME = "funcName";
    private static final String DESC_RETURNVALTYPE = "returnValType";
    private static final String DESC_DETAILEDDESC = "detailedDesc";
    private static final List<FunctionGroup> functionGroups = new ArrayList<FunctionGroup>(3);

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTN_OK});
        TreeView tv = (TreeView)this.getView().getControl(TREE_FUNCTION);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String curPropStr = (String)this.getView().getFormShowParameter().getCustomParam(CURRENTPROP);
        String funcNumStackStr = (String)this.getView().getFormShowParameter().getCustomParam(CACHE_STACK_FUNCNUMBERS);
        if (StringUtils.isNotBlank((CharSequence)curPropStr)) {
            this.initFuncTree((ExpressionProperty)SerializationUtils.fromJsonString((String)curPropStr, ExpressionProperty.class), funcNumStackStr);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_FUNCTIONTREE});
            this.initFuncDescPanel();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = String.valueOf(evt.getNodeId());
        if (StringUtils.isNotBlank((CharSequence)nodeId) && nodeId.startsWith(PREFIX_FUNCPROP)) {
            Stack funcNums;
            String funcNumber = nodeId.substring(PREFIX_FUNCPROP.length());
            String funcNumStackStr = this.getPageCache().get(CACHE_STACK_FUNCNUMBERS);
            Stack stack = funcNums = StringUtils.isNotBlank((CharSequence)funcNumStackStr) ? (Stack)SerializationUtils.fromJsonString((String)funcNumStackStr, Stack.class) : new Stack();
            if (funcNums.isEmpty() || !StringUtils.equals((CharSequence)funcNumber, (CharSequence)((CharSequence)funcNums.peek()))) {
                this.refreshFuncDescPanel(funcNumber);
                this.setFuncNumsStackCache(funcNumber);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.confirm();
        }
    }

    private void initFuncTree(ExpressionProperty currentProp, String funcNumStackStr) {
        TreeNode groupNode;
        HashMap<String, String> filterMap = new HashMap<String, String>(1);
        filterMap.put("filter", (String)this.getView().getFormShowParameter().getCustomParam("filter"));
        List allFuncProps = WfFunctionConfigUtils.getFuncPropsByCurProp((ExpressionProperty)currentProp, filterMap);
        if (WfUtils.isEmptyForCollection((Collection)allFuncProps)) {
            this.initFuncDescPanel();
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_FUNCTIONTREE});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_NOFUNCHINT});
        allFuncProps.sort((o1, o2) -> o1.getOrder() - o2.getOrder());
        this.getPageCache().put(CACHE_ALL_FUNCPROPS, SerializationUtils.toJsonString((Object)allFuncProps, (boolean)true));
        String topFuncNum = "";
        if (StringUtils.isBlank((CharSequence)funcNumStackStr)) {
            this.initFuncDescPanel();
        } else {
            this.getPageCache().put(CACHE_STACK_FUNCNUMBERS, funcNumStackStr);
            Stack funcNumStack = (Stack)SerializationUtils.fromJsonString((String)funcNumStackStr, Stack.class);
            topFuncNum = (String)funcNumStack.peek();
            this.refreshFuncDescPanel(topFuncNum);
        }
        TreeNode root = new TreeNode();
        root.setId(ROOTID);
        root.setText(ResManager.loadKDString((String)"\u51fd\u6570\u914d\u7f6e", (String)"WfFunctionConfigPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        root.setChildren(new ArrayList());
        root.setIsOpened(Boolean.TRUE.booleanValue());
        LinkedHashMap<String, TreeNode> funcGroups = new LinkedHashMap<String, TreeNode>(functionGroups.size());
        for (FunctionGroup functionGroup : functionGroups) {
            if (!functionGroup.isVisible()) continue;
            groupNode = new TreeNode();
            String groupId = functionGroup.getId();
            groupNode.setId(PREFIX_FUNCGROUP + groupId);
            groupNode.setText(functionGroup.getName().getLocaleValue());
            groupNode.setIsOpened(Boolean.TRUE.booleanValue());
            groupNode.setChildren(new ArrayList());
            groupNode.setParentid(ROOTID);
            funcGroups.put(groupId, groupNode);
        }
        TreeNode focusNode = null;
        for (ExpressionProperty funcProp : allFuncProps) {
            String groupId = funcProp.getGroupId();
            if (!StringUtils.isNotBlank((CharSequence)groupId) || !funcGroups.containsKey(groupId)) continue;
            groupNode = new TreeNode();
            groupNode.setId(PREFIX_FUNCPROP + funcProp.getNumber());
            if (StringUtils.equals((CharSequence)topFuncNum, (CharSequence)funcProp.getNumber())) {
                focusNode = groupNode;
            }
            groupNode.setText(funcProp.getName());
            ((TreeNode)funcGroups.get(funcProp.getGroupId())).addChild(groupNode);
        }
        for (Map.Entry entry : funcGroups.entrySet()) {
            TreeNode funcGroupNode = (TreeNode)entry.getValue();
            if (funcGroupNode.getChildren().size() <= 0) continue;
            root.addChild(funcGroupNode);
        }
        TreeView treeView = (TreeView)this.getView().getControl(TREE_FUNCTION);
        treeView.addNode(root);
        treeView.setRootVisible(false);
        treeView.focusNode(focusNode);
    }

    private void refreshFuncDescPanel(String funcNumber) {
        ExpressionProperty curFuncProp = this.getFuncPropByNumber(funcNumber);
        if (curFuncProp == null) {
            return;
        }
        String descFuncName = WfFunctionConfigUtils.getDescNameByFuncNumber((String)funcNumber);
        ((Label)this.getView().getControl(LABEL_FUNCNAME)).setText(descFuncName);
        String descReturnValType = String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u503c\uff1a%s", (String)"WfFunctionConfigPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfFunctionConfigUtils.getReturnValTypeByFuncNumber((String)funcNumber));
        ((Label)this.getView().getControl(LABEL_RETURNTYPE)).setText(descReturnValType);
        String descDetailed = this.formatDescMultiText(curFuncProp.getDescription());
        this.getModel().setValue(MULTITEXT_FUNCDESC, (Object)descDetailed);
    }

    private void initFuncDescPanel() {
        ((Label)this.getView().getControl(LABEL_FUNCNAME)).setText(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51fd\u6570", (String)"WfFunctionConfigPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        ((Label)this.getView().getControl(LABEL_RETURNTYPE)).setText("");
    }

    private void setFuncNumsStackCache(String funcNumber) {
        Stack<String> funcNumStack = new Stack<String>();
        funcNumStack.push(funcNumber);
        this.getPageCache().put(CACHE_STACK_FUNCNUMBERS, SerializationUtils.toJsonString(funcNumStack));
    }

    private ExpressionProperty getFuncPropByNumber(String funcNumber) {
        String funcPropsJsonStr = this.getPageCache().get(CACHE_ALL_FUNCPROPS);
        if (StringUtils.isNotBlank((CharSequence)funcPropsJsonStr)) {
            List allFuncProps = SerializationUtils.fromJsonStringToList((String)funcPropsJsonStr, ExpressionProperty.class);
            for (ExpressionProperty funcProp : allFuncProps) {
                if (!StringUtils.equals((CharSequence)funcNumber, (CharSequence)funcProp.getNumber())) continue;
                return funcProp;
            }
        }
        return null;
    }

    private String formatDescMultiText(String desc) {
        return StringUtils.replace((String)desc, (String)"\\n", (String)"\n");
    }

    private void confirm() {
        String funcNumStackStr = this.getPageCache().get(CACHE_STACK_FUNCNUMBERS);
        this.getView().returnDataToParent((Object)funcNumStackStr);
        this.getView().close();
    }

    private static FunctionGroup createOneFunctionGroup(String id, LocaleString name, int seq, boolean visible) {
        FunctionGroup functionGroup = new FunctionGroup();
        functionGroup.setId(id);
        functionGroup.setName(name);
        functionGroup.setSeq(seq);
        functionGroup.setVisible(visible);
        functionGroup.setExpend(Boolean.FALSE.booleanValue());
        return functionGroup;
    }

    static {
        functionGroups.add(WfFunctionConfigPlugin.createOneFunctionGroup("Enum", WfFunctionConfigUtils.getEnumFuncGroupName(), 1, Boolean.TRUE));
        functionGroups.add(WfFunctionConfigPlugin.createOneFunctionGroup("Collection", WfFunctionConfigUtils.getCollectionFuncGroupName(), 2, Boolean.TRUE));
        functionGroups.add(WfFunctionConfigPlugin.createOneFunctionGroup("Custom", WfFunctionConfigUtils.getCustomFuncGroupName(), 3, Boolean.TRUE));
        functionGroups.sort((o1, o2) -> o1.getSeq() - o2.getSeq());
    }
}

