/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.rule.expression.property.ExpressionProperty;
import kd.bos.workflow.engine.rule.expression.property.IExpressionProperty;
import kd.bos.workflow.engine.rule.expression.property.ProcessMarcoExpressionProp;
import kd.bos.workflow.engine.rule.util.ExpressionPropUtils;
import kd.bos.workflow.engine.rule.util.WfFunctionConfigUtils;
import kd.bos.workflow.exception.WFErrorCode;

public class WfValExpressionPlugin
extends AbstractWorkflowPlugin {
    private static final String WF_VAL_EXPRESSION_PLUGIN_4 = "WfValExpressionPlugin_4";
    public static final String CURRENTPROPLIST = "currentPropList";
    public static final String CURRENTPROP = "currentProp";
    public static final String SUBJECT = "subject";
    public static final String SHOW_EXPRESSION = "expression";
    public static final String COMBOFIELD = "combofield";
    public static final String COMBOFIELD_0 = "combofield0";
    public static final String ICONAP = "iconap";
    public static final String CONFIRM = "confirm";
    public static final String CANCEL = "cancel";
    public static final String TIP = "tip";
    public static final String CONFIRMTYPE = "confirmType";
    public static final String CONFIRMTYPE_TIPS = "confirmType_tips";
    public static final String CONFIRMTYPE_ORG = "bos_org";
    public static final String CACHE_STACK_FUNCNUMBERS = "cache_funcNumsStack";
    public static final String CACHE_ALL_FUNCTIONPROPS = "allFunctions";
    public static final String BTN_SETFUNCTION = "set_function";
    public static final String BTN_CANCELFUNCTION = "cancel_function";
    public static final String PREFIX_EXPEXT_MC = "mc_";
    public static final String SUFFIX_EXP_ID = ".id";
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM});
        this.addClickListeners(new String[]{CANCEL});
        this.addClickListeners(new String[]{BTN_SETFUNCTION});
        this.addClickListeners(new String[]{BTN_CANCELFUNCTION});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        String propStr = "";
        if (CONFIRM.equals(key)) {
            String cacheFunctions = this.getPageCache().get(CACHE_STACK_FUNCNUMBERS);
            Stack functions = WfUtils.isNotEmpty((String)cacheFunctions) ? (Stack)SerializationUtils.fromJsonString((String)cacheFunctions, Stack.class) : new Stack();
            propStr = functions.isEmpty() ? this.getPageCache().get(CURRENTPROP) : this.getFunctionPropStr(functions);
            if (WfUtils.isNotEmpty((String)propStr)) {
                ExpressionProperty prop = (ExpressionProperty)SerializationUtils.fromJsonString((String)propStr, ExpressionProperty.class);
                String expression = (String)this.getModel().getValue(SHOW_EXPRESSION);
                if (WfUtils.isEmpty((String)expression) || "model".equals(expression) || "proc".equals(expression) || "event".equals(expression) || expression.matches("^proc\\.\\w+?EventParams$")) {
                    List props = ExpressionPropUtils.getNextProps((ExpressionProperty)prop, (AbstractFormPlugin)this, null);
                    if (props != null && props.size() > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c5e\u6027\u8868\u8fbe\u5f0f\u9700\u8981\u9009\u5230\u53f6\u5b50\u8282\u70b9\uff0c\u8bf7\u5f80\u4e0b\u9009\u62e9\u3002", (String)"WfValExpressionPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u8fbe\u5f0f\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u8868\u8fbe\u5f0f\u3002", (String)"WfValExpressionPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    }
                    return;
                }
                FormShowParameter parameter = this.getView().getFormShowParameter();
                String filterType = parameter.getCustomParam("filter") == null ? "" : parameter.getCustomParam("filter").toString();
                String filterEntity = parameter.getCustomParam("F7number") == null ? "" : parameter.getCustomParam("F7number").toString();
                Object confirmType = parameter.getCustomParam(CONFIRMTYPE);
                if (WfUtils.isNotEmptyString((Object)confirmType) && null != prop && !confirmType.equals(prop.getEntityNumber())) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u7c7b\u578b\u662f\u201c%s\u201d\u7684\u5b57\u6bb5\u4fe1\u606f\u3002", (String)"WfValExpressionPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), (Object[])parameter.getCustomParam(CONFIRMTYPE_TIPS)));
                    return;
                }
                if (WfUtils.isNotEmpty((String)filterEntity) && null != prop && "F7".equals(filterType) && !filterEntity.equals(prop.getEntityNumber())) {
                    DynamicObject dym = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)filterEntity)});
                    String tipMsg = filterEntity;
                    if (dym != null) {
                        tipMsg = dym.getString("name");
                    }
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u7c7b\u578b\u662f\u201c%s\u201d\u7684\u5b57\u6bb5\u4fe1\u606f\u3002", (String)"WfValExpressionPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), tipMsg));
                    return;
                }
                expression = this.addIDSuffix(prop, expression);
                if (prop != null && WfUtils.isEmpty((String)prop.getExpression())) {
                    prop.setExpression(expression);
                    prop.setName((String)this.getModel().getValue(SUBJECT));
                    prop.setFullName((String)this.getModel().getValue(SUBJECT));
                    propStr = SerializationUtils.toJsonString((Object)prop);
                }
                HashMap<String, String> data = new HashMap<String, String>();
                data.put(SHOW_EXPRESSION, expression);
                data.put("prop", propStr);
                Object customParam = parameter.getCustomParam("isLoopEntryParse");
                data.put("isLoopEntryParse", WfUtils.isNullObject((Object)customParam) ? Boolean.FALSE.toString() : customParam.toString());
                this.getView().returnDataToParent(data);
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfValExpressionPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
        } else if (CANCEL.equals(key)) {
            this.getView().close();
        } else if (BTN_SETFUNCTION.equals(key)) {
            this.openFunctionConfigPage();
        } else if (BTN_CANCELFUNCTION.equals(key)) {
            this.cancelAllFunctionConfig();
        }
    }

    private String getFunctionPropStr(Stack<String> functions) {
        String funcPropStr = "";
        String topFunction = functions.peek();
        List<ExpressionProperty> allfuncProps = this.initFunctionProps();
        if (StringUtils.isNotEmpty((CharSequence)topFunction) && WfUtils.isNotEmptyForCollection(allfuncProps)) {
            for (ExpressionProperty func : allfuncProps) {
                if (!topFunction.equalsIgnoreCase(func.getNumber())) continue;
                ExpressionProperty funcProp = WfFunctionConfigUtils.buildFuncExpressionProp((ExpressionProperty)func);
                ExpressionProperty currProp = (ExpressionProperty)SerializationUtils.fromJsonString((String)this.getPageCache().get(CURRENTPROP), ExpressionProperty.class);
                WfFunctionConfigUtils.setFuncPropValues((ExpressionProperty)funcProp, (ExpressionProperty)currProp);
                funcPropStr = SerializationUtils.toJsonString((Object)funcProp);
                break;
            }
        }
        return funcPropStr;
    }

    private String addIDSuffix(ExpressionProperty prop, String expression) {
        ExpressionProperty curProp = null;
        String newExpression = expression;
        if (prop != null && !"proc".equalsIgnoreCase((curProp = "function".equals(prop.getType()) && StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CURRENTPROP)) ? (ExpressionProperty)SerializationUtils.fromJsonString((String)this.getPageCache().get(CURRENTPROP), ExpressionProperty.class) : prop).getPrefix()) && WfUtils.isNotEmpty((String)curProp.getEntityNumber()) && !curProp.getPath().startsWith(PREFIX_EXPEXT_MC)) {
            newExpression = expression.replace(curProp.getExpression(), curProp.getExpression() + SUFFIX_EXP_ID);
        }
        return newExpression;
    }

    private void openFunctionConfigPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_function_configure");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_SETFUNCTION));
        String curPropStr = this.getPageCache().get(CURRENTPROP);
        parameter.setCustomParam(CURRENTPROP, (Object)curPropStr);
        parameter.setCustomParam(CACHE_STACK_FUNCNUMBERS, (Object)this.getPageCache().get(CACHE_STACK_FUNCNUMBERS));
        parameter.setCustomParam("filter", (Object)this.getPageCache().get("filter"));
        this.getView().showForm(parameter);
    }

    private void cancelAllFunctionConfig() {
        this.removeFuncNumsCache();
        String curPropStr = this.getPageCache().get(CURRENTPROP);
        if (StringUtils.isNotEmpty((CharSequence)curPropStr)) {
            ExpressionProperty currentProp = (ExpressionProperty)SerializationUtils.fromJsonString((String)curPropStr, ExpressionProperty.class);
            this.getModel().setValue(SHOW_EXPRESSION, (Object)currentProp.getExpression(), 0);
            this.getModel().setValue(SUBJECT, (Object)(WfUtils.isEmpty((String)currentProp.getFullName()) ? currentProp.getName() : currentProp.getFullName()), 0);
        }
    }

    private void removeFuncNumsCache() {
        this.getPageCache().remove(CACHE_STACK_FUNCNUMBERS);
    }

    private void updateExpViewWin(Stack<String> funcNumStack) {
        String curPropStr = this.getPageCache().get(CURRENTPROP);
        if (StringUtils.isNotEmpty((CharSequence)curPropStr)) {
            String showSubject;
            ExpressionProperty currentProp = (ExpressionProperty)SerializationUtils.fromJsonString((String)curPropStr, ExpressionProperty.class);
            String showExpression = currentProp.getExpression();
            String string = showSubject = WfUtils.isEmpty((String)currentProp.getFullName()) ? currentProp.getName() : currentProp.getFullName();
            if (funcNumStack != null && !funcNumStack.isEmpty()) {
                for (String funcNumber : funcNumStack) {
                    showExpression = String.format("%s(%s)", funcNumber, showExpression);
                    showSubject = String.format(WfFunctionConfigUtils.getSubjectSuffixByFuncNumber((String)funcNumber), showSubject);
                }
            }
            this.getModel().setValue(SHOW_EXPRESSION, (Object)showExpression);
            this.getModel().setValue(SUBJECT, (Object)showSubject);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfValExpressionPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    public void afterCreateNewData(EventObject e) {
        try {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            this.getPageCache().put("filter", (String)parameter.getCustomParam("filter"));
            this.getPageCache().put("F7number", (String)parameter.getCustomParam("F7number"));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("entityNumber", parameter.getCustomParam("entityNumber"));
            params.put("bpmnModel", parameter.getCustomParam("bpmnModel"));
            params.put("ruleType", parameter.getCustomParam("ruleType"));
            params.put("eventnumber", parameter.getCustomParam("eventnumber"));
            this.getPageCache().put("fromSubjectModelAndApp", (String)parameter.getCustomParam("fromSubjectModelAndApp"));
            this.getPageCache().put("hideLastAssigneeAndCommentFlag", (String)parameter.getCustomParam("hideLastAssigneeAndCommentFlag"));
            if (WfUtils.isNotEmptyString((Object)parameter.getCustomParam("leftEntryPath"))) {
                this.getPageCache().put("leftEntryPath", (String)parameter.getCustomParam("leftEntryPath"));
            }
            String expressionStr = (String)parameter.getCustomParam(SHOW_EXPRESSION);
            ComboEdit combofield0 = (ComboEdit)this.getControl(COMBOFIELD_0);
            List defaultProps = ExpressionPropUtils.getDefaultProps(params, (AbstractFormPlugin)this);
            this.getPageCache().put(COMBOFIELD_0, SerializationUtils.toJsonString((Object)defaultProps, (boolean)true));
            List<ComboItem> items = this.getItems(defaultProps);
            combofield0.setComboItems(items);
            if (WfUtils.isNotEmptyString((Object)parameter.getCustomParam(TIP))) {
                this.getView().showTipNotification((String)parameter.getCustomParam(TIP), Integer.valueOf(3000));
            }
            this.initFunctionProps();
            if (WfUtils.isNotEmpty((String)expressionStr)) {
                Stack<String> usedFunctions = new Stack<String>();
                if ((expressionStr = this.splitFunction(expressionStr, usedFunctions)).endsWith(SUFFIX_EXP_ID) && !expressionStr.startsWith("event")) {
                    expressionStr = expressionStr.substring(0, expressionStr.length() - 3);
                }
                int si = 0;
                if (expressionStr.startsWith("model") || expressionStr.startsWith("event")) {
                    this.recoverPropertys(expressionStr, si);
                } else {
                    ProcessMarcoExpressionProp prop = ExpressionPropUtils.getPropByExpression((String)expressionStr, (AbstractFormPlugin)this);
                    String s = expressionStr;
                    while (prop == null && s.contains(".")) {
                        s = s.substring(0, s.lastIndexOf("."));
                        prop = ExpressionPropUtils.getPropByExpression((String)s, (AbstractFormPlugin)this);
                    }
                    if (prop != null) {
                        String structurenumber = prop.getStructurenumber();
                        int index = this.recoverExpression(structurenumber);
                        if (!s.equals(expressionStr)) {
                            String ts = expressionStr.substring(s.length() + 1);
                            this.recoverPropertys(ts, index);
                        }
                    }
                }
                if (!usedFunctions.isEmpty()) {
                    this.updateExpViewWin(usedFunctions);
                }
            } else if (defaultProps.size() > 0) {
                List secondLevelProps;
                ExpressionProperty ep = (ExpressionProperty)defaultProps.get(0);
                if (WfUtils.isNotEmpty((String)ep.getNumber())) {
                    this.getModel().setValue(COMBOFIELD_0, (Object)ep.getNumber());
                }
                if ((secondLevelProps = ExpressionPropUtils.getNextProps((ExpressionProperty)ep, (AbstractFormPlugin)this, null)).size() > 0) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"iconap0"});
                    this.showNextCombo("combofield1", secondLevelProps);
                    ep = (ExpressionProperty)secondLevelProps.get(0);
                    this.getModel().setValue("combofield1", (Object)ep.getNumber());
                    this.setViewWindowValAndCacheCurrentProp(ep);
                    List threeLevelProps = ExpressionPropUtils.getNextProps((ExpressionProperty)ep, (AbstractFormPlugin)this, null);
                    if (threeLevelProps.size() > 0) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"iconap1"});
                        this.showNextCombo("combofield2", threeLevelProps);
                    }
                } else {
                    this.setViewWindowValAndCacheCurrentProp(ep);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f20\u53c2\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfValExpressionPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u521d\u59cb\u5316\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s", (String)"WfValExpressionPlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]), ex.getMessage()));
            this.log.error("\u8868\u8fbe\u5f0f\u521d\u59cb\u5316\u9519\u8bef\uff01\u539f\u56e0\uff1a" + WfUtils.getExceptionStacktrace((Throwable)ex));
        }
    }

    private void recoverPropertys(String expressionStr, int si) {
        String s = expressionStr;
        while (s.length() > 0) {
            String currentpropListJson = this.getPageCache().get(COMBOFIELD + si);
            if (WfUtils.isEmpty((String)currentpropListJson)) {
                s = "";
                throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u7b2c%s\u7ea7props\u89e3\u6790\u4e3a\u7a7a\u3002", (String)"WfValExpressionPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), si)});
            }
            ArrayList props = SerializationUtils.fromJsonStringToList((String)currentpropListJson, ExpressionProperty.class);
            if (props == null) {
                props = new ArrayList();
            }
            if (props.isEmpty()) {
                s = "";
            }
            Collections.sort(props, new Comparator<ExpressionProperty>(){

                @Override
                public int compare(ExpressionProperty p1, ExpressionProperty p2) {
                    if (p1.getNumber().length() == p2.getNumber().length()) {
                        return 0;
                    }
                    if (p1.getNumber().length() < p2.getNumber().length()) {
                        return 1;
                    }
                    return -1;
                }
            });
            boolean propsHasNotCurrentExpress = true;
            for (ExpressionProperty p : props) {
                String path = p.getPath();
                if (WfUtils.isEmpty((String)path)) {
                    throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u7b2c%s\u7ea7\u8868\u8fbe\u5f0f\u5c5e\u6027\u83b7\u53d6\u9519\u8bef\uff0c\u67d0\u4e2a\u5c5e\u6027\u7684\u8def\u5f84\u4e3a\u7a7a\u3002", (String)"WfValExpressionPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), si)});
                }
                if (!s.startsWith(path)) continue;
                this.getModel().setValue(COMBOFIELD + si, (Object)path);
                this.setViewWindowValAndCacheCurrentProp(p);
                List nextProps = ExpressionPropUtils.getNextProps((ExpressionProperty)p, (AbstractFormPlugin)this, null);
                if (nextProps.size() > 0 && ++si < 8) {
                    this.showNextCombo(COMBOFIELD + si, nextProps);
                    int iconShow = si - 1;
                    this.getView().setVisible(Boolean.TRUE, new String[]{ICONAP + iconShow});
                }
                if ((s = s.substring(path.length())).length() > 0 && nextProps.size() > 0 && s.startsWith(".")) {
                    s = s.substring(1);
                }
                propsHasNotCurrentExpress = false;
                break;
            }
            if (!propsHasNotCurrentExpress) continue;
            throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u7b2c%s\u7ea7\u8868\u8fbe\u5f0f\u5c5e\u6027\u83b7\u53d6\u9519\u8bef\uff0c\u6ca1\u6709\u627e\u5230\u4e0e\u5f53\u524d\u8868\u8fbe\u5f0f\u5bf9\u5e94\u7684\u8def\u5f84\u3002", (String)"WfValExpressionPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), si)});
        }
    }

    private void setViewWindowValAndCacheCurrentProp(ExpressionProperty currentProp) {
        this.getModel().setValue(SUBJECT, (Object)(WfUtils.isEmpty((String)currentProp.getFullName()) ? currentProp.getName() : currentProp.getFullName()), 0);
        this.getModel().setValue(SHOW_EXPRESSION, (Object)currentProp.getExpression(), 0);
        this.getPageCache().put(CURRENTPROP, SerializationUtils.toJsonString((Object)currentProp, (boolean)true));
    }

    private String splitFunction(String expressionStr, Stack<String> usedFunctions) {
        if (expressionStr.contains("(") && expressionStr.endsWith(")")) {
            String[] functions = expressionStr.split("\\(");
            for (int i = 0; i < functions.length; ++i) {
                String function = functions[i];
                if (!expressionStr.startsWith(function + "(") || !expressionStr.endsWith(")")) continue;
                usedFunctions.add(function);
                expressionStr = expressionStr.substring(function.length() + 1, expressionStr.length() - 1);
            }
            Collections.reverse(usedFunctions);
            this.getPageCache().put(CACHE_STACK_FUNCNUMBERS, SerializationUtils.toJsonString(usedFunctions));
        }
        return expressionStr;
    }

    private List<ExpressionProperty> initFunctionProps() {
        List functionProps = new ArrayList();
        String cacheFuncProps = this.getPageCache().get(CACHE_ALL_FUNCTIONPROPS);
        if (WfUtils.isNotEmpty((String)cacheFuncProps)) {
            functionProps = SerializationUtils.fromJsonStringToList((String)cacheFuncProps, ExpressionProperty.class);
        }
        if (functionProps.size() < 1) {
            functionProps = ExpressionPropUtils.getFunctionProps();
            this.getPageCache().put(CACHE_ALL_FUNCTIONPROPS, SerializationUtils.toJsonString(functionProps, (boolean)true));
        }
        return functionProps;
    }

    private int recoverExpression(String structurenumber) {
        String[] expArr = structurenumber.split("\\.");
        String nodeId = null;
        if (structurenumber.contains(".forkResult.") && expArr.length > 2 && expArr[2].contains("$")) {
            nodeId = expArr[2].split("\\$")[0];
        }
        int i = 0;
        while (i < expArr.length) {
            String expression = expArr[i];
            this.getModel().setValue(COMBOFIELD + i, (Object)expression);
            ExpressionProperty currentProp = this.getCurrentPropFromCacheByNumber(expression, COMBOFIELD + i);
            if (currentProp == null) break;
            this.setViewWindowValAndCacheCurrentProp(currentProp);
            List props = ExpressionPropUtils.getNextProps((ExpressionProperty)currentProp, (AbstractFormPlugin)this, (String)nodeId);
            if (props != null && !props.isEmpty()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{ICONAP + i});
                if (++i >= 8) continue;
                this.showNextCombo(COMBOFIELD + i, props);
                continue;
            }
            ++i;
        }
        return i;
    }

    private List<ComboItem> getItems(List<ExpressionProperty> props) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(props.size());
        for (IExpressionProperty iExpressionProperty : props) {
            ComboItem i = new ComboItem();
            i.setValue(iExpressionProperty.getNumber());
            i.setCaption(new LocaleString(iExpressionProperty.getName()));
            items.add(i);
        }
        return items;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (propertyName.contains(COMBOFIELD)) {
            String value = this.getModel().getValue(propertyName).toString();
            ExpressionProperty currentProp = null;
            if (WfUtils.isEmpty((String)value)) {
                int level = Integer.parseInt(propertyName.split(COMBOFIELD)[1]);
                this.getView().setVisible(Boolean.FALSE, new String[]{ICONAP + level});
                this.removePropsInCacheAndHideCtl(++level);
                if ((level -= 2) > -1) {
                    value = this.getModel().getValue(COMBOFIELD + level).toString();
                    currentProp = this.getCurrentPropFromCacheByNumber(value, COMBOFIELD + level);
                    if (currentProp != null) {
                        this.setViewWindowValAndCacheCurrentProp(currentProp);
                    }
                } else {
                    this.getPageCache().remove(CURRENTPROP);
                    this.getModel().setValue(SUBJECT, (Object)"", 0);
                    this.getModel().setValue(SHOW_EXPRESSION, (Object)"", 0);
                }
            } else {
                String nodeId = (String)this.getView().getFormShowParameter().getCustomParam("nodeId");
                currentProp = this.getCurrentPropFromCacheByNumber(value, propertyName);
                if (currentProp != null) {
                    this.setViewWindowValAndCacheCurrentProp(currentProp);
                }
                List<ExpressionProperty> props = new ArrayList();
                try {
                    props = ExpressionPropUtils.getNextProps((ExpressionProperty)currentProp, (AbstractFormPlugin)this, (String)nodeId);
                }
                catch (Exception exce) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6839\u636e\u4e8b\u4ef6\u53c2\u6570\u83b7\u53d6expression\u8868\u8fbe\u5f0f\u5c5e\u6027\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WfValExpressionPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]), exce.getLocalizedMessage()));
                }
                int level = Integer.parseInt(propertyName.split(COMBOFIELD)[1]);
                this.getView().setVisible(Boolean.FALSE, new String[]{ICONAP + level});
                this.removePropsInCacheAndHideCtl(++level);
                if (props != null && !props.isEmpty() && level < 8) {
                    int i = level - 1;
                    this.getView().setVisible(Boolean.TRUE, new String[]{ICONAP + i});
                    this.showNextCombo(COMBOFIELD + level, props);
                }
            }
            this.removeFuncNumsCache();
        }
    }

    private void showNextCombo(String comnoName, List<ExpressionProperty> props) {
        ComboEdit nextComboEdit = (ComboEdit)this.getControl(comnoName);
        nextComboEdit.setComboItems(this.getItems(props));
        this.getPageCache().put(comnoName, SerializationUtils.toJsonString(props, (boolean)false));
        this.getView().setVisible(Boolean.TRUE, new String[]{comnoName});
    }

    private void removePropsInCacheAndHideCtl(int level) {
        IPageCache pageCache = this.getPageCache();
        for (int i = level; i < 9; ++i) {
            if (!WfUtils.isNotEmpty((String)pageCache.get(COMBOFIELD + i))) continue;
            this.getModel().setValue(COMBOFIELD + i, (Object)"");
            this.getView().setVisible(Boolean.FALSE, new String[]{COMBOFIELD + i});
            this.getView().setVisible(Boolean.FALSE, new String[]{ICONAP + i});
            pageCache.remove(COMBOFIELD + i);
        }
    }

    private ExpressionProperty getCurrentPropFromCacheByNumber(String number, String controlName) {
        String currentpropListJson = this.getPageCache().get(controlName);
        if (WfUtils.isNotEmpty((String)currentpropListJson)) {
            List props = SerializationUtils.fromJsonStringToList((String)currentpropListJson, ExpressionProperty.class);
            for (ExpressionProperty p : props) {
                if (!number.equalsIgnoreCase(p.getNumber())) continue;
                return p;
            }
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if (BTN_SETFUNCTION.equals(actionId)) {
            this.funcConfigCallBack(returnData);
        }
    }

    private void funcConfigCallBack(Object returnData) {
        String funcNumStackStr = (String)returnData;
        Stack funcNumStack = StringUtils.isNotEmpty((CharSequence)funcNumStackStr) ? (Stack)SerializationUtils.fromJsonString((String)funcNumStackStr, Stack.class) : new Stack();
        this.getPageCache().put(CACHE_STACK_FUNCNUMBERS, funcNumStackStr);
        this.updateExpViewWin(funcNumStack);
    }
}

