/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.rule.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.CompareTypeDto;

public class CompareTypesForTCUtils {
    public static final String STRINGTYPE = "0";
    public static final String NUMBERTYPE = "1";
    public static final String DATETIMETYPE = "2";
    public static final String BOOLEANTYPE = "3";
    public static final String ENUMTYPE = "9";
    public static final String BASEDATATYPE = "14";
    public static final String USERTYPE = "15";
    public static final String ORGTYPE = "16";
    public static final String EQUAL = "==";
    public static final String NOTEQUAL = "!=";
    public static final String LT = "<";
    public static final String GT = ">";
    public static final String GTEQUAL = ">=";
    public static final String LTEQUAL = "<=";
    public static final String LK = "LK";
    public static final String ISTRUE = "ISTRUE";
    public static final String ISFALSE = "ISFALSE";
    public static final String EMPTY = "empty";
    public static final String NOTEMPTY = "!empty";
    public static final String BS = "BS";
    public static final String BO = "BO";
    public static final String CS = "CS";
    public static final String BR = "BR";
    public static final String NR = "NR";
    public static final String CBELONG = "IN";
    public static final String CNOTBELONG = "NI";
    public static final String NL = "NL";
    private HashMap<String, List<CompareTypeDto>> compareTypeMap = new HashMap();
    private static Map<String, CompareTypesForTCUtils> instanceMap = new HashMap<String, CompareTypesForTCUtils>();

    private CompareTypesForTCUtils() {
        this.createCompareTypeDtoMap();
    }

    public static CompareTypesForTCUtils get() {
        String lang = RequestContext.get().getLang().toString();
        CompareTypesForTCUtils instance = instanceMap.get(lang);
        if (instance == null) {
            instance = new CompareTypesForTCUtils();
            instanceMap.put(lang, instance);
        }
        return instance;
    }

    private void createCompareTypeDtoMap() {
        CompareTypeDto equalsDto = new CompareTypeDto(EQUAL, new LocaleString(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"CompareTypesForTCUtils_1", (String)"bos-wf-formplugin", (Object[])new Object[0])), true, "", 0, 0, false, false, false, false);
        CompareTypeDto notEqualsDto = new CompareTypeDto(NOTEQUAL, new LocaleString(ResManager.loadKDString((String)"\u4e0d\u7b49\u4e8e", (String)"CompareTypesForTCUtils_2", (String)"bos-wf-formplugin", (Object[])new Object[0])), true, "", 0, 0, false, false, false, false);
        CompareTypeDto ltDto = new CompareTypeDto(LT, new LocaleString(ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"CompareTypesForTCUtils_3", (String)"bos-wf-formplugin", (Object[])new Object[0])), true, "", 0, 0, false, false, false, false);
        CompareTypeDto gtDto = new CompareTypeDto(GT, new LocaleString(ResManager.loadKDString((String)"\u5927\u4e8e", (String)"CompareTypesForTCUtils_4", (String)"bos-wf-formplugin", (Object[])new Object[0])), true, "", 0, 0, false, false, false, false);
        CompareTypeDto gtEqualsDto = new CompareTypeDto(GTEQUAL, new LocaleString(ResManager.loadKDString((String)"\u5927\u4e8e\u7b49\u4e8e", (String)"CompareTypesForTCUtils_5", (String)"bos-wf-formplugin", (Object[])new Object[0])), true, "", 0, 0, false, false, false, false);
        CompareTypeDto ltEqualsDto = new CompareTypeDto(LTEQUAL, new LocaleString(ResManager.loadKDString((String)"\u5c0f\u4e8e\u7b49\u4e8e", (String)"CompareTypesForTCUtils_6", (String)"bos-wf-formplugin", (Object[])new Object[0])), true, "", 0, 0, false, false, false, false);
        CompareTypeDto containsDto = new CompareTypeDto(LK, new LocaleString(ResManager.loadKDString((String)"\u5305\u542b", (String)"CompareTypesForTCUtils_7", (String)"bos-wf-formplugin", (Object[])new Object[0])), true, "", 0, 0, false, false, false, false);
        CompareTypeDto emptyDto = new CompareTypeDto(EMPTY, new LocaleString(ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"CompareTypesForTCUtils_9", (String)"bos-wf-formplugin", (Object[])new Object[0])), false, "", 0, 0, false, false, false, false);
        CompareTypeDto notEmptyDto = new CompareTypeDto(NOTEMPTY, new LocaleString(ResManager.loadKDString((String)"\u4e0d\u4e3a\u7a7a", (String)"CompareTypesForTCUtils_10", (String)"bos-wf-formplugin", (Object[])new Object[0])), false, "", 0, 0, false, false, false, false);
        CompareTypeDto belongOrgDto = new CompareTypeDto(BO, new LocaleString(ResManager.loadKDString((String)"\u5c5e\u4e8e\u7ec4\u7ec7", (String)"CompareTypesForTCUtils_11", (String)"bos-wf-formplugin", (Object[])new Object[0])), true, "", 0, 10002, false, false, false, false);
        CompareTypeDto belongWfRoleDto = new CompareTypeDto(BR, new LocaleString(ResManager.loadKDString((String)"\u5c5e\u4e8e\u5de5\u4f5c\u6d41\u89d2\u8272", (String)"CompareTypesForTCUtils_12", (String)"bos-wf-formplugin", (Object[])new Object[0])), true, "", 0, 10003, false, false, false, false);
        CompareTypeDto notBelongWfRoleDto = new CompareTypeDto(NR, new LocaleString(ResManager.loadKDString((String)"\u4e0d\u5c5e\u4e8e\u5de5\u4f5c\u6d41\u89d2\u8272", (String)"CompareTypesForTCUtils_18", (String)"bos-wf-formplugin", (Object[])new Object[0])), true, "", 0, 10003, false, false, false, false);
        CompareTypeDto belongCollectionDto = new CompareTypeDto(CBELONG, new LocaleString(ResManager.loadKDString((String)"\u5c5e\u4e8e\u96c6\u5408", (String)"CompareTypesForTCUtils_15", (String)"bos-wf-formplugin", (Object[])new Object[0])), true, "", 0, 0, false, true, false, false);
        CompareTypeDto notBelongCollectionDto = new CompareTypeDto(CNOTBELONG, new LocaleString(ResManager.loadKDString((String)"\u4e0d\u5c5e\u4e8e\u96c6\u5408", (String)"CompareTypesForTCUtils_16", (String)"bos-wf-formplugin", (Object[])new Object[0])), true, "", 0, 0, false, true, false, false);
        CompareTypeDto notContainsDto = new CompareTypeDto(NL, new LocaleString(ResManager.loadKDString((String)"\u4e0d\u5305\u542b", (String)"CompareTypesForTCUtils_17", (String)"bos-wf-formplugin", (Object[])new Object[0])), true, "", 0, 0, false, false, false, false);
        ArrayList<CompareTypeDto> commonCompareTypes = new ArrayList<CompareTypeDto>();
        commonCompareTypes.add(equalsDto);
        commonCompareTypes.add(notEqualsDto);
        commonCompareTypes.add(gtDto);
        commonCompareTypes.add(ltDto);
        commonCompareTypes.add(gtEqualsDto);
        commonCompareTypes.add(ltEqualsDto);
        commonCompareTypes.add(emptyDto);
        commonCompareTypes.add(notEmptyDto);
        this.compareTypeMap.put(NUMBERTYPE, commonCompareTypes);
        ArrayList<CompareTypeDto> dateCompareTypes = new ArrayList<CompareTypeDto>();
        dateCompareTypes.addAll(commonCompareTypes);
        this.compareTypeMap.put(DATETIMETYPE, dateCompareTypes);
        ArrayList<CompareTypeDto> strCompareTypes = new ArrayList<CompareTypeDto>();
        strCompareTypes.addAll(commonCompareTypes);
        strCompareTypes.add(containsDto);
        strCompareTypes.add(notContainsDto);
        strCompareTypes.add(belongCollectionDto);
        strCompareTypes.add(notBelongCollectionDto);
        this.compareTypeMap.put(STRINGTYPE, strCompareTypes);
        ArrayList<CompareTypeDto> baseDataCompareTypes = new ArrayList<CompareTypeDto>();
        baseDataCompareTypes.add(equalsDto);
        baseDataCompareTypes.add(notEqualsDto);
        baseDataCompareTypes.add(emptyDto);
        baseDataCompareTypes.add(notEmptyDto);
        baseDataCompareTypes.add(belongCollectionDto);
        baseDataCompareTypes.add(notBelongCollectionDto);
        this.compareTypeMap.put(BASEDATATYPE, baseDataCompareTypes);
        ArrayList<CompareTypeDto> booleanCompareTypes = new ArrayList<CompareTypeDto>();
        booleanCompareTypes.add(equalsDto);
        booleanCompareTypes.add(notEqualsDto);
        this.compareTypeMap.put(BOOLEANTYPE, booleanCompareTypes);
        ArrayList<CompareTypeDto> userCompareTypes = new ArrayList<CompareTypeDto>();
        userCompareTypes.addAll(baseDataCompareTypes);
        userCompareTypes.add(belongOrgDto);
        userCompareTypes.add(belongWfRoleDto);
        userCompareTypes.add(notBelongWfRoleDto);
        this.compareTypeMap.put(USERTYPE, userCompareTypes);
        ArrayList<CompareTypeDto> orgCompareTypes = new ArrayList<CompareTypeDto>();
        orgCompareTypes.addAll(baseDataCompareTypes);
        this.compareTypeMap.put(ORGTYPE, orgCompareTypes);
        ArrayList<CompareTypeDto> enumCompareTypes = new ArrayList<CompareTypeDto>();
        enumCompareTypes.add(equalsDto);
        enumCompareTypes.add(notEqualsDto);
        this.compareTypeMap.put(ENUMTYPE, enumCompareTypes);
    }

    public List<CompareTypeDto> getCompareTypesById(String id) {
        if (this.compareTypeMap.get(id) == null) {
            return this.compareTypeMap.get(ENUMTYPE);
        }
        return this.compareTypeMap.get(id);
    }
}

