/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.rule.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterOperationMetaEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterOperationMetaEntityImpl;

public class ConditionConvertUtils {
    private static final String NUMBER = "number";
    private static final String VALUE = "value";
    private static final String COMPARE_TYPE = "compareType";
    private static final String FIELD_NAME = "fieldName";
    private static final String PERSONIDS = "personIds";
    private static final Log log = LogFactory.getLog(ConditionConvertUtils.class);

    public static List<Map<String, Object>> getConditionItems(List<ConditionalEntity> conditionals) {
        ArrayList<Map<String, Object>> conditionItems = new ArrayList<Map<String, Object>>(conditionals.size());
        for (ConditionalEntity entity : conditionals) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put(FIELD_NAME, entity.getParamnumber());
            item.put(COMPARE_TYPE, entity.getOperation());
            String value = entity.getValue();
            item.put(VALUE, SerializationUtils.fromJsonString((String)value, Map.class));
            conditionItems.add(item);
        }
        return conditionItems;
    }

    public static List<Map<String, Object>> getOperationItems(List<TaskCenterOperationMetaEntity> operationMetas) {
        ArrayList<Map<String, Object>> operationItems = new ArrayList<Map<String, Object>>(operationMetas.size());
        for (TaskCenterOperationMetaEntity entity : operationMetas) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("id", entity.getId());
            item.put(FIELD_NAME, entity.getOperationkey());
            item.put(COMPARE_TYPE, "");
            String value = entity.getOperateparams();
            Map ruleValue = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            Object personObj = ruleValue.get(PERSONIDS);
            if (personObj instanceof List) {
                List persons = (List)personObj;
                ConditionConvertUtils.replaceUsersName(persons);
                ruleValue.put(PERSONIDS, persons);
            }
            item.put(VALUE, ruleValue);
            operationItems.add(item);
        }
        return operationItems;
    }

    public static ConditionalRuleEntity getConditionalRule(List<Map<String, Object>> conditionItems, ConditionalRuleEntity conditionRuleModel) {
        if (conditionItems == null) {
            return null;
        }
        if (conditionRuleModel == null) {
            conditionRuleModel = new ConditionalRuleEntityImpl();
        }
        ArrayList<ConditionalEntityImpl> conditionals = new ArrayList<ConditionalEntityImpl>(conditionItems.size());
        for (Map<String, Object> item : conditionItems) {
            ConditionalEntityImpl conditional = new ConditionalEntityImpl();
            String value = SerializationUtils.toJsonString((Object)item.get(VALUE), (boolean)true);
            conditional.setParamnumber((String)item.get(FIELD_NAME));
            conditional.setValue(value);
            conditional.setOperation((String)item.get(COMPARE_TYPE));
            conditional.setConditionalRuleId(conditionRuleModel.getId());
            conditionals.add(conditional);
        }
        conditionRuleModel.setEntryentity(conditionals);
        return conditionRuleModel;
    }

    public static List<TaskCenterOperationMetaEntity> getTaskCenterOperationMetas(List<Map<String, Object>> operationItems) {
        if (operationItems == null) {
            return null;
        }
        ArrayList<TaskCenterOperationMetaEntity> TaskCenterOperationMetaEntitys = new ArrayList<TaskCenterOperationMetaEntity>(operationItems.size());
        for (Map<String, Object> item : operationItems) {
            TaskCenterOperationMetaEntityImpl operationMeta = new TaskCenterOperationMetaEntityImpl();
            operationMeta.setId((String)item.get("id"));
            operationMeta.setOperationkey((String)item.get(FIELD_NAME));
            operationMeta.setOperateparams(SerializationUtils.toJsonString((Object)item.get(VALUE), (boolean)true));
            TaskCenterOperationMetaEntitys.add((TaskCenterOperationMetaEntity)operationMeta);
        }
        return TaskCenterOperationMetaEntitys;
    }

    public static String getExpressionFromConditional(List<ConditionalEntity> conditionals) {
        StringBuilder expression = new StringBuilder("{");
        for (ConditionalEntity conditional : conditionals) {
            String number = conditional.getParamnumber();
            String logic = conditional.getLogic();
            String value = conditional.getValue();
            Map vMap = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            Object valueObj = vMap.get(number);
            String expressionValue = "";
            if (valueObj instanceof List) {
                List valList = (List)valueObj;
                if (valList.size() > 0) {
                    expressionValue = expressionValue + ((Map)valList.get(0)).get(VALUE) + "";
                }
            } else {
                expressionValue = valueObj + "";
            }
            logic = "1".equals(logic) ? "||" : "&&";
            String operation = conditional.getOperation();
            expression.append(number).append(operation).append(expressionValue).append(logic);
        }
        String expressionStr = expression.substring(0, expression.length() - 1) + "}";
        return expressionStr;
    }

    public static String getExpressionFromMap(List<Map<String, Object>> conditionItems) {
        if (conditionItems == null || conditionItems.size() < 1) {
            return "";
        }
        String entityNumber = "";
        for (Map<String, Object> entity : conditionItems) {
            List valueList;
            Map value = (Map)entity.get(VALUE);
            Object obj = value.get("task.entityNumber");
            if (!(obj instanceof List) || (valueList = (List)obj) == null || valueList.size() <= 0) continue;
            entityNumber = (String)((Map)valueList.get(0)).get(NUMBER);
            break;
        }
        List filterFields = null;
        if (WfUtils.isNotEmpty((String)entityNumber)) {
            EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
            try {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
            }
            catch (Exception e) {
                log.error(WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        StringBuilder expression = new StringBuilder("${");
        for (Map<String, Object> conditionItem : conditionItems) {
            String type;
            String number = (String)conditionItem.get(FIELD_NAME);
            String logic = (String)conditionItem.get("logic");
            String operation = (String)conditionItem.get(COMPARE_TYPE);
            logic = "1".equals(logic) ? " || " : " && ";
            Object valueObj = ((Map)conditionItem.get(VALUE)).get(number);
            StringBuilder expressionValue = new StringBuilder();
            if (valueObj instanceof List) {
                List valList = (List)valueObj;
                if (valList.size() > 0) {
                    if ("task.entityNumber".equals(number)) {
                        for (int i = 0; i < valList.size(); ++i) {
                            if (i == valList.size() - 1) {
                                expressionValue.append(((Map)valList.get(i)).get(NUMBER));
                                continue;
                            }
                            expressionValue.append(((Map)valList.get(i)).get(NUMBER)).append(',');
                        }
                    } else {
                        for (int i = 0; i < valList.size(); ++i) {
                            if (i == valList.size() - 1) {
                                expressionValue.append(((Map)valList.get(i)).get(VALUE));
                                continue;
                            }
                            expressionValue.append(((Map)valList.get(i)).get(VALUE)).append(',');
                        }
                    }
                }
            } else {
                expressionValue.append(valueObj);
            }
            char blank = ' ';
            if (operation.contains("empty")) {
                expression.append(operation).append(blank).append(number).append(logic);
                continue;
            }
            String string = type = filterFields == null ? "text" : ConditionConvertUtils.getConditionType(number, filterFields);
            if (WfUtils.isNotEmpty((String)type) && type.equals(NUMBER)) {
                expression.append(number).append(blank).append(operation).append(blank).append((CharSequence)expressionValue).append(logic);
                continue;
            }
            expression.append(number).append(blank).append(operation).append(blank).append('\"').append((CharSequence)expressionValue).append('\"').append(logic);
        }
        String expressionStr = expression.substring(0, expression.length() - 4) + "}";
        return expressionStr;
    }

    public static String getConditionType(String fieldName, List<FilterField> filterFields) {
        String type = "";
        for (FilterField filterField : filterFields) {
            String name = filterField.getFieldName();
            if (!fieldName.contains(name)) continue;
            int typeNum = filterField.getFieldType();
            if (typeNum == -6 || typeNum == 5 || typeNum == 4 || typeNum == -5 || typeNum == 8 || typeNum == 6 || typeNum == 3 || typeNum == 2) {
                type = NUMBER;
                break;
            }
            type = filterField.getFilterControlType();
            break;
        }
        return type;
    }

    private static void replaceUsersName(List<Map<String, Object>> persons) {
        ArrayList<Long> userIds = new ArrayList<Long>(persons.size());
        for (int j = 0; j < persons.size(); ++j) {
            Map<String, Object> person = persons.get(j);
            userIds.add(Long.valueOf((String)person.get(VALUE)));
            person.put("alias", WfUtils.getUsersName(userIds));
            userIds.clear();
        }
    }
}

