/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.taskmodel;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.base.MobileBaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.IFrame;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.AgentTaskHandleContext;
import kd.bos.workflow.engine.impl.cmd.task.TashHandleParam;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.management.plugin.ApprovalPageTpl;
import kd.bos.workflow.task.TaskModelExternalService;
import kd.bos.workflow.task.utils.TaskModelUtils;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForApprovalCustomEvent;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForHandledCustomEvent;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class TaskHandlePagePlugin
extends ApprovalPageTpl
implements RowClickEventListener {
    private Log logger = LogFactory.getLog(TaskHandlePagePlugin.class);
    private static final String PANEL_TOOLBAR = "toolbarpanel";
    private static String PANEL_BILLSHOWPAGE = "billpageshowpanel";
    private static String FRAME_BILLSHOWPAGE = "billpageshowframe";
    private static String AP_TOOLBAR = "toolbarap";
    private static String BTN_AGREE = "btn_agree";
    private static String BTN_NOTAGREE = "btn_notagree";
    private static String BTN_EXIT = "btn_exit";
    private static String LAB_NOBILLPAGE = "noshowbillpage";
    protected static final String TASKCATEGORY = "taskCategory";
    protected static final String ISBILLEXIST = "isBillExist";
    protected static final String ASSIGNEE = "assigneeid";
    protected static final String ISPCSHOW = "isPCShow";
    protected static final String FROMHISTORY = "fromHistory";
    protected static final String TASKTYPE = "tasktype";
    protected static final String NUMBER = "number";
    protected static final String TASKSUBMITOPERATION = "validateOperation";
    protected static final String AUDITTYPE = "auditType";
    protected static final String CALLBACK_WITHDRAW = "callBack_withdraw";
    protected static final String CALLBACK_CLOSEHANDLEPAGE = "closeHandlePageCallBack";
    protected AgentTaskHandleContext agentTaskHandleContext = null;

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{AP_TOOLBAR});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        this.setPreOpenForm(e, Boolean.TRUE);
    }

    public void setPreOpenForm(PreOpenFormEventArgs args, Boolean isPCShow) {
        FormShowParameter parameter = (FormShowParameter)args.getSource();
        Map customParams = parameter.getCustomParams();
        customParams.put("bizTask", true);
        ILocaleString captain = this.getCaptainForInitial(customParams, isPCShow);
        if (captain != null && !WfUtils.isEmpty((String)captain.getLocaleValue())) {
            parameter.setCaption(captain.getLocaleValue());
        }
        if (parameter.getAppId() == null) {
            parameter.setAppId("wf");
        }
    }

    public void afterCreateNewData(EventObject e) {
        try {
            if (this.getTaskDataInfo()) {
                return;
            }
            this.initApprovaPageControl();
            this.loadBizBillPage();
            this.initBizExtraPlugins();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (!customParams.isEmpty()) {
                Long taskId = 0L;
                if (!WfUtils.isNullObject(customParams.get("taskId"))) {
                    taskId = customParams.get("taskId") instanceof Long ? (Long)customParams.get("taskId") : Long.parseLong((String)customParams.get("taskId"));
                } else if (!WfUtils.isNullObject(customParams.get("tId"))) {
                    taskId = customParams.get("tId") instanceof Long ? (Long)customParams.get("tId") : Long.parseLong((String)customParams.get("tId"));
                }
                String apptype = ApprovalPluginUtil.getApptype(customParams.get("apptype"));
                ApprovalPluginUtil.callRecordReadTime(taskId, customParams.get("msgId"), apptype);
            }
        }
        catch (Exception e1) {
            StringBuilder errorMessage = new StringBuilder().append(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"TaskHandlePagePlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            errorMessage.append(e1.getMessage());
            this.logger.info(WfUtils.getExceptionStacktrace((Throwable)e1));
            this.getView().showTipNotification(errorMessage.toString());
        }
    }

    @Override
    public void afterCreatNewDataForApprovalCustomEvent(AfterCreatNewDataForApprovalCustomEvent e) {
    }

    public void initBizExtraPlugins() {
        String taskType = this.agentTaskHandleContext.getType();
        if (WfUtils.isEmpty((String)taskType)) {
            taskType = (String)this.getView().getFormShowParameter().getCustomParam("type");
        }
        if ("handled".equals(taskType) || !this.canDoOperation("wf_participant", false)) {
            this.initBizExtraPluginsForHandled();
        } else {
            this.initBizExtraPluginsForToHandle();
        }
    }

    public void initBizExtraPluginsForToHandle() {
        AfterCreatNewDataForApprovalCustomEvent args = new AfterCreatNewDataForApprovalCustomEvent(this.getView(), "keyForAfterCreatNewData", "afterCreatNewDataForApprovalCustomEvent", null, this.agentTaskHandleContext, null, null);
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent((CustomEventArgs)args);
    }

    public void initBizExtraPluginsForHandled() {
        AfterCreatNewDataForHandledCustomEvent args = new AfterCreatNewDataForHandledCustomEvent(this.getView(), "keyForHandledAfterCreatNewData", "afterCreatNewDataForHandledCustomEvent", null, this.agentTaskHandleContext, null);
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent((CustomEventArgs)args);
    }

    public void loadBizBillPage() {
        String taskType = this.agentTaskHandleContext.getType();
        if (WfUtils.isEmpty((String)taskType)) {
            taskType = (String)this.getView().getFormShowParameter().getCustomParam("type");
        }
        if ("handled".equals(taskType) || !this.canDoOperation("wf_participant", false)) {
            this.loadHandledPage();
        } else {
            this.loadTohandlePage();
        }
    }

    public void loadHandledPage() {
        this.getView().setStatus(OperationStatus.VIEW);
        this.loadBillPage();
    }

    public void loadTohandlePage() {
        this.loadBillPage();
    }

    private String getHeterosystemDealTaskUrl(TaskInfo taskInfo) {
        return TaskModelExternalService.create().getFormServiceLink(taskInfo, true);
    }

    private void loadBillPage() {
        try {
            TaskInfo taskInfo = this.agentTaskHandleContext.getTask();
            if (TaskModelUtils.isOuterSystemTask((TaskInfo)taskInfo)) {
                String heterosystemUrl = this.getHeterosystemDealTaskUrl(taskInfo);
                if (WfUtils.isNotEmpty((String)heterosystemUrl)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{FRAME_BILLSHOWPAGE});
                    IFrame iframe = (IFrame)this.getView().getControl(FRAME_BILLSHOWPAGE);
                    iframe.setSrc(heterosystemUrl);
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{LAB_NOBILLPAGE});
                }
            } else {
                Boolean isBillExist = this.agentTaskHandleContext == null ? Boolean.FALSE : this.agentTaskHandleContext.getBillExist();
                String formkey = this.getPageCache().get("formKey");
                Boolean isPCShow = this.agentTaskHandleContext.getPcShow();
                if (isBillExist.booleanValue() && WfUtils.isNotEmpty((String)formkey) && ApprovalPluginUtil.isExistForFormId(formkey)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_BILLSHOWPAGE});
                    String entitynumber = taskInfo.getEntityNumber();
                    String businesskey = taskInfo.getBusinessKey();
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entitynumber);
                    if (entityType instanceof BillEntityType) {
                        BillShowParameter formShowParameter = this.getBillShowParameter(isPCShow, businesskey, formkey, entitynumber);
                        this.showForm((FormShowParameter)formShowParameter);
                    }
                } else if (isPCShow.booleanValue()) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{LAB_NOBILLPAGE});
                }
            }
        }
        catch (Exception e) {
            StringBuilder errorMessage = new StringBuilder().append(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4e1a\u52a1\u5355\u636e\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"TaskHandlePagePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            errorMessage.append(e.getMessage());
            this.logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showTipNotification(errorMessage.toString());
        }
    }

    public BillShowParameter getBillShowParameter(Boolean isPCShow, String businesskey, String formkey, String entitynumber) {
        String billStatus;
        Object billShowParameter = null;
        QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "=", (Object)entitynumber)};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"modeltype", (QFilter[])filters);
        String modelType = dynamicObject.getString("modeltype");
        billShowParameter = isPCShow.booleanValue() ? ("BaseFormModel".equals(modelType) ? new BaseShowParameter() : new BillShowParameter()) : ("BaseFormModel".equals(modelType) ? new MobileBaseShowParameter() : new MobileBillShowParameter());
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("billStatus") && "view".equals(billStatus = (String)customParams.get("billStatus"))) {
            billShowParameter.setBillStatus(BillOperationStatus.VIEW);
            billShowParameter.setStatus(OperationStatus.VIEW);
        }
        if (WfUtils.isNotEmpty((String)businesskey)) {
            billShowParameter.setPkId(WfUtils.getBusinessKeyFromEntityType((String)businesskey, (String)entitynumber));
        }
        billShowParameter.setFormId(formkey);
        billShowParameter.getCustomParams().put("ServiceAppId", WfUtils.getAppIdForEntity((String)entitynumber));
        String billPageId = ApprovalPluginUtil.getBillPageId();
        billShowParameter.setPageId(billPageId);
        billShowParameter.getOpenStyle().setTargetKey(PANEL_BILLSHOWPAGE);
        billShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        billShowParameter.setCustomParams(customParams);
        billShowParameter.setCustomParam("formKey", (Object)formkey);
        billShowParameter.setCustomParam("businesskey", (Object)businesskey);
        billShowParameter.setCustomParam("onlyView", (Object)(this.agentTaskHandleContext.getBillView() != false || this.agentTaskHandleContext.isFromHistory() != false ? 1 : 0));
        billShowParameter.setCustomParam("pcShow", (Object)isPCShow);
        billShowParameter.setCustomParam("taskId", (Object)this.agentTaskHandleContext.getTaskId());
        this.getPageCache().put("billPageId", billPageId);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_CLOSEHANDLEPAGE));
        return billShowParameter;
    }

    public void initApprovaPageControl() {
        String taskType = this.agentTaskHandleContext.getType();
        if ("handled".equals(taskType) || !this.canDoOperation("wf_participant", false)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{AP_TOOLBAR});
        }
    }

    private boolean getTaskDataInfo() {
        boolean disContinue = Boolean.FALSE;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        TashHandleParam param = super.getTaskHandleParam(customParams);
        this.agentTaskHandleContext = super.getTaskInfo(param);
        boolean isTaskExist = this.agentTaskHandleContext.getTaskExist();
        TaskInfo taskInfo = this.agentTaskHandleContext.getTask();
        if (!isTaskExist || taskInfo == null) {
            this.getView().showConfirm(ApprovalPluginUtil.getTaskNotExistInfo(this.agentTaskHandleContext.getTaskNotExistReason()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_WITHDRAW));
            this.getView().setVisible(Boolean.FALSE, new String[]{AP_TOOLBAR});
            disContinue = Boolean.TRUE;
            return disContinue;
        }
        this.getFlowElement(taskInfo.getTaskDefinitionKey());
        this.setPageCacheForTaskData(customParams, taskInfo);
        return disContinue;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId != null && CALLBACK_WITHDRAW.equals(callBackId)) {
            super.showClosePage(null);
        }
    }

    private FlowElement getFlowElement(String taskDefinitionKey) {
        return null;
    }

    public void setPageCacheForTaskData(Map<String, Object> customParams, TaskInfo taskInfo) {
        Map<String, String> taskDataMap = this.putTaskDataIntoPageCache(taskInfo);
        this.getPageCache().put(taskDataMap);
    }

    private Map<String, String> putTaskDataIntoPageCache(TaskInfo taskInfo) {
        Long assigneeId;
        HashMap<String, String> taskDataMap = new HashMap<String, String>(25);
        taskDataMap.put("taskId", String.valueOf(taskInfo.getId()));
        taskDataMap.put(TASKCATEGORY, taskInfo.getCategory());
        taskDataMap.put("entityNumber", taskInfo.getEntityNumber());
        taskDataMap.put("businesskey", taskInfo.getBusinessKey());
        taskDataMap.put("BILLNO", taskInfo.getBillNo());
        taskDataMap.put("taskDefinitionKey", taskInfo.getTaskDefinitionKey());
        taskDataMap.put("formKey", taskInfo.getFormKey());
        taskDataMap.put("billView", this.agentTaskHandleContext.getBillView().toString());
        List<DecisionOption> decisionOptionList = this.getDecisionOptions(null);
        taskDataMap.put("decisionOptionList", SerializationUtils.toJsonString(decisionOptionList));
        taskDataMap.put("is_taskcoordinate", String.valueOf(this.agentTaskHandleContext.getTaskCoordinate()));
        taskDataMap.put(ISBILLEXIST, String.valueOf(this.agentTaskHandleContext.getBillExist()));
        taskDataMap.put("subject", WfUtils.isNotEmpty((String)taskInfo.getSubject().getLocaleValue()) ? taskInfo.getSubject().getLocaleValue() : "");
        taskDataMap.put(TASKSUBMITOPERATION, WfUtils.isNotEmpty((String)taskInfo.getValidateOperation()) ? taskInfo.getValidateOperation() : "");
        taskDataMap.put("SUSPENSIONSTATE", taskInfo.getSuspensionState());
        if (taskInfo instanceof HistoricTaskInstanceEntity && WfUtils.isNotEmpty((Long)(assigneeId = ((HistoricTaskInstanceEntity)taskInfo).getAssigneeId()))) {
            taskDataMap.put(ASSIGNEE, assigneeId.toString());
        }
        if (WfUtils.isNotEmpty((String)this.agentTaskHandleContext.getFormKey())) {
            taskDataMap.put("formKey", this.agentTaskHandleContext.getFormKey());
        }
        if (WfUtils.isNotEmpty((String)this.agentTaskHandleContext.getMobileFormKey())) {
            taskDataMap.put("mobileFormKey", this.agentTaskHandleContext.getMobileFormKey());
        }
        Boolean isPCShow = this.agentTaskHandleContext.getPcShow();
        taskDataMap.put(ISPCSHOW, isPCShow.toString());
        taskDataMap.put(FROMHISTORY, String.valueOf(this.agentTaskHandleContext.isFromHistory()));
        taskDataMap.put(TASKTYPE, this.agentTaskHandleContext.getType());
        taskDataMap.put("onlyView", String.valueOf(this.agentTaskHandleContext.getOnlyView()));
        String taskSource = "";
        if (taskInfo instanceof TaskEntityImpl) {
            taskSource = ((TaskEntity)taskInfo).getSource();
        } else if (taskInfo instanceof HistoricTaskInstanceEntityImpl) {
            taskSource = ((HistoricTaskInstanceEntity)taskInfo).getSource();
        }
        taskDataMap.put("taskSource", taskSource);
        return taskDataMap;
    }

    public void itemClick(ItemClickEvent evt) {
        ListSelectedRowCollection rows = ((ListView)this.getView()).getSelectedRows();
        evt.getItemKey().getClass();
    }

    @Override
    public String getApprovalPageId() {
        return null;
    }

    @Override
    public String getBillPageId() {
        return null;
    }

    @Override
    public boolean isPCShow() {
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "closeHandlePageCallBack": {
                super.showClosePage("");
                break;
            }
        }
    }

    @Override
    public void customEvent(CustomEventArgs e) {
    }
}

