/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.udlayout;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.model.AuditComment;
import kd.bos.workflow.bpmn.model.AuditCommentModel;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.management.plugin.ApprovalPageTpl;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForApprovalCustomEvent;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForCoordinateCustomEvent;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class AbstractCommonApprovalOpinionsPlugin
extends ApprovalPageTpl
implements TipsListener {
    protected static final String COMMONAUDITCOMMENT = "commonauditcomment";
    protected static final String MSG_APPROVAL = "msg_approval";
    private static final String AUDITCOMMENTWHENMATCH = "auditCommentWhenMatch";

    @Override
    public void afterCreatNewDataForApprovalCustomEvent(AfterCreatNewDataForApprovalCustomEvent e) {
        List<DecisionOption> decisionList = e.getDecisionOptionList();
        if (decisionList == null || decisionList.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5e38\u7528\u5ba1\u6279\u610f\u89c1\u65e0\u5339\u914d\u7684\u51b3\u7b56\u9879\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractCommonApprovalOpinionsPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        FlowElement flowElement = e.getFlowElement();
        DecisionOption defaultDecisionOption = new DecisionOption();
        for (DecisionOption decisionOption : decisionList) {
            if (!decisionOption.isDefaultDecision()) continue;
            defaultDecisionOption = decisionOption;
            break;
        }
        this.initAuditComment(flowElement, decisionList, defaultDecisionOption);
    }

    @Override
    public void afterCreatNewDataForCoordinateCustomEvent(AfterCreatNewDataForCoordinateCustomEvent e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{COMMONAUDITCOMMENT});
        this.getPageCache().put(AUDITCOMMENTWHENMATCH, String.valueOf(Boolean.FALSE));
    }

    public void initialize() {
        Vector icon = (Vector)this.getControl(COMMONAUDITCOMMENT);
        if (icon != null) {
            icon.addTipsListener((TipsListener)this);
            icon.addClickListener((ClickListener)this);
        }
    }

    protected void initAuditComment(FlowElement flowElement, List<DecisionOption> decisionList, DecisionOption defaultDecisionOption) {
        if (!(flowElement instanceof AuditTask)) {
            return;
        }
        AuditTask auditTask = (AuditTask)flowElement;
        AuditCommentModel auditCommentModel = auditTask.getAuditCommentModel();
        if (auditCommentModel == null) {
            this.initMsgApprovalWhenFalse(defaultDecisionOption);
            return;
        }
        List auditCommentList = auditCommentModel.getAuditComments();
        boolean auditCommentWhenMatch = auditCommentModel.isAuditCommentWhenMatch();
        IPageCache pageCache = this.getPageCache();
        if (auditCommentList != null && !auditCommentList.isEmpty()) {
            pageCache.put("auditCommentList", SerializationUtils.toJsonString((Object)auditCommentList));
        }
        if (decisionList == null || decisionList.isEmpty()) {
            pageCache.put("decisionList", SerializationUtils.toJsonString((Object)this.getPageCache().get("decisionOptionList")));
        } else {
            pageCache.put("decisionList", SerializationUtils.toJsonString(decisionList));
        }
        if (auditCommentList == null || auditCommentList.isEmpty() || defaultDecisionOption == null) {
            auditCommentWhenMatch = Boolean.FALSE;
        }
        this.getView().setVisible(Boolean.valueOf(auditCommentWhenMatch), new String[]{COMMONAUDITCOMMENT});
        pageCache.put(AUDITCOMMENTWHENMATCH, String.valueOf(auditCommentWhenMatch));
        if (auditCommentWhenMatch) {
            this.initMsgApprovalWhenTrue(auditCommentList, defaultDecisionOption);
        } else if (auditCommentModel.isAuditCommentWhenMatch() && WfConfigurationUtil.enableGetCommentFromBasedata()) {
            String formId = this.getView().getFormShowParameter().getFormId();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
            if (defaultDecisionOption != null && !"wf_approvalpageud_flofull".equals(formId)) {
                qFilters.add(new QFilter("decisiontype", "=", (Object)defaultDecisionOption.getAuditType()));
            }
            qFilters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"wf_commonauditcommenttree", (String)"name", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"number", (int)1);
            if (dynamicObjects.length > 0) {
                ILocaleString auditName = dynamicObjects[0].getLocaleString("name");
                this.getView().setVisible(Boolean.TRUE, new String[]{COMMONAUDITCOMMENT});
                pageCache.put(AUDITCOMMENTWHENMATCH, String.valueOf(Boolean.TRUE));
                this.getView().getModel().setValue(MSG_APPROVAL, (Object)auditName);
            } else {
                this.initMsgApprovalWhenFalse(defaultDecisionOption);
            }
        } else {
            this.initMsgApprovalWhenFalse(defaultDecisionOption);
        }
    }

    protected void initMsgApprovalWhenTrue(List<AuditComment> auditComments, DecisionOption defaultDecisionOption) {
        String defaultAuditNumber = defaultDecisionOption.getNumber();
        AuditComment defaultAuditComment = null;
        for (AuditComment auditComment : auditComments) {
            if (!WfUtils.isNotEmpty((String)auditComment.getDecision()) || !auditComment.getDecision().contains(defaultAuditNumber)) continue;
            defaultAuditComment = auditComment;
            break;
        }
        DynamicObject auditCommentDynamicObject = null;
        if (defaultAuditComment != null) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)defaultAuditComment.getBasedataid())};
            auditCommentDynamicObject = BusinessDataServiceHelper.loadSingle((String)"wf_commonauditcommenttree", (String)"name", (QFilter[])filters);
        }
        if (auditCommentDynamicObject != null) {
            ILocaleString auditText = auditCommentDynamicObject.getLocaleString("name");
            this.getView().setVisible(Boolean.TRUE, new String[]{COMMONAUDITCOMMENT});
            this.getPageCache().put(AUDITCOMMENTWHENMATCH, String.valueOf(Boolean.TRUE));
            this.getView().getModel().setValue(MSG_APPROVAL, (Object)auditText.toString());
        } else {
            this.initMsgApprovalWhenFalse(defaultDecisionOption);
        }
    }

    protected void initMsgApprovalWhenFalse(DecisionOption defaultDecisionOption) {
        if (defaultDecisionOption == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5e38\u7528\u5ba1\u6279\u610f\u89c1\u65e0\u5339\u914d\u7684\u51b3\u7b56\u9879\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractCommonApprovalOpinionsPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        IPageCache pageCache = this.getPageCache();
        this.getView().setVisible(Boolean.FALSE, new String[]{COMMONAUDITCOMMENT});
        pageCache.put(AUDITCOMMENTWHENMATCH, String.valueOf(Boolean.FALSE));
        String processInstanceId = pageCache.get("processInstanceId");
        String nodeId = pageCache.get("nodeId");
        String name = defaultDecisionOption.getName();
        String decisionId = defaultDecisionOption.getId();
        JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatas((Long)Long.valueOf(processInstanceId));
        String multiKey = BpmnModelUtil.getDecisionNameMultiKey((String)nodeId, (String)decisionId);
        ILocaleString auditText = BpmnModelUtil.getMultiLangFieldValue((JSONObject)multiLangDatas, (String)multiKey, (String)name);
        auditText = ApprovalPluginUtil.getDefaultApprovalMsg(auditText);
        this.getView().getModel().setValue(MSG_APPROVAL, (Object)auditText);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (COMMONAUDITCOMMENT.equals(closedCallBackEvent.getActionId()) && returnData instanceof ILocaleString) {
                ILocaleString msg = ApprovalPluginUtil.getDefaultApprovalMsg((ILocaleString)returnData);
                if (WfUtils.isEmpty((ILocaleString)msg)) {
                    msg.put((Object)Lang.get().toString(), (Object)((ILocaleString)returnData).getLocaleValue_zh_CN());
                }
                this.getModel().setValue(MSG_APPROVAL, (Object)msg);
            }
        }
    }

    @Override
    public String getApprovalPageId() {
        return this.getView().getPageId();
    }

    @Override
    public String getBillPageId() {
        return this.getPageCache().get("billPageId");
    }

    @Override
    public boolean isPCShow() {
        return false;
    }

    public void afterShowTips(AfterShowTipsEvent arg0) {
        this.logger.debug("afterShowTips");
    }

    public void beforeShowTips(BeforeShowTipsEvent arg0) {
        this.logger.debug("beforeShowTips");
    }
}

