/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.udlayout;

import java.util.Map;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.management.plugin.ApprovalPageTpl;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForApprovalCustomEvent;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForCoordinateCustomEvent;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForHandledCustomEvent;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class ApprovalAdvAppSchemePlugin
extends ApprovalPageTpl {
    private static final String DYNAMICPANEL = "dynamicpanel";
    private static final String TABAP_ADVAPPSCHEME = "tabpageap_advappscheme";
    private static final String IDICUSTCONTROLAP = "customcontrolap";
    protected static final String SCHEMEPLUGINPC = "kd.bos.ext.data.idi.formplugin.SmartPanelPlugin";
    protected static final String SCHEMEPLUGINMOB = "kd.bos.ext.data.idi.formplugin.SmartMobilePanelPlugin";
    private static final String SUCCESSFORADDINGPLUGIN = "successForAddingPlugin";
    protected static final String SCHEMENUMBER = "schemeNumber";
    protected static final String TABAP = "tabap";

    public void initialize() {
        String pluginName = null;
        Boolean isPCShowFromCache = this.isPCShow();
        boolean isPCShow = WfUtils.isNotEmptyString((Object)isPCShowFromCache) && Boolean.parseBoolean(((Object)isPCShowFromCache).toString());
        pluginName = isPCShow ? SCHEMEPLUGINPC : SCHEMEPLUGINMOB;
        boolean successForAddingPlugin = ApprovalPluginUtil.addPluginsForView(pluginName, this.getView());
        this.getPageCache().put(SUCCESSFORADDINGPLUGIN, String.valueOf(successForAddingPlugin));
    }

    @Override
    public void afterCreatNewDataForApprovalCustomEvent(AfterCreatNewDataForApprovalCustomEvent e) {
        this.initAdvAppScheme(e.getFlowElement());
    }

    @Override
    public void afterCreatNewDataForCoordinateCustomEvent(AfterCreatNewDataForCoordinateCustomEvent e) {
        this.initAdvAppScheme(e.getFlowElement());
    }

    @Override
    public void afterCreatNewDataForHandledApprovalCustomEvent(AfterCreatNewDataForHandledCustomEvent e) {
        this.initAdvAppScheme(e.getFlowElement());
    }

    private void initAdvAppScheme(FlowElement flowElement) {
        Map<String, String> info = this.getFlementConfigInfo(flowElement);
        String schemeNumber = null;
        if (info != null && !info.isEmpty()) {
            schemeNumber = info.get(SCHEMENUMBER);
        }
        boolean isShowAdvAppSchemeInfo = this.showAdvAppSchemeInfo(schemeNumber);
        if (this.isPCShow()) {
            this.getView().setVisible(Boolean.valueOf(isShowAdvAppSchemeInfo), new String[]{TABAP_ADVAPPSCHEME, IDICUSTCONTROLAP});
        } else {
            this.getView().setVisible(Boolean.valueOf(isShowAdvAppSchemeInfo), new String[]{DYNAMICPANEL});
        }
    }

    @Override
    public String getApprovalPageId() {
        return this.getView().getPageId();
    }

    @Override
    public String getBillPageId() {
        return this.getPageCache().get("billPageId");
    }

    @Override
    public boolean isPCShow() {
        return true;
    }
}

