/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.udlayout;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.exception.WFBizException;
import kd.bos.workflow.exception.WFBizOperationException;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFObjectNotFoundException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ApprovalPageUDUtil {
    private static final String ENTRYENTITY_NEXTNODE = "entryentity_nextnode";
    private static final String LABEL_NEXTNODE = "label_nextnode";
    public static final String BOS_WF_FORMPLUGIN = "bos-wf-formplugin";

    private ApprovalPageUDUtil() {
        throw new IllegalStateException("kd.bos.workflow.taskcenter.plugin.udlayout.ApprovalPageUDUtil");
    }

    public static void setEntryEntityForNextnode(List<Map<String, String>> nextNodeTextIdAndTextList, IDataModel model) {
        if (nextNodeTextIdAndTextList.isEmpty()) {
            return;
        }
        model.deleteEntryData(ENTRYENTITY_NEXTNODE);
        model.batchCreateNewEntryRow(ENTRYENTITY_NEXTNODE, nextNodeTextIdAndTextList.size());
        for (int i = 0; i < nextNodeTextIdAndTextList.size(); ++i) {
            Map<String, String> nextNodeIdAndTextMap = nextNodeTextIdAndTextList.get(i);
            String nextNodId = nextNodeIdAndTextMap.get("nextNodId");
            String nextNodText = nextNodeIdAndTextMap.get("nextNodeText");
            model.setValue(LABEL_NEXTNODE, (Object)nextNodText, i);
            if (WfUtils.isEmpty((String)nextNodId)) continue;
            model.setValue("nextnodeidtext", (Object)nextNodId, i);
        }
    }

    public static TaskService getTaskService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getTaskService();
    }

    public static RepositoryService getRepositoryService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRepositoryService();
    }

    public static FlowElement getFlowElement(Long processDefinitionId, Long processInstanceId, String taskDefinitionKey) {
        BpmnModel model = ApprovalPageUDUtil.getBpmnModel(processDefinitionId, processInstanceId);
        return model == null ? null : model.getFlowElement(taskDefinitionKey);
    }

    public static BpmnModel getBpmnModel(Long processDefinitionId, Long processInstanceId) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRepositoryService().getBpmnModel(processDefinitionId, processInstanceId);
    }

    public static String dealWithException(Exception e, String otherInfo) {
        String errorMessage = null;
        errorMessage = e instanceof WFObjectNotFoundException ? String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u65e0\u6cd5\u518d\u6b21\u63d0\u4ea4\u3002%s", (String)"ApprovalPluginNew_2", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]), WfUtils.isNotEmpty((String)otherInfo) ? otherInfo : "") : (e instanceof WFBizOperationException || e instanceof WFBizException || e instanceof WFEngineException || e instanceof KDBizException ? e.getMessage() + (WfUtils.isNotEmpty((String)otherInfo) ? otherInfo : "") : ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\u3002", (String)"ApprovalPluginNew_25", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
        return errorMessage;
    }

    public static List<SelectNodesModel> getRejectPreNode(List<Map<String, Object>> selectNodes) {
        ArrayList<SelectNodesModel> rejectOptions = new ArrayList<SelectNodesModel>();
        for (Map<String, Object> map : selectNodes) {
            if (map.get("nextNode") != null) {
                FlowElement flowElement = (FlowElement)map.get("nextNode");
                SelectNodesModel selectNodesModel = new SelectNodesModel();
                selectNodesModel.setItemId(flowElement.getId());
                selectNodesModel.setName(flowElement.getName());
                rejectOptions.add(selectNodesModel);
                continue;
            }
            if (map.get("nextNodeId") == null) continue;
            SelectNodesModel selectNodesModel = new SelectNodesModel();
            selectNodesModel.setItemId((String)map.get("nextNodeId"));
            selectNodesModel.setName(map.get("reason") == null ? " " : (String)map.get("reason"));
            rejectOptions.add(selectNodesModel);
        }
        return rejectOptions;
    }

    public static List<SelectNodesModel> filterUnFlowThrough(List<SelectNodesModel> list, Long procId) {
        ArrayList<SelectNodesModel> nodeList = new ArrayList<SelectNodesModel>();
        if (list != null && !list.isEmpty() && WfConfigurationUtil.isIgnoreNoThroughNode()) {
            if (list.size() == 1 && list.get(0).getItemId() == null) {
                return list;
            }
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            List entities = wfService.getHistoryService().getHistoricActivityByProcessInstanceId(procId);
            block0: for (SelectNodesModel selectNodesModel : list) {
                String nextNodeId = selectNodesModel.getItemId();
                for (HistoricActivityInstanceEntity historicActivityInstanceEntity : entities) {
                    if (!nextNodeId.equals(historicActivityInstanceEntity.getActivityId())) continue;
                    nodeList.add(selectNodesModel);
                    continue block0;
                }
            }
        } else if (list != null) {
            nodeList.addAll(list);
        }
        return nodeList;
    }
}

