/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.udlayout;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.workflow.bpmn.model.AuditPointModel;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.cmd.task.AgentTaskHandleContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.AuditPointInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.task.auditpoint.AuditPointCheckResult;
import kd.bos.workflow.engine.task.auditpoint.AuditPointType;
import kd.bos.workflow.management.plugin.ApprovalPageTpl;
import kd.bos.workflow.taskcenter.plugin.udlayout.ApprovalPageUDUtil;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForApprovalCustomEvent;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.BeforeSubmitCustomEvent;
import kd.bos.workflow.taskcenter.plugin.util.PictureResourceEnum;

public class WorkflowApprovalPageAuditPointPlugin
extends ApprovalPageTpl
implements TipsListener {
    private static final String AUDITPOINTS_TIPS = "displaynametips";
    private static final String FLEXPANEL_AUDITPOINTS = "flexpanel_auditpoints";
    private static final String RUFLEXPANEL = "ruflexpanel";
    private static final String AUDITPOINTS_TITLE = "auditpoints_title";
    private static final String ENTRYENTITY_AUDITPOINT = "entryentity_auditpoint";
    private static final String IMAGEAP_ISPASS = "imageap_ispass";
    private static final String CARDENTRYISPASS = "cardentryispass";
    private static final String AUDITPOINTS_ERRORMESSAGE = "errormessage";
    private static final String AUDITPOINTS_CARDENTRYFAILRE = "cardentryfailedreason";
    private static final String AUDITPOINTS_DESCRIPTION = "description";
    private static final String AUDITPOINTS_INSID = "auditpointinsid";
    private static final String AUDITPOINTS_TYPE = "auditpoint_type";
    private static final String AUDITPOINTS_DISPLAYNAME = "displayname";
    private static final String AUDITPOINTS_ISPASS = "combo_ispass";
    private static final String AUDITPOINTS_ISNEEDREASON = "isneedreason";
    private static final String AUDITPOINTS_FAILEDREASON = "failedreason";
    private static final String AUDITPOINTS_ISNEEDMARK = "isneedmark";

    public void registerListener(EventObject e) {
        Label auditPointsTips = (Label)this.getControl(AUDITPOINTS_TIPS);
        if (auditPointsTips != null) {
            auditPointsTips.addTipsListener((TipsListener)this);
        }
    }

    @Override
    public void afterCreatNewDataForApprovalCustomEvent(AfterCreatNewDataForApprovalCustomEvent e) {
        FlowElement flowElement = e.getFlowElement();
        AgentTaskHandleContext context = e.getContext();
        if (!(flowElement instanceof AuditTask) && context == null) {
            return;
        }
        TaskEntity taskEntity = (TaskEntity)context.getTask();
        this.showAuditPointCheckList((AuditTask)flowElement, taskEntity);
    }

    @Override
    public void beforeSubmitCustomEvent(BeforeSubmitCustomEvent e) {
        DynamicObjectCollection auditPointEntryEntities = this.getModel().getEntryEntity(ENTRYENTITY_AUDITPOINT);
        if (auditPointEntryEntities != null && !auditPointEntryEntities.isEmpty()) {
            Map<String, String> auditPointValidInfo = this.getAuditPointValidInfo(auditPointEntryEntities);
            if (!this.isAllMarked(auditPointEntryEntities)) {
                e.setVerifyInformation(String.format(ResManager.loadKDString((String)"\u8bf7\u6807\u6ce8\u5ba1\u6279\u8981\u70b9\u624b\u52a8\u68c0\u67e5\u9879\u201c%s\u201d\u7684\u68c0\u67e5\u7ed3\u679c\u3002", (String)"ApprovalPagePluginNew_14", (String)"bos-wf-formplugin", (Object[])new Object[0]), auditPointValidInfo.get("checkResultInfo")));
                e.setCancel(true);
                return;
            }
            if (!this.isAllInstructe(auditPointEntryEntities)) {
                e.setVerifyInformation(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5ba1\u6279\u8981\u70b9\u624b\u52a8\u68c0\u67e5\u9879\u201c%s\u201d\u7684\u672a\u901a\u8fc7\u539f\u56e0\u3002", (String)"ApprovalPagePluginNew_15", (String)"bos-wf-formplugin", (Object[])new Object[0]), auditPointValidInfo.get("failedReasonInfo")));
                e.setCancel(true);
                return;
            }
            this.updateAuditPoints(auditPointEntryEntities);
        }
    }

    private void updateAuditPoints(DynamicObjectCollection auditPointEntryEntities) {
        RepositoryService service = this.getRepositoryService();
        String currentUserId = RequestContext.get().getUserId();
        for (DynamicObject auditPointEntryEntity : auditPointEntryEntities) {
            Long auditPointsInsId = auditPointEntryEntity.getLong(AUDITPOINTS_INSID);
            AuditPointInstanceEntity auditPointInstanceEntity = (AuditPointInstanceEntity)service.findEntityById(auditPointsInsId, "wf_auditpointinstance");
            if (AuditPointType.MANUALCHECKS.getNumber().equals(auditPointEntryEntity.getString(AUDITPOINTS_TYPE))) {
                String checkResult = auditPointEntryEntity.getString(AUDITPOINTS_ISPASS);
                auditPointInstanceEntity.setCheckResult(checkResult);
                if (AuditPointCheckResult.FAILED.getNumber().equals(checkResult)) {
                    ILocaleString failedReason = auditPointEntryEntity.getLocaleString(AUDITPOINTS_FAILEDREASON);
                    auditPointInstanceEntity.setFailedReason(failedReason);
                }
            }
            auditPointInstanceEntity.setAssigneeId(Long.valueOf(currentUserId));
            ILocaleString assigneeName = WfUtils.findUserName((Long)Long.valueOf(currentUserId));
            auditPointInstanceEntity.setAssigneeName(assigneeName);
            service.saveOrUpdateEntity((Entity)auditPointInstanceEntity);
        }
    }

    private boolean isAllInstructe(DynamicObjectCollection auditPointEntryEntities) {
        boolean isAllInstructe = true;
        for (DynamicObject auditPointEntryEntity : auditPointEntryEntities) {
            String checkResult = auditPointEntryEntity.getString(AUDITPOINTS_ISPASS);
            Boolean isNeedReason = auditPointEntryEntity.getBoolean(AUDITPOINTS_ISNEEDREASON);
            ILocaleString failedReason = auditPointEntryEntity.getLocaleString(AUDITPOINTS_FAILEDREASON);
            if (!isNeedReason.booleanValue() || !WfUtils.isEmpty((ILocaleString)failedReason) || !AuditPointCheckResult.FAILED.getNumber().equals(checkResult)) continue;
            isAllInstructe = false;
        }
        return isAllInstructe;
    }

    private boolean isAllMarked(DynamicObjectCollection auditPointEntryEntities) {
        boolean isAllMarked = true;
        for (DynamicObject auditPointEntryEntity : auditPointEntryEntities) {
            Boolean isNeedMark = auditPointEntryEntity.getBoolean(AUDITPOINTS_ISNEEDMARK);
            String checkResult = auditPointEntryEntity.getString(AUDITPOINTS_ISPASS);
            if (!isNeedMark.booleanValue() || !AuditPointCheckResult.UNCONFIRMED.getNumber().equals(checkResult) && !WfUtils.isEmpty((String)checkResult)) continue;
            isAllMarked = false;
            break;
        }
        return isAllMarked;
    }

    private Map<String, String> getAuditPointValidInfo(DynamicObjectCollection auditPointEntryEntities) {
        HashMap<String, String> auditPointValidInfo = new HashMap<String, String>();
        StringBuilder checkResultNotify = new StringBuilder();
        StringBuilder failedReasonNotify = new StringBuilder();
        for (int i = 0; i < auditPointEntryEntities.size(); ++i) {
            Boolean isNeedMark = ((DynamicObject)auditPointEntryEntities.get(i)).getBoolean(AUDITPOINTS_ISNEEDMARK);
            String checkResult = ((DynamicObject)auditPointEntryEntities.get(i)).getString(AUDITPOINTS_ISPASS);
            if (isNeedMark.booleanValue() && (AuditPointCheckResult.UNCONFIRMED.getNumber().equals(checkResult) || WfUtils.isEmpty((String)checkResult))) {
                String displayName = ((DynamicObject)auditPointEntryEntities.get(i)).getString(AUDITPOINTS_DISPLAYNAME);
                checkResultNotify.append(displayName).append(' ');
            }
            Boolean isNeedReason = ((DynamicObject)auditPointEntryEntities.get(i)).getBoolean(AUDITPOINTS_ISNEEDREASON);
            ILocaleString failedReason = ((DynamicObject)auditPointEntryEntities.get(i)).getLocaleString(AUDITPOINTS_FAILEDREASON);
            if (!isNeedReason.booleanValue() || !WfUtils.isEmpty((ILocaleString)failedReason) || !AuditPointCheckResult.FAILED.getNumber().equals(checkResult)) continue;
            String displayName = ((DynamicObject)auditPointEntryEntities.get(i)).getString(AUDITPOINTS_DISPLAYNAME);
            failedReasonNotify.append(displayName).append(' ');
        }
        auditPointValidInfo.put("checkResultInfo", checkResultNotify.toString());
        auditPointValidInfo.put("failedReasonInfo", failedReasonNotify.toString());
        return auditPointValidInfo;
    }

    private void showAuditPointCheckList(AuditTask auditTask, TaskEntity taskEntity) {
        AuditPointModel auditPointModel = auditTask.getAuditPointModel();
        if (auditPointModel == null || !auditPointModel.isAuditPointWhenMatch()) {
            return;
        }
        IDataModel model = this.getModel();
        String title = auditPointModel.getAuditPointTitle();
        Label auditPointsTitle = (Label)this.getControl(AUDITPOINTS_TITLE);
        auditPointsTitle.setText(WfUtils.isEmpty((String)title) ? ResManager.loadKDString((String)"\u5ba1\u6279\u8981\u70b9", (String)"ApprovalPagePluginNew_20", (String)"bos-wf-formplugin", (Object[])new Object[0]) : title);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY_AUDITPOINT);
        List auditPointIntances = ApprovalPageUDUtil.getTaskService().getAuditPointInstancesByTaskId(taskEntity.getId());
        if (auditPointIntances == null || auditPointIntances.isEmpty()) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANEL_AUDITPOINTS, RUFLEXPANEL});
        model.deleteEntryData(ENTRYENTITY_AUDITPOINT);
        model.batchCreateNewEntryRow(ENTRYENTITY_AUDITPOINT, auditPointIntances.size());
        RepositoryService service = ApprovalPageUDUtil.getRepositoryService();
        block11: for (int i = 0; i < auditPointIntances.size(); ++i) {
            AuditPointInstanceEntity auditPointIntance = (AuditPointInstanceEntity)auditPointIntances.get(i);
            String type = auditPointIntance.getType();
            this.setControlsDisplayOrHidden(cardEntry, type, i);
            model.setValue(AUDITPOINTS_INSID, (Object)auditPointIntance.getId(), i);
            ILocaleString description = auditPointIntance.getDescription();
            if (!WfUtils.isEmpty((String)type)) {
                model.setValue(AUDITPOINTS_TYPE, (Object)type, i);
                model.setValue(AUDITPOINTS_DISPLAYNAME, (Object)auditPointIntance.getDisplayname().getLocaleValue(), i);
                model.setValue(AUDITPOINTS_DESCRIPTION, (Object)description.getLocaleValue(), i);
            } else {
                model.setValue(AUDITPOINTS_TYPE, (Object)AuditPointType.TEXTREMINDER.getNumber(), i);
                model.setValue(AUDITPOINTS_DISPLAYNAME, (Object)description.getLocaleValue(), i);
            }
            switch (type) {
                case "textreminder": 
                case "": {
                    model.setValue(IMAGEAP_ISPASS, (Object)PictureResourceEnum.AUDITPOINT_IMAGES_TEXTREMINDER.getValue(), i);
                    continue block11;
                }
                case "automaticchecks": {
                    model.setValue(IMAGEAP_ISPASS, (Object)PictureResourceEnum.AUDITPOINT_IMAGES_APPROVE.getValue(), i);
                    ILocaleString failedReason = auditPointIntance.getFailedReason();
                    String checkResult = auditPointIntance.getCheckResult();
                    if (auditPointIntance.isImmediately().booleanValue()) {
                        String langKey;
                        String key = ConditionUtil.getConInstKey((String)auditTask.getNumber(), (String)"auditPoint");
                        Map resultAndFailedReason = service.calculateAuditPointCheckResult(auditPointIntance.getBusinessRule(), (VariableScope)taskEntity, key);
                        Boolean isPassed = (Boolean)resultAndFailedReason.get("isPassed");
                        String exceptionMessage = (String)resultAndFailedReason.get("failedReason");
                        AuditPointInstanceEntity auditPointInstanceEntity = (AuditPointInstanceEntity)service.findEntityById(auditPointIntance.getId(), "wf_auditpointinstance");
                        if (isPassed.booleanValue()) {
                            checkResult = AuditPointCheckResult.APPROVE.getNumber();
                            auditPointInstanceEntity.setCheckResult(checkResult);
                        } else {
                            checkResult = AuditPointCheckResult.FAILED.getNumber();
                            auditPointInstanceEntity.setCheckResult(checkResult);
                            if (!WfUtils.isEmpty((String)exceptionMessage)) {
                                if (exceptionMessage.length() > 2000) {
                                    exceptionMessage = exceptionMessage.substring(0, 1999);
                                }
                                failedReason = WfUtils.getMultiLangValue((String)exceptionMessage);
                            } else {
                                ILocaleString failedReasonExpression = auditPointInstanceEntity.getFailedReasonExpression();
                                if (WfUtils.isNotEmpty((ILocaleString)failedReasonExpression)) {
                                    for (Map.Entry entry : failedReasonExpression.entrySet()) {
                                        langKey = (String)entry.getKey();
                                        String failedReasonValue = (String)entry.getValue();
                                        String failedReasonParsed = service.getBillExpressionParsedValue(taskEntity.getBusinessKey(), taskEntity.getEntityNumber(), failedReasonValue, (VariableScope)taskEntity);
                                        if (failedReasonParsed.length() > 2000) {
                                            failedReasonParsed = failedReasonParsed.substring(0, 1999);
                                        }
                                        failedReason.setItem(langKey, (Object)failedReasonParsed);
                                    }
                                    auditPointInstanceEntity.setFailedReason(failedReason);
                                }
                            }
                        }
                        ILocaleString descriptionExpression = auditPointIntance.getDescriptionExpression();
                        if (WfUtils.isNotEmpty((ILocaleString)descriptionExpression)) {
                            for (Map.Entry entry : descriptionExpression.entrySet()) {
                                langKey = (String)entry.getKey();
                                String descriptionValue = (String)entry.getValue();
                                String descriptionParsed = service.getBillExpressionParsedValue(taskEntity.getBusinessKey(), taskEntity.getEntityNumber(), descriptionValue, (VariableScope)taskEntity);
                                if (descriptionParsed.length() > 510) {
                                    descriptionParsed = descriptionParsed.substring(0, 509);
                                }
                                description.setItem(langKey, (Object)descriptionParsed);
                            }
                            auditPointInstanceEntity.setDescription(description);
                        }
                        service.saveOrUpdateEntity((Entity)auditPointInstanceEntity);
                    }
                    model.setValue(AUDITPOINTS_ISPASS, (Object)checkResult, i);
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{AUDITPOINTS_ISPASS});
                    if (AuditPointCheckResult.FAILED.getNumber().equals(checkResult)) {
                        model.setValue(IMAGEAP_ISPASS, (Object)PictureResourceEnum.AUDITPOINT_IMAGES_FAILED.getValue(), i);
                        model.setValue(AUDITPOINTS_ERRORMESSAGE, (Object)failedReason.getLocaleValue(), i);
                        cardEntry.setChildVisible(true, i, new String[]{AUDITPOINTS_CARDENTRYFAILRE});
                        cardEntry.setChildVisible(true, i, new String[]{AUDITPOINTS_ERRORMESSAGE});
                    }
                    model.setValue(AUDITPOINTS_DESCRIPTION, (Object)description.getLocaleValue(), i);
                    continue block11;
                }
                case "manualchecks": {
                    model.setValue(IMAGEAP_ISPASS, (Object)PictureResourceEnum.AUDITPOINT_IMAGES_UNCONFIRMED.getValue(), i);
                    model.setValue(AUDITPOINTS_ISNEEDREASON, (Object)auditPointIntance.isNeedReason(), i);
                    model.setValue(AUDITPOINTS_ISNEEDMARK, (Object)auditPointIntance.isNeedMark(), i);
                    continue block11;
                }
            }
        }
    }

    private void setControlsDisplayOrHidden(CardEntry cardEntry, String type, int i) {
        switch (type) {
            case "textreminder": 
            case "": {
                cardEntry.setChildVisible(true, i, new String[]{IMAGEAP_ISPASS, AUDITPOINTS_DISPLAYNAME});
                cardEntry.setChildVisible(false, i, new String[]{CARDENTRYISPASS, AUDITPOINTS_ISPASS, AUDITPOINTS_ERRORMESSAGE, AUDITPOINTS_CARDENTRYFAILRE, AUDITPOINTS_FAILEDREASON});
                break;
            }
            case "automaticchecks": 
            case "manualchecks": {
                cardEntry.setChildVisible(true, i, new String[]{IMAGEAP_ISPASS, AUDITPOINTS_DISPLAYNAME, CARDENTRYISPASS, AUDITPOINTS_ISPASS});
                cardEntry.setChildVisible(false, i, new String[]{AUDITPOINTS_ERRORMESSAGE, AUDITPOINTS_CARDENTRYFAILRE, AUDITPOINTS_FAILEDREASON});
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.canDoOperation("wf_participant", false)) {
            return;
        }
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (AUDITPOINTS_ISPASS.equals(propName)) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY_AUDITPOINT);
            int index = cardEntry.getEntryState().getFocusRow();
            IDataModel model = this.getModel();
            String ispassed = (String)model.getValue(AUDITPOINTS_ISPASS, index);
            if (WfUtils.isEmpty((String)ispassed)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u5ba1\u6279\u8981\u70b9\u68c0\u67e5\u9879\u662f\u5426\u901a\u8fc7\u3002", (String)"ApprovalPageAuditPointPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean isNeedReason = (Boolean)model.getValue(AUDITPOINTS_ISNEEDREASON, index);
            switch (ispassed) {
                case "approve": {
                    model.setValue(IMAGEAP_ISPASS, (Object)PictureResourceEnum.AUDITPOINT_IMAGES_APPROVE.getValue(), index);
                    break;
                }
                case "failed": {
                    model.setValue(IMAGEAP_ISPASS, (Object)PictureResourceEnum.AUDITPOINT_IMAGES_FAILED.getValue(), index);
                    break;
                }
                case "unconfirmed": {
                    model.setValue(IMAGEAP_ISPASS, (Object)PictureResourceEnum.AUDITPOINT_IMAGES_UNCONFIRMED.getValue(), index);
                    break;
                }
            }
            if (AuditPointCheckResult.FAILED.getNumber().equals(ispassed) && isNeedReason.booleanValue()) {
                cardEntry.setChildVisible(true, index, new String[]{AUDITPOINTS_CARDENTRYFAILRE});
                cardEntry.setChildVisible(true, index, new String[]{AUDITPOINTS_FAILEDREASON});
            } else {
                cardEntry.setChildVisible(false, index, new String[]{AUDITPOINTS_CARDENTRYFAILRE});
                cardEntry.setChildVisible(false, index, new String[]{AUDITPOINTS_FAILEDREASON});
            }
        }
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        FormShowParameter para = evt.getFormshowParameter();
        if (para == null) {
            para = new FormShowParameter();
            evt.setFormshowParameter(para);
        }
        if (AUDITPOINTS_TIPS.equals(key)) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY_AUDITPOINT);
            int index = cardEntry.getEntryState().getFocusRow();
            IDataModel model = this.getModel();
            if (index != -1) {
                String description = (String)model.getValue(AUDITPOINTS_DESCRIPTION, index);
                if (WfUtils.isEmpty((String)description)) {
                    description = ResManager.loadKDString((String)"\u8be5\u201c\u68c0\u67e5\u9879\u201d\u65e0\u8be6\u7ec6\u8bf4\u660e\u3002", (String)"ApprovalPagePluginNew_8", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                }
                para.setCustomParam("auditPointsTips", (Object)description);
            } else {
                this.logger.debug("\u5ba1\u6279\u8981\u70b9\u68c0\u67e5\u9879\u6ca1\u6709\u9009\u4e2d\u884c\uff01");
            }
        }
    }

    @Override
    public String getApprovalPageId() {
        return this.getView().getPageId();
    }

    @Override
    public String getBillPageId() {
        return this.getPageCache().get("billPageId");
    }

    @Override
    public boolean isPCShow() {
        return false;
    }

    public void afterShowTips(AfterShowTipsEvent arg0) {
        this.logger.debug("kd.bos.workflow.taskcenter.plugin.udlayout.WorkflowApprovalPageAuditPointPlugin.afterShowTips(AfterShowTipsEvent)");
    }
}

