/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.udlayout;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.management.plugin.ApprovalPageTpl;
import kd.bos.workflow.taskcenter.plugin.udlayout.ApprovalPageUDUtil;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForApprovalCustomEvent;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForCoordinateCustomEvent;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForHandledCustomEvent;

public class WorkflowApprovalPageFeedBackPlugin
extends ApprovalPageTpl
implements TabSelectListener {
    protected static final String ENTRYENTITY_FEEDBACK = "entryentity_feedback";
    protected static final String PICTUREFIELD_FEEDBACK = "picturefield_feedback";
    protected static final String TEXTFIELD_FEEDBACKID = "textfield_feedbackid";
    protected static final String TEXTFIELD_FEEDBACKNAME = "textfield_feedbackname";
    protected static final String TEXTFIELD_FEEDBACKTIME = "textfield_feedbacktime";
    protected static final String TEXTFIELD_FEEDBACKCONTENT = "textfield_feedbackcontent";
    protected static final String TEXTFIELD_ISSHOWRECALL = "textfield_isshowrecall";
    protected static final String BTN_FEEDBACKRECALL = "btn_feedbackrecall";
    protected static final String MSG_FEEDBACK = "msg_feedback";
    protected static final String BTNSUBMIT_FEEDBACK = "btnsubmit_feedback";
    protected static final String FLEXPANELAP_FEEDBACKNOMSG = "flexpanelap_feedbacknomsg";
    protected static final String TABPAGEAP_FEEDBACK = "tabpageap_feedback";
    protected static final String FEEDBACK_CREATEDATE = "createdate";
    protected static final String FEEDBACK_AVATAR = "avatar";
    protected static final String FEEDBACK_USERNAME = "username";
    protected static final String FEEDBACK_MSG = "feedbackmsg";
    protected static final String FEEDBACK_ID = "id";
    protected static final String FEEDBACK_CREATORID = "creatorid";
    protected static final String ISTASKEXIST = "isTaskExist";

    @Override
    public void afterCreatNewDataForApprovalCustomEvent(AfterCreatNewDataForApprovalCustomEvent e) {
        this.getView().setVisible(Boolean.valueOf(WfConfigurationUtil.getShowTabFeedback()), new String[]{TABPAGEAP_FEEDBACK});
    }

    @Override
    public void afterCreatNewDataForCoordinateCustomEvent(AfterCreatNewDataForCoordinateCustomEvent e) {
        this.getView().setVisible(Boolean.valueOf(WfConfigurationUtil.getShowTabFeedback()), new String[]{TABPAGEAP_FEEDBACK});
    }

    @Override
    public void afterCreatNewDataForHandledApprovalCustomEvent(AfterCreatNewDataForHandledCustomEvent e) {
        this.getView().setVisible(Boolean.valueOf(WfConfigurationUtil.getShowTabFeedback()), new String[]{TABPAGEAP_FEEDBACK});
        this.showFeedbackInfo();
    }

    public void initialize() {
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{BTN_FEEDBACKRECALL, BTNSUBMIT_FEEDBACK});
    }

    public void tabSelected(TabSelectEvent evt) {
        String key = evt.getTabKey();
        if (null == this.getPageCache().get(key)) {
            if (TABPAGEAP_FEEDBACK.equals(key) && WfConfigurationUtil.getShowTabFeedback()) {
                this.showFeedbackInfo();
            }
            this.getPageCache().put(key, "true");
        }
    }

    protected void showFeedbackInfo() {
        boolean isTaskExist = Boolean.parseBoolean(this.getPageCache().get(ISTASKEXIST));
        if (!isTaskExist) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TABPAGEAP_FEEDBACK});
            return;
        }
        String processInstanceId = this.getPageCache().get("processInstanceId");
        TaskService taskService = ApprovalPageUDUtil.getTaskService();
        List feedbackInfos = taskService.getFeedbackInfosByProcessInstanceId(processInstanceId);
        this.setEntryEntityForFeedback(feedbackInfos);
    }

    private void setEntryEntityForFeedback(List<Map<String, Object>> entryData) {
        IDataModel model = this.getModel();
        String entryName = ENTRYENTITY_FEEDBACK;
        model.deleteEntryData(ENTRYENTITY_FEEDBACK);
        Boolean onlyView = Boolean.parseBoolean(this.getPageCache().get("onlyView"));
        Boolean isShowFeedBack = Boolean.FALSE;
        if (!entryData.isEmpty()) {
            isShowFeedBack = Boolean.TRUE;
            Object createdatetext = null;
            Date createdate = null;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String userid = RequestContext.get().getUserId();
            model.batchCreateNewEntryRow(entryName, entryData.size());
            for (int i = 0; i < entryData.size(); ++i) {
                Map<String, Object> data = entryData.get(i);
                createdate = (Date)data.get(FEEDBACK_CREATEDATE);
                model.setValue(PICTUREFIELD_FEEDBACK, (Object)((String)data.get(FEEDBACK_AVATAR)), i);
                model.setValue(TEXTFIELD_FEEDBACKNAME, (Object)((String)data.get(FEEDBACK_USERNAME)), i);
                model.setValue(TEXTFIELD_FEEDBACKTIME, (Object)createdate, i);
                model.setValue(TEXTFIELD_FEEDBACKCONTENT, (Object)((ILocaleString)data.get(FEEDBACK_MSG)).toString(), i);
                model.setValue(TEXTFIELD_FEEDBACKID, data.get(FEEDBACK_ID), i);
                if (userid.equals(data.get(FEEDBACK_CREATORID).toString())) {
                    model.setValue(TEXTFIELD_ISSHOWRECALL, (Object)"1", i);
                    continue;
                }
                model.setValue(TEXTFIELD_ISSHOWRECALL, (Object)"0", i);
            }
        }
        this.getView().setVisible(isShowFeedBack, new String[]{entryName});
        this.getView().setVisible(Boolean.valueOf(isShowFeedBack == false && onlyView != false), new String[]{FLEXPANELAP_FEEDBACKNOMSG});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_FEEDBACKRECALL.equals(key)) {
            this.showFeedbackRecallFunc();
        } else if (BTNSUBMIT_FEEDBACK.equals(key)) {
            this.showSubmitFeedbackFunc();
        }
    }

    protected void showSubmitFeedbackFunc() {
        ILocaleString feedbackMsg = (ILocaleString)this.getModel().getValue(MSG_FEEDBACK);
        if (WfUtils.isEmpty((ILocaleString)feedbackMsg) || WfUtils.isEmpty((String)feedbackMsg.getLocaleValue().trim())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u9644\u52a0\u8bf4\u660e\u201d\u3002", (String)"ApprovalPagePluginNew_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else {
            HashMap<String, Object> customParam = new HashMap<String, Object>();
            customParam.put("businessKey", this.getPageCache().get("businesskey"));
            customParam.put("processInstanceId", Long.parseLong(this.getPageCache().get("processInstanceId")));
            customParam.put("feedbackMsg", feedbackMsg);
            ApprovalPageUDUtil.getTaskService().saveFeedbackInfo(customParam);
            this.showFeedbackInfo();
            this.getModel().setValue(MSG_FEEDBACK, null);
        }
    }

    protected void showFeedbackRecallFunc() {
        DynamicObject object = this.getSelectRowData(ENTRYENTITY_FEEDBACK);
        String feedbackId = (String)object.get(TEXTFIELD_FEEDBACKID);
        ApprovalPageUDUtil.getTaskService().deleteFeedbackInfoById(feedbackId);
        this.showFeedbackInfo();
    }

    protected DynamicObject getSelectRowData(String entryEntityName) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryEntityName);
        int row = grid.getEntryState().getFocusRow();
        this.logger.debug("getSelectRowData -- row:" + row);
        if (row > -1) {
            IDataModel model = this.getModel();
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection entrys = (DynamicObjectCollection)dataEntity.get(entryEntityName);
            this.logger.debug("getSelectRowData -- entrys:" + entrys);
            return (DynamicObject)entrys.get(row);
        }
        return null;
    }

    @Override
    public String getApprovalPageId() {
        return this.getView().getPageId();
    }

    @Override
    public String getBillPageId() {
        return this.getPageCache().get("billPageId");
    }

    @Override
    public boolean isPCShow() {
        return true;
    }
}

