/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.udlayout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.model.AuditComment;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowCommonCommentPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String CONSENTFLEXPANELAP = "consentflexpanelap";
    private static final String REJECTFLEXPANELAP = "rejectflexpanelap";
    private static final String TERMINATIONFLEXPANELAP = "terminationflexpanelap";
    private static final String CONSENTENTRYENTITY = "consententryentity";
    private static final String REJECTENTRYENTITY = "rejectentryentity";
    private static final String TERMINATIONENTRYENTITY = "terminationentryentity";
    private static final String CONSENTTEXTFIELD = "consenttextfield";
    private static final String REJECTTEXTFIELD = "rejecttextfield";
    private static final String TERMINATIONTEXTFIELD = "terminationtextfield";

    public void registerListener(EventObject e) {
        EntryGrid consentEntryGrid = (EntryGrid)this.getView().getControl(CONSENTENTRYENTITY);
        consentEntryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid rejectEntryGrid = (EntryGrid)this.getView().getControl(REJECTENTRYENTITY);
        rejectEntryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid terminationEntryGrid = (EntryGrid)this.getView().getControl(TERMINATIONENTRYENTITY);
        terminationEntryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{CONSENTFLEXPANELAP, REJECTFLEXPANELAP, TERMINATIONFLEXPANELAP});
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String auditCommentListStr = (String)parameter.getCustomParam("auditCommentList");
        String decisionListStr = (String)parameter.getCustomParam("decisionOptionList");
        String desionNumber = (String)parameter.getCustomParam("defultDesionNumber");
        if (WfUtils.isEmpty((String)auditCommentListStr) && !WfConfigurationUtil.enableGetCommentFromBasedata() || WfUtils.isEmpty((String)decisionListStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonApprovalCommentPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<AuditComment> auditComments = new ArrayList(0);
        if (WfUtils.isNotEmpty((String)auditCommentListStr)) {
            auditComments = SerializationUtils.fromJsonStringToList((String)auditCommentListStr, AuditComment.class);
        }
        List decisionList = SerializationUtils.fromJsonStringToList((String)decisionListStr, DecisionOption.class);
        if (WfUtils.isEmpty((String)desionNumber)) {
            this.initNoDesionNumberComments(auditComments, decisionList);
        } else {
            this.initDesionNumberComments(auditComments, decisionList, desionNumber);
        }
    }

    private void initDesionNumberComments(List<AuditComment> auditComments, List<DecisionOption> decisionList, String desionNumber) {
        String commentType = "approve";
        for (DecisionOption decisionOption : decisionList) {
            if (!desionNumber.equals(decisionOption.getNumber())) continue;
            commentType = decisionOption.getAuditType();
            break;
        }
        String flexpanelap = CONSENTFLEXPANELAP;
        String entryEntity = CONSENTENTRYENTITY;
        String textField = CONSENTTEXTFIELD;
        if ("reject".equals(commentType)) {
            flexpanelap = REJECTFLEXPANELAP;
            entryEntity = REJECTENTRYENTITY;
            textField = REJECTTEXTFIELD;
        } else if ("terminate".equals(commentType)) {
            flexpanelap = TERMINATIONFLEXPANELAP;
            entryEntity = TERMINATIONENTRYENTITY;
            textField = TERMINATIONTEXTFIELD;
        }
        ArrayList<String> auditCommentList = new ArrayList<String>(auditComments.size());
        if (auditComments.isEmpty()) {
            DynamicObject[] dynamicObjects;
            QFilter qDecisionType = new QFilter("decisiontype", "=", (Object)commentType);
            QFilter qEnable = new QFilter("enable", "=", (Object)Boolean.TRUE);
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"wf_commonauditcommenttree", (String)"name", (QFilter[])new QFilter[]{qDecisionType, qEnable}, (String)"number")) {
                String auditName = dynamicObject.getString("name");
                auditCommentList.add(auditName);
            }
        } else {
            ArrayList<Long> auditCommentIdList = new ArrayList<Long>(auditComments.size());
            for (AuditComment auditComment : auditComments) {
                String[] decisionArr;
                HashSet<String> decisionSet;
                String decision = auditComment.getDecision();
                if (WfUtils.isEmpty((String)decision) || !(decisionSet = new HashSet<String>(Arrays.asList(decisionArr = decision.split(",")))).contains(desionNumber)) continue;
                auditCommentIdList.add(auditComment.getBasedataid());
            }
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", auditCommentIdList)};
            DynamicObject[] auditCommentDynamicObject = BusinessDataServiceHelper.load((String)"wf_commonauditcommenttree", (String)"name,id", (QFilter[])filters);
            HashMap<Long, String> auditCommentMap = new HashMap<Long, String>(auditCommentDynamicObject.length);
            for (DynamicObject dynamicObject : auditCommentDynamicObject) {
                auditCommentMap.put(dynamicObject.getLong("id"), dynamicObject.getString("name"));
            }
            for (Long auditCommentId : auditCommentIdList) {
                auditCommentList.add((String)auditCommentMap.get(auditCommentId));
            }
        }
        this.setValueForEntryEntity(auditCommentList, flexpanelap, entryEntity, textField, true);
    }

    private void initNoDesionNumberComments(List<AuditComment> auditCommentList, List<DecisionOption> decisionList) {
        ArrayList<String> consentAuditComments = new ArrayList<String>(auditCommentList.size());
        ArrayList<String> rejectAuditComments = new ArrayList<String>(auditCommentList.size());
        ArrayList<String> terminationAuditComments = new ArrayList<String>(auditCommentList.size());
        ArrayList<Long> auditCommentIdList = new ArrayList<Long>(auditCommentList.size());
        HashMap<Long, String> auditCommentMap = new HashMap<Long, String>(auditCommentList.size());
        for (AuditComment auditComment : auditCommentList) {
            auditCommentIdList.add(auditComment.getBasedataid());
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", auditCommentIdList)};
        DynamicObject[] auditCommentDynamicObjectArray = BusinessDataServiceHelper.load((String)"wf_commonauditcommenttree", (String)"id,name", (QFilter[])filters);
        for (DynamicObject auditCommentDynamicObject : auditCommentDynamicObjectArray) {
            auditCommentMap.put(auditCommentDynamicObject.getLong("id"), auditCommentDynamicObject.getString("name"));
        }
        block12: for (AuditComment auditComment : auditCommentList) {
            String decisionNumber = auditComment.getDecision();
            if (WfUtils.isNotEmpty((String)decisionNumber)) {
                decisionNumber = WfUtils.isNotEmpty((String)decisionNumber.split(",")[0]) ? decisionNumber.split(",")[0] : decisionNumber.split(",")[1];
            }
            for (DecisionOption decision : decisionList) {
                boolean flag = false;
                if (decision.getNumber().equals(decisionNumber)) {
                    switch (decision.getAuditType()) {
                        case "approve": {
                            consentAuditComments.add((String)auditCommentMap.get(auditComment.getBasedataid()));
                            break;
                        }
                        case "reject": {
                            rejectAuditComments.add((String)auditCommentMap.get(auditComment.getBasedataid()));
                            break;
                        }
                        case "terminate": {
                            terminationAuditComments.add((String)auditCommentMap.get(auditComment.getBasedataid()));
                            break;
                        }
                    }
                    flag = true;
                }
                if (!flag) continue;
                continue block12;
            }
        }
        if (auditCommentList.isEmpty() && WfConfigurationUtil.enableGetCommentFromBasedata()) {
            QFilter qEnable = new QFilter("enable", "=", (Object)Boolean.TRUE);
            if (consentAuditComments.isEmpty()) {
                DynamicObject[] dynamicObjects;
                QFilter qDecisionType = new QFilter("decisiontype", "=", (Object)"approve");
                for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"wf_commonauditcommenttree", (String)"name", (QFilter[])new QFilter[]{qDecisionType, qEnable}, (String)"number")) {
                    String auditName = dynamicObject.getString("name");
                    consentAuditComments.add(auditName);
                }
            }
            if (rejectAuditComments.isEmpty()) {
                DynamicObject[] dynamicObjects;
                QFilter qDecisionType = new QFilter("decisiontype", "=", (Object)"reject");
                for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"wf_commonauditcommenttree", (String)"name", (QFilter[])new QFilter[]{qDecisionType, qEnable}, (String)"number")) {
                    String auditName = dynamicObject.getString("name");
                    rejectAuditComments.add(auditName);
                }
            }
            if (terminationAuditComments.isEmpty()) {
                DynamicObject[] dynamicObjects;
                QFilter qDecisionType = new QFilter("decisiontype", "=", (Object)"terminate");
                for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"wf_commonauditcommenttree", (String)"name", (QFilter[])new QFilter[]{qDecisionType, qEnable}, (String)"number")) {
                    String auditName = dynamicObject.getString("name");
                    terminationAuditComments.add(auditName);
                }
            }
        }
        this.setValueForEntryEntity(consentAuditComments, CONSENTFLEXPANELAP, CONSENTENTRYENTITY, CONSENTTEXTFIELD, false);
        this.setValueForEntryEntity(rejectAuditComments, REJECTFLEXPANELAP, REJECTENTRYENTITY, REJECTTEXTFIELD, false);
        this.setValueForEntryEntity(terminationAuditComments, TERMINATIONFLEXPANELAP, TERMINATIONENTRYENTITY, TERMINATIONTEXTFIELD, false);
    }

    private void setValueForEntryEntity(List<String> auditComments, String flexpanelap, String entryEntity, String textField, boolean isDesionNumber) {
        if (auditComments == null || auditComments.isEmpty()) {
            if (isDesionNumber) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonApprovalCommentPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{flexpanelap});
        IDataModel model = this.getModel();
        model.deleteEntryData(entryEntity);
        model.batchCreateNewEntryRow(entryEntity, auditComments.size());
        for (int i = 0; i < auditComments.size(); ++i) {
            model.setValue(textField, (Object)auditComments.get(i), i);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        AbstractGrid grid = (AbstractGrid)evt.getSource();
        IDataModel model = grid.getModel();
        int row = evt.getRow();
        ILocaleString rtData = null;
        String contextKey = null;
        String entityKey = grid.getEntryState().getKey();
        if (entityKey.contains("consent")) {
            contextKey = CONSENTTEXTFIELD;
        } else if (entityKey.contains("reject")) {
            contextKey = REJECTTEXTFIELD;
        } else if (entityKey.contains("termination")) {
            contextKey = TERMINATIONTEXTFIELD;
        }
        if (row >= 0 || WfUtils.isEmpty((String)contextKey)) {
            rtData = (ILocaleString)model.getValue(contextKey, row);
        }
        this.getView().returnDataToParent((Object)rtData);
        this.getView().close();
    }
}

