/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.udlayout;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.management.plugin.ApprovalPageTpl;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class WorkflowRejectSettingPlugin
extends ApprovalPageTpl {
    private static final long serialVersionUID = 3094735952032901681L;
    protected static final String REJECTDECISIONCOMBOFIELD = "rejectdecisioncombofield";
    protected static final String REJECTNODECOMBOFIELD = "rejectnodecombofield";
    protected static final String FLEXPANEL_BACKTONODE = "backtonodepanel";
    protected static final String CONFIRM = "confirm";
    protected static final String REJECTBACKTONODE = "rejectbacktonode";

    public void initialize() {
        this.addClickListeners(new String[]{CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String decisionOptionListStr = (String)parameter.getCustomParam("decisionOptionList");
        List decisionOptionList = SerializationUtils.fromJsonStringToList((String)decisionOptionListStr, DecisionOption.class);
        String auditNumber = (String)parameter.getCustomParam("auditNumber");
        this.getPageCache().put("processInstanceId", (String)parameter.getCustomParam("processInstanceId"));
        this.getPageCache().put("processDefinitionId", (String)parameter.getCustomParam("processDefinitionId"));
        this.getPageCache().put("taskDefinitionKey", (String)parameter.getCustomParam("taskDefinitionKey"));
        this.getPageCache().put("businesskey", (String)parameter.getCustomParam("businesskey"));
        this.getPageCache().put("taskId", (String)parameter.getCustomParam("taskId"));
        Boolean isDynamicReject = Boolean.valueOf((String)parameter.getCustomParam("isDynamicReject"));
        String auditType = (String)parameter.getCustomParam("auditType");
        this.showRejectBackToNode(auditType);
        this.initRejectDecision(decisionOptionList, auditNumber, auditType);
        this.initRejectNode((String)parameter.getCustomParam("rejectOptions"));
        this.initRejectNode(auditNumber);
        if (!isDynamicReject.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{REJECTDECISIONCOMBOFIELD, REJECTNODECOMBOFIELD});
        }
    }

    private void initRejectDecision(List<DecisionOption> decisionOptionList, String auditNumber, String auditType) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        for (DecisionOption decisionOption : decisionOptionList) {
            if (auditType == null || !auditType.equals(decisionOption.getAuditType())) continue;
            String name = decisionOption.getName();
            String id = decisionOption.getNumber();
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(name));
            comboItem.setValue(id);
            comboItems.add(comboItem);
        }
        ComboEdit operation = (ComboEdit)this.getControl(REJECTDECISIONCOMBOFIELD);
        operation.setComboItems(comboItems);
        this.getView().getModel().setValue(REJECTDECISIONCOMBOFIELD, (Object)auditNumber);
    }

    private void initRejectNode(String auditNumber) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String auditType = (String)parameter.getCustomParam("auditType");
        TaskService taskService = this.getTaskService();
        HashMap<String, Object> mapParam = new HashMap<String, Object>();
        mapParam.put("auditType", auditType);
        mapParam.put("auditNumber", auditNumber);
        mapParam.put("isPreAssign", Boolean.TRUE);
        Long processdefinitionid = Long.valueOf(this.getPageCache().get("processDefinitionId"));
        Long processinstanceid = Long.valueOf(this.getPageCache().get("processInstanceId"));
        Long taskid = Long.valueOf(this.getPageCache().get("taskId"));
        BpmnModel bpmnModel = this.getRepositoryService().getBpmnModel(processdefinitionid, processinstanceid);
        FlowElement element = bpmnModel.getFlowElement(this.getPageCache().get("taskDefinitionKey"));
        List<Map<String, Object>> nextUserTaskNodeList = taskService.getNextUserTaskNode((UserTask)((AuditTask)element), this.getPageCache().get("businesskey"), taskid, mapParam);
        if (((AuditTask)element).isDynamicReject()) {
            nextUserTaskNodeList = ApprovalPluginUtil.filterUnFlowThrough(nextUserTaskNodeList, Long.valueOf(this.getPageCache().get("processInstanceId")), this.getHistoryService());
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        if (nextUserTaskNodeList.isEmpty()) {
            String nextNodeText = ResManager.loadKDString((String)"\u5f85\u5b9a\uff08\u65e0\u4e0b\u4e00\u6b65\u8282\u70b9\uff09", (String)"AbstractApprovalPageUDPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(nextNodeText));
            comboItem.setValue("reason");
            comboItems.add(comboItem);
        } else {
            for (Map map : nextUserTaskNodeList) {
                ComboItem comboItem;
                FlowElement nextNodeFlowelement = (FlowElement)map.get("nextNode");
                if (nextNodeFlowelement != null) {
                    comboItem = new ComboItem();
                    comboItem.setCaption(new LocaleString(nextNodeFlowelement.getName()));
                    comboItem.setValue(nextNodeFlowelement.getId());
                    comboItems.add(comboItem);
                    continue;
                }
                if (map.get("nextNodeId") == null) continue;
                comboItem = new ComboItem();
                comboItem.setValue((String)map.get("nextNodeId"));
                comboItem.setCaption(map.get("reason") == null ? null : new LocaleString((String)map.get("reason")));
                comboItems.add(comboItem);
            }
        }
        ComboEdit operation = (ComboEdit)this.getControl(REJECTNODECOMBOFIELD);
        operation.setComboItems(comboItems);
        if (!comboItems.isEmpty()) {
            this.getView().getModel().setValue(REJECTNODECOMBOFIELD, (Object)((ComboItem)comboItems.get(0)).getValue());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        if (REJECTDECISIONCOMBOFIELD.equals(propName)) {
            ChangeData[] changeData = e.getChangeSet();
            Object newValue = changeData[0].getNewValue();
            String decisionOptions = this.getView().getParentView().getPageCache().get("decisionOptionList");
            if (WfUtils.isEmpty((String)decisionOptions)) {
                return;
            }
            List decisionOptionList = SerializationUtils.fromJsonStringToList((String)decisionOptions, DecisionOption.class);
            for (DecisionOption decisionOptionOne : decisionOptionList) {
                if (!String.valueOf(newValue).equals(decisionOptionOne.getNumber())) continue;
                this.initRejectNode(decisionOptionOne.getNumber());
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (CONFIRM.equals(key)) {
            String rejectDecisionValue = (String)this.getView().getModel().getValue(REJECTDECISIONCOMBOFIELD);
            if (WfUtils.isEmpty((String)rejectDecisionValue)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u51b3\u7b56\u9879\u3002", (String)"WorkflowRejectSettingPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            String rejectNodeValue = (String)this.getView().getModel().getValue(REJECTNODECOMBOFIELD);
            if (WfUtils.isEmpty((String)rejectNodeValue)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u9a73\u56de\u8282\u70b9\u3002", (String)"WorkflowRejectSettingPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("auditNumber", rejectDecisionValue);
            returnMap.put("rejectNode", rejectNodeValue);
            this.getView().getParentView().getPageCache().put("showRejectBackToNode", String.valueOf(this.getModel().getValue(REJECTBACKTONODE)));
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    protected void showRejectBackToNode(String auditType) {
        Boolean showRejectBackToNode = Boolean.FALSE;
        Long processDefinitionId = WfUtils.normalizeId((String)this.getPageCache().get("processDefinitionId"));
        Long processInstanceId = WfUtils.normalizeId((String)this.getPageCache().get("processInstanceId"));
        String srcNodeId = this.getPageCache().get("taskDefinitionKey");
        RepositoryService repositoryService = WfUtils.getWfService().getRepositoryService();
        BpmnModel bpmnModel = repositoryService.getBpmnModel(processDefinitionId, processInstanceId);
        Map models = bpmnModel.getMainProcess().getForkJoinModels();
        AuditTask auditTask = this.getAuditTaskElements();
        if (null != auditTask && auditTask.isAllowRejectAndGoBack() && (!(auditTask instanceof YunzhijiaTask) && "reject".equals(auditType) || auditTask instanceof YunzhijiaTask && "forceReject".equals(auditType)) && models != null && models.get(srcNodeId) != null && ((NodeForkJoinModel)models.get(srcNodeId)).getLatestJoinNode() == null && ((NodeForkJoinModel)models.get(srcNodeId)).getLatestForkNode() == null && !((NodeForkJoinModel)models.get(srcNodeId)).isJoinNode()) {
            showRejectBackToNode = Boolean.TRUE;
        }
        this.getView().setVisible(showRejectBackToNode, new String[]{REJECTBACKTONODE});
    }

    @Override
    public String getApprovalPageId() {
        return this.getView().getPageId();
    }

    @Override
    public String getBillPageId() {
        return this.getPageCache().get("billPageId");
    }

    @Override
    public boolean isPCShow() {
        return true;
    }
}

