/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.IFormView;
import kd.bos.form.control.Toolbar;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.mcontrol.MBarItemAp;
import kd.bos.metadata.form.mcontrol.MToolbarAp;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.TaskHandleContext;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.taskcenter.plugin.validate.ApprovalButtonSetting;
import kd.bos.workflow.taskcenter.plugin.validate.ApprovalButtonSettingCustomEvent;

public class ApprovalButtonSettingUtil {
    private static final String MBARITEM_MORE_TITLE = "...";
    private static final String MTOOLBARAPBUTTNOS = "mtoolbarapbuttnos";
    private static final String MBARITEM_MORE = "mbaritem_more";
    private static final String BTNVIEWFLOWCHART = "btnviewflowchart";
    private static final String BTNPRECOMPUTATOR = "btnprecomputator";

    public static ApprovalButtonSettingCustomEvent fireCustomEvent(String scene, Map<String, List<ApprovalButtonSetting>> buttonSettingMap, IFormView view) {
        if (null == buttonSettingMap || buttonSettingMap.isEmpty()) {
            return null;
        }
        ApprovalButtonSettingCustomEvent args = new ApprovalButtonSettingCustomEvent(view, "approvalbuttonsettingcustomevent", "approvalbuttonsettingcustomevent", null, scene, buttonSettingMap);
        FormViewPluginProxy proxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent((CustomEventArgs)args);
        return args;
    }

    public static void setApprovalButtonSettingForMBarItem(List<ApprovalButtonSetting> settingList, StringBuilder btnkeys, String businessScene, String title, String key, String backColor, String foreColor, String imageKeyUrl) {
        ApprovalButtonSetting setting = ApprovalButtonSettingUtil.setApprovalButtonSettingForMBarItem(title, key, backColor, foreColor, businessScene);
        setting.setImageKey(imageKeyUrl);
        if (BTNVIEWFLOWCHART.equals(key) || BTNPRECOMPUTATOR.equals(key)) {
            setting.setImgHeight("28px");
            setting.setImgWidth("28px");
        } else {
            setting.setImgHeight("18px");
            setting.setImgWidth("18px");
        }
        settingList.add(setting);
        btnkeys.append(key.toLowerCase()).append(',');
    }

    public static void setApprovalButtonSettingForDropdownItem(List<ApprovalButtonSetting> settingList, StringBuilder btnkeys, String parientKey, String businessScene, String key, String title, String imageKeyUrl) {
        ApprovalButtonSetting setting = ApprovalButtonSettingUtil.setApprovalButtonSettingForDropdownItem(key, title, imageKeyUrl, parientKey, businessScene);
        settingList.add(setting);
        btnkeys.append(key.toLowerCase()).append(',');
    }

    public static void setApprovalButtonSettingForMBarItem(List<ApprovalButtonSetting> settingList, StringBuilder btnkeys, String businessScene, String title, String key, String backColor, String foreColor) {
        ApprovalButtonSetting setting = ApprovalButtonSettingUtil.setApprovalButtonSettingForMBarItem(title, key, backColor, foreColor, businessScene);
        settingList.add(setting);
        btnkeys.append(key.toLowerCase()).append(',');
    }

    public static void addDynamicApprovalButtonSettingForMob(ApprovalButtonSettingCustomEvent settingCustomEvent, String defaultToolbarKey, IFormView view) {
        Map<String, List<ApprovalButtonSetting>> buttonSettingMap = settingCustomEvent.getButtonSettingMap();
        if (null == buttonSettingMap || buttonSettingMap.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, List<ApprovalButtonSetting>>> ite = buttonSettingMap.entrySet().iterator();
        Map.Entry<String, List<ApprovalButtonSetting>> entry = null;
        MToolbarAp mToolbarAp = null;
        String replaceTargetKey = null;
        List<ApprovalButtonSetting> settings = null;
        MBarItemAp itemAp = null;
        DropdownItem dropdownItem = null;
        String title = MBARITEM_MORE_TITLE;
        String backColor = view.getPageCache().get("backColorForDynBtn");
        String foreColor = view.getPageCache().get("forColorForDynBtn");
        String parentKey = null;
        HashMap<String, MBarItemAp> parentControl = new HashMap<String, MBarItemAp>();
        ApprovalButtonSetting parentSetting = null;
        String tempMToolbarKey = null;
        int index = 0;
        boolean hideDefaultToolbar = true;
        boolean modified = settingCustomEvent.isModified();
        while (ite.hasNext()) {
            entry = ite.next();
            if (null == entry || null == (settings = entry.getValue()) || settings.isEmpty()) continue;
            dropdownItem = null;
            mToolbarAp = new MToolbarAp();
            tempMToolbarKey = MTOOLBARAPBUTTNOS + index;
            mToolbarAp.setKey(tempMToolbarKey);
            if (modified) {
                Collections.sort(settings, new Comparator<ApprovalButtonSetting>(){

                    @Override
                    public int compare(ApprovalButtonSetting o1, ApprovalButtonSetting o2) {
                        if (null == o1 || null == o2) {
                            return 0;
                        }
                        return o1.getSeq() - o2.getSeq();
                    }
                });
            }
            for (ApprovalButtonSetting setting : settings) {
                if (null == setting) continue;
                if (!setting.isDropdownItem()) {
                    parentKey = setting.getKey();
                    if (parentControl.containsKey(parentKey)) continue;
                    itemAp = ApprovalButtonSettingUtil.revertMBarItem(setting);
                    mToolbarAp.getItems().add(itemAp);
                    if (WfUtils.isNotEmpty((String)itemAp.getImageKey())) {
                        mToolbarAp.setItemStyle(3);
                    }
                    parentControl.put(parentKey, itemAp);
                    continue;
                }
                dropdownItem = ApprovalButtonSettingUtil.revertDropdownItem(setting);
                parentKey = setting.getParentKey();
                if (null == parentKey) {
                    parentKey = MBARITEM_MORE;
                }
                if (parentControl.containsKey(parentKey)) {
                    ((MBarItemAp)parentControl.get(parentKey)).getDropdownItems().add(dropdownItem);
                    continue;
                }
                parentSetting = ApprovalButtonSettingUtil.getTargetSetting(settings, parentKey);
                itemAp = null != parentSetting ? ApprovalButtonSettingUtil.revertMBarItem(parentSetting) : ApprovalButtonSettingUtil.setMBarItem(title, parentKey, backColor, foreColor);
                itemAp.getDropdownItems().add(dropdownItem);
                mToolbarAp.getItems().add(itemAp);
                parentControl.put(itemAp.getKey(), itemAp);
            }
            replaceTargetKey = entry.getKey();
            if (null == replaceTargetKey || replaceTargetKey.isEmpty()) {
                replaceTargetKey = defaultToolbarKey;
            }
            if (hideDefaultToolbar && defaultToolbarKey.equals(replaceTargetKey)) {
                hideDefaultToolbar = false;
            }
            view.updateControlMetadata(replaceTargetKey, mToolbarAp.createControl());
            ++index;
        }
        if (hideDefaultToolbar) {
            view.setVisible(Boolean.FALSE, new String[]{defaultToolbarKey});
        }
    }

    private static MBarItemAp setMBarItem(String title, String key, String backColor, String foreColor) {
        MBarItemAp itemAp = new MBarItemAp();
        itemAp.setName(new LocaleString(title));
        itemAp.setId(key);
        itemAp.setKey(key);
        itemAp.setHeight(new LocaleString("100%"));
        itemAp.setButtonStyle(1);
        itemAp.setRadius("0");
        itemAp.setBackColor(backColor);
        itemAp.setForeColor(foreColor);
        return itemAp;
    }

    private static ApprovalButtonSetting getTargetSetting(List<ApprovalButtonSetting> settings, String targetKey) {
        if (null == settings || settings.isEmpty()) {
            return null;
        }
        ApprovalButtonSetting targetSetting = null;
        for (ApprovalButtonSetting setting : settings) {
            if (null == setting || !targetKey.equals(setting.getKey())) continue;
            targetSetting = setting;
            break;
        }
        return targetSetting;
    }

    private static DropdownItem revertDropdownItem(ApprovalButtonSetting setting) {
        if (null == setting) {
            return null;
        }
        DropdownItem item = new DropdownItem();
        item.setKey(setting.getKey());
        item.setTitle(setting.getTitle());
        return item;
    }

    private static MBarItemAp revertMBarItem(ApprovalButtonSetting setting) {
        if (null == setting) {
            return null;
        }
        MBarItemAp itemAp = new MBarItemAp();
        itemAp.setName(setting.getTitle());
        itemAp.setId(setting.getKey());
        itemAp.setKey(setting.getKey());
        itemAp.setHeight(setting.getHeight());
        itemAp.setButtonStyle(setting.getBtnStyle());
        itemAp.setRadius(setting.getRadius());
        itemAp.setBackColor(setting.getBackColor());
        itemAp.setForeColor(setting.getForeColor());
        String imageKeyUrl = setting.getImageKey();
        if (WfUtils.isNotEmpty((String)imageKeyUrl)) {
            itemAp.setImageKey(imageKeyUrl);
            itemAp.setImgHeight(setting.getImgHeight());
            itemAp.setImgWidth(setting.getImgWidth());
        }
        return itemAp;
    }

    private static ApprovalButtonSetting setApprovalButtonSettingForMBarItem(String title, String key, String backColor, String foreColor, String businessScene) {
        ApprovalButtonSetting setting = new ApprovalButtonSetting();
        setting.setTitle(new LocaleString(title));
        setting.setKey(key);
        setting.setHeight(new LocaleString("100%"));
        setting.setBtnStyle(1);
        setting.setRadius("0");
        if (WfUtils.isNotEmpty((String)backColor)) {
            setting.setBackColor(backColor);
        }
        if (WfUtils.isNotEmpty((String)foreColor)) {
            setting.setForeColor(foreColor);
        }
        if (null != businessScene) {
            setting.setBusinessScene(businessScene);
        }
        return setting;
    }

    private static ApprovalButtonSetting setApprovalButtonSettingForDropdownItem(String key, String title, String imageKeyUrl, String parientKey, String businessScene) {
        ApprovalButtonSetting setting = new ApprovalButtonSetting();
        setting.setKey(key);
        setting.setTitle(new LocaleString(title));
        setting.setParentKey(parientKey);
        setting.setBusinessScene(businessScene);
        setting.setDropdownItem(true);
        return setting;
    }

    public static void collectAppBtnSettingForDecision(List<ApprovalButtonSetting> settingList, TaskHandleContext context) {
        if (null == context) {
            return;
        }
        UserTask flowElement = context.getFlowElement();
        if (null == flowElement) {
            return;
        }
        List decisionOptions = flowElement.getDecisionOptions();
        if (decisionOptions == null || decisionOptions.isEmpty()) {
            return;
        }
        TaskInfo taskInfo = context.getTask();
        if (null == taskInfo) {
            return;
        }
        Long processInstanceId = taskInfo.getProcessInstanceId();
        for (DecisionOption dec : decisionOptions) {
            String multiKey = BpmnModelUtil.getDecisionNameMultiKey((String)flowElement.getId(), (String)dec.getId());
            ILocaleString decisionName = BpmnModelUtil.getMultiLangFieldValue((Long)processInstanceId, (String)multiKey, (String)dec.getName());
            ApprovalButtonSettingUtil.setApprovalButtonSetting(settingList, dec.getAuditType(), dec.getNumber(), (LocaleString)decisionName);
        }
    }

    public static void setApprovalButtonSetting(List<ApprovalButtonSetting> settingList, String businessScene, String key, LocaleString title) {
        ApprovalButtonSettingUtil.setApprovalButtonSetting(settingList, businessScene, key, title, null);
    }

    public static void setApprovalButtonSetting(List<ApprovalButtonSetting> settingList, String businessScene, String key, LocaleString title, String parentKey) {
        ApprovalButtonSetting setting = new ApprovalButtonSetting();
        setting.setBusinessScene(businessScene);
        setting.setKey(key);
        setting.setTitle(title);
        if (null != parentKey) {
            setting.setParentKey(parentKey);
            setting.setDropdownItem(true);
        } else {
            setting.setOperationStyle(1);
        }
        settingList.add(setting);
    }

    public static void addDynamicApprovalButtonSettingForPC(ApprovalButtonSettingCustomEvent settingCustomEvent, String toolKey, IFormView view) {
        StringBuilder controlKeys = new StringBuilder();
        view.setVisible(Boolean.FALSE, new String[]{toolKey});
        Map<String, List<ApprovalButtonSetting>> buttonSettingMap = settingCustomEvent.getButtonSettingMap();
        Set<Map.Entry<String, List<ApprovalButtonSetting>>> buttonSettingEntrySets = buttonSettingMap.entrySet();
        for (Map.Entry<String, List<ApprovalButtonSetting>> buttonSetting : buttonSettingEntrySets) {
            String key = buttonSetting.getKey();
            if (!(view.getControl(key) instanceof Toolbar)) continue;
            List<ApprovalButtonSetting> buttonSettingList = buttonSetting.getValue();
            Collections.sort(buttonSettingList, new Comparator<ApprovalButtonSetting>(){

                @Override
                public int compare(ApprovalButtonSetting o1, ApprovalButtonSetting o2) {
                    return o1.getSeq() - o2.getSeq();
                }
            });
            HashMap sonButtonMap = new HashMap(buttonSettingList.size());
            ArrayList<ApprovalButtonSetting> parentButtonList = new ArrayList<ApprovalButtonSetting>(buttonSettingList.size());
            for (ApprovalButtonSetting approvalButtonSetting : buttonSettingList) {
                String parientKey = approvalButtonSetting.getParentKey();
                if (WfUtils.isEmpty((String)parientKey)) {
                    parentButtonList.add(approvalButtonSetting);
                    continue;
                }
                List<ApprovalButtonSetting> sonButtonList = sonButtonMap.get(parientKey) == null ? new ArrayList() : (List)sonButtonMap.get(parientKey);
                sonButtonList.add(approvalButtonSetting);
                sonButtonMap.put(parientKey, sonButtonList);
            }
            ArrayList<Map> items = new ArrayList<Map>();
            for (ApprovalButtonSetting parentButton : parentButtonList) {
                String parentKey = parentButton.getKey();
                BarItemAp itemAp = ApprovalButtonSettingUtil.getBarItemAp(parentButton.getTitle().toString(), parentKey, parentKey);
                itemAp.setHeight(parentButton.getHeight());
                itemAp.setButtonStyle(parentButton.getBtnStyle());
                itemAp.setRadius(parentButton.getRadius());
                itemAp.setBackColor(parentButton.getBackColor());
                itemAp.setForeColor(parentButton.getForeColor());
                itemAp.setOperationStyle(parentButton.getOperationStyle());
                List sonButtonList = (List)sonButtonMap.get(parentKey);
                if (null == sonButtonList || sonButtonList.isEmpty()) {
                    items.add(itemAp.createControl());
                    continue;
                }
                for (ApprovalButtonSetting sonButton : sonButtonList) {
                    DropdownItem item = new DropdownItem();
                    item.setKey(sonButton.getKey());
                    item.setTitle(sonButton.getTitle());
                    itemAp.getDropdownItems().add(item);
                }
                items.add(itemAp.createControl());
            }
            Toolbar toolbar = (Toolbar)view.getControl(key);
            toolbar.addControls(items);
            controlKeys.append(key).append(",");
        }
        if (WfUtils.isNotEmptyString((Object)controlKeys)) {
            view.getPageCache().put("addControlKeys", controlKeys.toString());
        }
    }

    public static BarItemAp getBarItemAp(String btnName, String btnId, String btnKey) {
        BarItemAp itemAp = new BarItemAp();
        itemAp.setName(new LocaleString(btnName));
        itemAp.setId(btnId);
        itemAp.setKey(btnKey);
        itemAp.setButtonStyle(1);
        itemAp.setRadius("0");
        return itemAp;
    }
}

