/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.ca.SignService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ca.SignScheme;
import kd.bos.entity.ca.VerifySignInfo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.ClientMethodResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.SignCallbackEvent;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.MenuItem;
import kd.bos.form.control.Toolbar;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.SignOperateCallback;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.utils.personalSetting.MessageBussinessInfo;
import kd.bos.message.utils.personalSetting.MessageBussinessPublishUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ca.SignServiceHelper;
import kd.bos.util.Pair;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BillSetting;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.SensitiveFieldInfo;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.component.approvalrecord.ApprovalAttachmentInfo;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.design.plugin.nodetemplatelibrary.util.NodeTemplateLibraryUtil;
import kd.bos.workflow.engine.BillPagePluginUtil;
import kd.bos.workflow.engine.HistoryService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.bpmn.helper.nodetemplate.NodeTemplateUtil;
import kd.bos.workflow.engine.impl.cmd.task.AgentTaskHandleContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;
import kd.bos.workflow.engine.impl.util.SignatureUtils;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.util.MessageUtils;
import kd.bos.workflow.engine.task.Task;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.exception.WFBizOperationException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.management.plugin.WFBillSummaryUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.taskcenter.plugin.util.SignServiceUtil;
import kd.bos.workflow.taskcenter.plugin.validate.AddPersonFiltersCustomEvent;
import kd.bos.workflow.taskcenter.plugin.validate.IApprovalSubPlugin;
import kd.bos.workflow.taskcenter.plugin.validate.RequiredValidator;
import kd.bos.workflow.util.WfCommonUtil;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.math.NumberUtils;

public class ApprovalPluginUtil {
    private static Log logger = LogFactory.getLog(ApprovalPluginUtil.class);
    private static final String WF_MOBILELIST_MOB = "wf_mobilelist_mob";
    public static final String DEVICE = "device";
    public static final String FROMYZJ = "fromyzj";
    private static final String OPERATION = "operation";
    public static final String MUSTINPUTFORAPPROVALMSG = "mustInputForApprovalMsg";
    public static final String AUDITTYPE_BILLSAVE = "audittype_billsave";
    public static final String TASKENTITY = "taskEntity";
    public static final String ONLYVIEW = "onlyView";
    public static final String TYPE = "TYPE";
    public static final String BILLSUMMARY = "billSummary";
    public static final String RETURN_DATA_USERID = "returnDataUserId";
    public static final String RETURN_DATA_USERNAME = "returnDataUserName";
    public static final String AVATAR = "avatar";
    public static final String ERRORTIPS = "errorTips";
    private static final String WFSENSITIVECALLBACKFLAG = "WfSensitiveCallBackFlag";
    public static final String DATASIGNEDVERIFY = "dataSignedVerify";
    public static final String DATASIGNEDADD = "dataSignedAdd";
    public static final String KEY_DELETASKRECALL = "deleTaskRecall";
    public static final String KEY_DELETASKRECALLTRANSFER = "deleTaskRecallTransfer";
    public static final String KEY_TRANDELETASKRECALL = "tranDeleTaskRecall";
    public static final String KEY_COODELETASKRECALL = "cooDeleTaskRecall";
    public static final String KEY_ADDSIGNDELETASKRECALL = "addsignDeleTaskRecall";
    public static final String KEY_SUBMITDELETASKRECALL = "submitDeleTaskRecall";
    public static final String CATEGORY = "category";
    public static final String PROCESSINSTANCEID = "processInstanceId";
    public static final String PROCESSDEFINITIONID = "processDefinitionId";
    public static final String TASKDEFINITIONKEY = "taskdefinitionkey";
    private static final String CREDIT_CONTROL = "creditcontrol_ssc".split("_")[0];

    public static StringBuilder getAssignNodeNames(String nodeNames) {
        StringBuilder nodeNameBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)nodeNames)) {
            Map nextNodeObject = (Map)SerializationUtils.fromJsonString((String)nodeNames, Map.class);
            for (Map.Entry entry : nextNodeObject.entrySet()) {
                String nodeName = (String)entry.getValue();
                nodeNameBuilder.append(nodeName);
                nodeNameBuilder.append('\uff0c');
            }
            nodeNameBuilder.deleteCharAt(nodeNameBuilder.length() - 1);
        }
        return nodeNameBuilder;
    }

    public static void showMobileFormByClickEvent(ShowType showType, String formId, Map<String, Object> customParam, String captain, String pluginName, String callBackId, IFormView formView) {
        MobileFormShowParameter para_base = new MobileFormShowParameter();
        para_base.getOpenStyle().setShowType(showType);
        para_base.setFormId(formId);
        if (null != customParam) {
            para_base.setCustomParams(customParam);
        }
        if (null != captain) {
            para_base.setCaption(captain);
        }
        if (null != callBackId) {
            para_base.setCloseCallBack(new CloseCallBack(pluginName, callBackId));
        }
        formView.showForm((FormShowParameter)para_base);
    }

    public static void showAfterClosePage(IFormView formView) {
        Map customParams = formView.getFormShowParameter().getCustomParams();
        logger.info("ApprovalPluginUtil.showAfterClosePage begin and customParams:" + customParams);
        if (ApprovalPluginUtil.isExpectValueFromParams(customParams, "closeType", "closeWin")) {
            ApprovalPluginUtil.closeExploreWindow(formView);
            return;
        }
        Object device = customParams.get(DEVICE);
        if (null != device) {
            Object fromyzj = customParams.get(FROMYZJ);
            if (WfUtils.isNotEmptyString(fromyzj) && Boolean.parseBoolean(fromyzj.toString()) || "yunzhijiaup".equals(customParams.get("apptype"))) {
                if (WfConfigurationUtil.getReturnToYjzTodo() && "phone".equals((String)customParams.get("source"))) {
                    ApprovalPluginUtil.closeExploreWindow(formView);
                } else {
                    ApprovalPluginUtil.showProcessAssistantPage(formView);
                }
            } else {
                ApprovalPluginUtil.closeExploreWindow(formView);
            }
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            Object searchMap = customParams.get("searchmap");
            if (!(searchMap instanceof Map) || ((Map)searchMap).isEmpty()) {
                map.put(OPERATION, "refresh");
            } else {
                map.put(OPERATION, "search");
                map.put("data", (String)searchMap);
            }
            formView.returnDataToParent(map);
            String approvalScene = formView.getPageCache().get("approvalScene");
            if (WfUtils.isEmpty((String)approvalScene)) {
                formView.getPageCache().put("approvalScene", "true");
            } else if ("false".equals(approvalScene)) {
                formView.getPageCache().remove("approvalScene");
            }
            formView.close();
        }
    }

    public static void closeExploreWindow(IFormView formView) {
        logger.debug("ApprovalPluginUtil.closeExploreWindow pageid:" + formView.getPageId());
        HashMap<String, String> arg = new HashMap<String, String>();
        arg.put("pageId", formView.getPageId());
        ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("closeExploreWindow", arg);
    }

    public static void showApprovalMobSuccessPage(String successInfo, String successDetailInfo, IFormView formView) {
        formView.showSuccessNotification(ApprovalPluginUtil.getSuccessTips(successInfo, successDetailInfo));
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        formView.close();
    }

    public static void showApprovalMobSuccessPage(String successInf, IFormView formView) {
        formView.showSuccessNotification(successInf);
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        formView.close();
    }

    public static String getSuccessTips(String successInfo, String successDetailInfo) {
        return String.format(ResManager.loadKDString((String)"%1$s\u6210\u529f%2$s", (String)"ApprovalPluginUtil_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), successInfo, WfUtils.isEmptyString((Object)successDetailInfo) ? "\u3002" : "\uff1a" + successDetailInfo);
    }

    public static void showProcessAssistantPage(IFormView formView) {
        MobileFormShowParameter para_base = new MobileFormShowParameter();
        para_base.getOpenStyle().setShowType(ShowType.ReplaceHomePage);
        para_base.setFormId(WF_MOBILELIST_MOB);
        formView.executeClientCommand("setCaption", new Object[]{ResManager.loadKDString((String)"\u5f85\u529e\u4efb\u52a1", (String)"ApprovalPluginUtil_11", (String)"bos-wf-formplugin", (Object[])new Object[0])});
        Object searchMap = formView.getFormShowParameter().getCustomParam("searchmap");
        if (searchMap instanceof Map && !((Map)searchMap).isEmpty()) {
            para_base.setCustomParam("searchmap", searchMap);
        }
        formView.showForm((FormShowParameter)para_base);
    }

    public static String showWithdrawFunc(String type, Long taskId, Long executionId, IFormView formView) {
        try {
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            logger.debug("showWithdrawFunc type:" + type + ";taskId:" + taskId + ";executionId:" + executionId);
            if ("handled".equals(type)) {
                return ApprovalPluginUtil.doWithdrawForHandled(wfService, taskId, formView);
            }
            if ("toApply".equals(type)) {
                return ApprovalPluginUtil.doWithdrawForToApply(wfService, executionId, formView);
            }
        }
        catch (KDException e) {
            formView.showTipNotification(e.getMessage(), Integer.valueOf(3000));
        }
        return null;
    }

    private static String doWithdrawForToApply(WorkflowService wfService, Long executionId, IFormView formView) {
        wfService.getTaskService().withdrawTask(null, executionId);
        return ResManager.loadKDString((String)"\u6d41\u7a0b\u64a4\u9500\u6210\u529f\u3002", (String)"ApprovalPluginUtil_6", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    }

    private static String doWithdrawForHandled(WorkflowService wfService, Long taskId, IFormView formView) {
        TaskService taskService = wfService.getTaskService();
        taskService.withdrawTask(taskId, null);
        return ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u6210\u529f\u64a4\u56de\u3002", (String)"ApprovalPluginUtil_12", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    }

    public static void hideBillControls(BillView billView) {
        ApprovalPluginUtil.hideFormControls((FormView)billView);
    }

    public static void hideFormControls(FormView formView) {
        ApprovalPluginUtil.hideFormControls(formView, false);
    }

    public static void hideBillControls(BillView billView, boolean isOnleHideEntryBtn) {
        ApprovalPluginUtil.hideFormControls((FormView)billView, isOnleHideEntryBtn);
    }

    public static void hideFormControls(FormView billView, boolean isOnleHideEntryBtn) {
        List items = billView.getRootControl().getItems();
        if (0 != items.size()) {
            ArrayList<Control> controlsForBtn = new ArrayList<Control>();
            ArrayList<Control> controlsForCardEntryBtn = new ArrayList<Control>();
            ApprovalPluginUtil.getAllDefaultHideControlsByView(items, controlsForBtn, controlsForCardEntryBtn, Boolean.FALSE, null);
            if (0 != controlsForBtn.size() && !isOnleHideEntryBtn) {
                for (Control control : controlsForBtn) {
                    ApprovalPluginUtil.setHideControl(billView, control.getKey());
                }
            }
            if (0 != controlsForCardEntryBtn.size()) {
                for (Control control : controlsForCardEntryBtn) {
                    String[] controlKeys = control.getKey().split("\\.");
                    ApprovalPluginUtil.setControlVisibleForCardEntry((IFormView)billView, controlKeys[0], false, controlKeys[1]);
                }
            }
        }
    }

    private static void setHideControl(FormView billView, String key) {
        billView.setVisible(Boolean.FALSE, new String[]{key});
    }

    public static void setControlVisibleForCardEntry(IFormView view, String entryKey, boolean isVisible, String ... ctlKeys) {
        CardEntry cardEntry = (CardEntry)view.getControl(entryKey);
        if (null == cardEntry) {
            return;
        }
        int rowCount = view.getModel().getEntryRowCount(cardEntry.getEntryKey());
        if (0 != rowCount) {
            for (int i = 0; i < rowCount; ++i) {
                cardEntry.setChildVisible(isVisible, i, ctlKeys);
            }
        }
        view.setVisible(Boolean.valueOf(isVisible), ctlKeys);
    }

    private static boolean defaultHide(Control item) {
        Class<?> clazz = item.getClass();
        return Toolbar.class.equals(clazz) || Button.class.equals(clazz) || MenuItem.class.equals(clazz);
    }

    private static void getAllDefaultHideControlsByView(List<Control> items, List<Control> controlsForBtn, List<Control> controlsForCardEntryBtn, Boolean isFromCardEntry, String entryKeyForCardEntry) {
        Container container = null;
        List controlItems = null;
        for (Control control : items) {
            if (Container.class.isAssignableFrom(control.getClass())) {
                if (Toolbar.class.isInstance(control)) {
                    ApprovalPluginUtil.setAllDefaultHideControlsByView(isFromCardEntry, control, entryKeyForCardEntry, controlsForCardEntryBtn, controlsForBtn);
                    continue;
                }
                container = (Container)control;
                controlItems = container.getItems();
                if (0 != controlItems.size()) {
                    if (CardEntry.class.isInstance(control) && WfUtils.isEmpty((String)entryKeyForCardEntry)) {
                        isFromCardEntry = Boolean.TRUE;
                        entryKeyForCardEntry = control.getKey();
                    }
                    ApprovalPluginUtil.getAllDefaultHideControlsByView(controlItems, controlsForBtn, controlsForCardEntryBtn, isFromCardEntry, entryKeyForCardEntry);
                    continue;
                }
                ApprovalPluginUtil.setAllDefaultHideControlsByView(isFromCardEntry, control, entryKeyForCardEntry, controlsForCardEntryBtn, controlsForBtn);
                continue;
            }
            ApprovalPluginUtil.setAllDefaultHideControlsByView(isFromCardEntry, control, entryKeyForCardEntry, controlsForCardEntryBtn, controlsForBtn);
        }
    }

    private static void setAllDefaultHideControlsByView(Boolean isFromCardEntry, Control control, String entryKeyForCardEntry, List<Control> controlsForCardEntryBtn, List<Control> controlsForBtn) {
        if (ApprovalPluginUtil.defaultHide(control)) {
            if (isFromCardEntry.booleanValue()) {
                control.setKey(entryKeyForCardEntry + "." + control.getKey());
                controlsForCardEntryBtn.add(control);
            } else {
                controlsForBtn.add(control);
            }
        }
    }

    public static Map<String, Object> showTaskReminderResult(Long executionId, ILocaleString reminderMsg, String type) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskService taskService = wfService.getTaskService();
        Map returnInfo = taskService.taskReminders(executionId, reminderMsg, type);
        return returnInfo;
    }

    public static Map<String, Object> showTaskReminderResult(Long executionId, ILocaleString reminderMsg, String type, Long taskId) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskService taskService = wfService.getTaskService();
        Map returnInfo = taskService.taskReminders(executionId, reminderMsg, type, taskId);
        return returnInfo;
    }

    public static boolean isExistForFormId(String formId) {
        return BillPagePluginUtil.isExistForFormId((String)formId);
    }

    public static String getTypeFromParams(Map customParams) {
        Object type = customParams.get("type");
        Object wfUnitTest = customParams.get("WFApprovalPageTestPlugin_Type");
        type = !WfUtils.isEmptyString(wfUnitTest) ? wfUnitTest : (WfUtils.isNotEmptyString(type) ? type : "");
        return type.toString();
    }

    public static String getBillPageId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static List<Long> getExistUserIdsForCoordinate(Long taskId) {
        ArrayList<Long> existUserIds = new ArrayList<Long>();
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskService taskService = wfService.getTaskService();
        List entities = taskService.getTaskHandleLogEntitiesByTaskIdAndType(taskId, "coordinate");
        if (null != entities && 0 != entities.size()) {
            Long currentUserId = Long.parseLong(RequestContext.get().getUserId());
            for (TaskHandleLogEntity entity : entities) {
                if (!entity.getOwnerId().equals(currentUserId)) continue;
                existUserIds.add(entity.getAssigneeid());
            }
        }
        return existUserIds;
    }

    public static Map<String, Object> getNotRepeatDataForUser(List<Map<String, Object>> returnDataList, List<Long> existUserIds, List<Long> taskOwnerIds) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        StringBuilder userNames = new StringBuilder();
        StringBuilder userIds = new StringBuilder();
        String errorTips = null;
        StringBuilder userNamesForExist = new StringBuilder();
        Object returnId = null;
        Object returnName = null;
        boolean isExist = null != existUserIds && 0 != existUserIds.size();
        boolean isOwner = null != taskOwnerIds && 0 != taskOwnerIds.size();
        Boolean isExistBreak = null;
        Boolean isOwnerBreak = null;
        char comma = ',';
        for (Map<String, Object> returnDataMap : returnDataList) {
            returnId = returnDataMap.get(RETURN_DATA_USERID);
            returnName = returnDataMap.get(RETURN_DATA_USERNAME);
            if (WfUtils.isNotEmptyString((Object)returnId)) {
                String[] returnUserIds = returnId.toString().split(",");
                String[] returnUserNames = returnName.toString().split(",");
                int i = 0;
                for (String id : returnUserIds) {
                    isExistBreak = Boolean.FALSE;
                    isOwnerBreak = Boolean.FALSE;
                    if (isExist) {
                        for (Long userId : existUserIds) {
                            if (!userId.equals(Long.parseLong(id))) continue;
                            isExistBreak = Boolean.TRUE;
                            break;
                        }
                    }
                    if (isOwner) {
                        for (Long userId : taskOwnerIds) {
                            if (!userId.equals(Long.parseLong(id))) continue;
                            isOwnerBreak = Boolean.TRUE;
                            break;
                        }
                    }
                    if (isExistBreak.booleanValue()) {
                        userNamesForExist.append(returnUserNames[i]).append(comma);
                    } else if (isOwnerBreak.booleanValue()) {
                        userNamesForExist.append(returnUserNames[i]).append(comma);
                    } else {
                        userIds.append(returnUserIds[i]).append(comma);
                        userNames.append(returnUserNames[i]).append(comma);
                    }
                    ++i;
                }
                continue;
            }
            userIds.append(returnId).append(comma);
            userNames.append(returnName).append(comma);
        }
        if (0 != userNamesForExist.length()) {
            errorTips = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u4efb\u52a1\u7684\u53c2\u4e0e\u4eba\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"ApprovalPluginUtil_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), userNamesForExist.substring(0, userNamesForExist.length() - 1));
        }
        data.put(ERRORTIPS, errorTips);
        data.put(RETURN_DATA_USERID, WfUtils.isEmptyString((Object)userIds) ? "" : userIds.substring(0, userIds.length() - 1));
        data.put(RETURN_DATA_USERNAME, WfUtils.isEmptyString((Object)userNames) ? "" : userNames.substring(0, userNames.length() - 1));
        return data;
    }

    public static void showClearEntryEntity(IDataModel model, String entryName, IFormView view) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entrys = (DynamicObjectCollection)dataEntity.get(entryName);
        if (entrys.size() > 0) {
            entrys.clear();
            view.updateView(entryName);
        }
    }

    public static void showMtoolbarStyleForHide(IFormView view, String panelName) {
        JSONObject style = new JSONObject();
        JSONObject margin = new JSONObject();
        margin.put("r", (Object)"");
        margin.put("b", (Object)"11px");
        margin.put("t", (Object)"11px");
        margin.put("l", (Object)"");
        style.put("m", (Object)margin);
        HashMap<String, JSONObject> prop = new HashMap<String, JSONObject>(1);
        prop.put("s", style);
        view.updateControlMetadata(panelName, prop);
    }

    public static List<IApprovalRecordGroup> getApprovalRecordItems(TaskService taskService, Long processInstanceId, String businesskey, String curTaskId, Boolean isNewApprovalRecord) {
        return taskService.queryApprovalRecord(processInstanceId, businesskey, curTaskId, isNewApprovalRecord);
    }

    public static List getOpenIdsForApprovalRecord(List<IApprovalRecordGroup> approvalRecordItems) {
        ArrayList<String> openIds = new ArrayList<String>();
        if (WfUtils.isNotEmptyForCollection(approvalRecordItems)) {
            String openId = null;
            for (IApprovalRecordGroup approvalRecordItem : approvalRecordItems) {
                List children = approvalRecordItem.getChildren();
                for (IApprovalRecordItem child : children) {
                    List trusteeOpenIds;
                    openId = child.getOpenId();
                    if (!WfUtils.isEmptyString((Object)openId) && !openIds.contains(openId)) {
                        openIds.add(openId);
                    }
                    if (!(child instanceof ApprovalRecordItem) || (trusteeOpenIds = ((ApprovalRecordItem)child).getTrusteeOpenIds()) == null || trusteeOpenIds.isEmpty()) continue;
                    openIds.addAll(trusteeOpenIds);
                }
            }
        }
        return openIds;
    }

    public static List getOpenIdsForApprovalRecord(TaskService taskService, Long processInstanceId, String businesskey, String curTaskId, Boolean isNewApprovalRecord) {
        List<IApprovalRecordGroup> approvalRecordItems = ApprovalPluginUtil.getApprovalRecordItems(taskService, processInstanceId, businesskey, curTaskId, isNewApprovalRecord);
        return ApprovalPluginUtil.getOpenIdsForApprovalRecord(approvalRecordItems);
    }

    public static List<Map<String, Object>> getApprovalRecordItemsByParentTaskId(TaskService taskService, Long parenttaskid) {
        return taskService.getApprovalRecordItemsByParentTaskId(parenttaskid);
    }

    private static List getOpenIdsForApprovalRecordReview(List<Map<String, Object>> approvalRecordChildren) {
        ArrayList<Object> openIds = new ArrayList<Object>();
        if (WfUtils.isNotEmptyForCollection(approvalRecordChildren)) {
            Object openId = null;
            for (Map<String, Object> child : approvalRecordChildren) {
                openId = child.get("openId");
                if (WfUtils.isEmptyString((Object)openId) || openIds.contains(openId)) continue;
                openIds.add(openId);
            }
        }
        return openIds;
    }

    public static List getOpenIdsForApprovalRecordReview(TaskService taskService, Long parenttaskid) {
        List<Map<String, Object>> approvalRecordChildren = ApprovalPluginUtil.getApprovalRecordItemsByParentTaskId(taskService, parenttaskid);
        return ApprovalPluginUtil.getOpenIdsForApprovalRecordReview(approvalRecordChildren);
    }

    public static boolean addPluginsForView(String pluginName, IFormView view) {
        try {
            Object plugin;
            Class<?> pluginClass = Class.forName(pluginName);
            if (null != pluginClass && (plugin = pluginClass.newInstance()) instanceof IFormPlugin) {
                view.addPlugin((IFormPlugin)plugin);
                return true;
            }
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return false;
    }

    public static Object getCustomParamFromFormShowParameter(IFormView view, String customName) {
        FormShowParameter formShowParameter;
        if (null != view && null != (formShowParameter = view.getFormShowParameter())) {
            return formShowParameter.getCustomParam(customName);
        }
        return null;
    }

    public static boolean isSignCallBackSucess(SignCallbackEvent evt, IFormView view) {
        String clearTextStr;
        if (null == evt) {
            view.showErrorNotification(ApprovalPluginUtil.getErrorNotificationMsgForSign());
            return false;
        }
        ClientMethodResult ret = evt.getResult();
        if (null == ret) {
            return false;
        }
        Boolean signSucess = ret.getSuccess();
        if (null == signSucess || !signSucess.booleanValue()) {
            view.showErrorNotification(ApprovalPluginUtil.getErrorNotificationMsgForSign());
            return false;
        }
        HashMap<String, String> signInfoMap = new HashMap<String, String>();
        Map signTextsMap = ret.getResult();
        if (null != signTextsMap && !signTextsMap.isEmpty()) {
            String signTextsStr = SerializationUtils.toJsonString((Object)signTextsMap);
            logger.debug("ApprovalPluginUtil.isSignSucess result signTextsStr: " + signTextsStr);
            if (WfUtils.isNotEmpty((String)signTextsStr)) {
                signInfoMap.put("signTextsStr", signTextsStr);
            }
        }
        if (WfUtils.isNotEmpty((String)(clearTextStr = evt.getClearText()))) {
            logger.debug("ApprovalPluginUtil.isSignSucess result clearTextStr: " + clearTextStr);
            signInfoMap.put("clearTextStr", clearTextStr);
        }
        if (!signInfoMap.isEmpty()) {
            signInfoMap.put("sign", "true");
            view.getPageCache().put(signInfoMap);
        }
        return true;
    }

    public static String getErrorNotificationMsgForSign() {
        return ResManager.loadKDString((String)"\u5ba2\u6237\u7aef\u7b7e\u540d\u5931\u8d25\u3002", (String)"ApprovalPluginUtil_15", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    }

    public static boolean doSignOperate(FlowElement flow, IFormView view, String entityNumber, String businessKey) {
        boolean configSignScheme;
        boolean verifySign = SignServiceUtil.isControlSetting(view.getPageCache().get("taskcontrol"), DATASIGNEDVERIFY);
        boolean sign = SignServiceUtil.isControlSetting(view.getPageCache().get("taskcontrol"), DATASIGNEDADD);
        logger.debug("ApprovalPluginUtil.doSignOperate getSignConfig verifySign: " + verifySign + ";sign: " + sign);
        if (!verifySign && !sign) {
            return false;
        }
        SignScheme signScheme = SignService.getSignScheme((String)entityNumber);
        boolean bl = configSignScheme = null != signScheme;
        if (verifySign) {
            if (!configSignScheme) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5ba2\u6237\u7aef\u9a8c\u7b7e\u5931\u8d25\uff1a\u7f3a\u5c11\u3010\u7b7e\u540d\u914d\u7f6e\u65b9\u6848\u3011\u3002", (String)"ApprovalPluginUtil_17", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return true;
            }
            boolean verifySignSucess = ApprovalPluginUtil.isVerifySignSucess(view, entityNumber, businessKey);
            if (!verifySignSucess) {
                return true;
            }
        }
        if (!sign) {
            return false;
        }
        if (!configSignScheme) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5ba2\u6237\u7aef\u7b7e\u540d\u5931\u8d25\uff1a\u7f3a\u5c11\u3010\u7b7e\u540d\u914d\u7f6e\u65b9\u6848\u3011\u3002", (String)"ApprovalPluginUtil_18", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return true;
        }
        String signOperateStr = signScheme.getSignOperate();
        if (WfUtils.isEmpty((String)signOperateStr)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5ba2\u6237\u7aef\u7b7e\u540d\u5931\u8d25\uff1a\u7f3a\u5c11\u3010\u7b7e\u540d\u914d\u7f6e\u65b9\u6848\u3011\u3002", (String)"ApprovalPluginUtil_18", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return true;
        }
        List signOperateList = (List)SerializationUtils.fromJsonString((String)signOperateStr, List.class);
        Object clearPinObj = null;
        String clearPinStr = "true";
        for (Object obj : signOperateList) {
            if (!(obj instanceof Map) || !((clearPinObj = ((Map)obj).get("ClearPin")) instanceof Boolean) || ((Boolean)clearPinObj).booleanValue()) continue;
            clearPinStr = "false";
            break;
        }
        view.getPageCache().put("clearPin", clearPinStr);
        return false;
    }

    public static boolean isVerifySignSucess(IFormView view, String entityNumber, String businessKey) {
        String verifySignFailedMsg = null;
        try {
            logger.debug("ApprovalPluginUtil.isVerifySignSucess params entityNumber: " + entityNumber + ";businessKey: " + businessKey);
            VerifySignInfo verifyInfo = SignServiceHelper.verifySignById((String)entityNumber, (Object)businessKey);
            if (null == verifyInfo) {
                return true;
            }
            boolean verifySignSucess = verifyInfo.isSuccess();
            if (verifySignSucess) {
                return true;
            }
            verifySignFailedMsg = verifyInfo.getMessage();
        }
        catch (Exception e) {
            logger.debug("ApprovalPluginUtil.isVerifySignSucess Exception\uff1a " + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        if (null == verifySignFailedMsg) {
            verifySignFailedMsg = ResManager.loadKDString((String)"\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ApprovalPluginUtil_16", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        view.showErrorNotification(verifySignFailedMsg);
        return false;
    }

    public static boolean isSignOperateSucess(IFormView view, String entityNumber, String billPageId, SignOperateCallback signOperateCallback) {
        String opResultFailedMessage = null;
        try {
            DynamicObjectCollection docs = new DynamicObjectCollection();
            IFormView billView = view.getViewNoPlugin(billPageId);
            DynamicObject billInfo = billView.getModel().getDataEntity();
            docs.add((Object)billInfo);
            logger.debug("ApprovalPluginUtil.isSignOperateSucess clearTextMap params entityNumber: " + entityNumber);
            Map clearTextMap = SignService.computeDigests((String)entityNumber, (DynamicObjectCollection)docs);
            if (null == clearTextMap || clearTextMap.isEmpty()) {
                return false;
            }
            String clearText = SerializationUtils.toJsonString((Object)clearTextMap);
            OperationResult opResult = new OperationResult();
            opResult.setClearText(clearText);
            OperateOption options = OperateOption.create();
            options.setVariableValue("isStrict", "false");
            options.setVariableValue("signCallbackFlag", "true");
            options.setVariableValue("signFirstSave", "false");
            options.setVariableValue("isStrict", "false");
            signOperateCallback.setOption(options);
            String clearPinStr = view.getPageCache().get("clearPin");
            logger.debug("ApprovalPluginUtil.isSignOperateSucess SignOperateCallback start and clearPinStr :" + clearPinStr);
            boolean clearPin = WfUtils.isEmpty((String)clearPinStr) ? true : Boolean.parseBoolean(clearPinStr);
            opResult = signOperateCallback.sign(opResult, clearPin);
            if (null != opResult) {
                boolean opResultIsSuccess = opResult.isSuccess();
                if (opResultIsSuccess) {
                    return true;
                }
                opResultFailedMessage = opResult.getMessage();
            }
        }
        catch (Exception e) {
            logger.debug("ApprovalPluginUtil.isSignOperateSucess Exception\uff1a " + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        if (WfUtils.isEmpty(opResultFailedMessage)) {
            opResultFailedMessage = ApprovalPluginUtil.getErrorNotificationMsgForSign();
        }
        view.showErrorNotification(opResultFailedMessage);
        return true;
    }

    public static void saveSignOperate(IFormView view, String entityNumber) {
        if (WfUtils.isEmpty((String)view.getPageCache().get("sign"))) {
            return;
        }
        try {
            Map signTextsMap = new HashMap();
            String signTextsStr = view.getPageCache().get("signTextsStr");
            if (WfUtils.isNotEmpty((String)signTextsStr)) {
                signTextsMap = (Map)SerializationUtils.fromJsonString((String)signTextsStr, Map.class);
            }
            Map clearTextsMap = new HashMap();
            String clearTextStr = view.getPageCache().get("clearTextStr");
            if (WfUtils.isNotEmpty((String)clearTextStr)) {
                clearTextsMap = (Map)SerializationUtils.fromJsonString((String)clearTextStr, Map.class);
            }
            logger.debug("ApprovalPluginUtil.saveSignOperate params entityNumber: " + entityNumber + ";signTextsStr: " + signTextsStr + ";clearTextStr: " + clearTextStr);
            SignService.saveSignMessage((String)entityNumber, signTextsMap, clearTextsMap);
            SignService.writeLog((String)entityNumber, signTextsMap, clearTextsMap);
        }
        catch (Exception e) {
            logger.debug("ApprovalPluginUtil.saveSignOperate Exception\uff1a " + WfUtils.getExceptionStacktrace((Throwable)e));
            throw e;
        }
    }

    public static Boolean senstiveFieldChangeShowForm(IFormView view, IFormPlugin form, TaskService taskService, String auditType, String scene, String nodeType) {
        IPageCache pageCache = view.getPageCache();
        String formkey = pageCache.get("realFormKey");
        if (null != formkey && formkey.endsWith("&mfm")) {
            return Boolean.FALSE;
        }
        String callBackFlag = pageCache.get(WFSENSITIVECALLBACKFLAG);
        if (!Boolean.valueOf(callBackFlag == null ? "false" : callBackFlag.toString()).booleanValue()) {
            if (!WfConfigurationUtil.sensitiveChangeSwitch()) {
                return Boolean.FALSE;
            }
            if (WfUtils.isEmpty((String)auditType) || !"approve".equalsIgnoreCase(auditType)) {
                return Boolean.FALSE;
            }
            DynamicObject dataEntity = null;
            String entityId = null;
            String pageId = pageCache.get("billPageId");
            if (WfUtils.isNotEmpty((String)pageId)) {
                IFormView formView = view.getViewNoPlugin(pageId);
                if (formView == null) {
                    return Boolean.FALSE;
                }
                IDataModel model = formView.getModel();
                if (!model.isDataLoaded()) {
                    pageCache.put("billLoadingNotEnded", "billLoadingNotEnded");
                    return Boolean.FALSE;
                }
                dataEntity = model.getDataEntity(true);
                entityId = model.getDataEntityType().getAlias();
            } else {
                Map<String, Object> params = ApprovalPluginUtil.initParamsFromBillSummary(pageCache, view);
                dataEntity = (DynamicObject)params.get("dataEntity");
                entityId = (String)params.get("entityId");
            }
            if (dataEntity != null && entityId != null) {
                SensitiveFieldInfo sensitiveFieldInfo;
                Long taskId;
                Long l = taskId = WfUtils.isNotEmpty((String)pageCache.get("taskid")) ? Long.valueOf(pageCache.get("taskid")) : null;
                if (WfUtils.isEmpty((Long)taskId)) {
                    Long l2 = taskId = WfUtils.isNotEmpty((String)pageCache.get("taskId")) ? Long.valueOf(pageCache.get("taskId")) : null;
                }
                if ((sensitiveFieldInfo = taskService.getSensitiveFieldInfo(entityId, dataEntity, "approve", nodeType, taskId)) != null && sensitiveFieldInfo.getIsSensitiveChange().booleanValue()) {
                    if (WfConfigurationUtil.isShowSensitiveChange()) {
                        if ("mob".equals(scene)) {
                            MobileFormShowParameter mFormShowParameter = new MobileFormShowParameter();
                            mFormShowParameter.setFormId("wf_sensitivfiledmobile");
                            mFormShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                            StyleCss sc = new StyleCss();
                            sc.setHeight("180px");
                            sc.setWidth("260px");
                            mFormShowParameter.getOpenStyle().setInlineStyleCss(sc);
                            HashMap<String, String> m = new HashMap<String, String>(1);
                            m.put("position", "center");
                            mFormShowParameter.getOpenStyle().setCustParam(m);
                            mFormShowParameter.setCloseCallBack(new CloseCallBack(form, WFSENSITIVECALLBACKFLAG));
                            mFormShowParameter.setCustomParam("sensitivefieldinfo", (Object)SerializationUtils.toJsonString((Object)sensitiveFieldInfo));
                            view.showForm((FormShowParameter)mFormShowParameter);
                            return Boolean.TRUE;
                        }
                        FormShowParameter formShowParameter = new FormShowParameter();
                        formShowParameter.setFormId("wf_sensitivfiledchange");
                        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                        formShowParameter.setCloseCallBack(new CloseCallBack(form, WFSENSITIVECALLBACKFLAG));
                        formShowParameter.setCustomParam("sensitivefieldinfo", (Object)SerializationUtils.toJsonString((Object)sensitiveFieldInfo));
                        view.showForm(formShowParameter);
                        return Boolean.TRUE;
                    }
                    pageCache.put("sensitivefieldinfo", SerializationUtils.toJsonString((Object)sensitiveFieldInfo));
                }
            }
        }
        return Boolean.FALSE;
    }

    private static Map<String, Object> initParamsFromBillSummary(IPageCache pageCache, IFormView view) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        String realFormKey = pageCache.get("realFormKey");
        if (WfUtils.isNotEmpty((String)realFormKey) && realFormKey.endsWith("$")) {
            String billSummaryNumber = realFormKey.substring(0, realFormKey.length() - 1);
            String businesskey = pageCache.get("businesskey");
            QFilter qfilter = new QFilter("number", "=", (Object)billSummaryNumber);
            DynamicObject mobileConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"wf_mbillsummary_cfg", (String)"defaultrows,defaultdatarows,billtype,entryentity.fieldid,entryentity.fieldkey,entryentity.fieldname,entryentity.isheadfield,entryentity.isdefaultshow,entryentity.entrylocation,entryentity.entrylocationid,entryentity.entrylocationname,entryentity.editable,entryentity.fieldpercent,entryentity.fontcolor,entryentity.fontsize", (QFilter[])new QFilter[]{qfilter});
            String dynamicObjectInfo = (String)view.getFormShowParameter().getCustomParam("dynamicObjectInfo");
            String entityNumber = pageCache.get("entitynumber");
            if (WfUtils.isNotEmpty((String)dynamicObjectInfo) && WfUtils.isNotEmpty((String)entityNumber)) {
                DynamicObject editBillInfo = DynamicObjectJsonSerializer.parseDynamicObjectJson((String)dynamicObjectInfo, (String)entityNumber);
                DynamicObject dataEntity = ApprovalPluginUtil.initBillInfo(businesskey, entityNumber, editBillInfo, mobileConfig);
                params.put("entityId", entityNumber);
                params.put("dataEntity", dataEntity);
            }
        }
        return params;
    }

    public static DynamicObject initBillInfo(String businesskey, String entityNumber, DynamicObject editBillInfo, DynamicObject mobileConfig) {
        DynamicObject billInfo = BusinessDataServiceHelper.loadSingle((Object)businesskey, (String)entityNumber);
        DynamicObjectCollection entries = mobileConfig.getDynamicObjectCollection("entryentity");
        MetadataReader reader = new MetadataReader();
        String fid = reader.loadIdByNumber(entityNumber, MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
        Map<String, EntityItem<?>> mapItems = WFBillSummaryUtil.getItems(entityMetadata);
        for (DynamicObject object : entries) {
            boolean editable = object.getBoolean("editable");
            if (!editable) continue;
            String fieldkey = object.getString("fieldkey");
            EntityItem<?> entity = mapItems.get(fieldkey);
            if (object.get("isheadfield") != null && object.getBoolean("isheadfield")) {
                if (entity instanceof DateRangeField || entity instanceof TimeRangeField) {
                    Pair<String, String> startAndEndKey = WFBillSummaryUtil.getStartAndEndKey(entity);
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)startAndEndKey.getKey())) || !StringUtils.isNotBlank((CharSequence)((CharSequence)startAndEndKey.getValue()))) continue;
                    billInfo.set((String)startAndEndKey.getKey(), editBillInfo.get((String)startAndEndKey.getKey()));
                    billInfo.set((String)startAndEndKey.getValue(), editBillInfo.get((String)startAndEndKey.getValue()));
                    continue;
                }
                billInfo.set(fieldkey, editBillInfo.get(fieldkey));
                continue;
            }
            String entryKey = object.getString("entrylocation");
            DynamicObjectCollection datas = billInfo.getDynamicObjectCollection(entryKey);
            if (datas.isEmpty()) continue;
            for (int i = 0; i < datas.size(); ++i) {
                if (entity instanceof DateRangeField || entity instanceof TimeRangeField) {
                    Pair<String, String> startAndEndKey = WFBillSummaryUtil.getStartAndEndKey(entity);
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)startAndEndKey.getKey())) || !StringUtils.isNotBlank((CharSequence)((CharSequence)startAndEndKey.getValue()))) continue;
                    ((DynamicObject)datas.get(i)).set((String)startAndEndKey.getKey(), ((DynamicObject)editBillInfo.getDynamicObjectCollection(entryKey).get(i)).get((String)startAndEndKey.getKey()));
                    ((DynamicObject)datas.get(i)).set((String)startAndEndKey.getValue(), ((DynamicObject)editBillInfo.getDynamicObjectCollection(entryKey).get(i)).get((String)startAndEndKey.getValue()));
                    continue;
                }
                ((DynamicObject)datas.get(i)).set(fieldkey, ((DynamicObject)editBillInfo.getDynamicObjectCollection(entryKey).get(i)).get(fieldkey));
            }
        }
        return billInfo;
    }

    public static boolean setCloseSensitiveFieldPageData(Object returnData, IPageCache pageCache) {
        Map returnDataMap;
        if (returnData instanceof Map && !(returnDataMap = (Map)returnData).isEmpty()) {
            String sensitiveFieldInfoStr = (String)returnDataMap.get("sensitivefieldinfo");
            pageCache.put("sensitivefieldinfo", sensitiveFieldInfoStr);
            pageCache.put(WFSENSITIVECALLBACKFLAG, "true");
            return true;
        }
        return false;
    }

    public static ILocaleString getDefaultApprovalMsg(ILocaleString approvalMessage) {
        LocaleString defaultApprovalMsg = new LocaleString("");
        if (null == approvalMessage) {
            return defaultApprovalMsg;
        }
        if (Lang.zh_CN.equals((Object)Lang.get()) || Lang.zh_TW.equals((Object)Lang.get())) {
            defaultApprovalMsg.put((Object)Lang.zh_CN.toString(), (Object)approvalMessage.getLocaleValue_zh_CN());
            defaultApprovalMsg.put((Object)Lang.zh_TW.toString(), (Object)approvalMessage.getLocaleValue_zh_TW());
            return defaultApprovalMsg;
        }
        defaultApprovalMsg.put((Object)Lang.get().toString(), (Object)approvalMessage.getLocaleValue());
        return defaultApprovalMsg;
    }

    @Deprecated
    public static boolean needDoSignOperate(FlowElement flow, String type) {
        if (!WfConfigurationUtil.needDataSigned()) {
            return false;
        }
        if (null == flow || !flow.getClass().getTypeName().equalsIgnoreCase(AuditTask.class.getTypeName())) {
            return false;
        }
        BillSetting billSetting = ((AuditTask)flow).getBillSetting();
        if (null == billSetting) {
            return false;
        }
        if (DATASIGNEDVERIFY.equals(type)) {
            return billSetting.isDataSignedVerify();
        }
        return billSetting.isDataSignedAdd();
    }

    public static Object checkApptype(Object apptype) {
        DynamicObject[] channelObjects;
        if (StringUtils.isNotBlank((Object)apptype) && (channelObjects = BusinessDataServiceHelper.load((String)"msg_channel", (String)" number", null)) != null && channelObjects.length > 0) {
            for (DynamicObject channelObject : channelObjects) {
                String number = String.valueOf(channelObject.get("number"));
                if (!apptype.toString().contains(number)) continue;
                apptype = number;
                break;
            }
        }
        return apptype;
    }

    public static void callRecordReadTime(AgentTaskHandleContext context, Map<String, Object> customParams) {
        Long taskId = null;
        if (context != null) {
            taskId = context.getTaskId();
        } else if (!WfUtils.isNullObject((Object)customParams.get("taskId"))) {
            taskId = (Long)customParams.get("taskId");
        } else if (!WfUtils.isNullObject((Object)customParams.get("tId"))) {
            taskId = (Long)customParams.get("tId");
        }
        Object msgId = WfUtils.isNotEmptyForMap(customParams) ? customParams.get("msgId") : null;
        String apptype = WfUtils.isNotEmptyForMap(customParams) ? ApprovalPluginUtil.getApptype(customParams.get("apptype")) : null;
        ApprovalPluginUtil.callRecordReadTime(taskId, msgId, apptype);
    }

    public static void callRecordReadTime(Long taskId, Object msgId, Object apptype) {
        try {
            logger.debug("recordReadTime, taskId:" + taskId + "msgId:" + msgId + "apptype:" + apptype);
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("taskId", taskId);
            map.put("msgId", msgId);
            map.put("apptype", MessageUtils.getApptypeOrChannelNumber(null, (String)(apptype != null ? apptype.toString() : "")));
            MessageBussinessInfo messageBussinessInfo = new MessageBussinessInfo();
            messageBussinessInfo.setType(MessageBussinessInfo.Type.RECORDREADTIME.getNumber());
            messageBussinessInfo.setData(map);
            MessageBussinessPublishUtil.publishBizMessage((MessageBussinessInfo)messageBussinessInfo);
        }
        catch (Exception e) {
            logger.warn("recordReadTime:" + e);
        }
    }

    public static String getTaskNotExistInfo(String taskNotExistReason) {
        String tips = null;
        switch (taskNotExistReason) {
            case "taskNotExistReason_notExist": {
                tips = ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u67e5\u770b\u3002", (String)"ApprovalPluginUtil_19", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                break;
            }
            case "taskNotExistReason_checkRight": {
                tips = ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u4efb\u52a1\u7684\u53c2\u4e0e\u4eba\uff0c\u4e0d\u80fd\u67e5\u770b\u3002", (String)"ApprovalPluginUtil_58", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                break;
            }
            case "taskNotExistReason_userAccount": {
                tips = ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u67e5\u770b\u3002", (String)"ApprovalPluginNew_57", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return tips;
    }

    public static List<Map<String, Object>> filterUnFlowThrough(List<Map<String, Object>> list, Long procId, HistoryService historyService) {
        List entities;
        if (null == list || list.isEmpty() || null == historyService) {
            return list;
        }
        if (list.size() == 1 && list.get(0).get("nextNode") == null) {
            return list;
        }
        if (!WfConfigurationUtil.isIgnoreNoThroughNode()) {
            return list;
        }
        ArrayList<Map<String, Object>> nodeList = new ArrayList<Map<String, Object>>();
        Map<String, Object> nextNodeMap = list.get(0);
        Object isRejectToParentProcess = nextNodeMap.get("isRejectToParentProcess");
        Object parentProcessInstanceId = nextNodeMap.get("parentProcessInstanceId");
        if (Boolean.TRUE.equals(isRejectToParentProcess) && parentProcessInstanceId != null) {
            procId = Long.parseLong(String.valueOf(parentProcessInstanceId));
        }
        if (null == (entities = historyService.getHistoricActivityByProcessInstanceId(procId)) || entities.isEmpty()) {
            return nodeList;
        }
        Object nextNodeObj = null;
        String nextNodeId = null;
        block0: for (Map<String, Object> nodeMap : list) {
            if (null == nodeMap || nodeMap.isEmpty() || !((nextNodeObj = nodeMap.get("nextNode")) instanceof FlowNode) || null == (nextNodeId = ((FlowNode)nextNodeObj).getId()) || nextNodeId.isEmpty()) continue;
            for (HistoricActivityInstanceEntity entity : entities) {
                if (null == entity || !nextNodeId.equals(entity.getActivityId())) continue;
                nodeList.add(nodeMap);
                continue block0;
            }
        }
        return nodeList;
    }

    public static void addAllApprovalPluginsBeforeShowForm(FormShowParameter parameter) {
        Map<String, Object> taskControl = ApprovalPluginUtil.queryTaskControlByParam(parameter);
        boolean isSSCCreditNodeExt = ApprovalPluginUtil.addExtraNodeTplApprovalPluginsBeforeShowForm(parameter, taskControl);
        if (isSSCCreditNodeExt) {
            return;
        }
        ApprovalPluginUtil.addExtraApprovalPluginsBeforeShowForm(parameter, taskControl);
    }

    @Deprecated
    public static void addExtraApprovalPluginsBeforeShowForm(FormShowParameter parameter) {
        Map<String, Object> taskControl = ApprovalPluginUtil.queryTaskControlByParam(parameter);
        ApprovalPluginUtil.addExtraApprovalPluginsBeforeShowForm(parameter, taskControl);
    }

    public static void addExtraApprovalPluginsBeforeShowForm(FormShowParameter parameter, Map<String, Object> taskControl) {
        try {
            String entityNumber = (String)parameter.getCustomParam("entityNumber");
            if (WfUtils.isEmpty((String)entityNumber)) {
                return;
            }
            Object extrasObj = WfCommonUtil.getValueFromJson(taskControl, (String)"extras");
            if (!(extrasObj instanceof Map)) {
                return;
            }
            Map extras = (Map)extrasObj;
            boolean creditObj = WfCommonUtil.getBooleanValueFromJson((Map)extras, (String)CREDIT_CONTROL);
            if (!creditObj) {
                return;
            }
            Map<String, Object> extraPluginsMap = ApprovalPluginUtil.getExtraPluginInConfcenter();
            for (Map.Entry<String, Object> entry : extraPluginsMap.entrySet()) {
                Map entryMap = (Map)entry.getValue();
                String appids = String.valueOf(entryMap.get("appids"));
                String appNumber = FormMetadataCache.getFormConfig((String)entityNumber).getBizAppNumber();
                Map approvepluginMap = (Map)entryMap.get("approveplugin");
                if (appids == null || appNumber == null || !appids.toLowerCase().contains(appNumber.toLowerCase()) || WfUtils.isEmptyForMap((Map)approvepluginMap)) continue;
                Object model = approvepluginMap.get("model");
                Object pluginName = approvepluginMap.get("class");
                Set<String> pluginNames = ApprovalPluginUtil.getPluginsByParam(parameter);
                if (model == null || pluginName == null || !ApprovalPluginUtil.isClassLegal((String)pluginName, pluginNames)) continue;
                if ("prop".equalsIgnoreCase((String)model)) {
                    String control = (String)parameter.getCustomParam("control");
                    Map controlMap = WfUtils.isNotEmpty((String)control) ? (Map)SerializationUtils.fromJsonString((String)control, Map.class) : new HashMap();
                    Map extrasMap = WfUtils.isNotEmptyForMap(controlMap) ? (Map)controlMap.get("extras") : new HashMap();
                    Object value = WfUtils.isNotEmptyForMap(extrasMap) ? extrasMap.get(entry.getKey()) : null;
                    if (value == null || !"true".equalsIgnoreCase(value)) continue;
                    parameter.addCustPlugin((String)pluginName);
                    continue;
                }
                if (!"always".equalsIgnoreCase((String)model)) continue;
                parameter.addCustPlugin((String)pluginName);
            }
        }
        catch (Exception e) {
            logger.warn("ApprovalPluginUtil.addExtraApprovalPluginsBeforeShowForm Exception\uff1a " + WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    public static void addExtraNodeTplApprovalPluginsBeforeShowForm(FormShowParameter parameter) {
        Map<String, Object> controlMap = ApprovalPluginUtil.queryTaskControlByParam(parameter);
        ApprovalPluginUtil.addExtraNodeTplApprovalPluginsBeforeShowForm(parameter, controlMap);
    }

    public static boolean addExtraNodeTplApprovalPluginsBeforeShowForm(FormShowParameter parameter, Map<String, Object> taskControl) {
        try {
            String category = (String)parameter.getCustomParam(CATEGORY);
            if (!NodeTemplateLibraryUtil.isScalableNodes(category)) {
                return Boolean.FALSE;
            }
            Object nodeExtObj = WfCommonUtil.getValueFromJson(taskControl, (String)"extNum");
            if (!(nodeExtObj instanceof List)) {
                return Boolean.FALSE;
            }
            List nodeExtNums = (List)nodeExtObj;
            if (WfUtils.isEmptyForCollection((Collection)nodeExtNums)) {
                return Boolean.FALSE;
            }
            Set<String> pluginNames = ApprovalPluginUtil.getPluginsByParam(parameter);
            List extPluginsByType = NodeTemplateUtil.getExtPluginsByType((String)category, (String)"auditListeners");
            HashMap pluginMap = Maps.newHashMapWithExpectedSize((int)extPluginsByType.size());
            boolean isSSCCreditNodeExt = Boolean.FALSE;
            for (JSONObject extPlugin : extPluginsByType) {
                if (!ApprovalPluginUtil.isClassLegal(extPlugin.getString("implementation"), pluginNames)) continue;
                pluginMap.put(TaskBehaviorUtil.buildNodeExdNumControlKey((String)extPlugin.getString("nodeTemplateNum"), (String)extPlugin.getString("pluginNumber")), extPlugin.getString("implementation"));
                if (isSSCCreditNodeExt || !NodeTemplateUtil.isSSCCredit((String)extPlugin.getString("nodeTemplateNum"), (String)category)) continue;
                isSSCCreditNodeExt = Boolean.TRUE;
            }
            nodeExtNums.stream().map(pluginMap::get).filter(WfUtils::isNotEmptyString).forEach(arg_0 -> ((FormShowParameter)parameter).addCustPlugin(arg_0));
            return isSSCCreditNodeExt;
        }
        catch (Exception e) {
            logger.error("ApprovalPluginUtil.addExtraNodeTplApprovalPluginsBeforeShowForm Exception\uff1a " + WfUtils.getExceptionStacktrace((Throwable)e));
            return Boolean.FALSE;
        }
    }

    private static Map<String, Object> queryTaskControlByParam(FormShowParameter parameter) {
        Long taskIdL;
        Task task;
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskService taskService = wfService.getTaskService();
        Object taskId = parameter.getCustomParam(ApprovalPluginUtil.isPCShow(parameter) ? "taskId" : "taskid");
        if (taskId == null) {
            taskId = parameter.getCustomParam("tId");
        }
        if (WfUtils.isNullObject((Object)(task = taskService.getTask(taskIdL = Long.valueOf(taskId instanceof Long ? WfUtils.normalizeId((Long)((Long)taskId)) : NumberUtils.toLong((String)ObjectUtils.toString((Object)taskId))))))) {
            return null;
        }
        return WfCommonUtil.getValueFromMapJson((String)task.getControl());
    }

    public static boolean isPCShow(FormShowParameter parameter) {
        Object isPCShow = parameter.getCustomParam("isPCShow");
        return WfUtils.isNullObject((Object)isPCShow) || BooleanUtils.toBoolean((String)isPCShow.toString());
    }

    public static Map<String, Object> getExtraPluginInConfcenter() {
        JSONObject extraPluginsMap = new HashMap();
        Object extraPluginsObj = MessageServiceUtil.getConfigCenterProperty((String)"global", (String)"extraApprovalPlugins");
        if (extraPluginsObj != null) {
            extraPluginsMap = JSON.parseObject((String)((String)extraPluginsObj));
        }
        return extraPluginsMap;
    }

    private static boolean isClassLegal(String impl, Set<String> plugins) {
        return ApprovalPluginUtil.isExistClass(impl) && !plugins.contains(impl);
    }

    private static Set<String> getPluginsByParam(FormShowParameter parameter) {
        parameter.initFormConfig();
        List plugins = parameter.getFormConfig().getPlugins();
        return plugins.stream().map(Plugin::getClassName).collect(Collectors.toSet());
    }

    public static boolean isExistClass(String pluginName) {
        try {
            Object plugin;
            Class<?> pluginClass = Class.forName(pluginName);
            if (null != pluginClass && (plugin = pluginClass.newInstance()) instanceof IFormPlugin) {
                return true;
            }
        }
        catch (Exception e) {
            logger.warn("isExistClass: " + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return false;
    }

    public static void showTransferRecord(IFormView view, String taskId, String userId, boolean coordinate) {
        MobileFormShowParameter parameter = null;
        if (view instanceof IMobileView || "wf_mobilapprovalrecord".equals(view.getFormShowParameter().getFormId())) {
            parameter = new MobileFormShowParameter();
            parameter.setFormId("wf_mobiletransferrecord");
        } else {
            parameter = new FormShowParameter();
            parameter.setFormId("wf_viewtransferrecord");
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("taskId", (Object)taskId);
        parameter.setCustomParam("userId", (Object)userId);
        parameter.setCustomParam("coordinate", (Object)coordinate);
        ArchiveFormService.create().setArchiveRouteInfo(view, (FormShowParameter)parameter);
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put("transferRecordPageId", parameter.getPageId());
        view.showForm((FormShowParameter)parameter);
    }

    public static List<QFilter> addPersonFiltersCustomEvent(IFormView view, List<QFilter> qFilters) {
        if (null == view) {
            return null;
        }
        if (qFilters == null) {
            qFilters = new ArrayList<QFilter>(1);
        }
        AddPersonFiltersCustomEvent args = new AddPersonFiltersCustomEvent(view, "addPersonFiltersCustomEvent", "addPersonFiltersCustomEventName", null, qFilters);
        FormViewPluginProxy proxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent((CustomEventArgs)args);
        return args.getQFilters();
    }

    public static String getApptype(Object apptypeObj) {
        String apptype = null;
        if (apptypeObj == null) {
            return apptype;
        }
        if (apptypeObj instanceof List) {
            apptype = (String)((List)apptypeObj).get(0);
        } else if (apptypeObj instanceof String[]) {
            apptype = ((String[])apptypeObj)[0];
        } else if (apptypeObj instanceof String) {
            apptype = (String)apptypeObj;
        }
        return apptype;
    }

    public static boolean isAllowTransfer(UserTask element, TaskInfo task) {
        if (task != null && StringUtils.isNotBlank((CharSequence)task.getControl())) {
            Map map = (Map)SerializationUtils.fromJsonString((String)task.getControl(), Map.class);
            Object transfer = map.get("transfer");
            return transfer != null && (Boolean)transfer != false;
        }
        if (element != null) {
            return element.isAllowTransfer();
        }
        return false;
    }

    public static boolean isAllowCirculate(UserTask element, TaskInfo task) {
        if (task != null && StringUtils.isNotBlank((CharSequence)task.getControl())) {
            Map map = (Map)SerializationUtils.fromJsonString((String)task.getControl(), Map.class);
            Object circulate = map.get("circulate");
            return circulate != null && Boolean.parseBoolean((String)circulate);
        }
        if (element != null && element.getCirculateModel() != null) {
            return element.getCirculateModel().isCirculateWhenMatch();
        }
        return false;
    }

    public static Object[] getAttachment(List<ApprovalAttachmentInfo> attachmentInfos) {
        if (null == attachmentInfos || attachmentInfos.isEmpty()) {
            return new Object[0];
        }
        Object[] attIds = new Object[attachmentInfos.size()];
        int i = 0;
        for (ApprovalAttachmentInfo approvalAttachmentInfo : attachmentInfos) {
            if (null == approvalAttachmentInfo) continue;
            attIds[i] = Long.valueOf(approvalAttachmentInfo.getId());
            ++i;
        }
        return attIds;
    }

    public static void clearEntryEntity(IFormView view, String entryName) {
        if (null == view) {
            return;
        }
        IDataModel model = view.getModel();
        if (null == model) {
            return;
        }
        DynamicObject dataEntity = model.getDataEntity(true);
        if (null == dataEntity) {
            return;
        }
        DynamicObjectCollection entrys = (DynamicObjectCollection)dataEntity.get(entryName);
        if (null == entrys || 0 == entrys.size()) {
            return;
        }
        entrys.clear();
        view.updateView(entryName);
    }

    public static void setEntryEntity(IFormView view, String entryEntityName, List<Map<String, Object>> entryEntityDatas) {
        if (null == entryEntityDatas || entryEntityDatas.isEmpty()) {
            return;
        }
        IDataModel model = view.getModel();
        if (null == model) {
            return;
        }
        ApprovalPluginUtil.clearEntryEntity(view, entryEntityName);
        model.batchCreateNewEntryRow(entryEntityName, entryEntityDatas.size());
        int i = 0;
        Set<Map.Entry<String, Object>> entrySet = null;
        Iterator<Map.Entry<String, Object>> iterator = null;
        Map.Entry<String, Object> entry2 = null;
        for (Map<String, Object> map : entryEntityDatas) {
            if (null == map || map.isEmpty()) continue;
            entrySet = map.entrySet();
            for (Map.Entry<String, Object> entry2 : entrySet) {
                model.setValue(entry2.getKey(), entry2.getValue(), i);
            }
            ++i;
        }
    }

    public static boolean jumpToRightPageForApproval(TaskInfo taskInfo, boolean PCShow, IFormView view) {
        if (null == taskInfo || null == view) {
            return false;
        }
        String formId = (String)view.getFormShowParameter().getCustomParam("initFormId");
        if (WfUtils.isNotEmpty((String)formId)) {
            return false;
        }
        formId = view.getFormShowParameter().getFormId();
        String processingPage = null;
        processingPage = PCShow ? taskInfo.getProcessingPage() : taskInfo.getProcessingMobilePage();
        Object type = view.getFormShowParameter().getCustomParam("type");
        String noJumpFormIds = "wf_msg_center, wf_moverlist_mob, wf_mobilemylist_mob, wf_mobilemyoverlist_mob";
        String parentFormId = view.getFormShowParameter().getParentFormId();
        if ("botp_convertop".equals(processingPage) || WfUtils.isNotEmptyString((Object)parentFormId) && noJumpFormIds.contains(parentFormId) && WfUtils.isNotEmptyString((Object)type) && !"toHandle".equals(type) && !"dynApply".equals(type)) {
            return false;
        }
        if ("wf_approvalpage".equals(processingPage)) {
            processingPage = "wf_approvalpage_bac";
        }
        if (formId.equals(processingPage)) {
            return false;
        }
        boolean userTaskNode = "wf_approvalbill, wf_approvalbill_view, wf_approvalbillmob, wf_approvalbillmob_view".contains(formId);
        boolean auditTaskNode = "wf_approvalpage_bac, wf_approvalpageview_bac, wf_approvalpagemobile_bac, wf_approvalmobileview_bac, wf_approvalpage_mob, wf_approvalpageview_mob".contains(formId);
        String category = taskInfo.getCategory();
        if (BpmnModelUtil.instanceofUserTaskOnly((String)category) && userTaskNode || BpmnModelUtil.instanceofAuditTask((String)category) && auditTaskNode && "true".equals(view.getPageCache().get(ONLYVIEW))) {
            return false;
        }
        FormShowParameter formShowParameter = null;
        ShowType showType = null;
        if (PCShow) {
            formShowParameter = new FormShowParameter();
            showType = ShowType.InCurrentForm;
            formShowParameter.setPageId(view.getPageId());
        } else {
            formShowParameter = new MobileFormShowParameter();
            showType = ShowType.ReplaceHomePage;
        }
        formShowParameter.setFormId(processingPage);
        formShowParameter.getOpenStyle().setShowType(showType);
        Long taskId = taskInfo.getId();
        formShowParameter.setCustomParams(view.getFormShowParameter().getCustomParams());
        formShowParameter.setCustomParam("taskId", (Object)(null == taskId ? taskInfo.getProcessInstanceId() : taskId));
        formShowParameter.setCustomParam("type", processingPage.contains("view") ? view.getFormShowParameter().getCustomParam("type") : "toHandle");
        formShowParameter.setCustomParam("initFormId", (Object)formId);
        formShowParameter.setParentFormId(parentFormId);
        formShowParameter.setParentPageId(view.getFormShowParameter().getParentPageId());
        formShowParameter.setCloseCallBack(view.getFormShowParameter().getCloseCallBack());
        formShowParameter.addCustPlugin("kd.bos.workflow.autogonext.plugin.ApprovalBeforeClosedPlugin");
        view.showForm(formShowParameter);
        return true;
    }

    public static String getTerminalWay(IFormView view, String terminal) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        if (WfUtils.isEmptyForMap((Map)customParams)) {
            return terminal;
        }
        Object mobileMobFlag = customParams.get("mobileMobFlag");
        if (WfUtils.isNotEmptyString(mobileMobFlag) && WF_MOBILELIST_MOB.equalsIgnoreCase((String)mobileMobFlag)) {
            return "mobile";
        }
        String appType = ApprovalPluginUtil.getApptype(customParams.get("apptype"));
        if ("web".equalsIgnoreCase(terminal) && WfUtils.isEmptyString((Object)appType)) {
            return terminal;
        }
        if ("mcenter".equalsIgnoreCase(appType)) {
            return terminal;
        }
        terminal = WfUtils.isNotEmptyString((Object)appType) ? String.format("mobile_%s", appType) : "mobile_other";
        return terminal;
    }

    public static Object executeApprovalSubPlugin(String caseName, Object ... obj) {
        PluginProxy pluginProxy = PluginProxy.create(IApprovalSubPlugin.class, (String)("kd.bos.workflow.taskcenter.plugin.validate.IApprovalSubPlugin." + caseName));
        List plugins = pluginProxy.getPlugins();
        if (null == plugins || plugins.isEmpty()) {
            logger.debug("executeApprovalSubPlugin is null.");
            return null;
        }
        Class<IApprovalSubPlugin> approvalSubPlugin = IApprovalSubPlugin.class;
        Method[] methods = approvalSubPlugin.getMethods();
        Method method = null;
        for (Method m : methods) {
            if (!caseName.equals(m.getName())) continue;
            method = m;
            break;
        }
        if (null == method) {
            return null;
        }
        Object result = null;
        Object resultForExecute = null;
        for (IApprovalSubPlugin plugin : plugins) {
            if (null == plugin) continue;
            try {
                resultForExecute = method.invoke((Object)plugin, obj);
            }
            catch (Exception e) {
                logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            }
            if (resultForExecute instanceof Boolean && ((Boolean)resultForExecute).booleanValue()) {
                result = resultForExecute;
                continue;
            }
            result = resultForExecute;
        }
        return result;
    }

    public static boolean executeClosePageAfterSubmitTask(boolean isPCShow, Map<String, Object> customParams) {
        logger.info("ApprovalPluginUtil executeApprovalSubPlugin begin.");
        Object closedPageByApprovalSubPlugin = ApprovalPluginUtil.executeApprovalSubPlugin("executeClosePageAfterSubmitTask", isPCShow, customParams);
        boolean result = null == closedPageByApprovalSubPlugin ? false : (Boolean)closedPageByApprovalSubPlugin;
        logger.info("ApprovalPluginUtil executeApprovalSubPlugin end result: " + result);
        return result;
    }

    public static boolean executeClosePageAfterSubmitTask(boolean isPCShow, IFormView view) {
        HashMap<String, Object> executeMap = new HashMap<String, Object>(10);
        executeMap.putAll(view.getFormShowParameter().getCustomParams());
        executeMap.put("formView", view);
        return ApprovalPluginUtil.executeClosePageAfterSubmitTask(isPCShow, executeMap);
    }

    public static boolean isRequiredValidatorSuccess(IFormView view, String decisionOptionValue) {
        if (null == view) {
            return true;
        }
        IPageCache pageCache = view.getPageCache();
        if (null == pageCache) {
            return true;
        }
        if (null != decisionOptionValue && decisionOptionValue.split("_and_").length > 2 && !"approve".equals(decisionOptionValue.split("_and_")[2])) {
            return true;
        }
        String mustInputFieldInfoStr = pageCache.get("mustInputFieldInfoMap");
        if (WfUtils.isEmpty((String)mustInputFieldInfoStr)) {
            return true;
        }
        Map mustInputFieldInfoMap = (Map)SerializationUtils.fromJsonString((String)mustInputFieldInfoStr, Map.class);
        if (null == mustInputFieldInfoMap || mustInputFieldInfoMap.isEmpty()) {
            return true;
        }
        logger.debug("ApprovalPluginUtil.isRequiredValidatorSuccess mustInputFieldInfoStr:" + mustInputFieldInfoStr);
        String entityNumber = pageCache.get("entitynumber");
        DynamicObject dataEntity = view.getViewNoPlugin(pageCache.get("billPageId")).getModel().getDataEntity(true);
        RequiredValidator requiredValidator = new RequiredValidator(entityNumber, dataEntity, mustInputFieldInfoMap);
        OperationResult operationResult = requiredValidator.validate();
        if (null == operationResult) {
            return true;
        }
        String title = ResManager.loadKDString((String)"\u5ba1\u6279\u63d0\u4ea4\u6821\u9a8c\u5fc5\u5f55\u3002", (String)"RequiredValidator_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        view.showOperationResult(operationResult, title);
        return false;
    }

    public static boolean isExpectValueFromParams(Map<String, Object> customParams, String customParamKey, String expectValue) {
        if (null == customParams || customParams.isEmpty()) {
            return false;
        }
        Object customParamValue = customParams.get(customParamKey);
        return WfUtils.isNotEmptyString((Object)customParamValue) && expectValue.equals(customParamValue);
    }

    public static Boolean getResultForBillOperation(Object result, String operation, IFormView formView, String confirmCallBackClassName) {
        if (null == result) {
            return Boolean.FALSE;
        }
        if (!(result instanceof Map)) {
            logger.debug("the return value of [ApprovalPluginNew bill operation] is illegal.");
            return Boolean.FALSE;
        }
        Map resultMap = (Map)result;
        return ApprovalPluginUtil.validateOperationResult(resultMap, operation, formView, confirmCallBackClassName);
    }

    private static Boolean validateOperationResult(Map<String, Object> resultMap, String operation, IFormView formView, String confirmCallBackClassName) {
        String sMsg;
        String operationResult = (String)resultMap.get("operationResult");
        Object objectResult = null;
        try {
            objectResult = DataEntitySerializer.deSerializerFromString((String)operationResult, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
        }
        catch (Exception e) {
            logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        if (null == objectResult || !OperationResult.class.isInstance(objectResult)) {
            return Boolean.FALSE;
        }
        OperationResult ret = (OperationResult)objectResult;
        if (ret.isSuccess()) {
            return Boolean.TRUE;
        }
        boolean validateActionResult = true;
        try {
            validateActionResult = ApprovalPluginUtil.isValidateActionResultSuccess(resultMap, operation, formView, confirmCallBackClassName);
        }
        catch (Exception e) {
            logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        if (!validateActionResult) {
            return Boolean.FALSE;
        }
        StringBuilder sb = new StringBuilder();
        ErrorLevel errorLevel = null;
        boolean isRedError = false;
        boolean isYellowError = false;
        boolean isWarning = false;
        List errs = ret.getAllErrorOrValidateInfo();
        if (null == errs || errs.isEmpty()) {
            String cancelMsg = ret.getMessage();
            if (WfUtils.isNotEmpty((String)cancelMsg)) {
                sb.append(cancelMsg);
                errorLevel = ErrorLevel.Error;
                isYellowError = true;
            }
        } else {
            for (IOperateInfo info : errs) {
                if (!isRedError && info instanceof OperateErrorInfo && null != (errorLevel = ((OperateErrorInfo)info).getLevel())) {
                    isRedError = ErrorLevel.FatalError.getValue() == errorLevel.getValue();
                    isYellowError = ErrorLevel.Error.getValue() == errorLevel.getValue();
                    boolean bl = isWarning = ErrorLevel.Warning.getValue() == errorLevel.getValue();
                }
                if (!isRedError && !isYellowError) continue;
                sb.append(info.getMessage()).append(" ");
            }
        }
        if (null != ret.getInteractionContext() && WfConfigurationUtil.isShowInteractionMessage() && WfUtils.isNotEmptyString((Object)(sMsg = ret.getInteractionContext().getSimpleMessage()))) {
            sb.append((Object)sMsg);
            errorLevel = ErrorLevel.Error;
            isRedError = true;
        }
        if (isWarning) {
            return Boolean.TRUE;
        }
        if (0 != sb.length()) {
            WFBizOperationException bizErr = new WFBizOperationException(null, WFErrorCode.businessBizOperationError(), new Object[]{sb.toString().replaceAll("\uff01", "\u3002"), errorLevel});
            bizErr.setOperationResult(ret);
            throw bizErr;
        }
        return Boolean.TRUE;
    }

    private static boolean isValidateActionResultSuccess(Map<String, Object> resultMap, String operation, IFormView formView, String confirmCallBackClassName) {
        List actionResult = (List)resultMap.get("actionResult");
        if (null == actionResult || actionResult.isEmpty()) {
            return true;
        }
        boolean validateSuccess = true;
        HashMap<String, Object> arg = new HashMap<String, Object>(2);
        for (Object actionResultObj : actionResult) {
            if (!(actionResultObj instanceof Map)) continue;
            if ("showConfirm".equals(((Map)actionResultObj).get("a"))) {
                formView.getPageCache().put("confirmCallBackIdForValidator", operation);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmCallBackIdForValidator", confirmCallBackClassName);
                formView.getPageCache().put("ConfirmCallBackListener.confirmCallBackIdForValidator", SerializationUtils.toJsonString((Object)confirmCallBacks));
                validateSuccess = false;
                ((Map)((List)((Map)actionResultObj).get("p")).get(0)).put("id", "confirmCallBackIdForValidator");
                break;
            }
            if ("showForm".equals(((Map)actionResultObj).get("a"))) {
                validateSuccess = false;
                ((Map)((List)((Map)actionResultObj).get("p")).get(0)).put("parentPageId", formView.getPageId());
                break;
            }
            if (!"ShowNotificationMsg".equals(((Map)actionResultObj).get("a"))) continue;
            String pcShow = formView.getPageCache().get("isPCShow");
            if (null == pcShow || Boolean.parseBoolean(pcShow)) break;
            validateSuccess = false;
            break;
        }
        if (!validateSuccess) {
            arg.put("pageId", formView.getPageId());
            arg.put("actions", actionResult);
            ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("sendDynamicFormAction", arg, "confirmOperationResult");
            return false;
        }
        return true;
    }

    public static boolean isMustInputForApprovalMsg(IFormView view, String controlKey) {
        Control control = view.getControl(controlKey);
        if (!(control instanceof TextEdit)) {
            return true;
        }
        TextEdit field = (TextEdit)control;
        IDataEntityProperty property = field.getProperty();
        if (!(property instanceof MuliLangTextProp)) {
            return true;
        }
        return ((MuliLangTextProp)property).isMustInput();
    }

    public static void showRecallDelegateConfirmPage(Long taskId, Runnable method, IFormView view, String callBackId) {
        if (TaskDelegateUtil.isContainDeleTaskAndNotTrustee((Long)taskId, (Long)RequestContext.get().getCurrUserId())) {
            view.showConfirm(ResManager.loadKDString((String)"\u6b64\u4efb\u52a1\u5df2\u7ecf\u59d4\u6258\u7ed9\u4ed6\u4eba\uff0c\u60a8\u5904\u7406\u65f6\u4f1a\u6536\u56de\u53d7\u6258\u4eba\u5df2\u505a\u8fc7\u7684\u64cd\u4f5c\uff08\u5982\u8f6c\u4ea4\u3001\u534f\u529e\u3001\u540e\u52a0\u7b7e\uff09\uff0c\u60a8\u786e\u5b9a\u8981\u4eb2\u81ea\u5904\u7406\u5417\uff1f", (String)"WorkflowTCDataPlugin_60", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callBackId));
        } else {
            method.run();
        }
    }

    public static void initSignatureFP(IFormView view) {
        boolean isPcShow = ApprovalPluginUtil.isPCShow(view.getFormShowParameter());
        SignatureUtils.initSignatureFP((IFormView)view, (boolean)isPcShow);
    }

    public static void initSignatureFP(IFormView view, String flexPanelApSignature, String signatureField) {
        boolean isPcShow = ApprovalPluginUtil.isPCShow(view.getFormShowParameter());
        SignatureUtils.initSignatureFP((IFormView)view, (boolean)isPcShow, (String)flexPanelApSignature, (String)signatureField);
    }

    public static boolean checkForceSignature(IFormView view, String key) {
        Object auditSignatureObj = view.getModel().getValue(key);
        String auditSignature = ObjectUtils.toString((Object)auditSignatureObj);
        String info = SignatureUtils.checkForceSignature((IPageCache)view.getPageCache(), (String)auditSignature);
        if (WfUtils.isNotEmptyString((Object)info)) {
            view.showTipNotification(info);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

