/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.base.BaseShowParameter;
import kd.bos.base.MobileBaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.utils.MobileFormUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.workflow.bpmn.model.BillSetting;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.TaskHandleContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillPageAttributeConfigEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.management.plugin.WFBillSummaryUtil;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;
import kd.bos.workflow.taskcenter.plugin.util.ShowFormResult;

public class ShowForm {
    protected Log logger = LogFactory.getLog(this.getClass());
    private TaskHandleContext context;
    private String nodeType;
    private String formIdTemp;
    private IPageCache pageCache;
    private String targetKey;
    private Object parameterType;
    private String parentPageId;
    private CloseCallBack callBack;
    private String formId;
    private DynamicObject dynamicObject;
    private String formNumber;
    private DynamicObject billInfo;
    public static String NODETYPE_USER = "UserTask";
    public static String NODETYPE_AUDIT = "AuditTask";
    public static String MODELTYPE_MOB_NEWMBILLSUMMARYKEY = "$";
    public static String MODELTYPE_MOB_BILLSUMMARY = "billSummary";
    public static String MODELTYPE_PC_BaseFormModel = "BaseFormModel";

    public ShowFormResult build() {
        ShowFormResult result = new ShowFormResult();
        String validateMsg = this.getValidateMsg();
        if (null != validateMsg) {
            result.setErrorMsg(validateMsg);
            return result;
        }
        FormShowParameter parameter = this.getFormShowParameter();
        result.setSuccess(true);
        result.setParameter(parameter);
        return result;
    }

    private FormShowParameter getFormShowParameter() {
        if (!this.context.getPcShow().booleanValue() && this.formIdTemp.endsWith(MODELTYPE_MOB_NEWMBILLSUMMARYKEY)) {
            return this.getFormShowParameterForSummary();
        }
        if (this.formIdTemp.contains("billSummary")) {
            return this.getFormShowParameterForSummaryOld();
        }
        FormShowParameter parameter = this.buildFormShowParameterByModelType();
        this.setCommonFormShowParameter(parameter);
        if (NODETYPE_AUDIT.equals(this.nodeType)) {
            this.setFormShowParameterForAudit(parameter);
            if (parameter instanceof MobileFormShowParameter) {
                return parameter;
            }
            this.setBillShowParameter((BillShowParameter)parameter);
            return parameter;
        }
        this.setFormShowParameterForUser(parameter);
        if (parameter instanceof MobileFormShowParameter) {
            return parameter;
        }
        this.setBillShowParameter((BillShowParameter)parameter);
        return parameter;
    }

    private void setBillShowParameter(BillShowParameter parameter) {
        if (NODETYPE_USER.equals(this.nodeType) && "toHandle".equals(this.parameterType)) {
            parameter.setBillStatus(BillOperationStatus.EDIT);
        } else {
            parameter.setBillStatus(BillOperationStatus.VIEW);
        }
        String businesskey = this.context.getTask().getBusinessKey();
        if (null == businesskey || 0 == businesskey.length()) {
            return;
        }
        parameter.setPkId(WfUtils.getBusinessKeyFromEntityType((String)businesskey, (String)this.context.getTask().getEntityNumber()));
        this.logger.info("setBillShowParameter setDisableLayoutScheme:" + !WfConfigurationUtil.isJumpEmbeddedPageByBillType());
        parameter.setCustomParam("disableBillType", (Object)(!WfConfigurationUtil.isJumpEmbeddedPageByBillType() ? 1 : 0));
    }

    private void setFormShowParameterForUser(FormShowParameter parameter) {
        boolean isToApplyOrApplyed;
        if (this.context.getOnlyView().booleanValue()) {
            parameter.getCustomParams().put("VIEWBILL", Boolean.TRUE);
        }
        if ("toHandle".equals(this.parameterType)) {
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setCustomParam("istohandle", (Object)Boolean.TRUE);
        }
        boolean bl = isToApplyOrApplyed = "toApply".equals(this.parameterType) || "applyed".equals(this.parameterType);
        if (this.context.getOnlyView().booleanValue() || "handled".equals(this.parameterType) || isToApplyOrApplyed) {
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setCustomParam("istoapplyorapplyed", (Object)isToApplyOrApplyed);
            parameter.setCustomParam("showBillBtnsWhenToApplyOrApplyed", this.getShowBillBtnsWhenToApplyOrApplyedValue(this.context.getPcShow()));
        }
        parameter.addCustPlugin("kd.bos.workflow.taskcenter.plugin.ApprovalBillOperationPlugin");
        parameter.setCustomParam("type", this.parameterType);
        parameter.setCustomParam("parentPageId", (Object)this.parentPageId);
        parameter.setCloseCallBack(this.callBack);
    }

    private void setFormShowParameterForAudit(FormShowParameter parameter) {
        parameter.setCustomParam("onlyView", (Object)(this.context.getBillView() != false || this.context.isFromHistory() != false || !ManagementConstants.ACTIVE.getStateCode().equals(this.pageCache.get("SUSPENSIONSTATE")) ? 1 : 0));
        parameter.setCustomParam("taskid", (Object)this.context.getTaskId());
        parameter.setCustomParam("showBillBtnsWhenToApplyOrApplyed", this.getShowBillBtnsWhenToApplyOrApplyedValue(this.context.getPcShow()));
        String type = this.context.getType();
        if (("applyed".equals(type) || "toApply".equals(type)) && !"dynnApply".equals(this.parameterType)) {
            parameter.setCustomParam("istoapplyorapplyed", (Object)Boolean.TRUE);
        }
        parameter.setStatus(OperationStatus.VIEW);
    }

    private Object getShowBillBtnsWhenToApplyOrApplyedValue(Boolean isPCShow) {
        String showBillBtnsWhenToApplyOrApplyed = this.getPageCache().get("showBillBtnsWhenToApplyOrApplyed");
        if (WfUtils.isEmpty((String)showBillBtnsWhenToApplyOrApplyed) && null != isPCShow) {
            showBillBtnsWhenToApplyOrApplyed = isPCShow.toString();
        }
        return showBillBtnsWhenToApplyOrApplyed;
    }

    protected void setCommonFormShowParameter(FormShowParameter para_base) {
        String t;
        String processinstanceId;
        String billPageId = ApprovalPluginUtil.getBillPageId();
        this.pageCache.put("billPageId", billPageId);
        this.pageCache.put("approvalBillInnerPageId", billPageId);
        para_base.setFormId(this.formId);
        HashMap<String, Object> customParams = para_base.getCustomParams();
        if (WfUtils.isEmptyForMap((Map)customParams)) {
            customParams = new HashMap<String, Object>();
        }
        TaskInfo task = this.context.getTask();
        String entityNumber = task.getEntityNumber();
        customParams.put("entitynumber", entityNumber);
        customParams.put("businesskey", task.getBusinessKey());
        customParams.put("SOURCE", "WF");
        customParams.put("SCENE", "AUDITFLOW");
        customParams.put("CURNODE", this.pageCache.get("CURNODE"));
        customParams.put("bizIdentifyKey", this.pageCache.get("bizIdentifyKey"));
        customParams.put("processDefinitionId", task.getProcessDefinitionId());
        customParams.put("processInstanceId", task.getProcessInstanceId());
        customParams.put("taskDefinitionKey", task.getTaskDefinitionKey());
        customParams.put("businessKey", task.getBusinessKey());
        String pageParameter = this.context.getPageParameter();
        if (WfUtils.isNotEmpty((String)pageParameter)) {
            try {
                customParams.putAll((Map)SerializationUtils.fromJsonString((String)pageParameter, Map.class));
            }
            catch (Exception e) {
                this.logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        customParams.put("pcShow", this.context.getPcShow());
        customParams.put("formkey", this.formId);
        String appId = WfUtils.getAppIdForEntity((String)entityNumber);
        if (WfUtils.isNotEmptyString((Object)appId)) {
            customParams.put("ServiceAppId", appId);
        }
        if (WfUtils.isNotEmpty((String)(processinstanceId = this.pageCache.get("processInstanceId"))) && WfUtils.isNotEmpty((String)(t = (String)this.context.getVaraibleValue("appnumber")))) {
            appId = t;
        }
        if (!"bos".equalsIgnoreCase(appId)) {
            customParams.put("checkRightAppId", appId);
        }
        para_base.setCustomParams(customParams);
        para_base.addCustPlugin("kd.bos.workflow.runtime.plugin.ApprovalBillControlPlugIn");
        para_base.getOpenStyle().setShowType(ShowType.InContainer);
        para_base.getOpenStyle().setTargetKey(this.targetKey);
        para_base.setPageId(billPageId);
    }

    private FormShowParameter getFormShowParameterForSummaryOld() {
        this.logger.debug("ApprovalPlugin---\u8fdb\u5165\u5355\u636e\u6458\u8981\u4fe1\u606f");
        this.pageCache.put("showExtbtns", "false");
        List<String> disVisbleNumber = this.getDisVisbleNumbersForBill(this.context.getFlowElement(), this.context.getPcShow());
        String billSummaryKey = "billSummary_@_";
        if (this.formIdTemp.contains(billSummaryKey)) {
            this.formId = this.formIdTemp.split(billSummaryKey)[1];
        } else {
            Map billSummarys = MobileFormUtils.getBillSummarys((String)this.context.getTask().getEntityNumber());
            if (null != billSummarys && 0 != billSummarys.size()) {
                Set billSummaryKeys = billSummarys.keySet();
                Iterator billSummaryIte = billSummaryKeys.iterator();
                this.formId = (String)billSummaryIte.next();
            }
        }
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "wf_billsummary_mob");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("number", "bos_mobileform");
        customParam.put("businessPkId", this.context.getTask().getBusinessKey());
        customParam.put("businessNumber", this.context.getTask().getEntityNumber());
        customParam.put("billSummaryNumber", this.formId);
        customParam.put("configNumber", "null");
        customParam.put("disVisbleNumber", disVisbleNumber);
        customParam.put("bizApplier", this.pageCache.get("bizApplier"));
        customParam.put("bizApplierName", this.pageCache.get("bizApplierName"));
        showParameter.setCustomParams(customParam);
        showParameter.setClientParam("preview", (Object)"true");
        return showParameter;
    }

    protected FormShowParameter getFormShowParameterForSummary() {
        UserTask flowElement = this.context.getFlowElement();
        String type = this.context.getType();
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(this.formId);
        showParameter.setCustomParam("billid", (Object)this.context.getTask().getBusinessKey());
        showParameter.setCustomParam("dynamicObjectInfo", (Object)DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)this.billInfo));
        showParameter.setCustomParam("billtype", (Object)this.formNumber);
        showParameter.setCustomParam("configfields", this.dynamicObject.get("entryentity"));
        showParameter.setCustomParam("defaultrows", this.dynamicObject.get("defaultrows"));
        showParameter.setCustomParam("defaultdatarows", this.dynamicObject.get("defaultdatarows"));
        showParameter.setCustomParam("applier", (Object)this.context.getTask().getStarterId());
        showParameter.setCustomParam("billsummaryid", this.dynamicObject.get("id"));
        showParameter.setCustomParam("billsummarynumber", (Object)this.formId);
        showParameter.setCustomParam("disvisblenumber", this.getDisVisbleNumbersForBill(flowElement, this.context.getPcShow()));
        showParameter.setCustomParam("appliername", (Object)this.context.getTask().getStartName().getLocaleValue());
        showParameter.setCustomParam("type", (Object)type);
        showParameter.setCustomParam("SOURCE", (Object)"WF");
        showParameter.getOpenStyle().setTargetKey(this.targetKey);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setAppId(BizAppServiceHelp.getAppIdByFormNum((String)this.formNumber));
        if ("toHandle".equals(type) && WFBillSummaryUtil.editable(this.dynamicObject)) {
            showParameter.setStatus(OperationStatus.EDIT);
            if (this.context.getTaskCoordinate().booleanValue() && (flowElement.getAutoCoordinateModel() == null || !flowElement.getAutoCoordinateModel().isAutoCoordianteFieldModify())) {
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setCustomParam("type", (Object)"handled");
            }
        } else {
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("type", (Object)"handled");
        }
        if (!ManagementConstants.ACTIVE.getStateCode().equals(this.getPageCache().get("SUSPENSIONSTATE"))) {
            showParameter.setCustomParam("type", (Object)"handled");
            showParameter.setStatus(OperationStatus.VIEW);
        }
        String pageId = UUID.randomUUID().toString();
        this.pageCache.put("pageid", pageId);
        showParameter.setPageId(pageId);
        return showParameter;
    }

    private List<String> getDisVisbleNumbersForBill(UserTask currentNode, Boolean pcShow) {
        ArrayList<String> disVisbleNumber;
        block5: {
            BillSetting billSetting;
            block4: {
                disVisbleNumber = new ArrayList<String>();
                billSetting = currentNode.getBillSetting();
                if (billSetting == null) {
                    return disVisbleNumber;
                }
                if (!pcShow.booleanValue()) break block4;
                List pcConfigs = billSetting.getPageAttrConfig();
                if (pcConfigs == null || pcConfigs.isEmpty()) break block5;
                for (BillPageAttributeConfigEntity cfg : pcConfigs) {
                    if (!cfg.isHide()) continue;
                    disVisbleNumber.add(cfg.getFieldnumber());
                }
                break block5;
            }
            List mobileConfigs = billSetting.getMobilePageAttrConfig();
            if (mobileConfigs != null && !mobileConfigs.isEmpty()) {
                for (BillPageAttributeConfigEntity cfg : mobileConfigs) {
                    if (!cfg.isHide()) continue;
                    disVisbleNumber.add(cfg.getFieldnumber());
                }
            }
        }
        return disVisbleNumber;
    }

    private FormShowParameter buildFormShowParameterByModelType() {
        if (this.formIdTemp.endsWith("&mfm")) {
            return new MobileFormShowParameter();
        }
        if (this.formIdTemp.endsWith("&dfm")) {
            return new FormShowParameter();
        }
        QFilter q = new QFilter("number", "=", (Object)this.context.getTask().getEntityNumber());
        QFilter[] filters = new QFilter[]{q};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"modeltype", (QFilter[])filters);
        String modelType = dynamicObject.getString("modeltype");
        if (this.context.getPcShow().booleanValue()) {
            if (MODELTYPE_PC_BaseFormModel.equals(modelType)) {
                return new BaseShowParameter();
            }
            return new BillShowParameter();
        }
        if (MODELTYPE_PC_BaseFormModel.equals(modelType)) {
            return new MobileBaseShowParameter();
        }
        return new MobileBillShowParameter();
    }

    private String getValidateMsg() {
        if (!this.context.getBillExist().booleanValue()) {
            new ResManager();
            return ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u4e0d\u5b58\u5728\u3002", (String)"ShowBill_0", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        if (WfUtils.isEmpty((String)this.formIdTemp)) {
            new ResManager();
            return ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u5185\u5d4c\u8868\u5355\u3002", (String)"ShowBill_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        if (!this.context.getPcShow().booleanValue() && this.formIdTemp.endsWith(MODELTYPE_MOB_NEWMBILLSUMMARYKEY)) {
            this.formId = this.formIdTemp.substring(0, this.formIdTemp.length() - 1);
            QFilter qfilter = new QFilter("number", "=", (Object)this.formId);
            this.dynamicObject = null;
            try {
                this.dynamicObject = BusinessDataServiceHelper.loadSingle((String)"wf_mbillsummary_cfg", (String)"defaultrows,defaultdatarows,billtype,entryentity.fieldid,entryentity.fieldkey,entryentity.fieldname,entryentity.fieldtype,entryentity.isheadfield,entryentity.isdefaultshow,entryentity.entrylocation,entryentity.entrylocationid,entryentity.entrylocationname,entryentity.editable,entryentity.fieldpercent,entryentity.fontcolor,entryentity.fontsize", (QFilter[])new QFilter[]{qfilter});
            }
            catch (Exception e) {
                this.logger.info(String.format("billsummery %s is not exist", this.formId));
            }
            if (this.dynamicObject == null) {
                return String.format(ResManager.loadKDString((String)"\u5355\u636e\u6458\u8981\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApprovalPluginNew_158", (String)"bos-wf-formplugin", (Object[])new Object[0]), this.formId);
            }
            this.formNumber = this.dynamicObject.getString("billtype_id");
            this.billInfo = null;
            String businessKey = this.context.getTask().getBusinessKey();
            try {
                this.billInfo = BusinessDataServiceHelper.loadSingle((Object)businessKey, (String)this.formNumber);
            }
            catch (Exception e) {
                this.logger.info(String.format("bill %s is not exist", businessKey));
            }
            if (this.billInfo == null) {
                return String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApprovalPluginNew_159", (String)"bos-wf-formplugin", (Object[])new Object[0]), businessKey);
            }
        } else {
            this.formId = this.formIdTemp.endsWith("&mfm") ? this.formIdTemp.split("&mfm")[0] : this.formIdTemp;
        }
        if (!this.formId.contains(MODELTYPE_MOB_BILLSUMMARY) && !ApprovalPluginUtil.isExistForFormId(this.formId)) {
            new ResManager();
            return ResManager.loadKDString((String)"\u5355\u636e\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"ShowBill_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public ShowForm(TaskHandleContext context, String nodeType, String formIdTemp) {
        this.context = context;
        this.nodeType = nodeType;
        this.formIdTemp = formIdTemp;
    }

    public ShowForm() {
    }

    public TaskHandleContext getContext() {
        return this.context;
    }

    public ShowForm setContext(TaskHandleContext context) {
        this.context = context;
        return this;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public ShowForm setNodeType(String nodeType) {
        this.nodeType = nodeType;
        return this;
    }

    public String getFormIdTemp() {
        return this.formIdTemp;
    }

    public ShowForm setFormIdTemp(String formIdTemp) {
        this.formIdTemp = formIdTemp;
        return this;
    }

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    public ShowForm setPageCache(IPageCache pageCache) {
        this.pageCache = pageCache;
        return this;
    }

    public String getTargetKey() {
        return this.targetKey;
    }

    public ShowForm setTargetKey(String targetKey) {
        this.targetKey = targetKey;
        return this;
    }

    public Object getParameterType() {
        return this.parameterType;
    }

    public ShowForm setParameterType(Object parameterType) {
        this.parameterType = parameterType;
        return this;
    }

    public String getParentPageId() {
        return this.parentPageId;
    }

    public ShowForm setParentPageId(String parentPageId) {
        this.parentPageId = parentPageId;
        return this;
    }

    public CloseCallBack getCallBack() {
        return this.callBack;
    }

    public ShowForm setCallBack(CloseCallBack callBack) {
        this.callBack = callBack;
        return this;
    }
}

