/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LoadingType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ca.SignScheme;
import kd.bos.entity.ca.VerifySignInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.VarcharProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.operate.SignOperateCallback;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ca.SignCommandParam;
import kd.bos.servicehelper.ca.SignCommandResult;
import kd.bos.servicehelper.ca.SignServiceHelper;
import kd.bos.workflow.taskcenter.plugin.entity.SignInfoForBatch;
import kd.bos.workflow.util.WfCommonUtil;

public class SignServiceUtil {
    private static Log logger = LogFactory.getLog(SignServiceUtil.class);

    public static boolean getClearPin(SignScheme signScheme) {
        boolean clearPinStr = true;
        String signOperateStr = signScheme.getSignOperate();
        logger.info("ApprovalPluginUtil.doSignOperate sign signOperateStr: " + signOperateStr);
        List signOperateList = (List)SerializationUtils.fromJsonString((String)signOperateStr, List.class);
        Object clearPinObj = null;
        for (Object obj : signOperateList) {
            if (!(obj instanceof Map) || !((clearPinObj = ((Map)obj).get("ClearPin")) instanceof Boolean) || ((Boolean)clearPinObj).booleanValue()) continue;
            clearPinStr = false;
            break;
        }
        return clearPinStr;
    }

    public static DynamicObjectCollection getSignDocs(String formId, List<Object> ids) {
        ids = SignServiceUtil.isStringPk(formId) ? ids.stream().map(id -> String.valueOf(id)).collect(Collectors.toList()) : ids.stream().map(id -> Long.parseLong(id.toString())).collect(Collectors.toList());
        ORM orm = ORM.create();
        return orm.getByIds(formId, ids);
    }

    private static boolean isStringPk(String formId) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        ISimpleProperty pkProp = type.getPrimaryKey();
        return pkProp instanceof VarcharProp;
    }

    public static SignInfoForBatch collectionData(IFormView view) {
        DynamicObject[] collection;
        SignInfoForBatch signInfoForBatch = new SignInfoForBatch();
        String taskIdsStr = (String)view.getFormShowParameter().getCustomParam("taskids");
        logger.info("SignServiceUtil.collectionData taskids: " + taskIdsStr);
        String[] arrs = taskIdsStr.split(",");
        Long[] taskids = new Long[arrs.length];
        int i = 0;
        for (String val : arrs) {
            taskids[i] = Long.valueOf(val);
            ++i;
        }
        for (DynamicObject dynamicObject : collection = BusinessDataServiceHelper.load((String)"wf_task", (String)"businesskey, control, entitynumber, id, billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)taskids)})) {
            Long taskId = dynamicObject.getLong("id");
            String control = dynamicObject.getString("control");
            Map valueFromMapJson = WfCommonUtil.getValueFromMapJson((String)control);
            String billNo = dynamicObject.getString("billno");
            boolean verifySignSetting = WfCommonUtil.getBooleanValueFromJson((Map)valueFromMapJson, (String)"dataSignedVerify");
            boolean signSetting = WfCommonUtil.getBooleanValueFromJson((Map)valueFromMapJson, (String)"dataSignedAdd");
            if (!verifySignSetting && !signSetting) {
                signInfoForBatch.addNoSignTaskIds(taskId);
                continue;
            }
            String entityNumberStr = dynamicObject.getString("entitynumber");
            if (null == signInfoForBatch.getEntityNumber()) {
                signInfoForBatch.setEntityNumber(entityNumberStr);
            }
            if (signInfoForBatch.isSignForSameEntity() && !signInfoForBatch.getEntityNumber().equals(entityNumberStr)) {
                signInfoForBatch.setSignForSameEntity(false);
            }
            String businessKey = dynamicObject.getString("businesskey");
            signInfoForBatch.putBusinessAndBillnoMapping(businessKey, billNo);
            if (verifySignSetting) {
                signInfoForBatch.putVerifySignTask(businessKey, taskId);
            }
            if (!signSetting) continue;
            signInfoForBatch.putSignTask(businessKey, taskId);
        }
        view.getPageCache().put("totalCount", String.valueOf(taskids.length));
        return signInfoForBatch;
    }

    public static boolean isControlSetting(String control, String field) {
        if (null == control || control.isEmpty()) {
            return false;
        }
        Map controlMap = (Map)SerializationUtils.fromJsonString((String)control, Map.class);
        if (null == controlMap || controlMap.isEmpty()) {
            return false;
        }
        Object value = controlMap.get(field);
        if (null == value) {
            return false;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public static void verifySignsForBatch(SignInfoForBatch signInfoForBatch, List<String> failList) {
        if (!signInfoForBatch.isNeedVerifySignTask()) {
            return;
        }
        Map<String, List<Long>> verifySignMapping = signInfoForBatch.getVerifySignTask();
        List businessKeys = verifySignMapping.keySet().stream().collect(Collectors.toList());
        logger.debug("SignServiceUtil.verifySignsForBatch() entityNumber: " + signInfoForBatch.getEntityNumber() + ";businessKeys: " + businessKeys);
        Map verifyResult = SignServiceHelper.verifySignByIds((String)signInfoForBatch.getEntityNumber(), businessKeys);
        for (Map.Entry entry : verifyResult.entrySet()) {
            VerifySignInfo verifySignInfo = (VerifySignInfo)entry.getValue();
            logger.debug("SignServiceUtil.verifySignsForBatch() verifySignInfo : " + verifySignInfo + ";verifySignInfo.isSuccess(): " + verifySignInfo.isSuccess());
            if (verifySignInfo.isSuccess()) continue;
            String businessKey = String.valueOf(entry.getKey());
            logger.debug("SignServiceUtil.verifySignsForBatch() businessKey : " + businessKey);
            signInfoForBatch.removeTask(businessKey);
            StringBuilder failMsg = new StringBuilder();
            failMsg.append("[").append(signInfoForBatch.getBusinessAndBillnoMapping().get(businessKey)).append("]").append(verifySignInfo.getMessage());
            failList.add(failMsg.toString());
        }
        logger.debug("SignServiceUtil.verifySignsForBatch() failList : " + failList);
    }

    public static boolean signForBatch(SignInfoForBatch signInfoForBatch, SignScheme signScheme, SignOperateCallback signOperateCallback, List<String> failList, IFormView view) {
        if (!signInfoForBatch.isNeedSignTask()) {
            return false;
        }
        List<Object> businessKeys = signInfoForBatch.getSignTask().keySet().stream().collect(Collectors.toList());
        boolean clearPin = SignServiceUtil.getClearPin(signScheme);
        logger.debug("SignServiceUtil.signForBatch clearPin:" + clearPin);
        DynamicObjectCollection docs = SignServiceUtil.getSignDocs(signInfoForBatch.getEntityNumber(), businessKeys);
        SignServiceUtil.setSignOperateCallbackOption(signOperateCallback);
        logger.debug("SignServiceUtil.signForBatch businessKeys:" + businessKeys);
        SignCommandParam signParam = new SignCommandParam(signInfoForBatch.getEntityNumber(), docs, signOperateCallback, clearPin, false);
        SignCommandResult signResult = SignServiceHelper.sendClientSignCommand((SignCommandParam)signParam);
        logger.info("SignServiceUtil.signForBatch signResult:" + signResult);
        List needPkIds = signResult.getNeedPkIds();
        logger.debug("SignServiceUtil.signForBatch signResult needPkIds:" + needPkIds);
        if (null == needPkIds || needPkIds.isEmpty()) {
            return false;
        }
        List notNeedPkIds = signResult.getNotNeedPkIds();
        logger.debug("SignServiceUtil.signForBatch signResult notNeedPkIds:" + notNeedPkIds);
        for (Object pkId : notNeedPkIds) {
            String businessKey = String.valueOf(pkId);
            signInfoForBatch.getNoSignTaskIds().addAll((Collection<Long>)signInfoForBatch.getSignTask().get(businessKey));
            signInfoForBatch.removeTask(businessKey);
        }
        logger.debug("SignServiceUtil.signForBatch signResult notNeedPkIds noSignTaskIds:" + signInfoForBatch.getNoSignTaskIds());
        OperationResult opResult = signResult.getOperationResult();
        logger.info("SignServiceUtil.signForBatch opResult:" + opResult + ";opResult.isSuccess(): " + opResult.isSuccess());
        if (opResult.isSuccess()) {
            SignServiceUtil.showLoading(view, ResManager.loadKDString((String)"\u6279\u91cf\u6dfb\u52a0\u6570\u5b57\u7b7e\u540d\u4e2d\u3002", (String)"SignServiceUtil_02", (String)"bos-wf-formplugin", (Object[])new Object[0]), true);
            HashMap<String, String> cacheMap = new HashMap<String, String>();
            cacheMap.put("signInfoForBatch", SerializationUtils.toJsonString((Object)signInfoForBatch));
            cacheMap.put("failList", SerializationUtils.toJsonString(failList));
            view.getPageCache().put(cacheMap);
            return true;
        }
        StringBuilder failMsg = null;
        for (Object pkId : needPkIds) {
            String businessKey = String.valueOf(pkId);
            signInfoForBatch.removeTask(businessKey);
            failMsg = new StringBuilder();
            failMsg.append("[").append(signInfoForBatch.getBusinessAndBillnoMapping().get(businessKey)).append("]").append(opResult.getMessage());
            failList.add(failMsg.toString());
        }
        logger.debug("SignServiceUtil.signForBatch failList :" + failList);
        return false;
    }

    public static void setSignOperateCallbackOption(SignOperateCallback signOperateCallback) {
        OperateOption options = OperateOption.create();
        options.setVariableValue("isStrict", "false");
        options.setVariableValue("signCallbackFlag", "true");
        options.setVariableValue("signFirstSave", "false");
        options.setVariableValue("isStrict", "false");
        signOperateCallback.setOption(options);
    }

    public static void showLoading(IFormView view, String msg, boolean visible) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(4);
        paraMap.put("text", msg);
        paraMap.put("type", LoadingType.Default.getType());
        paraMap.put("visible", visible);
        paraMap.put("pageId", view.getPageId());
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction("setPageLoading", paraMap);
    }
}

