/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.service.separatestorage.SeparateStorageFormService;
import kd.bos.workflow.task.TaskModelExternalService;
import kd.bos.workflow.task.utils.TaskModelUtils;

public class WorkflowTCDataPluginUtil {
    private static Log logger = LogFactory.getLog(WorkflowTCDataPluginUtil.class);
    public static final String ERROR_INFO = "errorInfo";
    public static final String TASKISNOTEXIST = "taskIsNotExist";
    public static final String HANDLEDATA = "handleData";
    private static final String WORKFLOW_TC_DATA_PLUGIN_5 = "WorkflowTCDataPlugin_5";

    public static boolean showMCenterTaskAndProcessPage(Long id, IFormView view, CloseCallBack callBack, String type) {
        TaskInfo taskInfo = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getTaskService().findTaskByIdAndType(id, type);
        if (taskInfo == null) {
            return false;
        }
        if ("toHandle".equals(type) || "handled".equals(type)) {
            if (TaskModelUtils.isBizTaskOpenByBrowserTab((TaskInfo)taskInfo)) {
                return WorkflowTCDataPluginUtil.showTaskHandlePageByOpenUrl(taskInfo, view);
            }
            return WorkflowTCDataPluginUtil.showApprovalPage(id, taskInfo, view, callBack, type);
        }
        return WorkflowTCDataPluginUtil.showApprovalPage(id, taskInfo, view, callBack, type);
    }

    public static Boolean showApprovalPage(Long id, TaskInfo taskInfo, IFormView view, CloseCallBack callBack, String type) {
        if (WorkflowTCDataPluginUtil.hasCurrentPageTab(id, type, view)) {
            return Boolean.TRUE;
        }
        return WorkflowTCDataPluginUtil.showApprovalPageDetail(view, id, taskInfo, callBack, type);
    }

    @Deprecated
    public static Boolean showApprovalPage(Long taskId, IFormView view, CloseCallBack callBack, String type) {
        TaskInfo taskInfo = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getTaskService().findTaskByIdAndType(taskId, type);
        return WorkflowTCDataPluginUtil.showApprovalPage(taskId, taskInfo, view, callBack, type);
    }

    public static Boolean showTaskHandlePageByOpenUrl(TaskInfo taskInfo, IFormView view) {
        TaskModelExternalService taskModelService = TaskModelExternalService.create();
        String trdSsoUrl = taskModelService.getFormServiceLink(taskInfo, true);
        if (WfUtils.isNotEmpty((String)trdSsoUrl)) {
            view.openUrl(trdSsoUrl);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Boolean showApprovalPageDetail(IFormView view, Long id, TaskInfo taskInfo, CloseCallBack callBack, String type) {
        FormShowParameter parameter = WorkflowTCDataPluginUtil.getApprovalParameter(id, taskInfo, callBack, view.getParentView(), type);
        ArchiveFormService.create().setArchiveRouteInfo(view, parameter);
        SeparateStorageFormService.create().setSeparateStorageKey(parameter);
        Object errorInfo = parameter.getCustomParam(ERROR_INFO);
        if (WfUtils.isNotEmptyString((Object)errorInfo)) {
            if (TASKISNOTEXIST.equals(errorInfo)) {
                return Boolean.FALSE;
            }
            view.showTipNotification((String)errorInfo, Integer.valueOf(3000));
        } else {
            IFormView formView = view.getParentView();
            if (null != formView) {
                formView.showForm(parameter);
                view.sendFormAction(formView);
            } else {
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                view.showForm(parameter);
            }
        }
        return Boolean.TRUE;
    }

    public static void openBillViewParameter(String type, Long taskId, IFormView view, String billFormId) {
        if (WorkflowTCDataPluginUtil.hasCurrentPageTab(taskId, "showBill" + type, view)) {
            return;
        }
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskService taskService = wfService.getTaskService();
        Map billInfo = taskService.getBillForTaskCenter(taskId, type);
        String entitynumber = null;
        String businesskey = null;
        String formkey = null;
        String billType = null;
        String procInstId = null;
        String formkeyview = null;
        String taskDefinitionKey = null;
        if (billInfo == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u8981\u67e5\u770b\u7684\u6570\u636e\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u518d\u8bd5\u3002", (String)"WorkflowTCDataPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        entitynumber = (String)billInfo.get("entitynumber");
        businesskey = (String)billInfo.get("businesskey");
        formkey = (String)billInfo.get("formkey");
        formkeyview = (String)billInfo.get("formkeyview");
        billType = (String)billInfo.get("billtype");
        procInstId = (String)billInfo.get("processinstanceid");
        taskDefinitionKey = (String)billInfo.get("taskDefinitionKey");
        boolean isBillExist = WfUtils.exist((String)entitynumber, (Object)businesskey);
        if (!isBillExist) {
            view.showTipNotification(WFMultiLangConstants.getBillNotExistTip(), Integer.valueOf(3000));
        } else {
            if (null == formkey || 0 == formkey.trim().length()) {
                formkey = !WfUtils.isEmptyString((Object)formkeyview) ? formkeyview : entitynumber;
            }
            if (WfUtils.isEmpty((String)formkey) || WfUtils.isEmpty((String)businesskey)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u53ef\u80fd\u5df2\u7ecf\u88ab\u5176\u4ed6\u4eba\u5904\u7406\uff0c\u5c0f\u4e91\u6b63\u5728\u4e3a\u60a8\u5237\u65b0\u9875\u9762\uff0c\u4ee5\u83b7\u53d6\u6700\u65b0\u6570\u636e\u3002", (String)WORKFLOW_TC_DATA_PLUGIN_5, (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            FormShowParameter para_base = new FormShowParameter();
            para_base.getCustomParams().put("source", "taskmonitor");
            para_base.getCustomParams().put("rowId", taskId);
            para_base.getCustomParams().put("pkId", WfUtils.getBusinessKeyFromEntityType((String)businesskey, (String)entitynumber));
            para_base.getCustomParams().put("BillFormId", billFormId);
            para_base.getCustomParams().put("type", type);
            para_base.getCustomParams().put("procInstId", procInstId);
            para_base.getCustomParams().put("taskId", taskId);
            para_base.setCustomParam("taskDefinitionKey", (Object)taskDefinitionKey);
            para_base.setCustomParam("formkey", (Object)formkey);
            para_base.setCustomParam("businessKey", (Object)businesskey);
            para_base.setCustomParam("entityNumber", (Object)entitynumber);
            ArchiveFormService.create().setArchiveRouteInfo(view, para_base);
            String appId = WfUtils.getAppIdForEntity((String)entitynumber);
            if (WfUtils.isNotEmptyString((Object)appId)) {
                para_base.getCustomParams().put("ServiceAppId", appId);
            }
            para_base.getCustomParams().put("formId", formkey);
            String name = WfUtils.getEntityNameProperty((String)formkey, (String)billType).getLocaleValue();
            para_base.setCaption(name);
            if ("NoCodeFlow".equalsIgnoreCase((String)billInfo.get("processtype"))) {
                para_base.setFormId("bos_nocode_approvalpage");
            } else {
                para_base.setFormId("wf_openbills");
            }
            para_base.setPageId(WorkflowTCDataPluginUtil.getPageId(taskId, "showBill" + type, view));
            para_base.getOpenStyle().setTargetKey(WorkflowTCDataPluginUtil.getTargetTab());
            para_base.getOpenStyle().setShowType(ShowType.NewTabPage);
            view.showForm(para_base);
        }
    }

    public static boolean hasCurrentPageTab(long taskId, String type, IFormView view) {
        if (view.getParentView() == null) {
            return false;
        }
        IFormView formView = WorkflowTCDataPluginUtil.getCurrentPageTab(taskId, type, view.getParentView());
        if (formView != null) {
            formView.activate();
            WorkflowTCDataPluginUtil.clearSelectData(view);
            view.sendFormAction(formView);
            return true;
        }
        return false;
    }

    public static void clearSelectData(IFormView formView) {
        if (formView instanceof IListView) {
            IListView view = (IListView)formView;
            view.clearSelection();
        }
    }

    public static String getPageId(long taskId, String type, IFormView view) {
        String pageId = UUID.randomUUID().toString();
        if (null != view) {
            IPageCache parentPageCache = (IPageCache)view.getService(IPageCache.class);
            parentPageCache.put(WorkflowTCDataPluginUtil.getPageIdKey(taskId, type, view), pageId);
        }
        return pageId;
    }

    public static String getTargetTab() {
        return "_submaintab_";
    }

    public static IFormView getCurrentPageTab(long taskId, String type, IFormView view) {
        IFormView formView = null;
        if (WfUtils.isEmpty((String)type)) {
            type = HANDLEDATA;
        }
        if (null != view) {
            String pageIdkey = WorkflowTCDataPluginUtil.getPageIdKey(taskId, type, view);
            IPageCache parentPageCache = (IPageCache)view.getService(IPageCache.class);
            String pageId = parentPageCache.get(pageIdkey);
            if (WfUtils.isNotEmpty((String)pageId)) {
                formView = view.getViewNoPlugin(pageId);
            }
        }
        return formView;
    }

    public static FormShowParameter getApprovalParameter(Long taskId, CloseCallBack callBack, IFormView view) {
        TaskInfo taskInfo = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getTaskService().findTaskByIdAndType(taskId, "toHandle");
        return WorkflowTCDataPluginUtil.getApprovalParameter(taskId, taskInfo, callBack, view, "toHandle");
    }

    public static FormShowParameter getApprovalParameter(Long id, TaskInfo entity, CloseCallBack callBack, IFormView view, String type) {
        Boolean active;
        FormShowParameter parameter = new FormShowParameter();
        if (entity == null) {
            parameter.setCustomParam(ERROR_INFO, (Object)TASKISNOTEXIST);
            return parameter;
        }
        String entityNumber = entity.getEntityNumber();
        String businessKey = entity.getBusinessKey();
        if (WfUtils.isNotEmpty((String)entityNumber) && WfUtils.isNotEmpty((String)businessKey)) {
            boolean isBillExist = true;
            try {
                isBillExist = WfUtils.exist((String)entity.getEntityNumber(), (Object)entity.getBusinessKey());
            }
            catch (Exception e) {
                isBillExist = false;
            }
            if (!isBillExist) {
                parameter.setCustomParam(ERROR_INFO, (Object)WFMultiLangConstants.getBillNotExistTip());
                return parameter;
            }
        }
        if (StringUtils.isNotBlank((Object)(active = Boolean.valueOf(entity.isActive()))) && !active.booleanValue()) {
            parameter.setCustomParam(ERROR_INFO, (Object)ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u88ab\u51bb\u7ed3\uff0c\u4e0d\u80fd\u5904\u7406\u3002", (String)"WorkflowTCDataPluginUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return parameter;
        }
        String processingpage = entity.getProcessingPage();
        if (WfUtils.isEmpty((String)processingpage) || processingpage.equals("wf_approvalpage")) {
            processingpage = "wf_approvalpage_bac";
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("taskId", id);
        customParams.put("type", type);
        customParams.put("billExist", Boolean.TRUE);
        ILocaleString captain = entity.getCaptionPC();
        if (null == captain || WfUtils.isEmpty((ILocaleString)captain)) {
            ILocaleString entityNameLocal = entity.getEntityName();
            ILocaleString entityName = WfUtils.isNotEmpty((ILocaleString)entityNameLocal) ? entityNameLocal : WfUtils.getMultiLangValue((String)"");
            captain = WfMultiLangUtils.getMultiLangValueCaption((ILocaleString)entity.getStartName(), (ILocaleString)entityName);
        }
        if (captain != null && !WfUtils.isEmpty((String)captain.getLocaleValue())) {
            customParams.put("pCaption", captain.getLocaleValue());
        }
        if (!"toHandle".equals(type)) {
            customParams.put("onlyView", Boolean.TRUE);
        }
        if ("botp_convertop".equals(processingpage)) {
            processingpage = "toApply".equals(type) || "applyed".equals(type) ? "wf_approvalbill" : "wf_approvalpage_bac";
            customParams.put("onlyView", Boolean.TRUE);
        }
        if (entity.getControl() != null) {
            customParams.put("control", entity.getControl());
        }
        if (entity.getEntityNumber() != null) {
            customParams.put("entityNumber", entity.getEntityNumber());
        }
        if (entity.getBusinessKey() != null) {
            customParams.put("businessKey", entity.getBusinessKey());
        }
        if (entity.getProcessInstanceId() != null) {
            customParams.put("procInstId", entity.getProcessInstanceId());
        }
        customParams.put("processDefinitionId", entity.getProcessDefinitionId());
        customParams.put("processInstanceId", entity.getProcessInstanceId());
        customParams.put("category", entity.getCategory());
        customParams.put("taskdefinitionkey", entity.getTaskDefinitionKey());
        WorkflowTCDataPluginUtil.packageParameterForNoCodeFlow(entity, customParams);
        parameter.setPageId(WorkflowTCDataPluginUtil.getPageId(id, type, view));
        if (WfUtils.isTileMenuModel()) {
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        } else {
            parameter.getOpenStyle().setTargetKey(WorkflowTCDataPluginUtil.getTargetTab());
            parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        }
        parameter.setCustomParams(customParams);
        if (null != callBack) {
            parameter.setCloseCallBack(callBack);
        }
        parameter.setFormId(processingpage);
        parameter.addCustPlugin("kd.bos.workflow.autogonext.plugin.ApprovalBeforeClosedPlugin");
        return parameter;
    }

    @Deprecated
    public static FormShowParameter getApprovalParameter(Long id, CloseCallBack callBack, IFormView view, String type) {
        TaskInfo taskInfo = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getTaskService().findTaskByIdAndType(id, type);
        return WorkflowTCDataPluginUtil.getApprovalParameter(id, taskInfo, callBack, view, type);
    }

    private static void packageParameterForNoCodeFlow(TaskInfo entity, HashMap<String, Object> customParams) {
        HistoricProcessInstanceEntity processInstance;
        if (entity == null || !ModelType.NoCodeFlow.name().equalsIgnoreCase(entity.getProcessType())) {
            return;
        }
        if (!"UserTask".equalsIgnoreCase(entity.getCategory())) {
            return;
        }
        Object type = customParams.get("type");
        if ("toHandle".equals(type)) {
            if (entity.getTaskDefinitionKey() != null) {
                customParams.put("userTaskActivityId", entity.getTaskDefinitionKey());
            }
            if (entity.getBusinessKey() != null) {
                customParams.put("userTaskBusinessKey", entity.getBusinessKey());
            }
            if (entity.getEntityNumber() != null) {
                customParams.put("userTaskEntityNumber", entity.getEntityNumber());
            }
            RuntimeService runtimeService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRuntimeService();
            logger.info("packageParameterForNoCodeFlow runtimeService : " + runtimeService);
            if (runtimeService != null) {
                List identityLinkEntities = runtimeService.getIdentityLinksByTaskId(entity.getId());
                StringBuilder userIds = new StringBuilder();
                String userIdsStr = "";
                for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                    if (!"participant".equals(identityLinkEntity.getType())) continue;
                    userIds.append(identityLinkEntity.getUserId()).append(',');
                }
                if (WfUtils.isNotEmptyString((Object)userIds)) {
                    userIdsStr = userIds.toString();
                    userIdsStr = userIdsStr.length() != 0 ? userIdsStr.substring(0, userIdsStr.length() - 1) : "";
                }
                customParams.put("userTaskCurrentUserId", userIdsStr);
            }
        } else if ("handled".equals(type)) {
            if (entity.getTaskDefinitionKey() != null) {
                customParams.put("userTaskActivityId", entity.getTaskDefinitionKey());
            }
            if (entity.getBusinessKey() != null) {
                customParams.put("userTaskBusinessKey", entity.getBusinessKey());
            }
            if (entity.getEntityNumber() != null) {
                customParams.put("userTaskEntityNumber", entity.getEntityNumber());
            }
            if (entity instanceof HistoricTaskInstanceEntityImpl) {
                logger.debug("packageParameterForNoCodeFlow not todo");
                customParams.put("userTaskCurrentUserId", ((HistoricTaskInstanceEntityImpl)entity).getAssigneeId());
            }
        }
        logger.info("packageParameterForNoCodeFlow userTaskCurrentUserId : " + customParams.get("userTaskCurrentUserId"));
        if (entity.getHandleState() != null) {
            customParams.put("handleState", entity.getHandleState());
        }
        if (entity.getExecutionId() != null && (processInstance = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getHistoryService().getHistoricProcessInstance(entity.getProcessInstanceId())) != null) {
            customParams.put("entityNumber", processInstance.getEntitynumber());
            customParams.put("businessKey", processInstance.getBusinessKey());
        }
    }

    public static void manualDraw(Long taskId, AbstractFormPlugin plugin, String closecallbackafterconvert) {
        IFormView formView = plugin.getView().getParentView();
        String formatType = String.format("%s%s", "toHandle", "_button");
        if (WorkflowTCDataPluginUtil.hasCurrentPageTab(taskId, formatType, plugin.getView())) {
            return;
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPageId(WorkflowTCDataPluginUtil.getPageId(taskId, formatType, formView));
        billShowParameter.getOpenStyle().setTargetKey(WorkflowTCDataPluginUtil.getTargetTab());
        billShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        Map params = wfService.getTaskService().getTargetEntityInfoByTaskId(taskId);
        String targetEntityNumber = (String)params.get("entityNumber");
        if (WfUtils.isEmpty((String)targetEntityNumber)) {
            billShowParameter.setCustomParam(ERROR_INFO, (Object)ResManager.loadKDString((String)"\u8ba1\u7b97\u5f53\u524d\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"WorkflowTCDataPluginUtil_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        billShowParameter.setFormId(targetEntityNumber);
        billShowParameter.addCustPlugin("kd.bos.workflow.runtime.plugin.BillConvertControlPlugin");
        billShowParameter.setHasRight(true);
        params.put("isIgnoreLicense", Boolean.TRUE);
        params.put("taskid", taskId);
        billShowParameter.setCustomParams(params);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, closecallbackafterconvert));
        formView.showForm((FormShowParameter)billShowParameter);
        plugin.getView().sendFormAction(formView);
    }

    public static void manualPush(List<Long> taskIds, String processingPage, AbstractFormPlugin plugin, String callbackKey) {
        try {
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            ConvertOpParameter opParameter = wfService.getTaskService().buildConvertOpParameter(taskIds);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(processingPage);
            showParameter.getCustomParams().put("opparam", SerializationUtils.toJsonString((Object)opParameter));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCaption(ResManager.loadKDString((String)"\u4e0b\u63a8", (String)"WorkflowTCDataPluginUtil_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, callbackKey));
            showParameter.setHasRight(true);
            showParameter.getCustomParams().put("isIgnoreLicense", Boolean.TRUE);
            plugin.getView().showForm(showParameter);
        }
        catch (WFEngineException e) {
            plugin.getView().showTipNotification(e.getMessage());
        }
        catch (Exception e) {
            plugin.getView().showErrMessage(WfUtils.getExceptionStacktrace((Throwable)e), ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\u3002", (String)"WorkflowTCDataPluginUtil_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private static String getPageIdKey(long taskId, String type, IFormView view) {
        String pageIdkey = type + taskId;
        if (null != RequestContext.get()) {
            pageIdkey = pageIdkey + RequestContext.get().getUserId();
        }
        if (null != view) {
            pageIdkey = pageIdkey + view.getPageId();
        }
        return pageIdkey;
    }

    public static FormShowParameter getCirculateLogParameter(Long taskId) {
        FormShowParameter para = new FormShowParameter();
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setFormId("wf_taskcirculationlog");
        para.setCustomParam("taskid", (Object)taskId);
        para.setCaption(ResManager.loadKDString((String)"\u4f20\u9605\u8bb0\u5f55", (String)"WorkflowTCDataPluginUtil_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        return para;
    }
}

