/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.lang.Lang;
import kd.bos.mservice.svc.picture.IPictureProp;
import kd.bos.param.ParameterReader;
import kd.bos.workflow.engine.WfUtils;

public class RequiredValidator {
    private String entityNumber;
    private DynamicObject dataEntity;
    private Map<String, String> requiredFieldInfoMap;

    public RequiredValidator(String entityNumber, DynamicObject dataEntity, Map<String, String> requiredFieldInfoMap) {
        this.entityNumber = entityNumber;
        this.dataEntity = dataEntity;
        this.requiredFieldInfoMap = requiredFieldInfoMap;
    }

    public OperationResult validate() {
        if (null == this.requiredFieldInfoMap || this.requiredFieldInfoMap.isEmpty() || WfUtils.isEmpty((String)this.entityNumber) || null == this.dataEntity) {
            return null;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.entityNumber);
        if (null == mainType) {
            return null;
        }
        ValidateResultCollection validateResultCollection = new ValidateResultCollection();
        String fieldKey = null;
        String fieldName = null;
        DynamicProperty vProperty = null;
        Map entities = mainType.getAllEntities();
        Collection entityTypeCollection = entities.values();
        Iterator<Map.Entry<String, String>> ite = this.requiredFieldInfoMap.entrySet().iterator();
        Map.Entry<String, String> entry = null;
        String fieldKeyForEntry = null;
        block0: while (ite.hasNext()) {
            entry = ite.next();
            fieldKey = entry.getKey();
            if (WfUtils.isEmpty((String)fieldKey)) continue;
            fieldName = entry.getValue();
            if (!fieldKey.contains(".")) {
                vProperty = this.getVProperty(fieldKey, (EntityType)mainType);
                this.validateField(fieldName, vProperty, this.entityNumber, validateResultCollection);
                continue;
            }
            for (EntityType entityType : entityTypeCollection) {
                if (!(entityType instanceof EntryType) || !(fieldKeyForEntry = fieldKey.split("\\.")[0]).equals(entityType.getName())) continue;
                vProperty = this.getVProperty(fieldKey.split("\\.")[1], entityType);
                this.validateField(fieldName, vProperty, fieldKeyForEntry, validateResultCollection);
                continue block0;
            }
        }
        List validateResults = validateResultCollection.getValidateErrors();
        if (null == validateResults || validateResults.isEmpty()) {
            return null;
        }
        OperationResult operationResult = new OperationResult();
        operationResult.setValidateResult(validateResultCollection);
        operationResult.setSuccess(false);
        operationResult.setBillCount(1);
        operationResult.setMessage(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"RequiredValidator_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        return operationResult;
    }

    private DynamicProperty getVProperty(String fieldKey, EntityType entityType) {
        DynamicProperty vProperty = entityType.getProperty(fieldKey);
        if (vProperty instanceof BasedataProp) {
            vProperty = ((BasedataProp)vProperty).getCompareProp();
        } else if (vProperty instanceof RefBillProp) {
            vProperty = ((RefBillProp)vProperty).getCompareProp();
        }
        return vProperty;
    }

    public void validateField(String fieldName, DynamicProperty vProperty, String entityKey, ValidateResultCollection validateResultCollection) {
        ExtendedDataEntity[] extDataEntities;
        if (null == vProperty) {
            return;
        }
        boolean enableNull = vProperty.isEnableNull();
        DynamicObject[] dataEntities = new DynamicObject[]{this.dataEntity};
        ExtendedDataEntitySet extendDataEntitySet = new ExtendedDataEntitySet();
        if (dataEntities != null && dataEntities.length > 0) {
            extendDataEntitySet.Parse(dataEntities, (MainEntityType)dataEntities[0].getDataEntityType());
        }
        for (ExtendedDataEntity extDataEntity : extDataEntities = extendDataEntitySet.FindByEntityKey(entityKey)) {
            if (vProperty instanceof GeoPointProp) {
                this.geoPointValidator(extDataEntity, vProperty, fieldName, validateResultCollection, enableNull);
                break;
            }
            Object value = vProperty.getValue((Object)extDataEntity.getDataEntity());
            if (value == null && vProperty instanceof IPictureProp) {
                value = ((IPictureProp)vProperty).getDefaultImgKey();
            }
            if (!(vProperty instanceof MuliLangTextProp) && (!enableNull && ((IValidatorHanlder)vProperty).getValueComparator().compareValue(value) || enableNull && value == null)) {
                this.buildErrMessage(extDataEntity, vProperty, fieldName, null, validateResultCollection);
                break;
            }
            if (!(vProperty instanceof MuliLangTextProp)) continue;
            this.muliLangTextValidator(extDataEntity, vProperty, fieldName, validateResultCollection, value, enableNull);
            break;
        }
    }

    private void muliLangTextValidator(ExtendedDataEntity extDataEntity, DynamicProperty vProperty, String fieldName, ValidateResultCollection validateResultCollection, Object value, boolean enableNull) {
        String mustLanStr;
        ArrayList<String> mustInputLang = null;
        DynamicObject billParam = ParameterReader.getBillParameter((String)this.entityNumber);
        if (billParam != null && StringUtils.isNotBlank((CharSequence)(mustLanStr = billParam.getString("mul_lan_input_setting")))) {
            String[] mustLang = mustLanStr.split(",");
            mustInputLang = new ArrayList<String>(5);
            for (String lan : mustLang) {
                if (StringUtils.isEmpty((CharSequence)lan)) continue;
                mustInputLang.add(lan);
            }
        }
        ArrayList<String> mustInputLan = new ArrayList<String>(5);
        if (value != null && StringUtils.isBlank((CharSequence)((ILocaleString)value).getLocaleValue())) {
            mustInputLan.add(Lang.get().getLangTag().replace('-', '_'));
        }
        if (mustInputLang != null && !mustInputLang.isEmpty()) {
            for (String lan : mustInputLang) {
                if (null == value || value.toString().trim().isEmpty()) {
                    this.buildErrMessage(extDataEntity, vProperty, fieldName, null, validateResultCollection);
                    continue;
                }
                String valuelan = (String)((ILocaleString)value).get((Object)lan);
                if (!StringUtils.isBlank((CharSequence)valuelan) || mustInputLan.contains(lan)) continue;
                mustInputLan.add(lan);
            }
            if (!mustInputLan.isEmpty()) {
                this.buildErrMessage(extDataEntity, vProperty, fieldName, mustInputLan, validateResultCollection);
            }
        } else if (!enableNull && ((MuliLangTextProp)vProperty).getValueComparator().compareValue(value) || enableNull && value == null) {
            if (!mustInputLan.isEmpty()) {
                this.buildErrMessage(extDataEntity, vProperty, fieldName, mustInputLan, validateResultCollection);
            } else {
                this.buildErrMessage(extDataEntity, vProperty, fieldName, null, validateResultCollection);
            }
        }
    }

    private void geoPointValidator(ExtendedDataEntity extDataEntity, DynamicProperty vProperty, String fieldName, ValidateResultCollection validateResultCollection, boolean enableNull) {
        GeoPointProp geoPointProp = (GeoPointProp)vProperty;
        DecimalProp longitudeProp = geoPointProp.getLongitudeProp();
        Object longitudeValue = longitudeProp.getValue((Object)extDataEntity.getDataEntity());
        if (!enableNull && longitudeProp.getValueComparator().compareValue(longitudeValue) || enableNull && longitudeValue == null) {
            this.buildErrMessage(extDataEntity, vProperty, fieldName, null, validateResultCollection);
        }
        DecimalProp latitudeProp = geoPointProp.getLatitudeProp();
        Object latitudeValue = latitudeProp.getValue((Object)extDataEntity.getDataEntity());
        if (!enableNull && latitudeProp.getValueComparator().compareValue(latitudeValue) || enableNull && latitudeValue == null) {
            this.buildErrMessage(extDataEntity, vProperty, fieldName, null, validateResultCollection);
        }
        TextProp addressProp = geoPointProp.getAddressProp();
        Object addressValue = addressProp.getValue((Object)extDataEntity.getDataEntity());
        if (!enableNull && addressProp.getValueComparator().compareValue(addressValue) || enableNull && addressValue == null) {
            this.buildErrMessage(extDataEntity, vProperty, fieldName, null, validateResultCollection);
        }
    }

    protected void buildErrMessage(ExtendedDataEntity extDataEntity, DynamicProperty vProperty, String fieldName, List<String> mustInputLan, ValidateResultCollection validateResultCollection) {
        StringBuilder contentS = new StringBuilder();
        int rowIndex = 0;
        int subRowIndex = 0;
        if (!(vProperty.getParent() instanceof EntryType)) {
            contentS.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d", (String)"RequiredValidator_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), fieldName));
        } else {
            EntryType entryType = (EntryType)vProperty.getParent();
            rowIndex = extDataEntity.getRowIndex();
            if (entryType instanceof SubEntryType) {
                subRowIndex = extDataEntity.getSubRowIndex();
                String entryName = entryType.getParent().getDisplayName().toString();
                String subEntryName = entryType.getDisplayName().toString();
                contentS.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\uff1a\u201c%2$s\u201d\u7b2c%3$s\u884c\uff0c\u201c%4$s\u201d\u7b2c%5$s\u884c", (String)"RequiredValidator_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), fieldName, entryName, rowIndex + 1, subEntryName, subRowIndex + 1));
            } else {
                contentS.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\uff1a\u201c%3$s\u201d", (String)"RequiredValidator_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), entryType.getDisplayName().toString(), rowIndex + 1, fieldName));
            }
        }
        if (0 == contentS.length()) {
            return;
        }
        if (null != mustInputLan) {
            String promptLang = ValidateContext.switchLang(mustInputLan);
            String mid = String.format(ResManager.loadKDString((String)"%1$s\u7684\u201c%2$s\u201d\u503c", (String)"RequiredValidator_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), contentS, promptLang);
            contentS.setLength(0);
            contentS.append(mid);
        }
        contentS.append('\u3002');
        String title = ResManager.loadKDString((String)"\u5ba1\u6279\u63d0\u4ea4\u6821\u9a8c\u5fc5\u5f55\u3002", (String)"RequiredValidator_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        ValidationErrorInfo info = new ValidationErrorInfo("", extDataEntity.getBillPkId(), extDataEntity.getDataEntityIndex(), rowIndex, "errorcode_001", title, contentS.toString(), ErrorLevel.FatalError);
        info.setEntityKey(this.entityNumber);
        info.setSubRowIndex(subRowIndex);
        ValidateResult validateResult = new ValidateResult();
        validateResult.addErrorInfo((OperateErrorInfo)info);
        validateResultCollection.addValidateError(title, validateResult);
    }
}

