/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.sys.basic.customer.op;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;

public class CustomerOpPlugin
extends AbstractOperationServicePlugIn
implements Plugin {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(DynamicObjectUtil.addFieldKey((String)"bd_customer", (boolean)true));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        String key = (String)this.operateMeta.get("key");
        if ("delete".equals(key)) {
            e.addValidator(new AbstractValidator(){

                public void validate() {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        DynamicObject customer = dataEntity.getDataEntity();
                        QFilter[] qfByNumber = new QFilter[]{new QFilter("number", "=", (Object)customer.getString("number"))};
                        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (QFilter[])qfByNumber);
                        if (YEM.isEmpty((Object)invoice)) continue;
                        DeleteServiceHelper.delete((String)"bdm_invice_title_strate", (QFilter[])qfByNumber);
                    }
                }
            });
        }
        if ("save".equals(key) || "submit".equals(key)) {
            e.addValidator(new AbstractValidator(){

                public void validate() {
                    ExtendedDataEntity[] dataEntities;
                    for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
                        DynamicObject datum = dataEntity.getDataEntity();
                        ArrayList<String> errSeq = new ArrayList<String>();
                        this.uniqueName(datum, errSeq);
                        this.societyCreditValidate(datum, errSeq);
                        this.customerValidate(datum, errSeq);
                        if (errSeq.isEmpty()) continue;
                        this.addFatalErrorMessage(dataEntity, String.join((CharSequence)"\n", errSeq));
                    }
                }

                private void customerValidate(DynamicObject datum, List<String> errSeq) {
                    String customerCode = datum.getString("uav6_custcode");
                    if (customerCode.isEmpty()) {
                        errSeq.add("\u96c6\u56e2\u5ba2\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (customerCode.contains(" ")) {
                        errSeq.add("\u96c6\u56e2\u5ba2\u5546\u7f16\u7801\u5305\u542b\u7a7a\u683c");
                    }
                }

                private void societyCreditValidate(DynamicObject datum, List<String> errSeq) {
                    String societyCreditCode = datum.getString("societycreditcode");
                    if (societyCreditCode.isEmpty()) {
                        errSeq.add("\u793e\u4f1a\u4fe1\u7528\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (societyCreditCode.contains(" ")) {
                        errSeq.add("\u793e\u4f1a\u4fe1\u7528\u7f16\u7801\u5305\u542b\u7a7a\u683c");
                    }
                    QFilter notIsSelf = new QFilter("id", "!=", datum.getPkValue());
                    notIsSelf.and("societycreditcode", "=", (Object)societyCreditCode);
                    if (QueryServiceHelper.exists((String)"bd_customer", (QFilter[])new QFilter[]{notIsSelf})) {
                        errSeq.add("\u793e\u4f1a\u4fe1\u7528\u7f16\u7801\u91cd\u590d,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u63d0\u4ea4");
                    }
                }

                private void uniqueName(DynamicObject datum, List<String> errSeq) {
                    String name = datum.getString("name").trim();
                    if (name.isEmpty()) {
                        errSeq.add("\u5ba2\u6237\u59d3\u540d\u4e3a\u5fc5\u586b\u9879\u76ee");
                    }
                    QFilter notIsSelf = new QFilter("id", "!=", datum.getPkValue());
                    notIsSelf.and("name", "=", (Object)name);
                    if (QueryServiceHelper.exists((String)"bd_customer", (QFilter[])new QFilter[]{notIsSelf})) {
                        errSeq.add("\u5df2\u7ecf\u5b58\u5728\u8be5\u540d\u79f0\u7684\u5ba2\u6237,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u63d0\u4ea4");
                    }
                }
            });
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities1;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject customer : dataEntities1 = e.getDataEntities()) {
            String opKey = e.getOperationKey();
            if (!"delete".equals(opKey)) continue;
            QFilter[] qfByNumber = new QFilter[]{new QFilter("number", "=", (Object)customer.getString("number"))};
            DynamicObject supplier = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (QFilter[])qfByNumber);
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (QFilter[])qfByNumber);
            if (!YEM.isEmpty((Object)invoice)) {
                DeleteServiceHelper.delete((String)"bdm_invice_title_strate", (QFilter[])qfByNumber);
            }
            if (supplier == null) continue;
            CustomerOpPlugin.clearLinkmanAss(supplier);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        super.afterExecuteOperationTransaction(e);
        block14: for (DynamicObject customer : dataEntities = e.getDataEntities()) {
            String opKey = e.getOperationKey();
            QFilter[] qfByNumber = new QFilter[]{new QFilter("number", "=", (Object)customer.getString("number"))};
            DynamicObject supplier = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (QFilter[])qfByNumber);
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (QFilter[])qfByNumber);
            switch (opKey) {
                case "delete": {
                    SaveServiceHelper.update((DynamicObject)customer);
                    if (!YEM.isNotEmpty((Object)supplier)) continue block14;
                    DeleteServiceHelper.delete((String)"bd_supplier", (QFilter[])qfByNumber);
                    DeleteServiceHelper.delete((String)"bd_bizpartner", (QFilter[])qfByNumber);
                    continue block14;
                }
                case "disable": 
                case "enable": {
                    if (!YEM.isEmpty((Object)supplier)) {
                        supplier.set("enable", customer.get("enable"));
                        SaveServiceHelper.update((DynamicObject)supplier);
                    }
                    if (YEM.isEmpty((Object)invoice)) continue block14;
                    invoice.set("enable", customer.get("enable"));
                    SaveServiceHelper.update((DynamicObject)invoice);
                    continue block14;
                }
                case "audit": 
                case "save": {
                    if (!"C".equals(customer.getString("status"))) continue block14;
                    this.autoSupplier(customer);
                    this.createInvoice(customer);
                    continue block14;
                }
                case "unaudit": {
                    if (invoice == null) continue block14;
                    invoice.set("status", (Object)"A");
                    SaveServiceHelper.update((DynamicObject)invoice);
                }
            }
        }
    }

    private void createInvoice(DynamicObject customer) {
        String number = customer.getString("number");
        String name = customer.getString("name");
        String registerNo = customer.getString("tx_register_no");
        QFilter[] qfByNumber = new QFilter[]{new QFilter("number", "=", (Object)customer.getString("number"))};
        DynamicObject invoiceBill = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (QFilter[])qfByNumber);
        if (invoiceBill == null) {
            invoiceBill = BusinessDataServiceHelper.newDynamicObject((String)"bdm_invice_title_strate");
        }
        invoiceBill.set("number", (Object)number);
        invoiceBill.set("name", (Object)name);
        invoiceBill.set("buyertype", (Object)"1");
        Object org = customer.get("org");
        invoiceBill.set("useorg", org);
        invoiceBill.set("org", org);
        invoiceBill.set("createorg", org);
        invoiceBill.set("enable", (Object)"1");
        invoiceBill.set("status", (Object)"A");
        invoiceBill.set("taxno", (Object)registerNo);
        DynamicObjectCollection invoiceDc = invoiceBill.getDynamicObjectCollection("cust");
        DynamicObject row = invoiceDc.addNew();
        row.set("custom", (Object)customer);
        row.set("customerno", (Object)number);
        row.set("customertaxno", (Object)registerNo);
        row.set("customername", (Object)name);
        OperationResult save = OperationServiceHelper.executeOperate((String)"save", (String)"bdm_invice_title_strate", (DynamicObject[])new DynamicObject[]{invoiceBill}, (OperateOption)OperateOption.create());
        if (!save.isSuccess()) {
            throw new KDBizException(String.format("\u53d1\u7968\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25,\u5931\u8d25\u539f\u56e0%s", YEM.getOpMsg((OperationResult)save)));
        }
        OperationResult subOp = OperationServiceHelper.executeOperate((String)"submit", (String)"bdm_invice_title_strate", (Object[])new Object[]{invoiceBill.getPkValue()}, (OperateOption)OperateOption.create());
        if (!subOp.isSuccess()) {
            throw new KDBizException(String.format("\u53d1\u7968\u4fe1\u606f\u63d0\u4ea4\u5931\u8d25,\u5931\u8d25\u539f\u56e0%s", YEM.getOpMsg((OperationResult)subOp)));
        }
        OperationResult auditOp = OperationServiceHelper.executeOperate((String)"audit", (String)"bdm_invice_title_strate", (DynamicObject[])new DynamicObject[]{invoiceBill}, (OperateOption)OperateOption.create());
        if (!subOp.isSuccess()) {
            throw new KDBizException(String.format("\u53d1\u7968\u4fe1\u606f\u5ba1\u6838\u5931\u8d25%s", YEM.getOpMsg((OperationResult)auditOp)));
        }
    }

    private static void clearLinkmanAss(DynamicObject supplier) {
        DynamicObjectCollection linkmanDc = supplier.getDynamicObjectCollection("entry_linkman");
        for (DynamicObject row : linkmanDc) {
            row.set("associatedaddress", null);
        }
        SaveServiceHelper.update((DynamicObject)supplier);
    }

    private void autoSupplier(DynamicObject customer) {
        QFilter qfByNum = new QFilter("number", "=", (Object)customer.getString("number"));
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (QFilter[])new QFilter[]{qfByNum});
        if (YEM.isEmpty((Object)supplier)) {
            supplier = BusinessDataServiceHelper.newDynamicObject((String)"bd_supplier");
            supplier.set("number", customer.get("number"));
            this.createSupplier(customer, supplier);
        } else {
            this.updateSupplier(customer, supplier);
        }
    }

    private void updateSupplier(DynamicObject customer, DynamicObject supplier) {
        DynamicObject newSupplier = this.constructHead(customer, supplier);
        this.linkmanAndAddressDc(customer, newSupplier, true);
        this.taxAndBank(customer, newSupplier, true);
        CustomerOpPlugin.allOp(newSupplier);
    }

    private void createSupplier(DynamicObject customer, DynamicObject supplier) {
        DynamicObject newSupplier = this.constructHead(customer, supplier);
        this.linkmanAndAddressDc(customer, newSupplier, false);
        this.taxAndBank(customer, newSupplier, false);
        CustomerOpPlugin.allOp(newSupplier);
    }

    private void taxAndBank(DynamicObject customer, DynamicObject supplier, boolean flag) {
        DynamicObject supRow;
        supplier.set("taxregistplace", customer.get("taxregistplace"));
        supplier.set("taxno", customer.get("taxno"));
        DynamicObjectCollection cusTaxDc = customer.getDynamicObjectCollection("entry_tax");
        DynamicObjectCollection cusBankDc = customer.getDynamicObjectCollection("entry_bank");
        DynamicObjectCollection supTaxDc = supplier.getDynamicObjectCollection("entry_tax");
        DynamicObjectCollection supBankDc = supplier.getDynamicObjectCollection("entry_bank");
        if (flag) {
            supTaxDc.clear();
            supBankDc.clear();
        }
        for (DynamicObject cusRow : cusTaxDc) {
            supRow = supTaxDc.addNew();
            supRow.set("taxcertificate", cusRow.get("taxcertificate"));
            supRow.set("effectivedate", cusRow.get("effectivedate"));
            supRow.set("expirydate", cusRow.get("expirydate"));
        }
        for (DynamicObject cusRow : cusBankDc) {
            supRow = supBankDc.addNew();
            supRow.set("bankaccount", cusRow.get("bankaccount"));
            supRow.set("accountname", cusRow.get("accountname"));
            supRow.set("iban", cusRow.get("iban"));
            supRow.set("bank", cusRow.get("bank"));
            supRow.set("currency", cusRow.get("currency"));
            supRow.set("isdefault_bank", cusRow.get("isdefault_bank"));
        }
    }

    private void linkmanAndAddressDc(DynamicObject customer, DynamicObject supplier, Boolean flag) {
        QFilter[] customerByIdAdd = new QFilter[]{new QFilter("customer.id", "=", customer.getPkValue())};
        DynamicObject[] cusAddresses = BusinessDataServiceHelper.load((String)"bd_address", (String)"issupplieradd,supplierid,supplier", (QFilter[])customerByIdAdd);
        if (flag.booleanValue()) {
            DynamicObject[] qfByAdd = new QFilter[]{new QFilter("supplier.id", "=", supplier.getPkValue())};
            DynamicObject[] supAddress = BusinessDataServiceHelper.load((String)"bd_address", (String)"issupplieradd,supplierid,supplier", (QFilter[])qfByAdd);
            HashSet<DynamicObject> supSet = new HashSet<DynamicObject>(Arrays.asList(supAddress));
            HashSet<DynamicObject> cusSet = new HashSet<DynamicObject>(Arrays.asList(cusAddresses));
            Set delAddress = cusSet.stream().filter(item -> !supSet.contains(item)).collect(Collectors.toSet());
            QFilter[] supDelQf = (QFilter[])delAddress.stream().map(item -> new QFilter("supplier.id", "=", item.getPkValue())).toArray(QFilter[]::new);
            DeleteServiceHelper.delete((String)"bd_address", (QFilter[])supDelQf);
            Set<Object> upAddress = supSet.isEmpty() ? new HashSet<DynamicObject>(cusSet) : supSet.stream().filter(item -> !cusSet.contains(item)).collect(Collectors.toSet());
            for (DynamicObject address : upAddress) {
                address.set("supplierid", supplier.get("id"));
                address.set("issupplieradd", (Object)true);
                address.set("supplier", (Object)supplier);
                SaveServiceHelper.update((DynamicObject)address);
            }
        } else {
            for (DynamicObject address : cusAddresses) {
                address.set("supplierid", supplier.get("id"));
                address.set("issupplieradd", (Object)true);
                address.set("supplier", (Object)supplier);
                SaveServiceHelper.update((DynamicObject)address);
            }
        }
        DynamicObjectCollection cLinkmanDc = customer.getDynamicObjectCollection("entry_linkman");
        DynamicObjectCollection sLinkmanDc = supplier.getDynamicObjectCollection("entry_linkman");
        if (flag.booleanValue()) {
            sLinkmanDc.clear();
        }
        for (DynamicObject cLinkmanRow : cLinkmanDc) {
            DynamicObject sLinkmanRow = sLinkmanDc.addNew();
            sLinkmanRow.set("familyname", cLinkmanRow.get("familyname"));
            sLinkmanRow.set("givenname", cLinkmanRow.get("givenname"));
            sLinkmanRow.set("middlename", cLinkmanRow.get("middlename"));
            sLinkmanRow.set("alias", cLinkmanRow.get("alias"));
            sLinkmanRow.set("contactperson", cLinkmanRow.get("contactperson"));
            sLinkmanRow.set("contactpersonpost", cLinkmanRow.get("contactpersonpost"));
            sLinkmanRow.set("dept", cLinkmanRow.get("dept"));
            sLinkmanRow.set("phonecode", cLinkmanRow.get("phonecode"));
            sLinkmanRow.set("phone", cLinkmanRow.get("phone"));
            sLinkmanRow.set("fax", cLinkmanRow.get("fax"));
            sLinkmanRow.set("email", cLinkmanRow.get("email"));
            sLinkmanRow.set("isdefault_linkman", cLinkmanRow.get("isdefault_linkman"));
            sLinkmanRow.set("role", cLinkmanRow.get("role"));
            DynamicObject associatedaddress = cLinkmanRow.getDynamicObject("associatedaddress");
            if (YEM.isNotEmpty((Object)associatedaddress)) {
                associatedaddress = BusinessDataServiceHelper.loadSingle((Object)associatedaddress.getPkValue(), (String)associatedaddress.getDynamicObjectType().getName());
            }
            sLinkmanRow.set("associatedaddress", (Object)associatedaddress);
            sLinkmanRow.set("invalid", cLinkmanRow.get("invalid"));
            sLinkmanRow.set("deleteidentity", cLinkmanRow.get("deleteidentity"));
        }
    }

    private static void allOp(DynamicObject supplier) {
        OperationResult subOp = OperationServiceHelper.executeOperate((String)"submit", (String)"bd_supplier", (Object[])new Object[]{supplier.getPkValue()}, (OperateOption)OperateOption.create());
        if (!subOp.isSuccess()) {
            throw new KDBizException(String.format("\u4f9b\u5e94\u5546\u63d0\u4ea4\u5931\u8d25,\u5931\u8d25\u539f\u56e0%s", YEM.getOpMsg((OperationResult)subOp)));
        }
        OperationResult auditOp = OperationServiceHelper.executeOperate((String)"audit", (String)"bd_supplier", (DynamicObject[])new DynamicObject[]{supplier}, (OperateOption)OperateOption.create());
        if (!subOp.isSuccess()) {
            throw new KDBizException(String.format("\u4f9b\u5e94\u5546\u5ba1\u6838\u5931\u8d25%s", YEM.getOpMsg((OperationResult)auditOp)));
        }
    }

    private DynamicObject constructHead(DynamicObject customer, DynamicObject supplier) {
        supplier.set("uav6_lawsuit", (Object)customer.getString("uav6_lawsuit"));
        supplier.set("uav6_lawsuitthing", (Object)customer.getString("uav6_lawsuitthing"));
        supplier.set("uav6_level", (Object)customer.getString("uav6_level"));
        supplier.set("name", (Object)customer.getString("name"));
        supplier.set("picturefield", customer.get("picturefield"));
        supplier.set("bizpartner", (Object)customer.getDynamicObject("bizpartner"));
        supplier.set("simplename", (Object)customer.getString("simplename"));
        supplier.set("simplepinyin", (Object)customer.getString("simplepinyin"));
        supplier.set("bizfunction", customer.get("bizfunction"));
        supplier.set("type", (Object)customer.getString("type"));
        supplier.set("createorg", customer.get("createorg"));
        supplier.set("chkisinternalcompany", customer.get("chkisinternalcompany"));
        supplier.set("internal_company", customer.get("internal_company"));
        supplier.set("uav6_internalunit", customer.get("uav6_internalunit"));
        supplier.set("uav6_tradeparty", customer.get("uav6_tradeparty"));
        supplier.set("uav6_partystatus", customer.get("uav6_partystatus"));
        supplier.set("uav6_paidcapital", customer.get("uav6_paidcapital"));
        supplier.set("uav6_coopstatus", customer.get("uav6_coopstatus"));
        supplier.set("ctrlstrategy", customer.get("ctrlstrategy"));
        supplier.set("country", customer.get("country"));
        supplier.set("societycreditcode", customer.get("societycreditcode"));
        supplier.set("tx_register_no", customer.get("tx_register_no"));
        supplier.set("duns", customer.get("duns"));
        supplier.set("artificialperson", customer.get("artificialperson"));
        supplier.set("curegcapital", customer.get("curegcapital"));
        supplier.set("regcapital", customer.get("regcapital"));
        supplier.set("businessterm", customer.get("businessterm"));
        supplier.set("businessscope", customer.get("businessscope"));
        supplier.set("establishdate", customer.get("establishdate"));
        supplier.set("linkman", customer.get("linkman"));
        supplier.set("bizpartner_phone", customer.get("bizpartner_phone"));
        supplier.set("bizpartner_fax", customer.get("bizpartner_fax"));
        supplier.set("url", customer.get("url"));
        supplier.set("postal_code", customer.get("postal_code"));
        supplier.set("admindivision", customer.get("admindivision"));
        supplier.set("bizpartner_address", customer.get("bizpartner_address"));
        supplier.set("idno", customer.get("idno"));
        supplier.set("purchaserid", customer.get("salerid"));
        supplier.set("purchasedeptid", customer.get("saledeptid"));
        supplier.set("settlementcyid", customer.get("settlementcyid"));
        supplier.set("taxrate", customer.get("taxrate"));
        supplier.set("enable", (Object)"1");
        supplier.set("status", (Object)"A");
        supplier.set("creator", customer.get("creator"));
        supplier.set("modifier", customer.get("modifier"));
        supplier.set("paymentcurrency", customer.get("paymentcurrency"));
        supplier.set("settlementtypeid", customer.get("settlementtypeid"));
        supplier.set("invoicecategory", customer.get("invoicecategory"));
        supplier.set("uav6_custcode", customer.get("uav6_custcode"));
        String groupNum = customer.getDynamicObject("group").getString("number");
        DynamicObject supplierGroup = BusinessDataServiceHelper.loadSingle((String)"bd_suppliergroup", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)groupNum)});
        DynamicObject standard = BusinessDataServiceHelper.loadSingle((String)"bd_suppliergroupstandard", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"JBFLBZ")});
        DynamicObject newRow = supplier.getDynamicObjectCollection("entry_groupstandard").addNew();
        newRow.set("groupid", (Object)supplierGroup);
        newRow.set("standardid", (Object)standard);
        supplier.set("group", (Object)supplierGroup);
        OperationResult opSave = OperationServiceHelper.executeOperate((String)"save", (String)supplier.getDynamicObjectType().getName(), (DynamicObject[])new DynamicObject[]{supplier}, (OperateOption)OperateOption.create());
        if (!opSave.isSuccess()) {
            DeleteServiceHelper.delete((String)supplier.getDynamicObjectType().getName(), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)supplier.getString("number"))});
            throw new KDBizException(String.format("\u4f9b\u5e94\u5546\u4fdd\u5b58\u5931\u8d25,\u5931\u8d25\u539f\u56e0%s", YEM.getOpMsg((OperationResult)opSave)));
        }
        return BusinessDataServiceHelper.loadSingle(opSave.getSuccessPkIds().get(0), (String)supplier.getDynamicObjectType().getName());
    }
}

