/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.sys.bill.original.op;

import java.util.ArrayList;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import yem.shmjs.sys.bill.original.validator.InvoiceOriginalBillDeleteValidator;
import yem.shmjs.sys.bill.util.OriginalBillHelper;

public class OriginalDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new InvoiceOriginalBillDeleteValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        RequestContext context = RequestContext.get();
        ThreadPools.executeOnceIncludeRequestContext((String)"disassociate_invoice", () -> {
            RequestContext.copyAndSet((RequestContext)context);
            ArrayList<Pair<String, String>> invalidInvoiceCodeNo = new ArrayList<Pair<String, String>>(bills.length);
            ArrayList<DynamicObject> redBills = new ArrayList<DynamicObject>(bills.length);
            for (DynamicObject bill : bills) {
                String billSourceType = bill.getString("billsourcetype");
                if (StringUtils.isBlank((String)billSourceType) || "A".equals(billSourceType) || "D".equals(billSourceType)) continue;
                if ("C".equals(billSourceType)) {
                    invalidInvoiceCodeNo.add((Pair<String, String>)Pair.of((Object)bill.getString("invoicecode"), (Object)bill.getString("invoiceno")));
                    continue;
                }
                redBills.add(bill);
            }
            OriginalBillHelper.invalidBillDelete(invalidInvoiceCodeNo);
            OriginalBillHelper.redBillDelete(redBills, invalidInvoiceCodeNo);
            DeleteServiceHelper.delete((String)"sim_bill_relation", (QFilter[])new QFilter("tbillid", "in", (Object)Stream.of(bills).map(DataEntityBase::getPkValue).toArray()).toArray());
        });
    }
}

