/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.sys.bill.original.validator;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;
import yem.shmjs.sys.bill.util.BillStatusEnum;
import yem.shmjs.sys.bill.util.CacheHelper;
import yem.shmjs.sys.bill.util.DynamicObjectUtil;

public class InvoiceOriginalBillDeleteValidator
extends AbstractValidator {
    public static final ImmutableSet<String> reverseBill = ImmutableSet.of((Object)"C", (Object)"B");

    public void validate() {
        Object[] reverseBillIds;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])new QFilter("sbillid", "in", (Object)Stream.of(dataEntities).map(ExtendedDataEntity::getBillPkId).toArray()).toArray());
        Set billIdSet = Stream.of(relations).map(relation -> relation.getLong("sbillid")).collect(Collectors.toSet());
        Map<Object, Object> billRelationMap = new HashMap(4);
        if (Stream.of(dataEntities).anyMatch(entity -> reverseBill.contains((Object)entity.getDataEntity().getString("billsourcetype"))) && (reverseBillIds = Arrays.stream(dataEntities).filter(entity -> reverseBill.contains((Object)entity.getDataEntity().getString("billsourcetype"))).map(ExtendedDataEntity::getBillPkId).toArray()).length != 0) {
            DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_bill_relation", (String)String.join((CharSequence)",", "sbillid", "tbillid"), (QFilter[])new QFilter("sbillid", "in", (Object)reverseBillIds).toArray());
            billRelationMap = Stream.of(billRelations).collect(Collectors.toMap(k -> k.get("sbillid"), v -> v.get("tbillid"), (v1, v2) -> v1));
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String billSourceType;
            DynamicObject bill = dataEntity.getDataEntity();
            String issueCacheKey = CacheHelper.get(DynamicObjectUtil.getDynamicObjectLongValue(bill.get("orgid")) + "!!!" + bill.getString("billno"));
            String processCacheKey = CacheHelper.get(bill.getPkValue() + "workbench");
            if (StringUtils.isNotBlank((CharSequence)issueCacheKey) || StringUtils.isNotBlank((CharSequence)processCacheKey)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u5f00\u7968\u7533\u8bf7\u5355\u6b63\u5728\u5f00\u7968\u5904\u7406\u4e2d\uff0c\u65e0\u6cd5\u5220\u9664", (String)"InvoiceOriginalBillDeleteValidator_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (reverseBill.contains((Object)(billSourceType = bill.getString("billsourcetype"))) && billRelationMap.containsKey(bill.getPkValue())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u5bf9\u5e94\u91cd\u5f00\u5355\u672a\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u91cd\u5f00\u5355", (String)"InvoiceOriginalBillDeleteValidator_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                continue;
            }
            String billStatus = bill.getString("billstatus");
            if (!(BillStatusEnum.TEMP_SAVE.getCode().equals(billStatus) || BillStatusEnum.NO_APPROVAL_REQUIRED.getCode().equals(billStatus) || StringUtils.isBlank((CharSequence)billStatus))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u6682\u5b58\u6216\u65e0\u9700\u5ba1\u6279\u7684\u624d\u80fd\u5220\u9664", (String)"InvoiceOriginalBillDeleteValidator_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"0".equals(bill.getString("confirmstate")) && !"C".equals(billSourceType)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u53ea\u6709\u672a\u7533\u8bf7\u7684\u624d\u80fd\u5220\u9664", (String)"InvoiceOriginalBillDeleteValidator_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (!billIdSet.contains(bill.getLong("id"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u5355\u636e\u5df2\u5173\u8054\u53d1\u7968\uff0c\u65e0\u6cd5\u5220\u9664", (String)"InvoiceOriginalBillDeleteValidator_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }
}

