/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.sys.bill.original.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginalSubmitValidator
extends AbstractValidator {
    private static final Logger log = LoggerFactory.getLogger(OriginalSubmitValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            this.qtycomparoto(dataEntity, bill);
        }
    }

    private void originalqtycomparoto(ExtendedDataEntity dataEntity, DynamicObject bill) {
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal1 = BigDecimal.ZERO;
        DynamicObjectCollection simOriginalBillItem = bill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject dynamicObject : simOriginalBillItem) {
            DynamicObject[] loaded;
            long yemSourceentryid = dynamicObject.getLong("yem_sourceentryid");
            BigDecimal num = dynamicObject.getBigDecimal("num");
            if (map.containsKey(yemSourceentryid)) {
                map.put(yemSourceentryid, ((BigDecimal)map.get(yemSourceentryid)).add(num));
            } else {
                map.put(yemSourceentryid, num);
            }
            if ((loaded = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"sim_original_bill_item,sim_original_bill_item.num,sim_original_bill_item.yem_sourceentryid", (QFilter[])new QFilter[]{new QFilter("sim_original_bill_item.yem_sourceentryid", "=", (Object)yemSourceentryid)})).length <= 0) continue;
            for (DynamicObject object : loaded) {
                DynamicObjectCollection sim_original_bill_item = object.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject dynamicObject1 : sim_original_bill_item) {
                    BigDecimal decimal = dynamicObject1.getBigDecimal("num");
                    bigDecimal = bigDecimal.add(decimal);
                }
            }
        }
        for (Long entry : map.keySet()) {
            DynamicObject yemImSaloutbillPro = BusinessDataServiceHelper.loadSingle((String)"yem_im_saloutbill_pro", (QFilter[])new QFilter[]{new QFilter("billentry.id", "=", (Object)entry)});
            if (yemImSaloutbillPro != null) {
                DynamicObjectCollection billentry = yemImSaloutbillPro.getDynamicObjectCollection("billentry");
                for (DynamicObject dynamicObject : billentry) {
                    String lotnumber = dynamicObject.getString("lotnumber");
                    DynamicObject imPurinbill = BusinessDataServiceHelper.loadSingle((String)"im_purinbill", (QFilter[])new QFilter[]{new QFilter("billentry.lotnumber", "=", (Object)lotnumber)});
                    if (imPurinbill == null) continue;
                    DynamicObjectCollection objectCollection = imPurinbill.getDynamicObjectCollection("billentry");
                    for (DynamicObject object : objectCollection) {
                        String conbillnumber = object.getString("conbillnumber");
                        DynamicObject apFinapbill = BusinessDataServiceHelper.loadSingle((String)"ap_finapbill", (QFilter[])new QFilter[]{new QFilter("detailentry.yem_purbillno.billno", "=", (Object)conbillnumber)});
                        DynamicObjectCollection detailentry = apFinapbill.getDynamicObjectCollection("detailentry");
                        for (DynamicObject dynamicObject1 : detailentry) {
                            BigDecimal quantity = dynamicObject1.getBigDecimal("quantity");
                            bigDecimal1 = bigDecimal1.add(quantity);
                        }
                    }
                }
            }
            bigDecimal = bigDecimal.add((BigDecimal)map.get(entry));
        }
        if (bigDecimal.compareTo(bigDecimal1) > 0) {
            bill.set("uav6_excessinvtickets", (Object)true);
            this.addWarningMessage(dataEntity, "\u5f00\u7968\u6570\u91cf" + bigDecimal.setScale(2, 4) + "\u5927\u4e8e\u6536\u7968\u6570\u91cf" + bigDecimal1.setScale(2, 4) + "\uff0c\u8bf7\u786e\u8ba4\uff01\uff01\uff01");
        } else {
            bill.set("uav6_excessinvtickets", (Object)false);
        }
    }

    private void qtycomparoto(ExtendedDataEntity dataEntity, DynamicObject bill) {
        DynamicObject[] apFinapbills;
        DynamicObject[] loaded;
        String billsource = bill.getString("billsource");
        if ("6".equals(billsource)) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal1 = BigDecimal.ZERO;
        DynamicObjectCollection simOriginalBillItem = bill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject[] dynamicObject : simOriginalBillItem) {
            String yemLotnumber = dynamicObject.getString("uav6_lotnumber");
            BigDecimal num = dynamicObject.getBigDecimal("num");
            bigDecimal = bigDecimal.add(num);
            list.add(yemLotnumber);
        }
        for (DynamicObject dynamicObject : loaded = BusinessDataServiceHelper.load((String)bill.getDataEntityType().getName(), (String)"id,billno,billstatus,sim_original_bill_item.uav6_lotnumber,sim_original_bill_item.num", (QFilter[])new QFilter[]{new QFilter("sim_original_bill_item.uav6_lotnumber", "in", list), new QFilter("billstatus", "!=", (Object)"A")})) {
            DynamicObjectCollection sim_original_bill_item = dynamicObject.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject dynamicObject2 : sim_original_bill_item) {
                String yemLotnumber = dynamicObject2.getString("uav6_lotnumber");
                if (!list.contains(yemLotnumber)) continue;
                BigDecimal num = dynamicObject2.getBigDecimal("num");
                bigDecimal = bigDecimal.add(num);
            }
        }
        for (DynamicObject apFinapbill : apFinapbills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,billno,detailentry.uav6_lotnumber,detailentry.quantity", (QFilter[])new QFilter[]{new QFilter("detailentry.uav6_lotnumber", "in", list)})) {
            DynamicObjectCollection detailentry = apFinapbill.getDynamicObjectCollection("detailentry");
            for (DynamicObject dynamicObject : detailentry) {
                String uav6_lotnumber = dynamicObject.getString("uav6_lotnumber");
                BigDecimal quantity = dynamicObject.getBigDecimal("quantity");
                if (!list.contains(uav6_lotnumber)) continue;
                bigDecimal1 = bigDecimal1.add(quantity);
            }
        }
        if (bigDecimal.compareTo(bigDecimal1) > 0) {
            bill.set("uav6_excessinvtickets", (Object)true);
            this.addWarningMessage(dataEntity, "\u5f00\u7968\u6570\u91cf" + bigDecimal + "\u5927\u4e8e\u6536\u7968\u6570\u91cf" + bigDecimal1 + "\uff0c\u8bf7\u786e\u8ba4\uff01\uff01\uff01");
        } else {
            bill.set("uav6_excessinvtickets", (Object)false);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
    }

    private void check_duplicates(ExtendedDataEntity dataEntity, DynamicObject eDataEntity) {
        DynamicObject[] dynamicObjects;
        DynamicObject[] loaded;
        ArrayList<Long> listid = new ArrayList<Long>();
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal1 = BigDecimal.ZERO;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        DynamicObjectCollection simOriginalBillItem = eDataEntity.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject dynamicObject : simOriginalBillItem) {
            long corebillid = dynamicObject.getLong("corebillid");
            DynamicObject goodsid = dynamicObject.getDynamicObject("goodsid");
            BigDecimal num = dynamicObject.getBigDecimal("num");
            bigDecimal = bigDecimal.add(num);
            if (goodsid != null) {
                String number = goodsid.getString("number");
                map.put(number, num);
            }
            listid.add(corebillid);
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (DynamicObject dynamicObject : loaded = BusinessDataServiceHelper.load((String)"yem_pa_matchrelation", (String)"id,billno,yem_salebillid,yem_procurebillid", (QFilter[])new QFilter[]{new QFilter("yem_salebillid", "in", listid)})) {
            long yemProcurebillid = dynamicObject.getLong("yem_procurebillid");
            list.add(yemProcurebillid);
        }
        for (DynamicObject object : dynamicObjects = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"id,billno,entry.corebillid", (QFilter[])new QFilter[]{new QFilter("entry.corebillid", "in", list)})) {
            DynamicObjectCollection entry = object.getDynamicObjectCollection("entry");
            for (DynamicObject dynamicObject : entry) {
                String number;
                DynamicObject material = dynamicObject.getDynamicObject("material");
                BigDecimal quantity = dynamicObject.getBigDecimal("quantity");
                if (material == null || !map.containsKey(number = material.getString("number"))) continue;
                bigDecimal1 = bigDecimal1.add(quantity);
            }
        }
        if (bigDecimal1.compareTo(bigDecimal) < 0) {
            this.addMessage(dataEntity, "\u5f00\u7968\u6570\u91cf" + bigDecimal + "\u5927\u4e8e\u6536\u7968\u6570\u91cf" + bigDecimal1 + "\uff0c\u8bf7\u786e\u8ba4\uff01\uff01\uff01");
        }
    }
}

