/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.sys.bill.placeAnOrder.form;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import yem.base.common.utils.OrgUtil;
import yem.base.common.utils.SystemParamUtil;
import yem.base.common.utils.YEM;
import yem.shmjs.sys.bill.policynumber.form.PolicyNumberBillPlugin;
import yem.shmjs.sys.bill.util.Util;

public class OrdercmdBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String URL = "";
    private static final Map<String, String> TOKEN = null;
    private static final Logger log = LoggerFactory.getLogger(OrdercmdBillPlugin.class);

    public void registerListener(EventObject e) {
        ((BasedataEdit)this.getControl("yem_company")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("yem_dept")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("uav6_polynum")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("uav6_futuresaccount")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit yem_org = (BasedataEdit)this.getControl("yem_org");
        if (yem_org != null) {
            yem_org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long currentOrgId = YEM.getCurrentOrgId();
        long currentUserId = YEM.getCurrentUserId();
        DynamicObject bosUser = BusinessDataServiceHelper.loadSingle((Object)currentUserId, (String)"bos_user");
        DynamicObject getdpt = PolicyNumberBillPlugin.getdpt(bosUser);
        this.getModel().setValue("yem_company", (Object)currentOrgId);
        this.getModel().setValue("yem_dept", (Object)getdpt);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "yem_company": {
                this.setOrgF7Filter(e, name);
                break;
            }
            case "yem_dept": {
                this.setDeptF7Filter(e);
                break;
            }
            case "uav6_futuresaccount": {
                DynamicObject uav6Futuresac = (DynamicObject)this.getModel().getValue("uav6_futuresac");
                if (uav6Futuresac == null) break;
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                long aLong = uav6Futuresac.getLong("id");
                qFilters.add(new QFilter("bank.id", "in", (Object)aLong));
                this.f7SetFilters(e, qFilters);
                break;
            }
            case "uav6_polynum": {
                DynamicObject yemDept = (DynamicObject)this.getModel().getValue("yem_dept");
                if (yemDept != null) {
                    ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                    qFilters.add(new QFilter("uav6_dept.id", "in", (Object)yemDept.getLong("id")));
                    this.f7SetFilters(e, qFilters);
                    break;
                }
                this.getView().showMessage("\u90e8\u95e8\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u90e8\u95e8\uff01\uff01\uff01");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject uav6_futuresaccount;
        DynamicObject uav6Futuresac;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (name.equals("uav6_futuresaccount") && (uav6Futuresac = (DynamicObject)this.getModel().getValue("uav6_futuresac")) == null && (uav6_futuresaccount = (DynamicObject)newValue) != null) {
            long aLong = uav6_futuresaccount.getLong("bank.id");
            this.getModel().setValue("uav6_futuresac", (Object)aLong);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("yem_xdzl_cdgrz".equals(key)) {
            this.getView().invokeOperation("save");
            long id = (Long)this.getModel().getValue("id");
            if (id != 0L) {
                this.varirty();
            } else {
                this.getView().showMessage("\u8bf7\u70b9\u51fb\u4fdd\u5b58\u540e\u518d\u8bd5\uff01");
            }
        }
    }

    public void setDeptF7Filter(BeforeF7SelectEvent e) {
        DynamicObject yem_company = (DynamicObject)this.getModel().getValue("yem_company");
        if (yem_company != null) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            List<Long> orgSubDept = this.getOrgSubDept(yem_company);
            DynamicObject[] orgrelation_dept = BusinessDataServiceHelper.load((String)"bos_org_orgrelation_dept", (String)"toorg", (QFilter[])new QFilter[]{new QFilter("fromorg", "=", (Object)yem_company.getLong("id"))});
            List deptIds = Arrays.stream(orgrelation_dept).filter(x -> x.getDynamicObject("toorg") != null).map(x -> x.getDynamicObject("toorg").getLong("id")).collect(Collectors.toList());
            orgSubDept.addAll(deptIds);
            qFilters.add(new QFilter("id", "in", orgSubDept));
            this.f7SetFilters(e, qFilters);
        }
    }

    private void setOrgF7Filter(BeforeF7SelectEvent e, String name) {
        boolean isFieldExist = MetadataServiceHelper.getDataEntityType((String)this.getView().getEntityId()).getAllFields().containsKey("yem_orgtype");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("orgpattern", "in", (Object)OrgUtil.getOrgPattern()));
        if (isFieldExist) {
            String yem_orgtype = (String)this.getModel().getValue("yem_orgtype");
            if ("yem_company".equals(name) || yem_orgtype.equals("bos_org") && "yem_org".equals(name)) {
                this.f7SetFilters(e, qFilters);
            }
        } else {
            this.f7SetFilters(e, qFilters);
        }
    }

    private void f7SetFilters(BeforeF7SelectEvent e, List<QFilter> qFilters) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setQFilters(qFilters);
    }

    private void varirty() {
        DecimalFormat df = new DecimalFormat("#");
        df.setGroupingUsed(false);
        long currentOrgId = YEM.getCurrentOrgId();
        Map getcaParameter = SystemParamUtil.getAppParams((String)"uav6_smcl", (Long)currentOrgId);
        DynamicObject yemVariety = (DynamicObject)this.getModel().getValue("yem_variety");
        DynamicObject yemConstract = (DynamicObject)this.getModel().getValue("yem_constract");
        String yemIsbuy = (String)this.getModel().getValue("yem_isbuy");
        String yemIsopen = (String)this.getModel().getValue("yem_isopen");
        DynamicObject uav6Polynum = (DynamicObject)this.getModel().getValue("uav6_polynum");
        String fkYemVariety = URL;
        String fkYemConstract = URL;
        String fkYemPolynum = URL;
        if (yemVariety != null) {
            fkYemVariety = yemVariety.getString("name");
        }
        if (yemConstract != null) {
            fkYemConstract = yemConstract.getString("name");
        }
        if (uav6Polynum != null) {
            long aLong = uav6Polynum.getLong("id");
            fkYemPolynum = String.valueOf(aLong);
        }
        JSONObject obj = new JSONObject();
        obj.put("fId", this.getModel().getValue("id"));
        obj.put("fbillno", this.getModel().getValue("billno"));
        obj.put("fkYemIsbuy", (Object)yemIsbuy);
        obj.put("fkYemIsopen", (Object)yemIsopen);
        obj.put("fkYemTransformcount", this.getModel().getValue("uav6_transformcount"));
        obj.put("fkYemPrice", (Object)this.getModel().getValue("yem_price").toString());
        obj.put("varietyName", (Object)fkYemVariety);
        obj.put("constractName", (Object)fkYemConstract);
        obj.put("fkYemPolynum", (Object)fkYemPolynum);
        try {
            String yemAddress = (String)getcaParameter.get("uav6_address");
            String yemUrl = (String)getcaParameter.get("uav6_token");
            String str = yemAddress + yemUrl;
            JSONObject responseMap = Util.RMBunti(str, obj);
            Integer code = (Integer)responseMap.get("code");
            String msg = (String)responseMap.get("msg");
            boolean pass = false;
            if (code == 200) {
                LinkedHashMap data = (LinkedHashMap)responseMap.get("data");
                ArrayList info = (ArrayList)data.get("info");
                ArrayList warnList = (ArrayList)data.get("warnList");
                ArrayList errorList = (ArrayList)data.get("errorList");
                pass = (Boolean)data.get("pass");
                if (!warnList.isEmpty()) {
                    this.getModel().setValue("uav6_informationdetails_tag", warnList.get(0));
                }
                if (!info.isEmpty()) {
                    this.getModel().setValue("uav6_informationdetails_tag", info.get(0));
                }
                if (pass) {
                    this.getModel().setValue("yem_hangstatus", (Object)"A");
                } else {
                    this.getModel().setValue("yem_hangstatus", (Object)"B");
                    this.getModel().setValue("uav6_informationdetails_tag", errorList.get(0));
                    this.getView().showMessage((String)errorList.get(0));
                }
            } else {
                this.getModel().setValue("yem_hangstatus", (Object)"B");
                this.getModel().setValue("uav6_informationdetails_tag", (Object)msg);
                this.getView().showMessage(msg);
            }
            this.getModel().setValue("uav6_rzjson", (Object)responseMap.toString());
            SaveServiceHelper.saveOperate((String)"save", (String)this.getModel().getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, null);
            this.getView().updateView();
            if (pass) {
                this.getView().invokeOperation("submit");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Long> getOrgSubDept(DynamicObject yem_company) {
        DynamicObject[] depts = BusinessDataServiceHelper.load((String)"bos_adminorg", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C"), new QFilter("structure.fullname", "like", (Object)("%" + yem_company.getString("name") + "%")), new QFilter("orgpattern.number", "=", (Object)"Orgform06")});
        return Arrays.stream(depts).map(x -> x.getLong("id")).collect(Collectors.toList());
    }
}

