/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.sys.bill.policynumber.api;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.shmjs.sys.bill.policynumber.api.constants.ApiErrorCode;
import yem.shmjs.sys.bill.policynumber.api.model.UpdatePLInfoRequestModel;

@ApiController(value="\u7b56\u7565\u62a5\u5173", desc="\u7b56\u7565\u62a5\u5173API")
@ApiMapping(value="policy-report")
public class PolicyReportUpdateApi {
    private static final Log log = LogFactory.getLog(PolicyReportUpdateApi.class);

    @ApiPostMapping(value="pl-info-update")
    public CustomApiResult<Object> updatePLInfoById(@ApiParam(value="\u76c8\u4e8f\u4fe1\u606f") @ApiParam(value="\u76c8\u4e8f\u4fe1\u606f") List<UpdatePLInfoRequestModel> data) {
        try {
            Object[] saved;
            log.info("request data: {}", data);
            if (data == null || data.isEmpty()) {
                return CustomApiResult.fail((String)ApiErrorCode.UNLEGAL_PARAMETERS.code(), (String)ApiErrorCode.UNLEGAL_PARAMETERS.message());
            }
            log.info("request data.length: {}", (Object)data.size());
            Map<Long, BigDecimal> dataMap = data.stream().collect(Collectors.toMap(UpdatePLInfoRequestModel::getId, UpdatePLInfoRequestModel::getValue));
            Map load = BusinessDataServiceHelper.loadFromCache((Object[])dataMap.keySet().toArray(), (String)"yem_bd_policynumber");
            if (load == null || load.isEmpty()) {
                return CustomApiResult.fail((String)ApiErrorCode.NO_MATCH_RECORD.code(), (String)ApiErrorCode.NO_MATCH_RECORD.message());
            }
            log.info("load {} records", (Object)load.keySet().size());
            for (Map.Entry entry : load.entrySet()) {
                Long bdId = (Long)entry.getKey();
                DynamicObject bd = (DynamicObject)entry.getValue();
                if (!dataMap.containsKey(bdId)) continue;
                bd.set("uav6_profitloss", (Object)dataMap.get(bdId).setScale(2, RoundingMode.HALF_UP));
            }
            Map<Long, Boolean> result = data.stream().collect(Collectors.toMap(UpdatePLInfoRequestModel::getId, model -> false));
            for (Object save : saved = SaveServiceHelper.save((DynamicObject[])load.values().toArray(new DynamicObject[0]))) {
                BigDecimal originValue;
                DynamicObject bd = (DynamicObject)save;
                long id = bd.getLong("id");
                BigDecimal value = bd.getBigDecimal("uav6_profitloss");
                if (!dataMap.containsKey(id) || value.compareTo((originValue = dataMap.get(id)).setScale(2, RoundingMode.HALF_UP)) != 0) continue;
                result.put(id, true);
            }
            return CustomApiResult.success(result);
        }
        catch (Exception e) {
            return CustomApiResult.fail((String)ApiErrorCode.INTERNAL_SERVER_ERROR.code(), (String)ApiErrorCode.INTERNAL_SERVER_ERROR.message());
        }
    }
}

