/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.sys.bill.policynumber.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.YEM;

public class PolicyNumberBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        ((BasedataEdit)this.getControl("uav6_dept")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "uav6_dept": {
                this.setDeptF7Filter(e);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long currentUserId = YEM.getCurrentUserId();
        long currentOrgId = YEM.getCurrentOrgId();
        DynamicObject bosUser = BusinessDataServiceHelper.loadSingle((Object)currentUserId, (String)"bos_user");
        DynamicObject getdpt = PolicyNumberBillPlugin.getdpt(bosUser);
        this.getModel().setValue("createorg", (Object)currentOrgId);
        this.getModel().setValue("uav6_dept", (Object)getdpt);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String uav6Rzjson = (String)this.getModel().getValue("uav6_rzjsons_tag");
        String uav6Informationdetails = (String)this.getModel().getValue("uav6_informationdetails_tag");
        String prettyTag = this.getPrettyTag(uav6Rzjson);
        CodeEdit codeEdit = (CodeEdit)this.getView().getControl("uav6_codeeditap");
        codeEdit.setText(prettyTag);
        Markdown markdown = (Markdown)this.getView().getControl("uav6_markdownap");
        markdown.setText(uav6Informationdetails);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("uav6_clbg_cdgrz".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getPrettyTag(String encryptData) {
        String str;
        block11: {
            block10: {
                Object obj = null;
                try {
                    if (encryptData != null) {
                        if (encryptData.startsWith("{")) {
                            obj = JSONObject.parseObject((String)encryptData, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
                        } else if (encryptData.startsWith("[")) {
                            obj = JSONObject.parseArray((String)encryptData);
                        }
                    }
                    if (obj == null) break block10;
                }
                catch (Exception exception) {
                    str = obj != null ? JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}) : this.s(encryptData);
                    catch (Throwable throwable) {
                        if (obj != null) {
                            str = JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
                        } else {
                            str = this.s(encryptData);
                        }
                        throw throwable;
                    }
                }
                str = JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
                break block11;
            }
            str = this.s(encryptData);
        }
        return this.subStringAndConcatTip(str);
    }

    private String subStringAndConcatTip(String param) {
        if (YEM.isNotEmpty((Object)param) && param.length() > 102400) {
            param = param.substring(0, 102400);
            StringBuilder sb = new StringBuilder();
            sb.append(param).append("\n\n\n\n\u8bf7\u6ce8\u610f\uff1a\u56e0\u5185\u5bb9\u592a\u957f\uff0c\u540e\u7eed\u90e8\u5206\u88ab\u81ea\u52a8\u622a\u65ad\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u53bb\u540e\u53f0\u67e5\u770b...");
            return sb.toString();
        }
        return param;
    }

    private String s(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toPlainString();
        }
        String s = o.toString();
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    public static DynamicObject getdpt(DynamicObject bosUser) {
        DynamicObjectCollection entryentity = bosUser.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : entryentity) {
            boolean ispartjob = dynamicObject.getBoolean("ispartjob");
            if (ispartjob) continue;
            return dynamicObject.getDynamicObject("dpt");
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "uav6_variety": {
                DynamicObjectCollection uav6TeClbgFlxx = this.getModel().getEntryEntity("uav6_te_clbg_flxx");
                HashMap<String, String> map = new HashMap<String, String>();
                for (DynamicObject teClbgFlxx : uav6TeClbgFlxx) {
                    DynamicObject uav6Variety = teClbgFlxx.getDynamicObject("uav6_variety");
                    if (!YEM.isNotEmpty((Object)uav6Variety)) continue;
                    String string = uav6Variety.getString("name");
                    map.put(string, string);
                }
                StringBuilder string = new StringBuilder();
                for (String entry : map.keySet()) {
                    if (string.length() == 0) {
                        string = new StringBuilder(entry);
                        continue;
                    }
                    string.append(",").append(entry);
                }
                this.getModel().setValue("uav6_assortment", (Object)string);
                break;
            }
        }
    }

    public void setDeptF7Filter(BeforeF7SelectEvent e) {
        DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
        if (createorg != null) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            List<Long> orgSubDept = this.getOrgSubDept(createorg);
            DynamicObject[] orgrelation_dept = BusinessDataServiceHelper.load((String)"bos_org_orgrelation_dept", (String)"toorg", (QFilter[])new QFilter[]{new QFilter("fromorg", "=", (Object)createorg.getLong("id"))});
            List deptIds = Arrays.stream(orgrelation_dept).filter(x -> x.getDynamicObject("toorg") != null).map(x -> x.getDynamicObject("toorg").getLong("id")).collect(Collectors.toList());
            orgSubDept.addAll(deptIds);
            qFilters.add(new QFilter("id", "in", orgSubDept));
            this.f7SetFilters(e, qFilters);
        }
    }

    private void f7SetFilters(BeforeF7SelectEvent e, List<QFilter> qFilters) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setQFilters(qFilters);
    }

    private List<Long> getOrgSubDept(DynamicObject yem_company) {
        DynamicObject[] depts = BusinessDataServiceHelper.load((String)"bos_adminorg", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C"), new QFilter("structure.fullname", "like", (Object)("%" + yem_company.getString("name") + "%")), new QFilter("orgpattern.number", "=", (Object)"Orgform06")});
        return Arrays.stream(depts).map(x -> x.getLong("id")).collect(Collectors.toList());
    }
}

