/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.sys.bill.policynumber.op;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.jetbrains.annotations.NotNull;
import yem.base.common.utils.SystemParamUtil;
import yem.base.common.utils.YEM;
import yem.shmjs.sys.bill.util.Util;

public class PolicyNumberAuditSyncPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(PolicyNumberAuditSyncPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(this.billEntityType.getFields().keySet());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] entities;
        super.endOperationTransaction(e);
        for (DynamicObject entity : entities = e.getDataEntities()) {
            this.varirty(entity);
        }
    }

    private void varirty(DynamicObject entity) {
        long currentOrgId = YEM.getCurrentOrgId();
        Map getcaParameter = SystemParamUtil.getAppParams((String)"uav6_smcl", (Long)currentOrgId);
        JSONObject obj = new JSONObject();
        PolicyNumberAuditSyncPlugin.getJSONobject(entity, obj);
        try {
            String yemAddress = (String)getcaParameter.get("uav6_address");
            String yemUrl = (String)getcaParameter.get("uav6_tokens");
            String str = yemAddress + yemUrl;
            JSONObject responseMap = Util.RMBunti(str, obj);
            Integer code = (Integer)responseMap.get((Object)"code");
            String msg = (String)responseMap.get((Object)"msg");
            if (code == 200) {
                entity.set("uav6_informationdetails_tag", (Object)msg);
                entity.set("uav6_rzjsons_tag", (Object)responseMap.toString());
            } else {
                entity.set("uav6_rzjsons_tag", (Object)responseMap.toString());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void getJSONobject(DynamicObject entity, JSONObject obj) {
        DecimalFormat df = new DecimalFormat("#");
        df.setGroupingUsed(false);
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        obj.put("fId", (Object)entity.getLong("id"));
        obj.put("fname", (Object)entity.getString("name"));
        obj.put("fnumber", (Object)entity.getString("number"));
        obj.put("fkYemCoopobj", (Object)entity.getString("uav6_coopobj"));
        obj.put("fkYemProjectprice", (Object)df.format(entity.getBigDecimal("uav6_projectprice")));
        obj.put("fkYemAppdate", (Object)PolicyNumberAuditSyncPlugin.getdate(entity, "uav6_appdate"));
        obj.put("fkYemStopamt", (Object)df.format(entity.getBigDecimal("uav6_stopamt")));
        obj.put("tkYemTimerangeStart", (Object)PolicyNumberAuditSyncPlugin.getdate(entity, "uav6_timerange_start"));
        obj.put("tkYemTimerangeEnd", (Object)PolicyNumberAuditSyncPlugin.getdate(entity, "uav6_timerange_end"));
        obj.put("needFeasibilityAnalysis", (Object)true);
        DynamicObjectCollection objectCollection = entity.getDynamicObjectCollection("uav6_ploytype");
        StringBuilder number = new StringBuilder();
        for (DynamicObject dynamicObject : objectCollection) {
            DynamicObject fbasedataid = dynamicObject.getDynamicObject("fbasedataid");
            if (number.length() == 0) {
                number = new StringBuilder(fbasedataid.getString("number"));
                continue;
            }
            number.append(",").append(fbasedataid.getString("number"));
        }
        obj.put("fkUav6Deposit", (Object)entity.getBigDecimal("uav6_deposit"));
        obj.put("ploytypeYemType", (Object)number.toString());
        obj.put("fkYemPlanTag", (Object)PolicyNumberAuditSyncPlugin.getLargeTextTag(entity, "uav6_plan"));
        obj.put("fkYemExpectedProfit", (Object)df.format(entity.getBigDecimal("uav6_expectedprofit")));
        obj.put("fkYemExpectedProfitdescTag", (Object)PolicyNumberAuditSyncPlugin.getLargeTextTag(entity, "uav6_expectedprofitdesc"));
        obj.put("fkYemOpreasonTag", (Object)PolicyNumberAuditSyncPlugin.getLargeTextTag(entity, "uav6_opreason"));
        obj.put("fkYemRiskplanTag", (Object)PolicyNumberAuditSyncPlugin.getLargeTextTag(entity, "uav6_riskplan"));
        obj.put("fkYemOtherinfoTag", (Object)PolicyNumberAuditSyncPlugin.getLargeTextTag(entity, "uav6_otherinfo"));
        DynamicObjectCollection yemTeClbgFlxx = entity.getDynamicObjectCollection("uav6_te_clbg_flxx");
        PolicyNumberAuditSyncPlugin.getentity(yemTeClbgFlxx, list);
        obj.put("yemTeClbgFlxx", list);
    }

    @NotNull
    private static String getdate(DynamicObject entity, String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date yemAppdate = entity.getDate(date);
        if (yemAppdate == null) {
            return "";
        }
        return sdf.format(yemAppdate);
    }

    private static void getentity(DynamicObjectCollection yemTeClbgFlxx, List<JSONObject> list) {
        DecimalFormat df = new DecimalFormat("#");
        df.setGroupingUsed(false);
        for (DynamicObject teClbgFlxx : yemTeClbgFlxx) {
            DynamicObject yemConstract;
            JSONObject JsonObject = new JSONObject();
            String varietyName = "";
            String ConstractName = "";
            DynamicObject yemVariety = teClbgFlxx.getDynamicObject("uav6_variety");
            if (yemVariety != null) {
                varietyName = yemVariety.getString("name");
            }
            if ((yemConstract = teClbgFlxx.getDynamicObject("uav6_constract")) != null) {
                ConstractName = yemConstract.getString("name");
            }
            JsonObject.put("fEntryId", (Object)teClbgFlxx.getString("id"));
            JsonObject.put("fkYemPlanamt", (Object)df.format(teClbgFlxx.getBigDecimal("uav6_planamt")));
            JsonObject.put("fkYemQty", (Object)df.format(teClbgFlxx.getBigDecimal("uav6_qty")));
            JsonObject.put("varietyName", (Object)varietyName);
            JsonObject.put("constractName", (Object)ConstractName);
            String yemIsbuy = teClbgFlxx.getString("uav6_isbuy");
            if ("A".equals(yemIsbuy)) {
                JsonObject.put("fkYemIsbuy", (Object)"\u4e70");
            } else if ("B".equals(yemIsbuy)) {
                JsonObject.put("fkYemIsbuy", (Object)"\u5356");
            }
            list.add(JsonObject);
        }
    }

    private static String getLargeTextTag(DynamicObject entity, String billno) {
        return entity.getString(billno + "_tag");
    }
}

